/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodInfo;
import org.netbeans.modules.visualweb.ejb.ui.EjbGroupTreeNodes;
import org.netbeans.modules.visualweb.ejb.ui.MethodDetailPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ConfigureMethodsPanel
extends JPanel {
    private EjbGroup ejbGroup;
    private MethodDetailPanel methodDetailPanel;
    private JPanel methodPanel;
    private JTree methodTree;
    private JLabel methodsLabel;
    private JPanel selectionPanel;
    private JScrollPane treeScrollPanel;

    public ConfigureMethodsPanel(EjbGroup ejbGroup) {
        this.initComponents();
        this.setName(NbBundle.getMessage(ConfigureMethodsPanel.class, (String)"CONFIGURE_METHODS"));
        this.methodTree.setCellRenderer(new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                if (object instanceof EjbGroupTreeNodes.MethodNode) {
                    MethodInfo methodInfo = ((EjbGroupTreeNodes.MethodNode)object).getMethod();
                    if (methodInfo.getReturnType().isCollection() && methodInfo.getReturnType().getElemClassName() == null) {
                        this.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/visualweb/ejb/resources/warning.png")));
                    } else {
                        this.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/visualweb/ejb/resources/methodPublic.gif")));
                    }
                } else {
                    this.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/visualweb/ejb/resources/session_bean.png")));
                }
                return this;
            }
        });
        this.ejbGroup = ejbGroup;
        this.setEjbGroup(ejbGroup);
    }

    public void setEjbGroup(EjbGroup ejbGroup) {
        this.ejbGroup = ejbGroup;
        EjbGroupTreeNodes ejbGroupTreeNodes = new EjbGroupTreeNodes(this.ejbGroup);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(ejbGroupTreeNodes.getRoot());
        this.methodTree.setModel(defaultTreeModel);
        this.methodTree.getSelectionModel().setSelectionMode(1);
        this.expandAll(true);
        if (ejbGroupTreeNodes.geFirstNodeToBeSelected() != null) {
            this.methodTree.setSelectionPath(new TreePath(ejbGroupTreeNodes.geFirstNodeToBeSelected().getPath()));
            this.methodDetailPanel = new MethodDetailPanel(this.ejbGroup, ejbGroupTreeNodes.geFirstNodeToBeSelected().getMethod());
        } else {
            this.methodDetailPanel = new MethodDetailPanel(this.ejbGroup, null);
        }
        this.methodPanel.add(this.methodDetailPanel);
        this.methodTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)ConfigureMethodsPanel.this.methodTree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null || treeSelectionEvent.getOldLeadSelectionPath() == null) {
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeSelectionEvent.getOldLeadSelectionPath().getLastPathComponent();
                if (defaultMutableTreeNode2 instanceof EjbGroupTreeNodes.MethodNode) {
                    MethodInfo methodInfo = ((EjbGroupTreeNodes.MethodNode)defaultMutableTreeNode2).getMethod();
                    if (methodInfo.getReturnType().isCollection()) {
                        ConfigureMethodsPanel.this.methodDetailPanel.updateColElemClassName();
                    }
                    ConfigureMethodsPanel.this.methodDetailPanel.stopLastCellEditing();
                }
                if (defaultMutableTreeNode instanceof EjbGroupTreeNodes.MethodNode) {
                    ConfigureMethodsPanel.this.methodDetailPanel.setMethod(((EjbGroupTreeNodes.MethodNode)defaultMutableTreeNode).getMethod());
                }
            }
        });
    }

    public void expandAll(boolean bl) {
        TreeNode treeNode = (TreeNode)this.methodTree.getModel().getRoot();
        this.expandAll(this.methodTree, new TreePath(treeNode), bl);
    }

    private void expandAll(JTree jTree, TreePath treePath, boolean bl) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                this.expandAll(jTree, treePath2, bl);
            }
        }
        if (bl) {
            jTree.expandPath(treePath);
        } else {
            jTree.collapsePath(treePath);
        }
    }

    public MethodDetailPanel getMethodDetailPanel() {
        return this.methodDetailPanel;
    }

    private void initComponents() {
        this.selectionPanel = new JPanel();
        this.treeScrollPanel = new JScrollPane();
        this.methodTree = new JTree();
        this.methodsLabel = new JLabel();
        this.methodPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.selectionPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        this.selectionPanel.setVerifyInputWhenFocusTarget(false);
        this.selectionPanel.setLayout(new BorderLayout());
        this.methodTree.setRootVisible(false);
        this.methodTree.setVisibleRowCount(12);
        this.treeScrollPanel.setViewportView(this.methodTree);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle");
        this.methodTree.getAccessibleContext().setAccessibleName(resourceBundle.getString("EJB_METHODS"));
        this.methodTree.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("EJB_METHODS"));
        this.selectionPanel.add((Component)this.treeScrollPanel, "Center");
        this.treeScrollPanel.getAccessibleContext().setAccessibleName(resourceBundle.getString("EJB_METHODS"));
        this.treeScrollPanel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("EJB_METHODS"));
        this.methodsLabel.setLabelFor(this.methodTree);
        Mnemonics.setLocalizedText((JLabel)this.methodsLabel, (String)NbBundle.getMessage(ConfigureMethodsPanel.class, (String)"EJB_METHODS"));
        this.selectionPanel.add((Component)this.methodsLabel, "North");
        this.methodsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureMethodsPanel.class, (String)"EJB_METHODS"));
        this.methodsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureMethodsPanel.class, (String)"EJB_METHODS"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.selectionPanel, gridBagConstraints);
        this.selectionPanel.getAccessibleContext().setAccessibleName(resourceBundle.getString("EJB_METHODS"));
        this.selectionPanel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("EJB_METHODS"));
        this.methodPanel.setMinimumSize(new Dimension(0, 0));
        this.methodPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 17, 0, 12);
        this.add((Component)this.methodPanel, gridBagConstraints);
        this.methodPanel.getAccessibleContext().setAccessibleName(resourceBundle.getString("METHOD_DETAILS"));
        this.methodPanel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("METHOD_DETAILS"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureMethodsPanel.class, (String)"EXPORT_EJB_DATASOURCES"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureMethodsPanel.class, (String)"EXPORT_EJB_DATASOURCES"));
    }
}

