/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.nodes;

import com.sun.rave.designtime.DisplayItem;
import com.sun.rave.designtime.impl.BasicBeanCreateInfo;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.logging.Level;
import javax.swing.Action;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbDataModel;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbInfo;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodInfo;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodParam;
import org.netbeans.modules.visualweb.ejb.load.EjbLoaderHelper;
import org.netbeans.modules.visualweb.ejb.nodes.EjbGroupNode;
import org.netbeans.modules.visualweb.ejb.nodes.EjbLibReferenceHelper;
import org.netbeans.modules.visualweb.ejb.util.InvalidParameterNameException;
import org.netbeans.modules.visualweb.ejb.util.MethodParamValidator;
import org.netbeans.modules.visualweb.ejb.util.Util;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public class MethodNode
extends AbstractNode
implements Node.Cookie {
    private MethodInfo methodInfo;
    private EjbGroup ejbGroup;
    private static final DataFlavor FLAVOR_METHOD_DISPLAY_ITEM = new DataFlavor("application/x-java-jvm-local-objectref; class=" + DisplayItem.class.getName(), "Ejb Method Display Item");

    public MethodNode(EjbGroup ejbGroup, MethodInfo methodInfo, EjbInfo ejbInfo) {
        super(Children.LEAF);
        this.ejbGroup = ejbGroup;
        this.methodInfo = methodInfo;
        this.setName(this.methodInfo.getName());
        this.setDisplayName(this.methodInfo.getName());
        this.setShortDescription(this.methodInfo.toString());
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{SystemAction.get(PropertiesAction.class)};
    }

    public Action getPreferredAction() {
        return SystemAction.get(PropertiesAction.class);
    }

    public Image getIcon(int n) {
        return this.getMethodIcon();
    }

    public Image getOpenedIcon(int n) {
        return this.getMethodIcon();
    }

    private Image getMethodIcon() {
        if (!this.methodInfo.getReturnType().isVoid()) {
            Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/visualweb/ejb/resources/methodPublic.gif");
            Image image2 = ImageUtilities.loadImage((String)"org/netbeans/modules/visualweb/ejb/resources/table_dp_badge.png");
            int n = image.getWidth(null) - image2.getWidth(null);
            int n2 = image.getHeight(null) - image2.getHeight(null);
            return ImageUtilities.mergeImages((Image)image, (Image)image2, (int)n, (int)n2);
        }
        return ImageUtilities.loadImage((String)"org/netbeans/modules/visualweb/ejb/resources/methodPublic.gif");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("projrave_ui_elements_server_nav_ejb_node");
    }

    public MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    protected Sheet createSheet() {
        Sheet.Set set;
        Sheet sheet = super.createSheet();
        Sheet.Set set2 = sheet.get("methodInfo");
        if (set2 == null) {
            set2 = new Sheet.Set();
            set2.setName("methodInfo");
            set2.setDisplayName(NbBundle.getMessage(MethodNode.class, (String)"METHOD_INFORMATION"));
            set2.setShortDescription(NbBundle.getMessage(MethodNode.class, (String)"METHOD_INFORMATION"));
            sheet.put(set2);
        }
        if ((set = sheet.get("methodReturn")) == null) {
            set = new Sheet.Set();
            set.setName("methodReturn");
            set.setDisplayName(NbBundle.getMessage(MethodNode.class, (String)"METHOD_RETURN"));
            set.setShortDescription(NbBundle.getMessage(MethodNode.class, (String)"METHOD_RETURN"));
            sheet.put(set);
        }
        set.put((Node.Property)new PropertySupport.ReadOnly("returnType", String.class, NbBundle.getMessage(MethodNode.class, (String)"RETURN_TYPE"), NbBundle.getMessage(MethodNode.class, (String)"RETURN_TYPE")){

            public Object getValue() {
                return MethodNode.this.methodInfo.getReturnType().getClassName();
            }
        });
        if (this.methodInfo.getReturnType().isCollection()) {
            set.put((Node.Property)new PropertySupport.ReadWrite("elementType", String.class, NbBundle.getMessage(MethodNode.class, (String)"RETURN_COL_ELEM_TYPE"), NbBundle.getMessage(MethodNode.class, (String)"RETURN_COL_ELEM_TYPE")){

                public PropertyEditor getPropertyEditor() {
                    return null;
                }

                public Object getValue() {
                    String string = MethodNode.this.methodInfo.getReturnType().getElemClassName();
                    if (string == null) {
                        string = NbBundle.getMessage(MethodNode.class, (String)"RETURN_COL_ELEM_TYPE_NOT_SPECIFIED");
                    }
                    return string;
                }

                public void setValue(Object object) {
                    String string = (String)object;
                    if (string == null || string.trim().length() == 0 || string.equals(NbBundle.getMessage(MethodNode.class, (String)"RETURN_COL_ELEM_TYPE_NOT_SPECIFIED"))) {
                        string = null;
                    }
                    try {
                        URLClassLoader uRLClassLoader = EjbLoaderHelper.getEjbGroupClassLoader(MethodNode.this.ejbGroup);
                        Class<?> clazz = Class.forName(string, true, uRLClassLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)("Class " + string + " not found"), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                        return;
                    }
                    MethodNode.this.methodInfo.getReturnType().setElemClassName(string);
                    EjbDataModel.getInstance().touchModifiedFlag();
                }
            });
        }
        set2.put((Node.Property)new PropertySupport.ReadOnly("signature", String.class, NbBundle.getMessage(EjbGroupNode.class, (String)"METHOD_SIGNATURE"), NbBundle.getMessage(EjbGroupNode.class, (String)"METHOD_SIGNATURE")){

            public Object getValue() {
                return MethodNode.this.methodInfo.toString();
            }
        });
        set2.put((Node.Property)new PropertySupport.ReadOnly("name", String.class, NbBundle.getMessage(EjbGroupNode.class, (String)"METHOD_NAME"), NbBundle.getMessage(EjbGroupNode.class, (String)"METHOD_NAME")){

            public Object getValue() {
                return MethodNode.this.methodInfo.getName();
            }
        });
        set2.put((Node.Property)new PropertySupport.ReadOnly("exceptions", String.class, NbBundle.getMessage(EjbGroupNode.class, (String)"EXCEPTIONS"), NbBundle.getMessage(EjbGroupNode.class, (String)"EXCEPTIONS")){

            public Object getValue() {
                return MethodNode.this.methodInfo.getExceptionsAsOneStr();
            }
        });
        Sheet.Set set3 = sheet.get("parameters");
        if (set3 == null) {
            set3 = new Sheet.Set();
            set3.setName("parameters");
            set3.setDisplayName(NbBundle.getMessage(MethodNode.class, (String)"METHOD_PARAMETERS"));
            set3.setShortDescription(NbBundle.getMessage(MethodNode.class, (String)"METHOD_PARAMETERS"));
            sheet.put(set3);
        }
        if (this.methodInfo.getParameters() != null && this.methodInfo.getParameters().size() != 0) {
            int n = 0;
            while (n < this.methodInfo.getParameters().size()) {
                final MethodParam methodParam = (MethodParam)this.methodInfo.getParameters().get(n);
                final int n2 = n++;
                set3.put((Node.Property)new PropertySupport.ReadWrite(methodParam.getName(), String.class, NbBundle.getMessage(MethodNode.class, (String)"PARAMETER_NAME"), NbBundle.getMessage(MethodNode.class, (String)"PARAMETER_NAME")){

                    public Object getValue() {
                        return methodParam.getName();
                    }

                    public void setValue(Object object) {
                        String string = (String)object;
                        if (string == null || string.trim().length() == 0) {
                            return;
                        }
                        string = string.trim();
                        try {
                            MethodParamValidator.validate(string, MethodNode.this.methodInfo, n2);
                        }
                        catch (InvalidParameterNameException invalidParameterNameException) {
                            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)invalidParameterNameException.getMessage(), 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                            return;
                        }
                        if (string.equals(methodParam.getName())) {
                            return;
                        }
                        if (!MethodNode.this.methodInfo.isParamNameUnique(string)) {
                            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(MethodNode.class, (String)"PARAMETER_NAME_NOT_UNIQUE", (Object)string), 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                            return;
                        }
                        methodParam.setName(string);
                        EjbDataModel.getInstance().touchModifiedFlag();
                    }
                });
                set3.put((Node.Property)new PropertySupport.ReadOnly(methodParam.getName() + "ParameteType", String.class, NbBundle.getMessage(MethodNode.class, (String)"PARAMETER_TYPE"), NbBundle.getMessage(MethodNode.class, (String)"PARAMETER_TYPE")){

                    public Object getValue() {
                        return methodParam.getType();
                    }
                });
            }
        }
        return sheet;
    }

    public boolean canCopy() {
        return this.isMethodDroppable();
    }

    public boolean canCut() {
        return false;
    }

    private boolean isMethodDroppable() {
        return !this.methodInfo.getReturnType().isVoid();
    }

    public Transferable clipboardCopy() {
        if (!this.isMethodDroppable()) {
            return null;
        }
        if (this.ejbGroup == null || this.methodInfo == null) {
            try {
                return super.clipboardCopy();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        try {
            ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCopy());
            exTransferable.put(new ExTransferable.Single(FLAVOR_METHOD_DISPLAY_ITEM){

                protected Object getData() {
                    return new MethodBeanCreateInfo(MethodNode.this.ejbGroup, MethodNode.this.methodInfo);
                }
            });
            return exTransferable;
        }
        catch (Exception exception) {
            System.err.println("MethodNode.clipboardCopy: Error");
            exception.printStackTrace();
            return null;
        }
    }

    private static class MethodBeanCreateInfo
    extends BasicBeanCreateInfo {
        private final EjbGroup ejbGroup;
        private final MethodInfo methodInfo;

        public MethodBeanCreateInfo(EjbGroup ejbGroup, MethodInfo methodInfo) {
            this.ejbGroup = ejbGroup;
            this.methodInfo = methodInfo;
        }

        public String getBeanClassName() {
            try {
                EjbLibReferenceHelper.addEjbGroupToActiveProject(this.ejbGroup);
            }
            catch (Exception exception) {
                Util.getLogger().log(Level.SEVERE, "Unable to add EJB Set to Project", exception);
            }
            return this.methodInfo.getDataProvider();
        }

        public String getDisplayName() {
            return this.methodInfo.getDataProvider();
        }
    }
}

