/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.modules.visualweb.ejb.actions.ConfigureMethodsAction;
import org.netbeans.modules.visualweb.ejb.actions.DeleteEjbGroupAction;
import org.netbeans.modules.visualweb.ejb.actions.ExportEjbDataSourceAction;
import org.netbeans.modules.visualweb.ejb.actions.ModifyEjbGroupAction;
import org.netbeans.modules.visualweb.ejb.actions.RefreshEjbGroupAction;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbDataModel;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.netbeans.modules.visualweb.ejb.nodes.EjbGroupNodeChildren;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class EjbGroupNode
extends AbstractNode
implements PropertyChangeListener,
Node.Cookie {
    private EjbGroup ejbGroup;

    public EjbGroupNode(EjbGroup ejbGroup) {
        super((Children)new EjbGroupNodeChildren(ejbGroup));
        this.ejbGroup = ejbGroup;
        this.setName(ejbGroup.getName());
        this.setDisplayName(ejbGroup.getName());
        this.setShortDescription(ejbGroup.getName());
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{SystemAction.get(RefreshEjbGroupAction.class), SystemAction.get(ModifyEjbGroupAction.class), SystemAction.get(DeleteEjbGroupAction.class), SystemAction.get(ConfigureMethodsAction.class), null, SystemAction.get(ExportEjbDataSourceAction.class)};
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("projrave_ui_elements_server_nav_ejb_node");
    }

    public Image getIcon(int n) {
        Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/visualweb/ejb/resources/ejbSetFolder.png");
        Image image2 = ImageUtilities.loadImage((String)"org/netbeans/modules/visualweb/ejb/resources/archive_container_8x8.png");
        int n2 = image.getWidth(null) - image2.getWidth(null);
        int n3 = image.getHeight(null) - image2.getHeight(null);
        return ImageUtilities.mergeImages((Image)image, (Image)image2, (int)n2, (int)n3);
    }

    public Image getOpenedIcon(int n) {
        Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/visualweb/ejb/resources/ejbSetOpenFolder.png");
        Image image2 = ImageUtilities.loadImage((String)"org/netbeans/modules/visualweb/ejb/resources/archive_container_8x8.png");
        int n2 = image.getWidth(null) - image2.getWidth(null);
        int n3 = image.getHeight(null) - image2.getHeight(null);
        return ImageUtilities.mergeImages((Image)image, (Image)image2, (int)n2, (int)n3);
    }

    protected EjbGroupNodeChildren getEjbGroupNodeChildren() {
        return (EjbGroupNodeChildren)this.getChildren();
    }

    public EjbGroup getEjbGroup() {
        return this.ejbGroup;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = sheet.get("ejbGroup");
        if (set == null) {
            set = new Sheet.Set();
            set.setName("ejbGroup");
            set.setDisplayName(NbBundle.getMessage(EjbGroupNode.class, (String)"EJB_GROUP_INFORMATION"));
            set.setShortDescription(NbBundle.getMessage(EjbGroupNode.class, (String)"EJB_GROUP_INFORMATION"));
            sheet.put(set);
        }
        set.put((Node.Property)new PropertySupport.ReadWrite("name", String.class, NbBundle.getMessage(EjbGroupNode.class, (String)"EJB_GROUP_NAME"), NbBundle.getMessage(EjbGroupNode.class, (String)"EJB_GROUP_NAME")){

            public Object getValue() {
                return EjbGroupNode.this.ejbGroup.getName();
            }

            public void setValue(Object object) {
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = true;
                if ((String)object == null || ((String)object).length() == 0) {
                    stringBuffer.append(NbBundle.getMessage(EjbGroupNode.class, (String)"EMPTY_GROUP_NAME"));
                    bl = false;
                } else if (EjbDataModel.getInstance().getEjbGroup((String)object) != null) {
                    stringBuffer.append(NbBundle.getMessage(EjbGroupNode.class, (String)"NAME_NOT_UNIQUE", (Object)("'" + (String)object + "'")));
                    bl = false;
                }
                if (!bl) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)stringBuffer.toString(), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                } else if (!EjbGroupNode.this.ejbGroup.getName().equals((String)object)) {
                    EjbGroupNode.this.ejbGroup.setName((String)object);
                    EjbDataModel.getInstance().touchModifiedFlag();
                }
            }
        });
        set.put((Node.Property)new PropertySupport.ReadOnly("containerType", String.class, NbBundle.getMessage(EjbGroupNode.class, (String)"APP_SERVER_TYPE"), NbBundle.getMessage(EjbGroupNode.class, (String)"APP_SERVER_TYPE")){

            public Object getValue() {
                return EjbGroupNode.this.ejbGroup.getAppServerVendor();
            }
        });
        set.put((Node.Property)new PropertySupport.ReadWrite("serverHost", String.class, NbBundle.getMessage(EjbGroupNode.class, (String)"APP_SERVER_HOST"), NbBundle.getMessage(EjbGroupNode.class, (String)"APP_SERVER_HOST")){

            public Object getValue() {
                return EjbGroupNode.this.ejbGroup.getServerHost();
            }

            public void setValue(Object object) {
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = true;
                if (object == null || ((String)object).length() == 0) {
                    bl = false;
                    stringBuffer.append(NbBundle.getMessage(EjbGroupNode.class, (String)"EMPTY_SERVER_HOST"));
                } else if (((String)object).trim().indexOf(" ") != -1) {
                    bl = false;
                    stringBuffer.append(NbBundle.getMessage(EjbGroupNode.class, (String)"SPACES_IN_SERVER_HOST", (Object)("'" + (String)object + "'")));
                }
                if (!bl) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)stringBuffer.toString(), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                } else {
                    EjbGroup ejbGroup = (EjbGroup)EjbGroupNode.this.ejbGroup.clone();
                    ejbGroup.setServerHost((String)object);
                    if (EjbGroupNode.this.checkClientJarInfo(ejbGroup, true) && !EjbGroupNode.this.ejbGroup.getServerHost().equals((String)object)) {
                        EjbGroupNode.this.ejbGroup.setServerHost((String)object);
                        EjbDataModel.getInstance().touchModifiedFlag();
                    }
                }
            }
        });
        set.put((Node.Property)new PropertySupport.ReadWrite("iiopPort", String.class, NbBundle.getMessage(EjbGroupNode.class, (String)"IIOP_PORT"), NbBundle.getMessage(EjbGroupNode.class, (String)"IIOP_PORT")){

            public Object getValue() {
                return Integer.toString(EjbGroupNode.this.ejbGroup.getIIOPPort());
            }

            public void setValue(Object object) {
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = true;
                if (object == null || ((String)object).length() == 0) {
                    bl = false;
                    stringBuffer.append(NbBundle.getMessage(EjbGroupNode.class, (String)"EMPTY_IIOP_PORT"));
                } else {
                    try {
                        int n = Integer.parseInt((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                        stringBuffer.append(NbBundle.getMessage(EjbGroupNode.class, (String)"IIOP_PORT_NOT_NUMBER"));
                    }
                }
                if (!bl) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)stringBuffer.toString(), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                } else {
                    EjbGroup ejbGroup = (EjbGroup)EjbGroupNode.this.ejbGroup.clone();
                    ejbGroup.setIIOPPort(Integer.parseInt((String)object));
                    if (EjbGroupNode.this.checkClientJarInfo(ejbGroup, false) && EjbGroupNode.this.ejbGroup.getIIOPPort() != Integer.parseInt((String)object)) {
                        EjbGroupNode.this.ejbGroup.setIIOPPort(Integer.parseInt((String)object));
                        EjbDataModel.getInstance().touchModifiedFlag();
                    }
                }
            }
        });
        set.put((Node.Property)new PropertySupport.ReadOnly("clientJarFileNames", String.class, NbBundle.getMessage(EjbGroupNode.class, (String)"CLIENT_JARS"), NbBundle.getMessage(EjbGroupNode.class, (String)"CLIENT_JARS")){

            public Object getValue() {
                return EjbGroupNode.this.ejbGroup.getClientJarFilesAsOneStr();
            }
        });
        set.put((Node.Property)new PropertySupport.ReadOnly("ddLocationFileName", String.class, NbBundle.getMessage(EjbGroupNode.class, (String)"DD_JAR_FILE"), NbBundle.getMessage(EjbGroupNode.class, (String)"DD_JAR_FILE")){

            public Object getValue() {
                if (EjbGroupNode.this.ejbGroup.getDDLocationFile() == null) {
                    return NbBundle.getMessage(EjbGroupNode.class, (String)"NONE");
                }
                return EjbGroupNode.this.ejbGroup.getDDLocationFile();
            }
        });
        this.ejbGroup.addPropertyChangeListener(this);
        return sheet;
    }

    private boolean checkClientJarInfo(EjbGroup ejbGroup, boolean bl) {
        NotifyDescriptor.Confirmation confirmation;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : ejbGroup.getClientJarFileNames()) {
            object = EjbDataModel.getInstance().findEjbGroupsForJar(string);
            confirmation = object.iterator();
            while (confirmation.hasNext()) {
                EjbGroup ejbGroup2 = (EjbGroup)confirmation.next();
                if (ejbGroup2 == null || ejbGroup2.getServerHost().equals(ejbGroup.getServerHost()) && ejbGroup2.getIIOPPort() == ejbGroup.getIIOPPort() || arrayList.contains(ejbGroup2.getName()) || ejbGroup2.getName().equals(ejbGroup.getName())) continue;
                arrayList.add(ejbGroup2.getName());
            }
        }
        if (arrayList.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl2 = true;
            object = arrayList.iterator();
            while (object.hasNext()) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append((String)object.next());
            }
            object = null;
            object = bl ? NbBundle.getMessage(EjbGroupNode.class, (String)"MISMATH_HOST_INFO_JAR_Q", (Object)stringBuffer.toString()) : NbBundle.getMessage(EjbGroupNode.class, (String)"MISMATH_PORT_INFO_JAR_Q", (Object)stringBuffer.toString());
            confirmation = new NotifyDescriptor.Confirmation(object, 2);
            return DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.OK_OPTION;
        }
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        EjbDataModel.getInstance().removeEjbGroup(this.ejbGroup);
        super.destroy();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setName((String)propertyChangeEvent.getNewValue());
    }
}

