/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.load;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.netbeans.modules.visualweb.ejb.load.EjbLoadException;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public final class DeploymentDescriptorExtractor {
    public static final String JAR_FILE_EXTENSION = ".jar";
    private String tmpDir = System.getProperty("java.io.tmpdir");
    private Map deploymentDescriptors = new HashMap();
    private Set allClazz = new HashSet();
    private ArrayList tmpJarFiles = new ArrayList();

    public DeploymentDescriptorExtractor(ArrayList arrayList) throws EjbLoadException {
        for (String string : arrayList) {
            this.extract(string, this.deploymentDescriptors, this.allClazz);
        }
    }

    public Map getDeploymentDescriptors() {
        return this.deploymentDescriptors;
    }

    public Set getAllClazz() {
        return this.allClazz;
    }

    public ArrayList getTmpJarFiles() {
        return this.tmpJarFiles;
    }

    private void extract(String string, Map map, Set set) throws EjbLoadException {
        try {
            Object object;
            ZipFile zipFile = new ZipFile(string);
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                hashMap.put(((ZipEntry)object).getName(), new Integer((int)((ZipEntry)object).getSize()));
            }
            zipFile.close();
            object = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            String string2 = null;
            String string3 = null;
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                int n = (int)zipEntry.getSize();
                if (n == -1) {
                    n = (Integer)hashMap.get(zipEntry.getName());
                }
                byte[] byArray = new byte[n];
                int n2 = 0;
                int n3 = 0;
                while (n - n2 > 0 && (n3 = zipInputStream.read(byArray, n2, n - n2)) != -1) {
                    n2 += n3;
                }
                String string4 = zipEntry.getName();
                if (string4.endsWith(".class")) {
                    int n4 = string4.indexOf(46);
                    set.add(string4.substring(0, n4).replace('/', '.'));
                    continue;
                }
                String string5 = this.getFileName(string4);
                if (string5.equalsIgnoreCase("ejb-jar.xml") || string5.equalsIgnoreCase("sun-ejb-jar.xml") || string5.equalsIgnoreCase("weblogic-ejb-jar.xml") || string5.equalsIgnoreCase("ibm-ejb-jar-bnd.xmi")) {
                    String string6;
                    boolean bl = true;
                    if (string5.equalsIgnoreCase("sun-ejb-jar.xml") || string5.equalsIgnoreCase("weblogic-ejb-jar.xml") || string5.equalsIgnoreCase("ibm-ejb-jar-bnd.xmi")) {
                        bl = false;
                    }
                    if (string5.equalsIgnoreCase("ibm-ejb-jar-bnd.xmi")) {
                        string6 = map.size() + ".xmi";
                        string5 = string5.replaceAll(".xmi", string6);
                    } else {
                        string6 = map.size() + ".xml";
                        string5 = string5.replaceAll(".xml", string6);
                    }
                    string6 = this.writeXmlFile(string5, byArray);
                    if (bl) {
                        string2 = string6;
                    } else {
                        string3 = string6;
                    }
                    if (string2 != null && string3 != null) {
                        map.put(string2, string3);
                        string2 = null;
                        string3 = null;
                    }
                }
                if (string5.indexOf(JAR_FILE_EXTENSION) == -1) continue;
                String string7 = this.writeXmlFile(string5, byArray);
                this.extract(string7, map, set);
                this.tmpJarFiles.add(string7);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string8 = "Error occurred when trying to extract the EJB deployment descriptors. Cannot find from jar file " + string;
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.DeploymentDescriptorExtractor").log(65536, string8);
            fileNotFoundException.printStackTrace();
            String string9 = NbBundle.getMessage(DeploymentDescriptorExtractor.class, (String)"FILE_NOT_FOUND", (Object)string);
            throw new EjbLoadException(1, string9);
        }
        catch (IOException iOException) {
            String string10 = "Error occurred when trying to extract the EJB deployment descriptors. Cannot read from jar file " + string;
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.DeploymentDescriptorExtractor").log(65536, string10);
            iOException.printStackTrace();
            String string11 = NbBundle.getMessage(DeploymentDescriptorExtractor.class, (String)"CANNOT_READ_FILE", (Object)string);
            throw new EjbLoadException(1, string11);
        }
    }

    private String getFileName(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    private String writeXmlFile(String string, byte[] byArray) throws EjbLoadException {
        try {
            File file = new File(this.getTempDir(), string);
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            fileOutputStream.close();
            return file.getAbsolutePath();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.DeploymentDescriptorExtractor").log(65536, exception.getMessage());
            exception.printStackTrace();
            throw new EjbLoadException(exception.getMessage());
        }
    }

    private File getTempDir() {
        File file = new File(this.tmpDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }
}

