/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.properties;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.properties.PropertiesPanel;
import org.netbeans.modules.subversion.ui.properties.PropertiesTable;
import org.netbeans.modules.subversion.ui.properties.SvnPropertiesNode;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SvnProperties
implements ActionListener,
DocumentListener {
    private PropertiesPanel panel;
    private File root;
    private PropertiesTable propTable;
    private SvnProgressSupport support;
    private boolean loadedFromFile;
    private File loadedValueFile;

    public SvnProperties(PropertiesPanel propertiesPanel, PropertiesTable propertiesTable, File file) {
        this.panel = propertiesPanel;
        this.propTable = propertiesTable;
        this.root = file;
        propertiesPanel.txtAreaValue.getDocument().addDocumentListener(this);
        ((JTextField)propertiesPanel.comboName.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        propertiesTable.getTable().addMouseListener(new TableMouseListener());
        propertiesPanel.btnRefresh.addActionListener(this);
        propertiesPanel.btnAdd.addActionListener(this);
        propertiesPanel.btnRemove.addActionListener(this);
        propertiesPanel.btnBrowse.addActionListener(this);
        propertiesPanel.comboName.setEditable(true);
        if (!file.isDirectory()) {
            propertiesPanel.cbxRecursively.setEnabled(false);
        }
        this.setLoadedValueFile(null);
        this.initPropertyNameCbx();
        this.setLoadedFromFile(false);
        this.refreshProperties();
    }

    public PropertiesPanel getPropertiesPanel() {
        return this.panel;
    }

    public void setPropertiesPanel(PropertiesPanel propertiesPanel) {
        this.panel = propertiesPanel;
    }

    public File getRoot() {
        return this.root;
    }

    public void setRoot(File file) {
        this.root = file;
    }

    public void setLoadedValueFile(File file) {
        this.loadedValueFile = file;
    }

    public File getLoadedValueFile() {
        return this.loadedValueFile;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.panel.btnRefresh)) {
            this.refreshProperties();
        }
        if (object.equals(this.panel.btnAdd)) {
            this.setProperties();
        }
        if (object.equals(this.panel.btnRemove)) {
            this.removeProperties();
        }
        if (object.equals(this.panel.btnBrowse)) {
            this.loadFromFile();
        }
    }

    protected void initPropertyNameCbx() {
        ArrayList<String> arrayList = new ArrayList<String>(8);
        if (this.panel.comboName.isEditable()) {
            if (this.root.isDirectory()) {
                arrayList.add("svn:ignore");
                arrayList.add("svn:externals");
            } else {
                arrayList.add("svn:eol-style");
                arrayList.add("svn:executable");
                arrayList.add("svn:keywords");
                arrayList.add("svn:needs-lock");
                arrayList.add("svn:mime-type");
            }
        }
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(new Vector(arrayList));
        this.panel.comboName.setModel(defaultComboBoxModel);
        this.panel.comboName.getEditor().setItem("");
    }

    protected String getPropertyValue() {
        return this.panel.txtAreaValue.getText();
    }

    protected String getPropertyName() {
        Object object = this.panel.comboName.getSelectedObjects()[0];
        if (object != null) {
            return this.panel.comboName.getEditor().getItem().toString().trim();
        }
        return object.toString().trim();
    }

    public boolean isLoadedFromFile() {
        return this.loadedFromFile;
    }

    public void setLoadedFromFile(boolean bl) {
        this.loadedFromFile = bl;
    }

    public void handleBinaryFile(File file) {
        this.setLoadedValueFile(file);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(NbBundle.getMessage(SvnProperties.class, (String)"Binary_Content"));
        stringBuffer.append("\n");
        try {
            stringBuffer.append(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            Subversion.LOG.log(Level.SEVERE, null, iOException);
        }
        this.panel.txtAreaValue.setText(stringBuffer.toString());
        this.setLoadedFromFile(true);
    }

    public void loadFromFile() {
        Object object;
        AccessibleJFileChooser accessibleJFileChooser = new AccessibleJFileChooser(NbBundle.getMessage(SvnProperties.class, (String)"ACSD_Properties"));
        accessibleJFileChooser.setDialogTitle(NbBundle.getMessage(SvnProperties.class, (String)"CTL_Load_Value_Title"));
        accessibleJFileChooser.setMultiSelectionEnabled(false);
        FileFilter[] fileFilterArray = accessibleJFileChooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            object = fileFilterArray[i];
            accessibleJFileChooser.removeChoosableFileFilter((FileFilter)object);
        }
        accessibleJFileChooser.setCurrentDirectory(this.root.getParentFile());
        accessibleJFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.exists();
            }

            public String getDescription() {
                return "";
            }
        });
        accessibleJFileChooser.setDialogType(0);
        accessibleJFileChooser.setApproveButtonMnemonic(NbBundle.getMessage(SvnProperties.class, (String)"MNE_LoadValue").charAt(0));
        accessibleJFileChooser.setApproveButtonText(NbBundle.getMessage(SvnProperties.class, (String)"CTL_LoadValue"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)accessibleJFileChooser, NbBundle.getMessage(SvnProperties.class, (String)"CTL_Load_Value_Title"));
        dialogDescriptor.setOptions(new Object[0]);
        object = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        accessibleJFileChooser.addActionListener(new ActionListener((JFileChooser)accessibleJFileChooser, (Dialog)object){
            final /* synthetic */ JFileChooser val$chooser;
            final /* synthetic */ Dialog val$dialog;
            {
                this.val$chooser = jFileChooser;
                this.val$dialog = dialog;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("ApproveSelection")) {
                    File file = this.val$chooser.getSelectedFile();
                    if (Utils.isFileContentText((File)file)) {
                        if (file.canRead()) {
                            StringWriter stringWriter = new StringWriter();
                            try {
                                Utils.copyStreamsCloseAll((Writer)stringWriter, (Reader)new FileReader(file));
                                ((SvnProperties)SvnProperties.this).panel.txtAreaValue.setText(stringWriter.toString());
                            }
                            catch (IOException iOException) {
                                Subversion.LOG.log(Level.SEVERE, null, iOException);
                            }
                        }
                    } else {
                        SvnProperties.this.handleBinaryFile(file);
                    }
                }
                this.val$dialog.dispose();
            }
        });
        ((Dialog)object).setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperties() {
        SVNUrl sVNUrl;
        try {
            sVNUrl = SvnUtils.getRepositoryRootUrl(this.root);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(sVNUrl);
        try {
            this.support = new SvnProgressSupport(){
                SvnClient client;
                ISVNProperty[] isvnProps;

                protected void perform() {
                    try {
                        this.client = Subversion.getInstance().getClient(sVNUrl);
                        ISVNStatus iSVNStatus = this.client.getSingleStatus(SvnProperties.this.root);
                        if (iSVNStatus.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED)) {
                            return;
                        }
                        this.isvnProps = this.client.getProperties(SvnProperties.this.root);
                    }
                    catch (SVNClientException sVNClientException) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                        return;
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            SvnPropertiesNode[] svnPropertiesNodeArray = new SvnPropertiesNode[isvnProps.length];
                            for (int i = 0; i < isvnProps.length; ++i) {
                                String string;
                                if (isvnProps[i] == null) {
                                    return;
                                }
                                String string2 = isvnProps[i].getName();
                                String string3 = SvnUtils.isBinary(isvnProps[i].getData()) ? NbBundle.getMessage(SvnProperties.class, (String)"Binary_Content") : ((string = isvnProps[i].getValue()) != null ? string : "");
                                svnPropertiesNodeArray[i] = new SvnPropertiesNode(string2, string3);
                            }
                            SvnProperties.this.propTable.setNodes(svnPropertiesNodeArray);
                        }
                    });
                }
            };
            this.support.start(requestProcessor, sVNUrl, NbBundle.getMessage(SvnProperties.class, (String)"LBL_Properties_Progress"));
        }
        finally {
            this.support = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties() {
        SVNUrl sVNUrl;
        try {
            sVNUrl = SvnUtils.getRepositoryRootUrl(this.root);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(sVNUrl);
        try {
            this.support = new SvnProgressSupport(){
                SvnClient client;
                ISVNProperty[] isvnProps;

                protected void perform() {
                    block7: {
                        try {
                            this.client = Subversion.getInstance().getClient(sVNUrl);
                        }
                        catch (SVNClientException sVNClientException) {
                            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                            return;
                        }
                        boolean bl = ((SvnProperties)SvnProperties.this).panel.cbxRecursively.isSelected();
                        try {
                            SvnProperties.this.addFile(this.client, SvnProperties.this.root, bl);
                            if (SvnProperties.this.isLoadedFromFile()) {
                                try {
                                    this.client.propertySet(SvnProperties.this.root, SvnProperties.this.getPropertyName(), SvnProperties.this.getLoadedValueFile(), bl);
                                    break block7;
                                }
                                catch (IOException iOException) {
                                    Subversion.LOG.log(Level.SEVERE, null, iOException);
                                    return;
                                }
                            }
                            this.client.propertySet(SvnProperties.this.root, SvnProperties.this.getPropertyName(), SvnProperties.this.getPropertyValue(), bl);
                        }
                        catch (SVNClientException sVNClientException) {
                            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                            return;
                        }
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            ((SvnProperties)SvnProperties.this).panel.comboName.getEditor().setItem("");
                            ((SvnProperties)SvnProperties.this).panel.txtAreaValue.setText("");
                        }
                    });
                }
            };
            this.support.start(requestProcessor, sVNUrl, NbBundle.getMessage(SvnProperties.class, (String)"LBL_Properties_Progress"));
        }
        finally {
            this.support = null;
        }
        this.refreshProperties();
    }

    private void addFile(SvnClient svnClient, File file, boolean bl) throws SVNClientException {
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            return;
        }
        ISVNStatus iSVNStatus = svnClient.getSingleStatus(file);
        if (iSVNStatus.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED)) {
            svnClient.addFile(file);
            if (bl && file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray == null) {
                    return;
                }
                for (File file2 : fileArray) {
                    this.addFile(svnClient, file2, bl);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProperties() {
        SVNUrl sVNUrl;
        try {
            sVNUrl = SvnUtils.getRepositoryRootUrl(this.root);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        final int[] nArray = this.propTable.getSelectedItems();
        RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(sVNUrl);
        try {
            this.support = new SvnProgressSupport(){
                SvnClient client;

                protected void perform() {
                    try {
                        this.client = Subversion.getInstance().getClient(sVNUrl);
                    }
                    catch (SVNClientException sVNClientException) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                        return;
                    }
                    try {
                        boolean bl = ((SvnProperties)SvnProperties.this).panel.cbxRecursively.isSelected();
                        for (int i = nArray.length - 1; i >= 0; --i) {
                            SvnPropertiesNode[] svnPropertiesNodeArray = SvnProperties.this.propTable.getNodes();
                            List<SvnPropertiesNode> list = Arrays.asList(svnPropertiesNodeArray);
                            String string = svnPropertiesNodeArray[SvnProperties.this.propTable.getModelIndex(nArray[i])].getName();
                            this.client.propertyDel(SvnProperties.this.root, string, bl);
                            try {
                                list.remove(svnPropertiesNodeArray[SvnProperties.this.propTable.getModelIndex(nArray[i])]);
                            }
                            catch (UnsupportedOperationException unsupportedOperationException) {
                                // empty catch block
                            }
                            SvnProperties.this.propTable.setNodes((SvnPropertiesNode[])list.toArray());
                        }
                    }
                    catch (SVNClientException sVNClientException) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                        return;
                    }
                }
            };
            this.support.start(requestProcessor, sVNUrl, NbBundle.getMessage(SvnProperties.class, (String)"LBL_Properties_Progress"));
        }
        finally {
            this.support = null;
        }
        this.refreshProperties();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.validateUserInput(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.validateUserInput(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.validateUserInput(documentEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateUserInput(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        Object object = this.panel.txtAreaValue;
        synchronized (object) {
            if (document.equals(this.panel.txtAreaValue.getDocument()) && this.isLoadedFromFile()) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        ((SvnProperties)SvnProperties.this).panel.txtAreaValue.setText("");
                    }
                });
                this.setLoadedFromFile(false);
            }
        }
        object = this.panel.comboName.getEditor().getItem().toString().trim();
        String string = this.panel.txtAreaValue.getText().trim();
        if (((String)object).length() == 0 || string.length() == 0 || ((String)object).indexOf(" ") > 0) {
            this.panel.btnAdd.setEnabled(false);
        } else {
            this.panel.btnAdd.setEnabled(true);
        }
        if (this.root.isFile()) {
            if (((String)object).equals("svn:ignore") || ((String)object).equals("svn:externals")) {
                this.panel.btnAdd.setEnabled(false);
            }
        } else if (this.root.isDirectory() && (((String)object).equals("svn:eol-style") || ((String)object).equals("svn:executable") || ((String)object).equals("svn:keywords") || ((String)object).equals("svn:needs-lock") || ((String)object).equals("svn:mime-type"))) {
            this.panel.btnAdd.setEnabled(false);
        }
    }

    public class TableMouseListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                int[] nArray = SvnProperties.this.propTable.getSelectedItems();
                SvnPropertiesNode[] svnPropertiesNodeArray = SvnProperties.this.propTable.getNodes();
                if (svnPropertiesNodeArray == null) {
                    return;
                }
                final String string = svnPropertiesNodeArray[SvnProperties.this.propTable.getModelIndex(nArray[0])].getName();
                final String string2 = svnPropertiesNodeArray[SvnProperties.this.propTable.getModelIndex(nArray[0])].getValue();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        ((SvnProperties)SvnProperties.this).panel.comboName.getEditor().setItem(string);
                        ((SvnProperties)SvnProperties.this).panel.txtAreaValue.setText(string2);
                    }
                });
            }
        }
    }
}

