/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.project;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.commit.CommitAction;
import org.netbeans.modules.subversion.ui.wizards.ImportWizard;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class ImportAction
extends NodeAction {
    public ImportAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(ImportAction.class, (String)"BK0006");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray.length == 1) {
            FileInformation fileInformation;
            FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
            File file = this.lookupImportDirectory(nodeArray[0]);
            if (file != null && file.isDirectory() && ((fileInformation = fileStatusCache.getStatus(file)).getStatus() & 0xFFFFFFFE) == 0) {
                FileObject fileObject = FileUtil.toFileObject((File)file);
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                if (project == null) {
                    return true;
                }
                FileObject fileObject2 = project.getProjectDirectory();
                return !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject);
            }
        }
        return false;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] nodeArray) {
        File file;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Utils.logVCSActionEvent((String)"SVN");
        if (nodeArray.length == 1 && (file = this.lookupImportDirectory(nodeArray[0])) != null) {
            ArrayList<File> arrayList = new ArrayList<File>(1);
            arrayList.add(file);
            Context context = new Context(Context.getEmptyList(), arrayList, Context.getEmptyList());
            ImportWizard importWizard = new ImportWizard(context);
            if (!importWizard.show()) {
                return;
            }
            Map map = importWizard.getCommitFiles();
            String string = importWizard.getMessage();
            this.performAction(context, map, string);
        }
    }

    private void performAction(final Context context, final Map map, final String string) {
        SVNUrl sVNUrl;
        try {
            sVNUrl = SvnUtils.getRepositoryRootUrl(context.getRootFiles()[0]);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(sVNUrl);
        SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

            public void perform() {
                CommitAction.performCommit(string, map, context, this, true);
            }
        };
        svnProgressSupport.start(requestProcessor, sVNUrl, NbBundle.getMessage(ImportAction.class, (String)"LBL_Import_Progress"));
    }

    public boolean cancel() {
        return true;
    }

    private File lookupImportDirectory(Node node) {
        Object object = null;
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project != null) {
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
            if (sourceGroupArray.length == 1) {
                FileObject fileObject = sourceGroupArray[0].getRootFolder();
                object = FileUtil.toFile((FileObject)fileObject);
            } else {
                object = FileUtil.toFile((FileObject)project.getProjectDirectory());
            }
        } else {
            Object object2;
            FileObject fileObject = null;
            Collection collection = node.getLookup().lookup(new Lookup.Template(FileObject.class)).allInstances();
            if (collection.size() > 0) {
                fileObject = (FileObject)collection.iterator().next();
            } else {
                object2 = (DataObject)node.getCookie(DataObject.class);
                if (object2 instanceof DataShadow) {
                    object2 = ((DataShadow)object2).getOriginal();
                }
                if (object2 != null) {
                    fileObject = object2.getPrimaryFile();
                }
            }
            if (fileObject != null && (object2 = FileUtil.toFile((FileObject)fileObject)) != null && ((File)object2).isDirectory()) {
                object = object2;
            }
        }
        return object;
    }
}

