/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.options;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.netbeans.modules.subversion.Annotator;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.options.AnnotationSettings;
import org.netbeans.modules.subversion.options.LabelsPanel;
import org.netbeans.modules.subversion.options.SvnOptionsPanel;
import org.netbeans.modules.subversion.ui.repository.Repository;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class SvnOptionsController
extends OptionsPanelController
implements ActionListener {
    private final SvnOptionsPanel panel;
    private final Repository repository;
    private final AnnotationSettings annotationSettings;

    public SvnOptionsController() {
        int n = 20;
        String string = NbBundle.getMessage(SvnOptionsController.class, (String)"CTL_Repository_Location");
        this.repository = new Repository(n, string);
        this.annotationSettings = new AnnotationSettings();
        this.panel = new SvnOptionsPanel();
        this.panel.browseButton.addActionListener(this);
        this.panel.manageConnSettingsButton.addActionListener(this);
        this.panel.manageLabelsButton.addActionListener(this);
        String string2 = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettingsPanel.annotationTextField.toolTipText", (Object[])Annotator.LABELS);
        this.panel.annotationTextField.setToolTipText(string2);
        this.panel.addButton.addActionListener(this);
    }

    public void update() {
        this.panel.executablePathTextField.setText(SvnModuleConfig.getDefault().getExecutableBinaryPath());
        this.panel.annotationTextField.setText(SvnModuleConfig.getDefault().getAnnotationFormat());
        this.annotationSettings.update();
        this.repository.refreshUrlHistory();
    }

    public void applyChanges() {
        if (!this.panel.executablePathTextField.getText().equals(SvnModuleConfig.getDefault().getExecutableBinaryPath())) {
            SvnClientFactory.reset();
        }
        SvnModuleConfig.getDefault().setExecutableBinaryPath(this.panel.executablePathTextField.getText());
        SvnModuleConfig.getDefault().setAnnotationFormat(this.panel.annotationTextField.getText());
        this.annotationSettings.applyChanges();
        Subversion.getInstance().getAnnotator().refresh();
        Subversion.getInstance().refreshAllAnnotations();
    }

    public void cancel() {
        this.repository.refreshUrlHistory();
    }

    public boolean isValid() {
        return true;
    }

    public boolean isChanged() {
        return !this.panel.executablePathTextField.getText().equals(SvnModuleConfig.getDefault().getExecutableBinaryPath()) || !this.panel.annotationTextField.getText().equals(SvnModuleConfig.getDefault().getAnnotationFormat()) || this.repository.isChanged() || this.annotationSettings.isChanged();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    public JComponent getComponent(Lookup lookup) {
        return this.panel;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.panel.browseButton) {
            this.onBrowseClick();
        } else if (actionEvent.getSource() == this.panel.manageConnSettingsButton) {
            this.onManageConnClick();
        } else if (actionEvent.getSource() == this.panel.manageLabelsButton) {
            this.onManageLabelsClick();
        } else if (actionEvent.getSource() == this.panel.addButton) {
            this.onAddClick();
        }
    }

    private File getExecutableFile() {
        String string = this.panel.executablePathTextField.getText();
        return FileUtil.normalizeFile((File)new File(string));
    }

    private void onBrowseClick() {
        File file = this.getExecutableFile();
        AccessibleJFileChooser accessibleJFileChooser = new AccessibleJFileChooser(NbBundle.getMessage(SvnOptionsController.class, (String)"ACSD_BrowseFolder"), file);
        accessibleJFileChooser.setDialogTitle(NbBundle.getMessage(SvnOptionsController.class, (String)"Browse_title"));
        accessibleJFileChooser.setMultiSelectionEnabled(false);
        accessibleJFileChooser.setFileSelectionMode(1);
        accessibleJFileChooser.showDialog(this.panel, NbBundle.getMessage(SvnOptionsController.class, (String)"OK_Button"));
        File file2 = accessibleJFileChooser.getSelectedFile();
        if (file2 != null) {
            this.panel.executablePathTextField.setText(file2.getAbsolutePath());
        }
    }

    private void onManageConnClick() {
        boolean bl = this.repository.show(NbBundle.getMessage(SvnOptionsController.class, (String)"CTL_ManageConnections"), new HelpCtx(Repository.class), true);
        if (bl) {
            this.repository.storeRecentUrls();
        } else {
            this.repository.refreshUrlHistory();
        }
    }

    private void onManageLabelsClick() {
        String string = this.panel.annotationTextField.getText().replaceAll(" ", "");
        this.annotationSettings.show(string != null && string.indexOf("{folder}") > -1);
    }

    private void onAddClick() {
        Object object;
        LabelsPanel labelsPanel = new LabelsPanel();
        ArrayList<Object> arrayList = new ArrayList<Object>(Annotator.LABELS.length);
        for (int i = 0; i < Annotator.LABELS.length; ++i) {
            object = new LabelVariable(Annotator.LABELS[i], "{" + Annotator.LABELS[i] + "} - " + NbBundle.getMessage(AnnotationSettings.class, (String)("AnnotationSettings.label." + Annotator.LABELS[i])));
            arrayList.add(object);
        }
        labelsPanel.labelsList.setListData(arrayList.toArray(new LabelVariable[arrayList.size()]));
        String string = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettings.labelVariables.title");
        object = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettings.labelVariables.acsd");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)labelsPanel, string);
        dialogDescriptor.setModal(true);
        dialogDescriptor.setValid(true);
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription((String)object);
        labelsPanel.labelsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    dialog.setVisible(false);
                }
            }
        });
        dialog.setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            Object[] objectArray = labelsPanel.labelsList.getSelectedValues();
            String string2 = "";
            for (int i = 0; i < objectArray.length; ++i) {
                string2 = string2 + "{" + ((LabelVariable)objectArray[i]).getVariable() + "}";
            }
            String string3 = this.panel.annotationTextField.getText();
            int n = this.panel.annotationTextField.getCaretPosition();
            if (n < 0) {
                n = string3.length();
            }
            StringBuffer stringBuffer = new StringBuffer(string3.length() + string2.length());
            stringBuffer.append(string3.substring(0, n));
            stringBuffer.append(string2);
            if (n < string3.length()) {
                stringBuffer.append(string3.substring(n, string3.length()));
            }
            this.panel.annotationTextField.setText(stringBuffer.toString());
            this.panel.annotationTextField.requestFocus();
            this.panel.annotationTextField.setCaretPosition(n + string2.length());
        }
    }

    private class LabelVariable {
        private String description;
        private String variable;

        public LabelVariable(String string, String string2) {
            this.description = string2;
            this.variable = string;
        }

        public String toString() {
            return this.description;
        }

        public String getDescription() {
            return this.description;
        }

        public String getVariable() {
            return this.variable;
        }
    }
}

