/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.netbeans.modules.subversion.client.cli.SvnCommand;
import org.openide.xml.XMLUtil;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class LogCommand
extends SvnCommand {
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private byte[] output;
    private final LogType type;
    private final File file;
    private final SVNRevision revStart;
    private final SVNRevision revEnd;
    private final boolean stopOnCopy;
    private final boolean fetchChangePath;
    private final long limit;
    private final SVNUrl url;
    private final String[] paths;

    public LogCommand(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl, boolean bl2, long l) {
        this.file = file;
        this.revStart = sVNRevision;
        this.revEnd = sVNRevision2;
        this.stopOnCopy = bl;
        this.fetchChangePath = bl2;
        this.limit = l;
        this.type = LogType.file;
        this.url = null;
        this.paths = null;
    }

    public LogCommand(SVNUrl sVNUrl, String[] stringArray, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl, boolean bl2, long l) {
        this.revStart = sVNRevision;
        this.revEnd = sVNRevision2;
        this.stopOnCopy = bl;
        this.fetchChangePath = bl2;
        this.limit = l;
        this.url = sVNUrl;
        this.paths = stringArray;
        this.type = LogType.url;
        this.file = null;
    }

    protected boolean hasBinaryOutput() {
        return true;
    }

    protected boolean notifyOutput() {
        return false;
    }

    protected int getCommand() {
        return 13;
    }

    public void output(byte[] byArray) {
        super.output(byArray);
        this.output = byArray;
    }

    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("log");
        arguments.add(this.revStart, this.revEnd);
        switch (this.type) {
            case file: {
                arguments.add(this.file);
                break;
            }
            case url: {
                arguments.add(this.url);
                if (this.paths == null) break;
                arguments.addPathArguments(this.paths);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal logtype: " + (Object)((Object)this.type));
            }
        }
        arguments.add("--xml");
        if (this.fetchChangePath) {
            arguments.add("-v");
        }
        if (this.stopOnCopy) {
            arguments.add("--stop-on-copy");
        }
        if (this.limit > 0L) {
            arguments.add("--limit");
            arguments.add(Long.toString(this.limit));
        }
    }

    public ISVNLogMessage[] getLogMessages() throws SVNClientException {
        if (this.output == null || this.output.length == 0) {
            return new ISVNLogMessage[0];
        }
        try {
            XMLReader xMLReader = XMLUtil.createXMLReader();
            XmlEntriesHandler xmlEntriesHandler = new XmlEntriesHandler();
            xMLReader.setContentHandler(xmlEntriesHandler);
            xMLReader.setErrorHandler(xmlEntriesHandler);
            InputSource inputSource = new InputSource(new ByteArrayInputStream(this.output));
            xMLReader.parse(inputSource);
            return xmlEntriesHandler.getLog();
        }
        catch (SAXException sAXException) {
            throw new SVNClientException((Throwable)sAXException);
        }
        catch (IOException iOException) {
            throw new SVNClientException((Throwable)iOException);
        }
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private class LogMessage
    implements ISVNLogMessage {
        private final String msg;
        private final SVNRevision.Number rev;
        private final String author;
        private final Date date;
        private final ISVNLogMessageChangePath[] paths;

        public LogMessage(String string, SVNRevision.Number number, String string2, Date date, ISVNLogMessageChangePath[] iSVNLogMessageChangePathArray) {
            this.msg = string;
            this.rev = number;
            this.author = string2;
            this.date = date;
            this.paths = iSVNLogMessageChangePathArray;
        }

        public SVNRevision.Number getRevision() {
            return this.rev;
        }

        public String getAuthor() {
            return this.author;
        }

        public Date getDate() {
            return this.date;
        }

        public String getMessage() {
            return this.msg;
        }

        public ISVNLogMessageChangePath[] getChangedPaths() {
            return this.paths;
        }

        public long getTimeMicros() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getTimeMillis() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getNumberOfChildren() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ISVNLogMessage[] getChildMessages() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class XmlEntriesHandler
    extends DefaultHandler {
        private static final String PATH_ELEMENT_NAME = "path";
        private static final String ENTRY_ELEMENT_NAME = "logentry";
        private static final String MSG_ELEMENT_NAME = "msg";
        private static final String AUTHOR_ELEMENT_NAME = "author";
        private static final String DATE_ELEMENT_NAME = "date";
        private static final String ACTION_ATTRIBUTE = "action";
        private static final String REVISION_ATTRIBUTE = "revision";
        private List<ISVNLogMessage> logs = new ArrayList<ISVNLogMessage>();
        private Map<String, Object> values;
        private String tag;

        private XmlEntriesHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.tag = string3.trim();
            if (ENTRY_ELEMENT_NAME.equals(string3)) {
                this.values = new HashMap<String, Object>();
                this.values.put(REVISION_ATTRIBUTE, attributes.getValue(REVISION_ATTRIBUTE));
            } else if (PATH_ELEMENT_NAME.equals(string3)) {
                List<Path> list = this.getPathList();
                Path path = new Path();
                path.action = attributes.getValue(ACTION_ATTRIBUTE).charAt(0);
                path.copyPath = attributes.getValue("copyfrom-path");
                path.copyRev = attributes.getValue("copyfrom-rev");
                list.add(path);
            } else if (this.values != null) {
                this.values.put(this.tag, "");
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.values == null || this.tag == null) {
                return;
            }
            String string = this.toString(n2, cArray, n);
            if (this.tag.equals(PATH_ELEMENT_NAME)) {
                List<Path> list = this.getPathList();
                list.get((int)(list.size() - 1)).path = list.get((int)(list.size() - 1)).path + string;
            } else {
                Object object = this.values.get(this.tag);
                if (object == null) {
                    this.values.put(this.tag, string);
                } else {
                    this.values.put(this.tag, object + string);
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            this.tag = null;
            if (ENTRY_ELEMENT_NAME.equals(string3) && this.values != null) {
                SVNLogMessageChangePath[] sVNLogMessageChangePathArray;
                String string4 = (String)this.values.get(AUTHOR_ELEMENT_NAME);
                if (string4 == null) {
                    string4 = "";
                }
                Date date = null;
                String string5 = (String)this.values.get(DATE_ELEMENT_NAME);
                if (string5 == null) {
                    throw new SAXException("'date' tag expected under 'logentry'");
                }
                try {
                    date = dateFormat.parse(string5);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                String string6 = (String)this.values.get(MSG_ELEMENT_NAME);
                if (string6 == null) {
                    string6 = "";
                }
                SVNRevision.Number number = this.getRevision((String)this.values.get(REVISION_ATTRIBUTE));
                List<Path> list = this.getPathList();
                if (list.size() > 0) {
                    sVNLogMessageChangePathArray = new SVNLogMessageChangePath[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        Path path = list.get(i);
                        sVNLogMessageChangePathArray[i] = new SVNLogMessageChangePath(path.path, this.getRevision(path.copyRev), path.copyPath, path.action);
                    }
                } else {
                    sVNLogMessageChangePathArray = new SVNLogMessageChangePath[]{};
                }
                this.logs.add(new LogMessage(string6, number, string4, date, (ISVNLogMessageChangePath[])sVNLogMessageChangePathArray));
                this.values = null;
            }
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public ISVNLogMessage[] getLog() {
            return this.logs.toArray(new ISVNLogMessage[this.logs.size()]);
        }

        private String toString(int n, char[] cArray, int n2) {
            char[] cArray2 = new char[n];
            System.arraycopy(cArray, n2, cArray2, 0, n);
            return new String(cArray2);
        }

        private List<Path> getPathList() {
            ArrayList arrayList = (ArrayList)this.values.get(PATH_ELEMENT_NAME);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.values.put(PATH_ELEMENT_NAME, arrayList);
            }
            return arrayList;
        }

        private SVNRevision.Number getRevision(String string) {
            SVNRevision.Number number = null;
            if (string != null && !string.trim().equals("")) {
                try {
                    number = new SVNRevision.Number(Long.parseLong(string));
                }
                catch (NumberFormatException numberFormatException) {
                    new SVNRevision.Number(-1L);
                }
            }
            return number;
        }

        private class Path {
            char action;
            String path = "";
            String copyRev;
            String copyPath;

            private Path() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LogType {
        file,
        url;

    }
}

