/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.util.logging.Level;
import javax.net.ssl.SSLKeyException;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientDescriptor;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.config.SvnConfigFiles;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.Cancellable;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SvnClientInvocationHandler
implements InvocationHandler {
    protected static final String GET_SINGLE_STATUS = "getSingleStatus";
    protected static final String GET_STATUS = "getStatus";
    protected static final String GET_INFO_FROM_WORKING_COPY = "getInfoFromWorkingCopy";
    private static Object semaphor = new Object();
    private final ISVNClientAdapter adapter;
    private final SvnClientDescriptor desc;
    private Cancellable cancellable;
    private SvnProgressSupport support;
    private final int handledExceptions;
    private static boolean metricsAlreadyLogged = false;

    public SvnClientInvocationHandler(ISVNClientAdapter iSVNClientAdapter, SvnClientDescriptor svnClientDescriptor, int n) {
        assert (iSVNClientAdapter != null);
        assert (svnClientDescriptor != null);
        this.adapter = iSVNClientAdapter;
        this.desc = svnClientDescriptor;
        this.handledExceptions = n;
    }

    public SvnClientInvocationHandler(ISVNClientAdapter iSVNClientAdapter, SvnClientDescriptor svnClientDescriptor, SvnProgressSupport svnProgressSupport, int n) {
        assert (iSVNClientAdapter != null);
        assert (svnClientDescriptor != null);
        this.adapter = iSVNClientAdapter;
        this.desc = svnClientDescriptor;
        this.support = svnProgressSupport;
        this.handledExceptions = n;
        this.cancellable = new Cancellable(){

            public boolean cancel() {
                try {
                    SvnClientInvocationHandler.this.adapter.cancelOperation();
                }
                catch (SVNClientException sVNClientException) {
                    Subversion.LOG.log(Level.SEVERE, null, sVNClientException);
                    return false;
                }
                return true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        try {
            Object object2;
            Object object3 = null;
            if (this.parallelizable(method, objectArray)) {
                object3 = this.invokeMethod(method, objectArray);
            } else {
                object2 = semaphor;
                synchronized (object2) {
                    object3 = this.invokeMethod(method, objectArray);
                }
            }
            object2 = object3;
            return object2;
        }
        catch (Exception exception) {
            block24: {
                if (!this.handleException((SvnClient)object, exception)) break block24;
                Object object4 = this.invoke(object, method, objectArray);
                return object4;
            }
            try {
                throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SVNClientException) {
                    throw throwable;
                }
                throw invocationTargetException;
            }
            catch (SSLKeyException sSLKeyException) {
                if (sSLKeyException.getCause() instanceof InvalidKeyException) {
                    InvalidKeyException invalidKeyException = (InvalidKeyException)sSLKeyException.getCause();
                    if (invalidKeyException.getMessage().toLowerCase().equals("illegal key size or default parameters")) {
                        SvnClientExceptionHandler.handleInvalidKeyException(invalidKeyException);
                    }
                    Object var7_15 = null;
                    return var7_15;
                }
                throw sSLKeyException;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (throwable instanceof InterruptedException) {
                    throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
                }
                if (throwable instanceof SVNClientException && (throwable2 = throwable.getCause()) instanceof IOException && (throwable2 = throwable2.getCause()) instanceof InterruptedException) {
                    throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
                }
                throwable2 = throwable.getCause();
                if (throwable2 instanceof InterruptedException) {
                    throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
                }
                if (this.support != null && this.support.isCanceled()) {
                    Subversion.LOG.log(Level.WARNING, null, throwable);
                    throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
                }
                throw throwable;
            }
        }
        finally {
            Subversion.getInstance().getRefreshHandler().refresh();
        }
    }

    private void logClientInvoked() {
        if (metricsAlreadyLogged) {
            return;
        }
        try {
            SvnClientFactory.checkClientAvailable();
        }
        catch (SVNClientException sVNClientException) {
            return;
        }
        String string = null;
        if (SvnClientFactory.isCLI()) {
            string = "CLI";
        } else if (SvnClientFactory.isJavaHl()) {
            string = "JAVAHL";
        } else if (SvnClientFactory.isSvnKit()) {
            string = "SVNKIT";
        } else {
            Subversion.LOG.warning("Unknown client type!");
        }
        if (string != null) {
            Utils.logVCSClientEvent((String)"SVN", (String)string);
        }
        metricsAlreadyLogged = true;
    }

    private boolean parallelizable(Method method, Object[] objectArray) {
        return this.isLocalReadCommand(method, objectArray);
    }

    protected boolean isLocalReadCommand(Method method, Object[] objectArray) {
        String string = method.getName();
        return string.equals(GET_SINGLE_STATUS) || string.equals(GET_INFO_FROM_WORKING_COPY) || method.getName().equals(GET_STATUS) && method.getParameterTypes().length == 3;
    }

    protected Object invokeMethod(Method method, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.handle(method, objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object handle(Method method, Object[] objectArray) throws SecurityException, InvocationTargetException, IllegalAccessException, NoSuchMethodException, IllegalArgumentException {
        Class<?>[] classArray = method.getParameterTypes();
        Class<?> clazz = method.getDeclaringClass();
        if (ISVNClientAdapter.class.isAssignableFrom(clazz)) {
            if (this.support != null) {
                this.support.setCancellableDelegate(this.cancellable);
            }
            if (this.desc != null && this.desc.getSvnUrl() != null) {
                SvnConfigFiles.getInstance().storeSvnServersSettings(this.desc.getSvnUrl());
            }
        } else {
            if (Cancellable.class.isAssignableFrom(clazz)) {
                return this.cancellable.getClass().getMethod(method.getName(), classArray).invoke((Object)this.cancellable, objectArray);
            }
            if (!SvnClientDescriptor.class.isAssignableFrom(clazz)) return this.adapter.getClass().getMethod(method.getName(), classArray).invoke((Object)this.adapter, objectArray);
            if (this.desc == null) throw new NoSuchMethodException(method.getName());
            return this.desc.getClass().getMethod(method.getName(), classArray).invoke((Object)this.desc, objectArray);
        }
        this.logClientInvoked();
        Object object = this.adapter.getClass().getMethod(method.getName(), classArray).invoke((Object)this.adapter, objectArray);
        if (this.support == null) return object;
        this.support.setCancellableDelegate(null);
        return object;
    }

    private boolean handleException(SvnClient svnClient, Throwable throwable) throws Throwable {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getCause();
        }
        if (!(throwable instanceof SVNClientException)) {
            throw throwable;
        }
        SvnClientExceptionHandler svnClientExceptionHandler = new SvnClientExceptionHandler((SVNClientException)throwable, this.adapter, svnClient, this.desc, this.handledExceptions);
        return svnClientExceptionHandler.handleException();
    }
}

