/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SubversionVCS;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.spi.queries.VisibilityQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SubversionVisibilityQuery
implements VisibilityQueryImplementation2,
VersioningListener {
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private FileStatusCache cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisible(FileObject fileObject) {
        boolean bl;
        block6: {
            boolean bl2;
            long l;
            block4: {
                boolean bl3;
                block5: {
                    l = System.currentTimeMillis();
                    Subversion.LOG.log(Level.FINE, "isVisible {0}", new Object[]{fileObject});
                    bl2 = true;
                    try {
                        if (!fileObject.isData()) break block4;
                        bl3 = true;
                        if (!Subversion.LOG.isLoggable(Level.FINE)) break block5;
                    }
                    catch (Throwable throwable) {
                        if (Subversion.LOG.isLoggable(Level.FINE)) {
                            Subversion.LOG.log(Level.FINE, "isVisible returns {0} in {1} millis", new Object[]{bl2, System.currentTimeMillis() - l});
                        }
                        throw throwable;
                    }
                    Subversion.LOG.log(Level.FINE, "isVisible returns {0} in {1} millis", new Object[]{bl2, System.currentTimeMillis() - l});
                }
                return bl3;
            }
            File file = FileUtil.toFile((FileObject)fileObject);
            bl = bl2 = this.isVisible(file);
            if (!Subversion.LOG.isLoggable(Level.FINE)) break block6;
            Subversion.LOG.log(Level.FINE, "isVisible returns {0} in {1} millis", new Object[]{bl2, System.currentTimeMillis() - l});
        }
        return bl;
    }

    public boolean isVisible(File file) {
        if (file == null) {
            return true;
        }
        if (file.isFile()) {
            return true;
        }
        if (!(VersioningSupport.getOwner((File)file) instanceof SubversionVCS)) {
            return true;
        }
        try {
            return this.getCache().getStatus(file).getStatus() != 256;
        }
        catch (Exception exception) {
            Subversion.LOG.log(Level.SEVERE, exception.getMessage(), exception);
            return true;
        }
    }

    private synchronized FileStatusCache getCache() {
        if (this.cache == null) {
            this.cache = Subversion.getInstance().getStatusCache();
            this.cache.addVersioningListener(this);
        }
        return this.cache;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>(this.listeners);
        arrayList.add(changeListener);
        this.listeners = arrayList;
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>(this.listeners);
        arrayList.remove(changeListener);
        this.listeners = arrayList;
    }

    public void versioningEvent(VersioningEvent versioningEvent) {
        File file;
        if (versioningEvent.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED && (file = (File)versioningEvent.getParams()[0]) != null && file.isDirectory()) {
            FileInformation fileInformation = (FileInformation)versioningEvent.getParams()[1];
            FileInformation fileInformation2 = (FileInformation)versioningEvent.getParams()[2];
            if (fileInformation != null && fileInformation.getStatus() == 256 || fileInformation2.getStatus() == 256) {
                this.fireVisibilityChanged();
            }
        }
    }

    static boolean isHiddenFolder(FileInformation fileInformation, File file) {
        return file.isDirectory() && fileInformation != null && fileInformation.getStatus() == 256;
    }

    private void fireVisibilityChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

