/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CvsLiteAdminHandler
implements AdminHandler {
    static final String INVALID_METADATA_MARKER = "invalid-metadata";
    private static final String INVALID_METADATA_MARKER_PATH = "CVS/invalid-metadata";
    private StandardAdminHandler stdHandler = new StandardAdminHandler();

    private void checkForInvalidMetadata(File file) {
        File file2 = new File(file, INVALID_METADATA_MARKER_PATH);
        if (file2.exists()) {
            Utils.deleteRecursively((File)file2.getParentFile());
        }
    }

    public void updateAdminData(String string, String string2, Entry entry, GlobalOptions globalOptions) throws IOException {
        this.checkForInvalidMetadata(new File(string));
        this.stdHandler.updateAdminData(string, string2, entry, globalOptions);
    }

    public Entry getEntry(File file) throws IOException {
        this.checkForInvalidMetadata(file.getParentFile());
        return this.stdHandler.getEntry(file);
    }

    public boolean exists(File file) {
        if (file.exists()) {
            return true;
        }
        if ("CVS".equals(file.getName())) {
            file = file.getParentFile();
        }
        return false;
    }

    public Iterator<Entry> getEntries(File file) throws IOException {
        this.checkForInvalidMetadata(file);
        if (new File(file, "CVS").isDirectory()) {
            return this.stdHandler.getEntries(file);
        }
        file = FileUtil.normalizeFile((File)file);
        return this.stdHandler.getEntries(file);
    }

    public Entry[] getEntriesAsArray(File file) throws IOException {
        this.checkForInvalidMetadata(file);
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        Iterator<Entry> iterator = this.getEntries(file);
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList.toArray(new Entry[arrayList.size()]);
    }

    public void setEntry(File file, Entry entry) throws IOException {
        this.checkForInvalidMetadata(file.getParentFile());
        File file2 = new File(file.getParentFile(), "CVS");
        this.createAdminDirs(file2);
        this.stdHandler.setEntry(file, entry);
    }

    private void createAdminDirs(File file) throws IOException {
        if (!file.exists() && file.getParentFile() != null && file.getParentFile().getParentFile() != null) {
            this.createAdminDirs(new File(file.getParentFile().getParentFile(), "CVS"));
        }
    }

    public String getRepositoryForDirectory(String string, String string2) throws IOException {
        this.checkForInvalidMetadata(new File(string));
        File file = new File(string);
        if (file.exists()) {
            return this.stdHandler.getRepositoryForDirectory(string, string2);
        }
        return this.stdHandler.getRepositoryForDirectory(string, string2);
    }

    public void removeEntry(File file) throws IOException {
        File file2 = file.getParentFile();
        this.checkForInvalidMetadata(file2);
        this.stdHandler.removeEntry(file);
    }

    public Set getAllFiles(File file) throws IOException {
        this.checkForInvalidMetadata(file);
        return this.stdHandler.getAllFiles(file);
    }

    public String getStickyTagForDirectory(File file) {
        this.checkForInvalidMetadata(file);
        return this.stdHandler.getStickyTagForDirectory(file);
    }
}

