/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.designtime.base;

import com.sun.rave.designtime.CategoryDescriptor;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class CategoryDescriptors {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("com.sun.rave.designtime.base.Bundle", Locale.getDefault(), CategoryDescriptors.class.getClassLoader());
    public static final CategoryDescriptor ACCESSIBILITY = new CategoryDescriptor(bundle.getString("accessibility"), bundle.getString("accessibilityCatDesc"), false);
    public static final CategoryDescriptor ADVANCED = new CategoryDescriptor(bundle.getString("adv"), bundle.getString("advCatDesc"), false);
    public static final CategoryDescriptor APPEARANCE = new CategoryDescriptor(bundle.getString("appear"), bundle.getString("appearCatDesc"), true);
    public static final CategoryDescriptor BEHAVIOR = new CategoryDescriptor(bundle.getString("behavior"), bundle.getString("behaviorCatDesc"), false);
    public static final CategoryDescriptor DATA = new CategoryDescriptor(bundle.getString("data"), bundle.getString("dataCatDesc"), true);
    public static final CategoryDescriptor EVENTS = new CategoryDescriptor(bundle.getString("ev"), bundle.getString("evCatDesc"), true);
    public static final CategoryDescriptor GENERAL = new CategoryDescriptor(bundle.getString("gen"), bundle.getString("genCatDesc"), true);
    public static final CategoryDescriptor INTERNAL = new CategoryDescriptor(bundle.getString("intern"), bundle.getString("internCatDesc"), false);
    public static final CategoryDescriptor JAVASCRIPT = new CategoryDescriptor(bundle.getString("js"), bundle.getString("jsCatDesc"), false);
    public static final CategoryDescriptor LAYOUT = new CategoryDescriptor(bundle.getString("layout"), bundle.getString("layoutCatDesc"), false);
    public static final CategoryDescriptor NAVIGATION = new CategoryDescriptor(bundle.getString("navigation"), bundle.getString("navigationCatDesc"), false);
    private static CategoryDescriptor[] defaultCategoryDescriptors = new CategoryDescriptor[]{GENERAL, APPEARANCE, LAYOUT, DATA, EVENTS, NAVIGATION, BEHAVIOR, ACCESSIBILITY, JAVASCRIPT, ADVANCED, INTERNAL};
    protected static HashMap categoryHash;

    public static CategoryDescriptor getCategoryDescriptor(String categoryName) {
        if (categoryName == null) {
            return null;
        }
        Object[] pair = (Object[])categoryHash.get(categoryName.toLowerCase());
        if (pair == null) {
            pair = new Object[]{null, new CategoryDescriptor(categoryName, "")};
            categoryHash.put(categoryName, pair);
        }
        return (CategoryDescriptor)pair[1];
    }

    public static String getCategoryDescriptorConstantName(String categoryName) {
        if (categoryName == null) {
            return null;
        }
        Object[] pair = (Object[])categoryHash.get(categoryName.toLowerCase());
        if (pair == null) {
            return null;
        }
        return (String)pair[0];
    }

    public static CategoryDescriptor[] getDefaultCategoryDescriptors() {
        return defaultCategoryDescriptors;
    }
}

