/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component.table;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.faces.FacesDesignContext;
import com.sun.webui.jsf.component.Table;
import com.sun.webui.jsf.component.TableRowGroup;
import com.sun.webui.jsf.model.DefaultTableDataProvider;
import java.util.logging.Logger;

public final class TableDesignHelper {
    private static final String SOURCE_DATA_PROPERTY = "sourceData";
    public static final String DEFAULT_TABLE_DATA_PROVIDER = "defaultTableDataProvider";
    private static final int INITIAL_TABLE_COLUMN_WIDTH = 150;
    private static final String WIDTH_PROPRTY = "width";

    private TableDesignHelper() {
    }

    public static DesignBean createDefaultDataProvider(DesignBean tableBean) {
        FacesDesignContext fcontext = (FacesDesignContext)tableBean.getDesignContext();
        DesignBean[] defTableDataProviderBeans = fcontext.getBeansOfType(DefaultTableDataProvider.class);
        if (defTableDataProviderBeans == null || defTableDataProviderBeans.length < 1) {
            DesignBean defaultDataProvider = fcontext.createBean(DefaultTableDataProvider.class.getName(), null, null);
            defaultDataProvider.setInstanceName(DEFAULT_TABLE_DATA_PROVIDER);
            return defaultDataProvider;
        }
        return defTableDataProviderBeans[0];
    }

    public static boolean isDefaultDataProvider(DesignBean tableBean, DesignBean dataProviderBean) {
        FacesDesignContext fcontext = (FacesDesignContext)tableBean.getDesignContext();
        DesignBean[] defTableDataProviderBeans = fcontext.getBeansOfType(DefaultTableDataProvider.class);
        return defTableDataProviderBeans != null && defTableDataProviderBeans.length > 0 && dataProviderBean == defTableDataProviderBeans[0];
    }

    public static void deleteDefaultDataProvider(DesignBean designBean) {
        FacesDesignContext fcontext = (FacesDesignContext)designBean.getDesignContext();
        DesignBean[] defTableDataProviderBeans = fcontext.getBeansOfType(DefaultTableDataProvider.class);
        if (defTableDataProviderBeans != null && defTableDataProviderBeans.length > 0) {
            int i;
            DesignBean[] tableBeans;
            DesignBean tableBean;
            if (designBean.getInstance() instanceof TableRowGroup) {
                tableBean = designBean.getBeanParent();
                int childCount = tableBean.getChildBeanCount();
                for (int j = 0; j < childCount; ++j) {
                    String modelBindingExpr;
                    DesignBean childBean = tableBean.getChildBean(j);
                    if (!(childBean.getInstance() instanceof TableRowGroup) || childBean == designBean) continue;
                    String sourceDataStr = null;
                    DesignProperty designProperty = childBean.getProperty(SOURCE_DATA_PROPERTY);
                    if (designProperty == null || !(sourceDataStr = designProperty.getValueSource()).startsWith(modelBindingExpr = fcontext.getBindingExpr(defTableDataProviderBeans[0]))) continue;
                    return;
                }
            } else {
                tableBean = designBean;
            }
            if ((tableBeans = fcontext.getBeansOfType(Table.class)) != null) {
                for (i = 0; i < tableBeans.length; ++i) {
                    if (tableBean == tableBeans[i]) continue;
                    int childCount = tableBeans[i].getChildBeanCount();
                    for (int j = 0; j < childCount; ++j) {
                        DesignBean childBean = tableBeans[i].getChildBean(j);
                        if (!(childBean.getInstance() instanceof TableRowGroup)) continue;
                        TableRowGroup tableRowGroup = (TableRowGroup)childBean.getInstance();
                        String sourceDataStr = null;
                        DesignProperty designProperty = childBean.getProperty(SOURCE_DATA_PROPERTY);
                        if (designProperty == null) continue;
                        sourceDataStr = designProperty.getValueSource();
                        String modelBindingExpr = fcontext.getBindingExpr(defTableDataProviderBeans[0]);
                        if (!modelBindingExpr.startsWith(sourceDataStr)) continue;
                        return;
                    }
                }
            }
            for (i = 0; i < defTableDataProviderBeans.length; ++i) {
                fcontext.deleteBean(defTableDataProviderBeans[i]);
            }
        }
    }

    public static DesignBean getTableRowGroupBean(DesignBean tableBean) {
        DesignBean tableRowGroupBean = null;
        int childCount = tableBean.getChildBeanCount();
        for (int i = 0; i < childCount && !((tableRowGroupBean = tableBean.getChildBean(i)).getInstance() instanceof TableRowGroup); ++i) {
        }
        return tableRowGroupBean;
    }

    public static DesignBean getTableColumnBean(DesignBean tableRowGroupBean, int colNo) {
        DesignBean tableColumnBean = null;
        int childCount = tableRowGroupBean.getChildBeanCount();
        for (int i = 0; i < childCount; ++i) {
            tableColumnBean = tableRowGroupBean.getChildBean(i);
            if (i == colNo) break;
        }
        return tableColumnBean;
    }

    public static void adjustTableWidth(DesignBean tableBean, int oldColumnWidth, int newColumnWidth) {
        DesignBean tableRowGroupBean = TableDesignHelper.getTableRowGroupBean(tableBean);
        if (tableRowGroupBean == null) {
            return;
        }
        int tableWidth = -1;
        DesignProperty widthProperty = tableBean.getProperty(WIDTH_PROPRTY);
        String widthValue = (String)widthProperty.getValue();
        if (widthProperty.getValue() != null) {
            try {
                tableWidth = Integer.parseInt(widthValue);
            }
            catch (Exception exc) {
                tableWidth = -1;
            }
        }
        int childCount = tableRowGroupBean.getChildBeanCount();
        if (tableWidth == -1) {
            for (int i = 0; i < childCount; ++i) {
                DesignBean tableColumnBean = tableRowGroupBean.getChildBean(i);
                DesignProperty columnWidthProperty = tableColumnBean.getProperty(WIDTH_PROPRTY);
                if (columnWidthProperty != null && columnWidthProperty.getValue() != null) {
                    try {
                        int colWidth = Integer.parseInt((String)columnWidthProperty.getValue());
                        tableWidth += colWidth;
                    }
                    catch (Exception exc) {
                        Logger.getLogger(TableDesignHelper.class.getName()).info(exc.getLocalizedMessage());
                        tableWidth += 150;
                    }
                    continue;
                }
                tableWidth += 150;
            }
        }
        if (oldColumnWidth == -1) {
            int noWidthCols = 0;
            int setColumnsWidth = 0;
            for (int i = 0; i < childCount; ++i) {
                DesignBean tableColumnBean = tableRowGroupBean.getChildBean(i);
                DesignProperty tcWidthProperty = tableColumnBean.getProperty(WIDTH_PROPRTY);
                if (tcWidthProperty != null && tcWidthProperty.getValue() != null) {
                    try {
                        int colWidth = Integer.parseInt((String)tcWidthProperty.getValue());
                        setColumnsWidth += colWidth;
                    }
                    catch (Exception exc) {
                        Logger.getLogger(TableDesignHelper.class.getName()).info(exc.getLocalizedMessage());
                        ++noWidthCols;
                    }
                    continue;
                }
                ++noWidthCols;
            }
            if (noWidthCols != 0) {
                oldColumnWidth = (tableWidth - setColumnsWidth) / noWidthCols;
                tableWidth += newColumnWidth - oldColumnWidth;
            }
        }
        widthValue = String.valueOf(tableWidth);
        widthProperty.setValue((Object)widthValue);
    }

    public static void adjustTableWidth(DesignBean tableRowGroupBean) {
        DesignBean tableBean = tableRowGroupBean.getBeanParent();
        DesignProperty tableWidthProperty = tableBean.getProperty(WIDTH_PROPRTY);
        int oldTableWidth = 0;
        int childCount = tableRowGroupBean.getChildBeanCount();
        if (tableWidthProperty != null && tableWidthProperty.getValue() != null) {
            try {
                oldTableWidth = Integer.parseInt((String)tableWidthProperty.getValue());
            }
            catch (Exception exc) {
                Logger.getLogger(TableDesignHelper.class.getName()).info(exc.getLocalizedMessage());
            }
        } else {
            for (int i = 0; i < childCount; ++i) {
                oldTableWidth += 150;
            }
            tableWidthProperty.setValue((Object)String.valueOf(oldTableWidth));
        }
        int newTableWidth = 0;
        for (int i = 0; i < childCount; ++i) {
            DesignBean tableColumnBean = tableRowGroupBean.getChildBean(i);
            DesignProperty columnWidthProperty = tableColumnBean.getProperty(WIDTH_PROPRTY);
            if (columnWidthProperty == null || columnWidthProperty.getValue() == null) continue;
            try {
                int colWidth = Integer.parseInt((String)columnWidthProperty.getValue());
                newTableWidth += colWidth;
                continue;
            }
            catch (Exception exc) {
                Logger.getLogger(TableDesignHelper.class.getName()).info(exc.getLocalizedMessage());
            }
        }
        if (newTableWidth > oldTableWidth) {
            tableWidthProperty.setValue((Object)String.valueOf(newTableWidth));
        }
    }

    public static DesignBean findChildBeanByName(DesignBean parent, String instanceName) {
        DesignBean child = null;
        DesignBean[] childBeans = parent.getChildBeans();
        if (childBeans != null && childBeans.length > 0) {
            for (int i = 0; i < childBeans.length; ++i) {
                if (!instanceName.equals(childBeans[i].getInstanceName())) continue;
                child = childBeans[i];
                break;
            }
        }
        return child;
    }
}

