/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.Result;
import com.sun.rave.designtime.markup.BasicMarkupMouseRegion;
import com.sun.rave.designtime.markup.MarkupDesignBean;
import com.sun.rave.designtime.markup.MarkupMouseRegion;
import com.sun.rave.designtime.markup.MarkupPosition;
import com.sun.rave.designtime.markup.MarkupRenderContext;
import com.sun.webui.jsf.component.Accordion;
import com.sun.webui.jsf.component.AccordionTab;
import com.sun.webui.jsf.component.Body;
import com.sun.webui.jsf.component.PanelLayout;
import com.sun.webui.jsf.component.util.DesignUtil;
import com.sun.webui.jsf.design.AbstractDesignInfo;
import java.util.regex.Pattern;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AccordionTabDesignInfo
extends AbstractDesignInfo {
    private static Pattern gridPattern = Pattern.compile(".*-rave-layout\\s*:\\s*grid.*");

    public AccordionTabDesignInfo() {
        super(AccordionTab.class);
    }

    public Result beanCreatedSetup(DesignBean bean) {
        DesignBean childBean;
        DesignBean parentBean;
        super.beanCreatedSetup(bean);
        DesignContext context = bean.getDesignContext();
        DesignProperty titleProperty = bean.getProperty("title");
        String suffix = DesignUtil.getNumericalSuffix(bean.getInstanceName());
        titleProperty.setValue((Object)(bean.getBeanInfo().getBeanDescriptor().getDisplayName() + " " + suffix));
        AccordionTabDesignInfo.selectTab(bean);
        if (context.canCreateBean(PanelLayout.class.getName(), bean, null)) {
            DesignBean panelBean = context.createBean(PanelLayout.class.getName(), bean, null);
            panelBean.getDesignInfo().beanCreatedSetup(panelBean);
            panelBean.getProperty("panelLayout").setValue((Object)AccordionTabDesignInfo.getParentLayout(bean));
        }
        if ((parentBean = bean.getBeanParent()).getInstance() instanceof AccordionTab && (childBean = parentBean.getChildBean(0)).getInstance() instanceof PanelLayout) {
            context.deleteBean(childBean);
        }
        return Result.SUCCESS;
    }

    public boolean acceptChild(DesignBean parentBean, DesignBean childBean, Class childClass) {
        if (parentBean.getInstance() instanceof AccordionTab) {
            parentBean.getProperty("selected").setValue((Object)Boolean.TRUE);
        }
        return true;
    }

    public boolean acceptParent(DesignBean parentBean, DesignBean childBean, Class childClass) {
        Object parent = parentBean.getInstance();
        return parent instanceof Accordion;
    }

    public Result beanPastedSetup(DesignBean bean) {
        DesignBean childBean;
        DesignContext context = bean.getDesignContext();
        DesignBean parentBean = bean.getBeanParent();
        if (parentBean.getInstance() instanceof AccordionTab && (childBean = parentBean.getChildBean(0)).getInstance() instanceof PanelLayout) {
            context.deleteBean(childBean);
        }
        return Result.SUCCESS;
    }

    public Result beanDeletedCleanup(DesignBean bean) {
        AccordionTabDesignInfo.unselectTab(bean);
        return Result.SUCCESS;
    }

    public void instanceNameChanged(DesignBean bean, String oldInstanceName) {
        DesignBean accordionBean = bean.getBeanParent();
        while (accordionBean != null && !(accordionBean.getInstance() instanceof Accordion)) {
            accordionBean.getProperty("selected").setValue((Object)Boolean.FALSE);
        }
        if (accordionBean != null) {
            DesignProperty selectedProperty = accordionBean.getProperty("selected");
            if (oldInstanceName != null && oldInstanceName.equals(selectedProperty.getValue())) {
                selectedProperty.setValue((Object)bean.getInstanceName());
            }
        }
    }

    public void customizeRender(MarkupDesignBean bean, MarkupRenderContext renderContext) {
        String id;
        MarkupPosition end;
        DocumentFragment documentFragment = renderContext.getDocumentFragment();
        MarkupPosition begin = renderContext.getBeginPosition();
        if (begin == (end = renderContext.getEndPosition())) {
            return;
        }
        assert (begin.getUnderParent() == end.getUnderParent());
        Element tabElement = null;
        for (Node n = begin.getBeforeSibling(); n != null && tabElement == null; n = n.getParentNode()) {
            if (n.getNodeType() != 1 || !n.getLocalName().equals("td")) continue;
            tabElement = (Element)n;
        }
        if (tabElement != null && (id = (String)bean.getProperty("id").getValue()) != null) {
            this.registerTab((DesignBean)bean, renderContext, tabElement);
        }
    }

    private void registerTab(final DesignBean bean, MarkupRenderContext context, Element e) {
        String styleClass = e.getAttribute("class");
        if (styleClass.indexOf("disabled") == -1) {
            BasicMarkupMouseRegion region = new BasicMarkupMouseRegion(){

                public boolean isClickable() {
                    return true;
                }

                public Result regionClicked(int clickCount) {
                    AccordionTabDesignInfo.selectTab(bean);
                    return Result.SUCCESS;
                }
            };
            context.associateMouseRegion(e, (MarkupMouseRegion)region);
            return;
        }
    }

    private static void selectTab(DesignBean bean) {
        if (bean.getInstance() instanceof AccordionTab) {
            bean.getProperty("selected").setValue((Object)Boolean.TRUE);
        }
    }

    private static void unselectTab(DesignBean bean) {
        if (bean.getInstance() instanceof AccordionTab) {
            bean.getProperty("selected").setValue((Object)Boolean.FALSE);
        }
    }

    private static String getParentLayout(DesignBean bean) {
        while (bean != null) {
            String style;
            if ((bean.getInstance() instanceof Body || bean instanceof MarkupDesignBean && ((MarkupDesignBean)bean).getElement().getTagName().equals("div")) && (style = (String)bean.getProperty("style").getValue()) != null && gridPattern.matcher(style).matches()) {
                return "grid";
            }
            bean = bean.getBeanParent();
        }
        return "flow";
    }
}

