/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.reportgenerator.api.impl.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chapter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Section;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.reportgenerator.api.Report;
import org.netbeans.modules.reportgenerator.api.ReportAttribute;
import org.netbeans.modules.reportgenerator.api.ReportBody;
import org.netbeans.modules.reportgenerator.api.ReportCustomizationOptions;
import org.netbeans.modules.reportgenerator.api.ReportElement;
import org.netbeans.modules.reportgenerator.api.ReportException;
import org.netbeans.modules.reportgenerator.api.ReportFooter;
import org.netbeans.modules.reportgenerator.api.ReportGenerator;
import org.netbeans.modules.reportgenerator.api.ReportHeader;
import org.netbeans.modules.reportgenerator.api.ReportSection;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class PDFReportGenerator
implements ReportGenerator {
    private OutputStream mReportStream;
    private File mReportFile;
    private Document mDocument;
    private ReportCustomizationOptions mOptions;

    public PDFReportGenerator(File file, ReportCustomizationOptions reportCustomizationOptions) {
        this.mReportFile = file;
        this.mOptions = reportCustomizationOptions;
    }

    public void generateReport(Report report) throws ReportException {
        FileOutputStream fileOutputStream;
        if (report == null) {
            return;
        }
        this.mDocument = new Document();
        try {
            fileOutputStream = new FileOutputStream(this.mReportFile);
            PdfWriter.getInstance(this.mDocument, fileOutputStream);
            this.mDocument.open();
            this.genReport(report);
        }
        catch (DocumentException documentException) {
            System.err.println(documentException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        this.mDocument.close();
        if (this.mReportFile.exists()) {
            fileOutputStream = FileUtil.toFileObject((File)this.mReportFile);
            FileOwnerQuery.getOwner((FileObject)fileOutputStream);
        }
    }

    private void genReport(Report report) throws DocumentException, IOException {
        ReportFooter reportFooter;
        ReportBody reportBody;
        boolean bl;
        Object object;
        Element element;
        Object object2;
        String string = report.getName();
        if (report.getName() != null) {
            object2 = FontFactory.getFont("Helvetica", 20.0f, 0, Color.BLUE);
            element = new Paragraph(string, (Font)object2);
            element.setAlignment(1);
            this.mDocument.add(element);
            object = new Paragraph("     ");
            this.mDocument.add((Element)object);
        }
        this.mDocument.add(new Paragraph(report.getDescription()));
        object2 = report.getOverviewImage();
        if (object2 != null) {
            element = com.lowagie.text.Image.getInstance((Image)object2, null);
            this.mDocument.add(element);
        }
        if (bl = this.mOptions.isGenerateVerboseReport()) {
            this.generateReportAttributes(report);
        }
        if ((object = report.getHeader()) != null) {
            this.generateHeader((ReportHeader)object);
        }
        if ((reportBody = report.getBody()) != null) {
            this.generateBody(reportBody);
        }
        if ((reportFooter = report.getFooter()) != null) {
            this.generateFooter(reportFooter);
        }
    }

    private void generateReportAttributes(Report report) throws DocumentException {
        List<ReportAttribute> list = report.getAttributes();
        if (list.size() > 0) {
            Paragraph paragraph = new Paragraph("     ");
            this.mDocument.add(paragraph);
            float[] fArray = new float[]{2.0f, 4.0f};
            PdfPTable pdfPTable = new PdfPTable(fArray);
            for (ReportAttribute reportAttribute : list) {
                this.generateAttribute(reportAttribute, pdfPTable);
            }
            this.mDocument.add(pdfPTable);
        }
    }

    private void generateHeader(ReportHeader reportHeader) throws DocumentException {
        this.mDocument.add(new Paragraph(reportHeader.getDescription()));
    }

    private void generateBody(ReportBody reportBody) throws BadElementException, IOException, DocumentException {
        List<ReportSection> list = reportBody.getReportSection();
        for (ReportSection reportSection : list) {
            this.generateSection(reportSection, list.indexOf(reportSection) + 1);
        }
    }

    private void generateSection(ReportSection reportSection, int n) throws BadElementException, IOException, DocumentException {
        Object object;
        Object object2;
        Object object3;
        String string = reportSection.getDescription();
        Image image = reportSection.getImage();
        Font font = FontFactory.getFont("Helvetica", 12.0f, 0, Color.BLACK);
        Chapter chapter = null;
        if (string != null) {
            object3 = new PdfPTable(1);
            object2 = new Paragraph(string, font);
            chapter = new Chapter((Paragraph)object2, n);
            if (image != null) {
                object = com.lowagie.text.Image.getInstance(image, null);
                PdfPCell pdfPCell = new PdfPCell((com.lowagie.text.Image)object);
                ((PdfPTable)object3).addCell(pdfPCell);
                chapter.add(object3);
            }
        } else if (image != null) {
            chapter = new Chapter("", n);
            object3 = com.lowagie.text.Image.getInstance(image, null);
            chapter.add(object3);
        }
        object3 = reportSection.getReportElements();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (ReportElement)object2.next();
            if (object instanceof ReportSection) {
                this.generateSection((ReportSection)object, object3.indexOf(object));
                continue;
            }
            boolean bl = this.mOptions.isIncludeOnlyElementsWithDocumentation();
            if (bl) {
                if (object.getDescription() == null) continue;
                this.generateElement((ReportElement)object, chapter);
                continue;
            }
            this.generateElement((ReportElement)object, chapter);
        }
        this.mDocument.add(chapter);
    }

    private void generateElement(ReportElement reportElement, Chapter chapter) throws BadElementException, DocumentException, IOException {
        boolean bl;
        Element element;
        Object object;
        Element element2;
        String string = reportElement.getName();
        String string2 = reportElement.getDescription();
        Image image = reportElement.getImage();
        Font font = FontFactory.getFont("Helvetica", 12.0f, 1, Color.BLUE);
        Section section = null;
        if (string == null) {
            string = "";
        }
        Paragraph paragraph = new Paragraph(string, font);
        section = chapter.addSection(paragraph, 2);
        Paragraph paragraph2 = new Paragraph("     ");
        section.add(paragraph2);
        section.setIndentationLeft(20.0f);
        if (string2 != null) {
            element2 = new Paragraph(string2);
            section.add(element2);
            object = new Paragraph("     ");
            section.add(object);
        }
        if (image != null) {
            element2 = new PdfPTable(1);
            object = com.lowagie.text.Image.getInstance(image, null);
            ((com.lowagie.text.Image)object).setAlignment(1);
            element = new PdfPCell((com.lowagie.text.Image)object);
            element.setHorizontalAlignment(1);
            element.setVerticalAlignment(1);
            ((PdfPTable)element2).addCell((PdfPCell)element);
            section.add(element2);
        }
        if (bl = this.mOptions.isGenerateVerboseReport()) {
            object = new float[]{2.0f, 4.0f};
            element = new PdfPTable((float[])object);
            List<ReportAttribute> list = reportElement.getAttributes();
            for (ReportAttribute reportAttribute : list) {
                this.generateAttribute(reportAttribute, (PdfPTable)element);
            }
            section.add(element);
        }
        object = new Paragraph("     ");
        section.add(object);
    }

    private void generateAttribute(ReportAttribute reportAttribute, PdfPTable pdfPTable) {
        String string = reportAttribute.getName();
        Object object = reportAttribute.getValue();
        PdfPCell pdfPCell = new PdfPCell(new Paragraph(string));
        pdfPCell.setHorizontalAlignment(0);
        pdfPTable.addCell(pdfPCell);
        PdfPCell pdfPCell2 = null;
        pdfPCell2 = object instanceof String ? new PdfPCell(new Paragraph(object.toString())) : new PdfPCell(new Paragraph(object.toString()));
        pdfPCell2.setHorizontalAlignment(0);
        pdfPTable.addCell(pdfPCell2);
    }

    private void generateFooter(ReportFooter reportFooter) throws DocumentException {
        this.mDocument.add(new Paragraph(reportFooter.getDescription()));
    }
}

