/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.reportgenerator.api;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.netbeans.modules.reportgenerator.api.Report;
import org.netbeans.modules.reportgenerator.api.ReportCustomizationOptions;
import org.netbeans.modules.reportgenerator.api.ReportException;
import org.netbeans.modules.reportgenerator.api.ReportGenerator;
import org.netbeans.modules.reportgenerator.api.ReportType;
import org.netbeans.modules.reportgenerator.generator.DataObjectSettings;
import org.netbeans.modules.reportgenerator.generator.ReportGeneratorFactory;
import org.netbeans.modules.reportgenerator.spi.ReportCookie;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class GenerateReportAction
extends AbstractAction {
    public static final String ACCELERATOR = "alt shift F10";
    private static final Icon icon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/reportgenerator/api/impl/resources/images/generateReport.png"));
    private static final String label = NbBundle.getMessage(GenerateReportAction.class, (String)"NAME_Generate_Report");
    private ReportGenerator mGenerator;
    private DataObject mDataObject;
    private ReportCookie myCookie;
    private File mReportFile;

    public GenerateReportAction(DataObject dataObject, ReportCookie reportCookie) {
        super(label, icon);
        File file;
        this.putValue("Name", label);
        this.putValue("ShortDescription", label);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(ACCELERATOR));
        this.mDataObject = dataObject;
        this.myCookie = reportCookie;
        String string = FileUtil.toFile((FileObject)dataObject.getPrimaryFile()).getAbsolutePath();
        int n = string.lastIndexOf(".");
        String string2 = string;
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        this.mReportFile = file = new File(string2 + ".pdf");
        ReportCustomizationOptions reportCustomizationOptions = DataObjectSettings.getOrStoreOptions(dataObject);
        try {
            this.mGenerator = ReportGeneratorFactory.getDefault().newReportGenerator(ReportType.REPORT_PDF, this.mReportFile, reportCustomizationOptions);
        }
        catch (ReportException reportException) {
            ErrorManager.getDefault().notify((Throwable)reportException);
        }
    }

    public GenerateReportAction(DataObject dataObject) {
        this(dataObject, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Report report;
            ReportCookie reportCookie = this.myCookie;
            reportCookie = this.myCookie == null ? (ReportCookie)this.mDataObject.getCookie(ReportCookie.class) : this.myCookie;
            if (reportCookie != null && (report = reportCookie.generateReport()) != null) {
                this.mGenerator.generateReport(report);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }
}

