/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.validation.xpath;

import java.util.Set;
import org.netbeans.modules.bpel.model.api.BooleanExpr;
import org.netbeans.modules.bpel.model.api.Branches;
import org.netbeans.modules.bpel.model.api.Condition;
import org.netbeans.modules.bpel.model.api.ContentElement;
import org.netbeans.modules.bpel.model.api.Copy;
import org.netbeans.modules.bpel.model.api.DeadlineExpression;
import org.netbeans.modules.bpel.model.api.DurationExpression;
import org.netbeans.modules.bpel.model.api.FinalCounterValue;
import org.netbeans.modules.bpel.model.api.For;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.PartReference;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.Query;
import org.netbeans.modules.bpel.model.api.RepeatEvery;
import org.netbeans.modules.bpel.model.api.StartCounterValue;
import org.netbeans.modules.bpel.model.api.To;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.VariableReference;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.model.api.support.PathValidationContext;
import org.netbeans.modules.bpel.model.api.support.SimpleBpelModelVisitor;
import org.netbeans.modules.bpel.model.api.support.SimpleBpelModelVisitorAdaptor;
import org.netbeans.modules.bpel.model.api.support.Utils;
import org.netbeans.modules.bpel.model.api.support.ValidationVisitor;
import org.netbeans.modules.bpel.validation.core.BpelValidator;
import org.netbeans.modules.soa.validation.util.Duration;
import org.netbeans.modules.soa.validation.util.DurationUtil;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.validation.ValidationUtil;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xpath.ext.spi.validation.XPathValidationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Validator
extends BpelValidator
implements ValidationVisitor {
    public Set<Validator.ResultItem> getResultItems() {
        return this.getValidationResult();
    }

    @Override
    protected SimpleBpelModelVisitor getVisitor() {
        return new SimpleBpelModelVisitorAdaptor(){

            public void visit(Copy copy) {
                Component component;
                Component component2 = Validator.this.getTypeOfElement(this.getType(copy.getFrom()));
                Component component3 = Validator.this.getTypeOfElement(this.getType(copy.getTo()));
                if (component2 == null || component3 == null) {
                    return;
                }
                String string = ((Named)component2).getName();
                String string2 = ((Named)component3).getName();
                if (string == null || string2 == null) {
                    return;
                }
                if (string.equals(string2)) {
                    return;
                }
                if (string.equals("anyType") || string2.equals("anyType")) {
                    return;
                }
                if (string.startsWith("nonNegative") && string2.startsWith("negative")) {
                    Validator.this.addError("FIX_NonNegative_Negative_Copy", (Component)copy);
                    return;
                }
                if (string.startsWith("positive") && string2.startsWith("negative")) {
                    Validator.this.addError("FIX_Positive_Negative_Copy", (Component)copy);
                    return;
                }
                if (string.startsWith("positive") && string2.startsWith("nonPositive")) {
                    Validator.this.addError("FIX_Positive_NonPositive_Copy", (Component)copy);
                    return;
                }
                if (string.startsWith("negative") && string2.startsWith("nonNegative")) {
                    Validator.this.addError("FIX_Negative_NonNegative_Copy", (Component)copy);
                    return;
                }
                if (string.startsWith("negative") && string2.startsWith("positive")) {
                    Validator.this.addError("FIX_Negative_Positive_Copy", (Component)copy);
                    return;
                }
                if (string.startsWith("nonPositive") && string2.startsWith("positive")) {
                    Validator.this.addError("FIX_NonPositive_Positive_Copy", (Component)copy);
                    return;
                }
                if (string.startsWith("nonPositive") && string2.startsWith("nonNegative")) {
                    Validator.this.addWarning("FIX_NonPositive_NonNegative_Copy", (Component)copy);
                    return;
                }
                if (string.startsWith("nonNegative") && string2.startsWith("nonPositive")) {
                    Validator.this.addWarning("FIX_NonNegative_NonPositive_Copy", (Component)copy);
                    return;
                }
                if (this.isNumeric(string) && this.isNumeric(string2)) {
                    return;
                }
                Component component4 = ValidationUtil.getBasedSimpleType((Component)component2);
                if (component4 == (component = ValidationUtil.getBasedSimpleType((Component)component3))) {
                    return;
                }
                String string3 = Validator.this.getTypeName(component4);
                String string4 = Validator.this.getTypeName(component);
                if (string3.equals("string") && string4.equals("time")) {
                    Validator.this.addWarning("FIX_Time_in_copy", (Component)copy);
                } else {
                    Validator.this.addWarning("FIX_TYPE_IN_COPY", (Component)copy, string3, string4);
                }
            }

            private boolean isNumeric(String string) {
                return string.equals("byte") || string.equals("decimal") || string.equals("double") || string.equals("float") || string.equals("int") || string.equals("integer") || string.equals("long") || string.equals("negativeInteger") || string.equals("nonNegativeInteger") || string.equals("nonPositiveInteger") || string.equals("positiveInteger") || string.equals("short") || string.equals("unsignedByte") || string.equals("unsignedInt") || string.equals("unsignedLong") || string.equals("unsignedShort");
            }

            public void visit(To to) {
                this.checkPartnerLink(to);
                this.checkVariable(to);
            }

            private void checkPartnerLink(To to) {
                BpelReference bpelReference = to.getPartnerLink();
                if (bpelReference == null) {
                    return;
                }
                PartnerLink partnerLink = (PartnerLink)bpelReference.get();
                if (partnerLink == null) {
                    return;
                }
                WSDLReference wSDLReference = partnerLink.getPartnerRole();
                if (wSDLReference == null || wSDLReference.get() == null) {
                    Validator.this.addError("FIX_To_PartnerLink", (Component)to);
                }
            }

            private void checkVariable(To to) {
                String string = to.getContent();
                if (string == null) {
                    return;
                }
                if ((string = string.trim()).length() == 0) {
                    return;
                }
                if (!string.startsWith("$")) {
                    Validator.this.addError("FIX_SA00033", (Component)to, string);
                }
            }

            private Component getType(From from) {
                if (from == null) {
                    return null;
                }
                Component component = this.getVariableReferenceType((VariableReference)from);
                if (component != null) {
                    SchemaComponent schemaComponent = this.getPartType((PartReference)from);
                    if (schemaComponent == null) {
                        return component;
                    }
                    return schemaComponent;
                }
                return this.checkXPath((ContentElement)from);
            }

            private Component getType(To to) {
                if (to == null) {
                    return null;
                }
                Component component = this.getVariableReferenceType((VariableReference)to);
                if (component != null) {
                    SchemaComponent schemaComponent = this.getPartType((PartReference)to);
                    if (schemaComponent == null) {
                        return component;
                    }
                    return schemaComponent;
                }
                return this.checkXPath((ContentElement)to);
            }

            private Component getVariableReferenceType(VariableReference variableReference) {
                BpelReference bpelReference = variableReference.getVariable();
                if (bpelReference == null) {
                    return null;
                }
                return Validator.this.getVariableDeclarationType((VariableDeclaration)bpelReference.get());
            }

            private SchemaComponent getPartType(PartReference partReference) {
                WSDLReference wSDLReference = partReference.getPart();
                if (wSDLReference == null) {
                    return null;
                }
                return this.getPartType((Part)wSDLReference.get());
            }

            private SchemaComponent getPartType(Part part) {
                GlobalType globalType;
                NamedComponentReference namedComponentReference;
                if (part == null) {
                    return null;
                }
                NamedComponentReference namedComponentReference2 = part.getElement();
                if (namedComponentReference2 != null && (namedComponentReference = (GlobalElement)namedComponentReference2.get()) != null) {
                    return namedComponentReference;
                }
                namedComponentReference = part.getType();
                if (namedComponentReference != null && (globalType = (GlobalType)namedComponentReference.get()) != null) {
                    return globalType;
                }
                return null;
            }

            public void visit(BooleanExpr booleanExpr) {
                this.checkXPath((ContentElement)booleanExpr);
            }

            public void visit(Branches branches) {
                this.checkXPath((ContentElement)branches);
            }

            public void visit(Condition condition) {
                this.checkXPath((ContentElement)condition);
            }

            public void visit(DeadlineExpression deadlineExpression) {
                this.checkXPath((ContentElement)deadlineExpression);
            }

            public void visit(FinalCounterValue finalCounterValue) {
                this.checkXPath((ContentElement)finalCounterValue);
            }

            public void visit(For for_) {
                this.checkXPath((ContentElement)for_);
                this.checkDuration((DurationExpression)for_);
            }

            public void visit(RepeatEvery repeatEvery) {
                this.checkXPath((ContentElement)repeatEvery);
                this.checkDuration((DurationExpression)repeatEvery);
                this.checkNegative(repeatEvery);
            }

            private void checkNegative(RepeatEvery repeatEvery) {
                String string = repeatEvery.getContent();
                try {
                    Duration duration = DurationUtil.parseDuration((String)string, (boolean)true);
                    if (duration == null) {
                        return;
                    }
                    if (duration.hasMinus() || this.isZero(duration)) {
                        Validator.this.addError("FIX_Negative_RepeatEvery", (Component)repeatEvery);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return;
                }
            }

            private boolean isZero(Duration duration) {
                return duration.getYears() == 0 && duration.getMonths() == 0 && duration.getDays() == 0 && duration.getHours() == 0 && duration.getMinutes() == 0 && duration.getSeconds() == 0.0;
            }

            public void visit(Query query) {
                this.checkXPath((ContentElement)query);
            }

            public void visit(StartCounterValue startCounterValue) {
                this.checkXPath((ContentElement)startCounterValue);
            }

            private SchemaComponent checkXPath(ContentElement contentElement) {
                return Utils.checkXPathExpression((ContentElement)contentElement, (XPathValidationContext)new PathValidationContext((org.netbeans.modules.xml.xam.spi.Validator)Validator.this, (ValidationVisitor)Validator.this, contentElement));
            }

            private void checkDuration(DurationExpression durationExpression) {
                String string = durationExpression.getContent();
                try {
                    DurationUtil.parseDuration((String)string, (boolean)true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Validator.this.addError("FIX_Duration", (Component)durationExpression, illegalArgumentException.getMessage());
                }
            }
        };
    }
}

