/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.validation.action;

import java.awt.event.ActionEvent;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.soa.validation.core.Controller;
import org.netbeans.modules.xml.ui.UI;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.openide.nodes.Node;

public final class FixImportAction
extends UI.IconAction {
    public FixImportAction() {
        super(UI.i18n(FixImportAction.class, (String)"CTL_Fix_Import_Action"), UI.i18n(FixImportAction.class, (String)"TLT_Fix_Import_Action"), null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Node node = UI.getSelectedNode();
        if (node == null) {
            return;
        }
        Controller controller = (Controller)node.getLookup().lookup(Controller.class);
        if (controller == null) {
            return;
        }
        Model model = controller.getModel();
        if (!(model instanceof BpelModel)) {
            return;
        }
        this.fixImport((BpelModel)model, controller);
    }

    private void fixImport(BpelModel bpelModel, Controller controller) {
        Process process = bpelModel.getProcess();
        if (process == null) {
            return;
        }
        Import[] importArray = process.getImports();
        if (importArray == null) {
            return;
        }
        for (int i = importArray.length - 1; i >= 0; --i) {
            bpelModel.startTransaction();
            process.removeImport(i);
            if (controller.validate(Validation.ValidationType.PARTIAL).isEmpty()) {
                bpelModel.endTransaction();
                continue;
            }
            bpelModel.rollbackTransaction();
        }
    }
}

