/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.css.gsf.AstUtils;
import org.netbeans.modules.css.gsf.CSSParserResult;
import org.netbeans.modules.css.gsf.CssAstElement;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.StructureItem;
import org.netbeans.modules.gsf.api.StructureScanner;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSStructureScanner
implements StructureScanner {
    public List<? extends StructureItem> scan(final CompilationInfo compilationInfo) {
        Iterator iterator = compilationInfo.getEmbeddedResults("text/x-css").iterator();
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        ParserResult parserResult = (ParserResult)iterator.next();
        final TranslatedSource translatedSource = parserResult.getTranslatedSource();
        SimpleNode simpleNode = ((CSSParserResult)parserResult).root();
        if (simpleNode == null) {
            return Collections.emptyList();
        }
        final ArrayList arrayList = new ArrayList();
        NodeVisitor nodeVisitor = new NodeVisitor(){

            public void visit(SimpleNode simpleNode) {
                if (simpleNode.kind() == 19) {
                    SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetParent();
                    assert (simpleNode2.kind() == 18);
                    int n = AstUtils.documentPosition(simpleNode2.startOffset(), translatedSource);
                    int n2 = AstUtils.documentPosition(simpleNode2.endOffset(), translatedSource);
                    if (n2 != n) {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                            SimpleNode simpleNode3 = (SimpleNode)simpleNode.jjtGetChild(i);
                            if (simpleNode3.kind() != 20) continue;
                            StringBuffer stringBuffer2 = new StringBuffer();
                            for (int j = 0; j < simpleNode3.jjtGetNumChildren(); ++j) {
                                SimpleNode simpleNode4 = (SimpleNode)simpleNode3.jjtGetChild(j);
                                if (simpleNode4.kind() != 21 && simpleNode4.kind() != 15 || simpleNode4.image().trim().length() <= 0) continue;
                                String string = CSSStructureScanner.this.extractDocumentText(simpleNode4, compilationInfo, translatedSource).trim();
                                stringBuffer2.append(string);
                                stringBuffer2.append(' ');
                            }
                            if (stringBuffer2.length() <= 0) continue;
                            stringBuffer.append(stringBuffer2.substring(0, stringBuffer2.length() - 1));
                            stringBuffer.append(", ");
                        }
                        if (stringBuffer.length() > 2) {
                            if (stringBuffer.charAt(stringBuffer.length() - 2) == ',') {
                                stringBuffer.deleteCharAt(stringBuffer.length() - 2);
                            }
                            arrayList.add(new CssRuleStructureItem(stringBuffer.toString(), CssAstElement.createElement(simpleNode2), translatedSource));
                        }
                    }
                }
            }
        };
        simpleNode.visitChildren(nodeVisitor);
        return arrayList;
    }

    private String extractDocumentText(SimpleNode simpleNode, CompilationInfo compilationInfo, TranslatedSource translatedSource) {
        int n = AstUtils.documentPosition(simpleNode.startOffset(), translatedSource);
        int n2 = AstUtils.documentPosition(simpleNode.endOffset(), translatedSource);
        return compilationInfo.getText().substring(n, n2);
    }

    public Map<String, List<OffsetRange>> folds(CompilationInfo compilationInfo) {
        final BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
        if (baseDocument == null) {
            return Collections.emptyMap();
        }
        Iterator iterator = compilationInfo.getEmbeddedResults("text/x-css").iterator();
        if (!iterator.hasNext()) {
            return Collections.emptyMap();
        }
        ParserResult parserResult = (ParserResult)iterator.next();
        final TranslatedSource translatedSource = parserResult.getTranslatedSource();
        SimpleNode simpleNode = ((CSSParserResult)parserResult).root();
        if (simpleNode == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<OffsetRange>> hashMap = new HashMap<String, List<OffsetRange>>();
        final ArrayList arrayList = new ArrayList();
        NodeVisitor nodeVisitor = new NodeVisitor(){

            public void visit(SimpleNode simpleNode) {
                if (simpleNode.kind() == 18) {
                    int n = AstUtils.documentPosition(simpleNode.startOffset(), translatedSource);
                    int n2 = AstUtils.documentPosition(simpleNode.endOffset(), translatedSource);
                    try {
                        if (Utilities.getLineOffset((BaseDocument)baseDocument, (int)n) < Utilities.getLineOffset((BaseDocument)baseDocument, (int)n2)) {
                            arrayList.add(new OffsetRange(n, n2));
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            }
        };
        simpleNode.visitChildren(nodeVisitor);
        hashMap.put("codeblocks", arrayList);
        return hashMap;
    }

    public StructureScanner.Configuration getConfiguration() {
        return new StructureScanner.Configuration(true, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CssRuleStructureItem
    implements StructureItem {
        private String name;
        private CssAstElement element;
        private int from;
        private int to;

        private static String escape(String string) {
            string = string.replace("<", "&lt;");
            string = string.replace(">", "&gt;");
            return string;
        }

        private CssRuleStructureItem(String string, CssAstElement cssAstElement, TranslatedSource translatedSource) {
            this.name = string;
            this.element = cssAstElement;
            this.from = AstUtils.documentPosition(cssAstElement.node().startOffset(), translatedSource);
            this.to = AstUtils.documentPosition(cssAstElement.node().endOffset(), translatedSource);
        }

        public String getName() {
            return this.name;
        }

        public String getSortText() {
            return this.getName();
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            return CssRuleStructureItem.escape(this.getName());
        }

        public ElementHandle getElementHandle() {
            return this.element;
        }

        public ElementKind getKind() {
            return ElementKind.RULE;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isLeaf() {
            return true;
        }

        public List<? extends StructureItem> getNestedItems() {
            return Collections.emptyList();
        }

        public long getPosition() {
            return this.from;
        }

        public long getEndPosition() {
            return this.to;
        }

        public ImageIcon getCustomIcon() {
            return null;
        }
    }
}

