/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.netbeans.modules.css.gsf.AstUtils;
import org.netbeans.modules.css.gsf.CSSParserResult;
import org.netbeans.modules.css.gsf.CssAnalyser;
import org.netbeans.modules.css.gsf.CssAstElement;
import org.netbeans.modules.css.parser.CssParserAccess;
import org.netbeans.modules.css.parser.CssParserResultHolder;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParseEvent;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.PositionManager;
import org.netbeans.modules.gsf.api.TranslatedSource;

public class CSSGSFParser
implements Parser,
PositionManager {
    private static final Logger TIMERS = Logger.getLogger("TIMER.j2ee.parser");
    private static JFrame debugFrame = null;
    private static JPanel debugPanel = null;

    private static String asString(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return (String)charSequence;
        }
        return ((Object)charSequence).toString();
    }

    public void parseFiles(Parser.Job job) {
        List list = job.files;
        for (ParserFile parserFile : list) {
            Object object;
            ParseEvent parseEvent = new ParseEvent(ParseEvent.Kind.PARSE, parserFile, null);
            job.listener.started(parseEvent);
            CSSParserResult cSSParserResult = null;
            try {
                Object object4;
                object = null;
                if (job.translatedSource instanceof CssParserResultHolder) {
                    object = ((CssParserResultHolder)job.translatedSource).result();
                }
                if (object == null) {
                    object4 = job.reader.read(parserFile);
                    String string = CSSGSFParser.asString((CharSequence)object4);
                    CssParserAccess cssParserAccess = CssParserAccess.getDefault();
                    object = cssParserAccess.parse(new StringReader(string));
                }
                cSSParserResult = new CSSParserResult(this, parserFile, ((CssParserAccess.CssParserResult)object).root());
                for (Error error : ((CssParserAccess.CssParserResult)object).errors(parserFile)) {
                    job.listener.error(error);
                }
                object4 = ((CssParserAccess.CssParserResult)object).root();
                if (object4 != null) {
                    List<Error> list2 = new CssAnalyser(cSSParserResult).checkForErrors((SimpleNode)object4);
                    for (Error error : list2) {
                        job.listener.error(error);
                    }
                }
            }
            catch (IOException iOException) {
                job.listener.exception((Exception)iOException);
                cSSParserResult = new CSSParserResult(this, parserFile, null);
            }
            if (TIMERS.isLoggable(Level.FINE)) {
                object = new LogRecord(Level.FINE, "CSS parse result");
                ((LogRecord)object).setParameters(new Object[]{cSSParserResult});
                TIMERS.log((LogRecord)object);
            }
            object = new ParseEvent(ParseEvent.Kind.PARSE, parserFile, (ParserResult)cSSParserResult);
            job.listener.finished((ParseEvent)object);
        }
    }

    public PositionManager getPositionManager() {
        return this;
    }

    public OffsetRange getOffsetRange(CompilationInfo compilationInfo, ElementHandle elementHandle) {
        if (elementHandle instanceof CssAstElement) {
            ParserResult parserResult = (ParserResult)compilationInfo.getEmbeddedResults("text/x-css").iterator().next();
            TranslatedSource translatedSource = parserResult.getTranslatedSource();
            CssAstElement cssAstElement = (CssAstElement)elementHandle;
            return new OffsetRange(AstUtils.documentPosition(cssAstElement.node().startOffset(), translatedSource), AstUtils.documentPosition(cssAstElement.node().endOffset(), translatedSource));
        }
        throw new IllegalArgumentException("Foreign element: " + elementHandle + " of type " + (elementHandle != null ? elementHandle.getClass().getName() : "null"));
    }

    private void debugParserResult(ParserResult parserResult) {
        if (debugFrame == null) {
            debugFrame = new JFrame("css ast view");
            debugPanel = new JPanel(new BorderLayout());
            debugPanel.setPreferredSize(new Dimension(400, 800));
            debugFrame.setContentPane(debugPanel);
            debugFrame.setVisible(true);
        }
        JTree jTree = new JTree((TreeNode)parserResult.getAst());
        debugPanel.removeAll();
        debugPanel.add((Component)jTree, "Center");
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            jTree.expandRow(i);
        }
        debugFrame.pack();
    }
}

