/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.server.manager.ui;

import java.awt.Image;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.identity.profile.api.configurator.SecurityMechanism;
import org.netbeans.modules.identity.profile.api.configurator.SecurityMechanismHelper;
import org.netbeans.modules.identity.server.manager.api.ServerInstance;
import org.netbeans.modules.identity.server.manager.ui.ProfileNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ProfilesNode
extends AbstractNode {
    private static final String PROFILES_NODE_BADGE = "org/netbeans/modules/identity/server/manager/ui/resources/ProfilesNodeBadge.png";
    private static final Image ICON_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/identity/server/manager/ui/resources/ProfilesNodeBadge.png");
    private static final String HELP_ID = "idmtools_am_config_am_sec_mech";
    private static Icon folderIconCache;
    private static Icon openedFolderIconCache;

    public ProfilesNode(ServerInstance serverInstance) {
        super((Children)new ProfilesNodeChildren(serverInstance));
        this.setName("");
        this.setDisplayName(NbBundle.getMessage(ProfilesNode.class, (String)"LBL_ProfilesNode"));
        this.setShortDescription(NbBundle.getMessage(ProfilesNode.class, (String)"DESC_ProfilesNode"));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public Image getIcon(int n) {
        return this.computeIcon(false, n);
    }

    public Image getOpenedIcon(int n) {
        return this.computeIcon(true, n);
    }

    static synchronized Icon getFolderIcon(boolean bl) {
        if (openedFolderIconCache == null) {
            Node node = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
            openedFolderIconCache = new ImageIcon(node.getOpenedIcon(1));
            folderIconCache = new ImageIcon(node.getIcon(1));
        }
        if (bl) {
            return openedFolderIconCache;
        }
        return folderIconCache;
    }

    private Image computeIcon(boolean bl, int n) {
        Icon icon = ProfilesNode.getFolderIcon(bl);
        Image image = ((ImageIcon)icon).getImage();
        image = ImageUtilities.mergeImages((Image)image, (Image)ICON_BADGE, (int)7, (int)7);
        return image;
    }

    public Action[] getActions(boolean bl) {
        Action[] actionArray = new Action[]{};
        return actionArray;
    }

    private static class ProfilesNodeChildren
    extends Children.Keys {
        private ServerInstance instance;

        public ProfilesNodeChildren(ServerInstance serverInstance) {
            this.instance = serverInstance;
        }

        protected void addNotify() {
            this.updateKeys();
        }

        protected Node[] createNodes(Object object) {
            return new Node[]{new ProfileNode((SecurityMechanism)object, this.instance)};
        }

        private void updateKeys() {
            Collection collection = new SecurityMechanismHelper(this.instance.getID()).getAllWSPSecurityMechanisms();
            this.setKeys(collection);
        }
    }
}

