/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sql.rowset;

import com.sun.rowset.internal.BaseRow;
import com.sun.rowset.internal.InsertRow;
import com.sun.rowset.internal.Row;
import com.sun.sql.rowset.BaseRowSetX;
import com.sun.sql.rowset.CachedRowSetX;
import com.sun.sql.rowset.Log;
import com.sun.sql.rowset.RowSetMetaDataX;
import com.sun.sql.rowset.RowSetMetaDataXImpl;
import com.sun.sql.rowset.internal.CachedRowSetXReader;
import com.sun.sql.rowset.internal.CachedRowSetXWriter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetInternal;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.serial.SQLInputImpl;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialRef;
import javax.sql.rowset.serial.SerialStruct;
import javax.sql.rowset.spi.SyncFactory;
import javax.sql.rowset.spi.SyncProvider;
import javax.sql.rowset.spi.SyncProviderException;
import javax.sql.rowset.spi.TransactionalWriter;

public abstract class CachedRowSetXImpl5
extends BaseRowSetX
implements CachedRowSetX,
RowSetInternal,
Serializable,
Cloneable {
    protected static ResourceBundle rb = ResourceBundle.getBundle("com.sun.sql.rowset.Bundle", Locale.getDefault());
    protected PropertyChangeSupport propertyChangeSupport;
    private boolean executed;
    protected boolean internalUseInstance;
    protected SyncProvider provider;
    protected RowSetReader rowSetReader;
    protected RowSetWriter rowSetWriter;
    private transient Connection conn;
    private transient ResultSetMetaData rsmd;
    protected RowSetMetaData rowSetMD;
    private int[] keyCols;
    private String tableName;
    protected Vector rvh;
    protected int cursorPos;
    private int absolutePos;
    protected int numDeleted;
    protected int numRows;
    private InsertRow insertRow;
    private boolean onInsertRow;
    private int currentRow;
    private boolean lastValueNull;
    protected SQLWarning sqlwarn;
    private String strMatchColumn = "";
    private int iMatchColumn = -1;
    protected RowSetWarning rowsetWarning;
    private String DEFAULT_SYNC_PROVIDER = "com.sun.sql.rowset.providers.RIOptimisticProvider";
    private boolean dbmslocatorsUpdateCopy;
    private ResultSet resultSet;
    private int endPos;
    private int prevEndPos;
    private int startPos;
    private int startPrev;
    private int pageSize;
    private int maxRowsreached;
    private boolean pagenotend = true;
    private boolean onFirstPage;
    private boolean onLastPage;
    private int populatecallcount;
    private int totalRows;
    private boolean callWithCon;
    private CachedRowSetXReader crsReader;
    private Vector iMatchColumns;
    private Vector strMatchColumns;
    private boolean tXWriter = false;
    private TransactionalWriter tWriter = null;
    private String catalogName = null;
    private String schemaName = null;
    private String[] columnCatalogNames = null;
    private String[] columnSchemaNames = null;
    private String[] columnTableNames = null;
    private String[] columnNames = null;
    private boolean[] insertableColumns = null;
    private boolean[] updatableColumns = null;
    private boolean printStatements;

    protected void initParams() {
        super.initParams();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.insertableColumns = null;
    }

    public boolean isExecuted() throws SQLException {
        return this.executed;
    }

    void checkExecuted() throws SQLException {
        if (this.internalUseInstance) {
            return;
        }
        if (!this.isExecuted() && this.rowSetMD == null) {
            throw new SQLException(rb.getString("EXECUTE_NEVER_CALLED"));
        }
    }

    public void setDataSourceName(String dataSourceName) throws SQLException {
        String oldValue = this.getDataSourceName();
        super.setDataSourceName(dataSourceName);
        this.release();
        this.propertyChangeSupport.firePropertyChange("dataSourceName", oldValue, dataSourceName);
    }

    public void setUrl(String url) throws SQLException {
        String oldValue = this.getUrl();
        super.setUrl(url);
        this.release();
        this.propertyChangeSupport.firePropertyChange("url", oldValue, url);
    }

    public void setUsername(String username) {
        String oldValue = this.getUsername();
        super.setUsername(username);
        try {
            this.release();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.propertyChangeSupport.firePropertyChange("username", oldValue, username);
    }

    public void setPassword(String password) {
        String oldValue = this.getPassword();
        super.setPassword(password);
        this.propertyChangeSupport.firePropertyChange("password", oldValue, password);
    }

    public void setType(int type) throws SQLException {
        int oldValue = 0;
        try {
            oldValue = this.getType();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        super.setType(type);
        this.propertyChangeSupport.firePropertyChange("type", oldValue, type);
    }

    public void setConcurrency(int concurrency) throws SQLException {
        int oldValue = 0;
        try {
            oldValue = this.getConcurrency();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        super.setConcurrency(concurrency);
        this.propertyChangeSupport.firePropertyChange("concurrency", oldValue, concurrency);
    }

    public void setTransactionIsolation(int transactionIsolation) throws SQLException {
        int oldValue = this.getTransactionIsolation();
        super.setTransactionIsolation(transactionIsolation);
        this.propertyChangeSupport.firePropertyChange("transactionIsolation", oldValue, transactionIsolation);
    }

    public void setMaxRows(int maxRows) throws SQLException {
        int oldValue = 0;
        try {
            oldValue = this.getMaxRows();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        super.setMaxRows(maxRows);
        this.propertyChangeSupport.firePropertyChange("maxRows", oldValue, maxRows);
    }

    public void setReadOnly(boolean isReadOnly) {
        if (this.isReadOnly() != isReadOnly) {
            boolean oldValue = this.isReadOnly();
            super.setReadOnly(isReadOnly);
            this.propertyChangeSupport.firePropertyChange("readOnly", oldValue, isReadOnly);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void initContainer() {
        this.rvh = new Vector(100);
        this.cursorPos = 0;
        this.absolutePos = 0;
        this.numRows = 0;
        this.numDeleted = 0;
        this.rsmd = null;
        this.rowSetMD = null;
    }

    protected void initProperties() throws SQLException {
        this.setShowDeleted(false);
        this.setQueryTimeout(0);
        this.setMaxRows(0);
        this.setMaxFieldSize(0);
        this.setType(1004);
        this.setConcurrency(1008);
        this.setReadOnly(true);
        this.setTransactionIsolation(2);
        this.setEscapeProcessing(true);
        this.setTypeMap(null);
        this.checkTransactionalWriter();
        this.onInsertRow = false;
        this.insertRow = null;
        this.executed = false;
        this.iMatchColumns = new Vector(10);
        for (int i = 0; i < 10; ++i) {
            this.iMatchColumns.add(i, new Integer(-1));
        }
        this.strMatchColumns = new Vector(10);
        for (int j = 0; j < 10; ++j) {
            this.strMatchColumns.add(j, null);
        }
    }

    private void checkTransactionalWriter() {
        Class<?> c;
        if (this.rowSetWriter != null && (c = this.rowSetWriter.getClass()) != null) {
            Class<?>[] theInterfaces = c.getInterfaces();
            for (int i = 0; i < theInterfaces.length; ++i) {
                if (theInterfaces[i].getName().indexOf("TransactionalWriter") <= 0) continue;
                this.tXWriter = true;
                this.establishTransactionalWriter();
            }
        }
    }

    private void establishTransactionalWriter() {
        this.tWriter = (TransactionalWriter)this.provider.getRowSetWriter();
    }

    public void setCommand(String command) throws SQLException {
        String oldValue = this.getCommand();
        super.setCommand(command);
        this.release();
        this.propertyChangeSupport.firePropertyChange("command", oldValue, command);
    }

    public void populate(ResultSet data) throws SQLException {
        Map<String, Class<?>> map = this.getTypeMap();
        if (data == null) {
            throw new SQLException(rb.getString("INVALID_RESULTSET_SUPPLIED"));
        }
        this.rsmd = data.getMetaData();
        this.rowSetMD = new RowSetMetaDataXImpl();
        this.initMetaData(this.rowSetMD, this.rsmd);
        this.rsmd = null;
        int numCols = this.rowSetMD.getColumnCount();
        int mRows = this.getMaxRows();
        int rowsFetched = 0;
        Row currentRow = null;
        while (data.next()) {
            currentRow = new Row(numCols);
            if (rowsFetched > mRows && mRows > 0) {
                this.rowsetWarning.setNextWarning(new RowSetWarning(rb.getString("MAX_ROWS_EXCEEDED")));
            }
            for (int i = 1; i <= numCols; ++i) {
                Object obj = map == null ? data.getObject(i) : data.getObject(i, map);
                if (obj instanceof Struct) {
                    obj = new SerialStruct((Struct)obj, map);
                } else if (obj instanceof SQLData) {
                    obj = new SerialStruct((SQLData)obj, map);
                } else if (obj instanceof Blob) {
                    obj = new SerialBlob((Blob)obj);
                } else if (obj instanceof Clob) {
                    obj = new SerialClob((Clob)obj);
                } else if (obj instanceof Array) {
                    obj = new SerialArray((Array)obj, map);
                }
                currentRow.initColumnObject(i, obj);
            }
            ++rowsFetched;
            this.rvh.add(currentRow);
        }
        this.executed = true;
        this.numRows = rowsFetched;
        this.notifyRowSetChanged();
    }

    private void initMetaData(RowSetMetaData md, ResultSetMetaData rsmd) throws SQLException {
        RowSetMetaDataX mdx = null;
        if (md instanceof RowSetMetaDataX) {
            mdx = (RowSetMetaDataX)md;
        }
        Log.getLogger().entering(this.getClass().getName(), "initMetaData()");
        int numCols = rsmd.getColumnCount();
        md.setColumnCount(numCols);
        for (int col = 1; col <= numCols; ++col) {
            md.setAutoIncrement(col, rsmd.isAutoIncrement(col));
            md.setCaseSensitive(col, rsmd.isCaseSensitive(col));
            md.setCurrency(col, rsmd.isCurrency(col));
            md.setNullable(col, rsmd.isNullable(col));
            md.setSigned(col, rsmd.isSigned(col));
            md.setSearchable(col, rsmd.isSearchable(col));
            int size = rsmd.getColumnDisplaySize(col);
            if (size < 0) {
                size = 0;
            }
            md.setColumnDisplaySize(col, size);
            md.setColumnLabel(col, rsmd.getColumnLabel(col));
            md.setColumnName(col, rsmd.getColumnName(col));
            md.setSchemaName(col, rsmd.getSchemaName(col));
            int precision = rsmd.getPrecision(col);
            if (precision < 0) {
                precision = 0;
            }
            md.setPrecision(col, precision);
            int scale = rsmd.getScale(col);
            if (scale < 0) {
                scale = 0;
            }
            md.setScale(col, scale);
            md.setTableName(col, rsmd.getTableName(col));
            md.setCatalogName(col, rsmd.getCatalogName(col));
            md.setColumnType(col, rsmd.getColumnType(col));
            md.setColumnTypeName(col, rsmd.getColumnTypeName(col));
            if (mdx != null) {
                mdx.setColumnClassName(col, rsmd.getColumnClassName(col));
                if (this.insertableColumns != null && this.insertableColumns.length >= col) {
                    mdx.setWritable(col, this.insertableColumns[col - 1]);
                    mdx.setDefinitelyWritable(col, this.insertableColumns[col - 1]);
                    mdx.setReadOnly(col, !this.insertableColumns[col - 1]);
                } else if (this.updatableColumns != null && this.updatableColumns.length >= col) {
                    mdx.setWritable(col, this.updatableColumns[col - 1]);
                    mdx.setDefinitelyWritable(col, this.updatableColumns[col - 1]);
                    mdx.setReadOnly(col, !this.updatableColumns[col - 1]);
                } else {
                    mdx.setWritable(col, true);
                    mdx.setDefinitelyWritable(col, false);
                    mdx.setReadOnly(col, false);
                }
            }
            this.dbmslocatorsUpdateCopy = false;
            if (this.conn == null) continue;
            try {
                this.dbmslocatorsUpdateCopy = this.conn.getMetaData().locatorsUpdateCopy();
                continue;
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection conn) throws SQLException {
        Log.getLogger().entering(this.getClass().getName(), "execute()");
        this.setConnection(conn);
        if (this.getPageSize() != 0) {
            this.crsReader = (CachedRowSetXReader)this.provider.getRowSetReader();
            this.crsReader.setStartPosition(1);
            this.callWithCon = true;
            this.crsReader.readData(this);
        } else {
            this.rowSetReader.readData(this);
        }
        this.executed = true;
        this.rowSetMD = (RowSetMetaDataXImpl)this.getMetaData();
        if (conn != null) {
            try {
                this.dbmslocatorsUpdateCopy = conn.getMetaData().locatorsUpdateCopy();
            }
            catch (SQLException e) {
                this.dbmslocatorsUpdateCopy = false;
            }
        } else {
            Connection tempConn = null;
            try {
                tempConn = CachedRowSetXImpl5.getConnection(this.getDataSourceName(), this.getUrl(), this.getUsername(), this.getPassword());
                this.dbmslocatorsUpdateCopy = tempConn.getMetaData().locatorsUpdateCopy();
            }
            catch (SQLException e) {
                this.dbmslocatorsUpdateCopy = false;
            }
            catch (AbstractMethodError e) {
                this.dbmslocatorsUpdateCopy = false;
            }
            finally {
                if (tempConn != null) {
                    try {
                        if (!tempConn.getAutoCommit()) {
                            tempConn.rollback();
                        }
                    }
                    catch (Exception dummy) {}
                    tempConn.close();
                }
            }
        }
    }

    private void setConnection(Connection connection) {
        this.conn = connection;
    }

    public void acceptChanges() throws SyncProviderException {
        try {
            this.checkExecuted();
        }
        catch (SQLException e) {
            throw new SyncProviderException(e.getMessage());
        }
        if (this.onInsertRow) {
            throw new SyncProviderException(rb.getString("INVALID_INSERT_ROW_OP"));
        }
        int saveCursorPos = this.cursorPos;
        boolean success = false;
        boolean conflict = false;
        try {
            if (this.rowSetWriter != null) {
                saveCursorPos = this.cursorPos;
                conflict = this.rowSetWriter.writeData(this);
                this.cursorPos = saveCursorPos;
            }
            if (this.tXWriter) {
                if (!conflict) {
                    this.tWriter = (TransactionalWriter)this.rowSetWriter;
                    this.tWriter.rollback();
                    success = false;
                } else {
                    this.tWriter = (TransactionalWriter)this.rowSetWriter;
                    this.tWriter.commit();
                    success = true;
                }
            }
            if (success) {
                this.setOriginal();
            } else if (!success) {
            }
        }
        catch (SyncProviderException spe) {
            throw spe;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SyncProviderException(e.getMessage());
        }
        catch (SecurityException e) {
            throw new SyncProviderException(e.getMessage());
        }
        finally {
            try {
                if (this.tWriter instanceof CachedRowSetXWriter) {
                    ((CachedRowSetXWriter)this.tWriter).closeConnection();
                }
            }
            catch (SQLException e) {}
        }
    }

    public void acceptChanges(Connection con) throws SyncProviderException {
        try {
            this.checkExecuted();
            this.setConnection(con);
            this.acceptChanges();
        }
        catch (SyncProviderException spe) {
            throw spe;
        }
        catch (SQLException sqle) {
            throw new SyncProviderException(sqle.getMessage());
        }
    }

    public void restoreOriginal() throws SQLException {
        this.checkExecuted();
        Iterator i = this.rvh.iterator();
        while (i.hasNext()) {
            Row currentRow = (Row)i.next();
            if (currentRow.getInserted()) {
                i.remove();
                --this.numRows;
                continue;
            }
            if (currentRow.getDeleted()) {
                currentRow.clearDeleted();
            }
            if (!currentRow.getUpdated()) continue;
            currentRow.clearUpdated();
        }
        this.cursorPos = 0;
        this.absolutePos = 0;
        this.notifyRowSetChanged();
    }

    public void release() throws SQLException {
        this.initContainer();
        this.executed = false;
        this.notifyRowSetChanged();
    }

    public void undoDelete() throws SQLException {
        this.checkExecuted();
        if (!this.getShowDeleted()) {
            return;
        }
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(rb.getString("INVALID_CURSOR_POS"));
        }
        Row currentRow = (Row)this.getCurrentRow();
        if (currentRow.getDeleted()) {
            currentRow.clearDeleted();
            --this.numDeleted;
            this.notifyRowChanged();
        }
    }

    public void undoInsert() throws SQLException {
        this.checkExecuted();
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(rb.getString("INVALID_CURSOR_POS"));
        }
        Row currentRow = (Row)this.getCurrentRow();
        if (currentRow.getInserted()) {
            this.rvh.remove(this.cursorPos);
            --this.numRows;
        } else {
            throw new SQLException(rb.getString("INVALID_INSERT_ROW_OP"));
        }
        this.notifyRowChanged();
    }

    public void undoUpdate() throws SQLException {
        this.checkExecuted();
        this.moveToCurrentRow();
        this.undoDelete();
        this.undoInsert();
    }

    public RowSet createShared() throws SQLException {
        RowSet clone;
        this.checkExecuted();
        try {
            clone = (RowSet)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new SQLException(ex.getMessage());
        }
        return clone;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public CachedRowSet createCopy() throws SQLException {
        ObjectInputStream in;
        this.checkExecuted();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bOut);
            out.writeObject(this);
        }
        catch (IOException ex) {
            throw new SQLException(rb.getString("CLONE_FAILED" + ex.getMessage()));
        }
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(bOut.toByteArray());
            in = new ObjectInputStream(bIn);
        }
        catch (StreamCorruptedException ex) {
            throw new SQLException(rb.getString("CLONE_FAILED" + ex.getMessage()));
        }
        catch (IOException ex) {
            throw new SQLException(rb.getString("CLONE_FAILED" + ex.getMessage()));
        }
        try {
            return (CachedRowSet)in.readObject();
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException(rb.getString("CLONE_FAILED" + ex.getMessage()));
        }
        catch (OptionalDataException ex) {
            throw new SQLException(rb.getString("CLONE_FAILED" + ex.getMessage()));
        }
        catch (IOException ex) {
            throw new SQLException(rb.getString("CLONE_FAILED" + ex.getMessage()));
        }
    }

    public CachedRowSet createCopySchema() throws SQLException {
        this.checkExecuted();
        int nRows = this.numRows;
        this.numRows = 0;
        CachedRowSet crs = this.createCopy();
        this.numRows = nRows;
        return crs;
    }

    public CachedRowSet createCopyNoConstraints() throws SQLException {
        this.checkExecuted();
        CachedRowSetXImpl5 crs = (CachedRowSetXImpl5)this.createCopy();
        crs.initProperties();
        try {
            crs.unsetMatchColumn(crs.getMatchColumnIndexes());
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        try {
            crs.unsetMatchColumn(crs.getMatchColumnNames());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return crs;
    }

    public Collection toCollection() throws SQLException {
        this.checkExecuted();
        boolean count = false;
        int colCount = this.rowSetMD.getColumnCount();
        TreeMap tMap = new TreeMap();
        for (int i = 0; i < this.numRows; ++i) {
            tMap.put(new Integer(i), this.rvh.get(i));
        }
        return tMap.values();
    }

    public Collection toCollection(int column) throws SQLException {
        int nRows;
        this.checkExecuted();
        Vector<Object> vec = new Vector<Object>(nRows);
        CachedRowSetXImpl5 crsTemp = (CachedRowSetXImpl5)this.createCopy();
        for (nRows = this.numRows; nRows != 0; --nRows) {
            crsTemp.next();
            vec.add(crsTemp.getObject(column));
        }
        return vec;
    }

    public Collection toCollection(String column) throws SQLException {
        this.checkExecuted();
        return this.toCollection(this.getColIdxByName(column));
    }

    public SyncProvider getSyncProvider() throws SQLException {
        return this.provider;
    }

    public void setSyncProvider(String providerStr) throws SQLException {
        this.provider = SyncFactory.getInstance(providerStr);
        this.rowSetReader = this.provider.getRowSetReader();
        this.rowSetWriter = (TransactionalWriter)this.provider.getRowSetWriter();
    }

    public void execute() throws SQLException {
        this.execute(null);
    }

    public boolean next() throws SQLException {
        this.checkExecuted();
        if (this.cursorPos < 0 || this.cursorPos >= this.numRows + 1) {
            throw new SQLException(rb.getString("INVALID_CURSOR_POS"));
        }
        boolean ret = this.internalNext();
        this.notifyCursorMoved();
        return ret;
    }

    protected boolean internalNext() throws SQLException {
        boolean ret = false;
        do {
            if (this.cursorPos < this.numRows) {
                ++this.cursorPos;
                ret = true;
                continue;
            }
            if (this.cursorPos != this.numRows) continue;
            ++this.cursorPos;
            ret = false;
            break;
        } while (!this.getShowDeleted() && this.rowDeleted());
        this.absolutePos = ret ? ++this.absolutePos : 0;
        return ret;
    }

    public void close() {
        this.cursorPos = 0;
        this.absolutePos = 0;
        this.numRows = 0;
        this.numDeleted = 0;
        try {
            this.initProperties();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.rvh.clear();
    }

    public boolean wasNull() throws SQLException {
        this.checkExecuted();
        return this.lastValueNull;
    }

    private void setLastValueNull(boolean value) {
        this.lastValueNull = value;
    }

    private void checkIndex(int idx) throws SQLException {
        if (idx < 1 || idx > this.rowSetMD.getColumnCount()) {
            throw new SQLException(MessageFormat.format(rb.getString("INVALID_COLUMN_INDEX"), new Integer(idx)));
        }
    }

    private void checkCursor() throws SQLException {
        if (this.isAfterLast() || this.isBeforeFirst()) {
            throw new SQLException(rb.getString("INVALID_CURSOR_POS"));
        }
    }

    private int getColIdxByName(String name) throws SQLException {
        int cols = this.rowSetMD.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            String colName = this.rowSetMD.getColumnLabel(i);
            if (colName == null || !name.equalsIgnoreCase(colName)) continue;
            return i;
        }
        throw new SQLException(rb.getString("INVALID_COLUMN_NAME"));
    }

    protected BaseRow getCurrentRow() throws SQLException {
        if (this.onInsertRow) {
            return this.insertRow;
        }
        if (this.cursorPos < 1 || this.cursorPos > this.rvh.size()) {
            throw new SQLException(rb.getString("INVALID_CURSOR_POS"));
        }
        return (BaseRow)this.rvh.get(this.cursorPos - 1);
    }

    protected void removeCurrentRow() throws SQLException {
        ((Row)this.getCurrentRow()).setDeleted();
        this.rvh.remove(this.cursorPos);
        --this.numRows;
    }

    public String getString(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        return value.toString();
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        try {
            Double d = new Double(value.toString());
            return d.compareTo(new Double(0.0)) != 0;
        }
        catch (NumberFormatException ex) {
            throw new SQLException(MessageFormat.format(rb.getString("GET_BOOLEAN_FAILED"), value.toString().trim(), new Integer(columnIndex)));
        }
    }

    public byte getByte(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return 0;
        }
        try {
            return new Byte(value.toString());
        }
        catch (NumberFormatException ex) {
            throw new SQLException(MessageFormat.format(rb.getString("GET_BYTE_FAILED"), value.toString().trim(), new Integer(columnIndex)));
        }
    }

    public short getShort(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return 0;
        }
        try {
            return new Short(value.toString().trim());
        }
        catch (NumberFormatException ex) {
            throw new SQLException(MessageFormat.format(rb.getString("GET_SHORT_FAILED"), value.toString().trim(), new Integer(columnIndex)));
        }
    }

    public int getInt(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return 0;
        }
        try {
            return new Integer(value.toString().trim());
        }
        catch (NumberFormatException ex) {
            throw new SQLException(MessageFormat.format(rb.getString("GET_INT_FAILED"), value.toString().trim(), new Integer(columnIndex)));
        }
    }

    public long getLong(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return 0L;
        }
        try {
            return new Long(value.toString().trim());
        }
        catch (NumberFormatException ex) {
            throw new SQLException(MessageFormat.format(rb.getString("GET_LONG_FAILED"), value.toString().trim(), new Integer(columnIndex)));
        }
    }

    public float getFloat(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return 0.0f;
        }
        try {
            return new Float(value.toString()).floatValue();
        }
        catch (NumberFormatException ex) {
            throw new SQLException(MessageFormat.format(rb.getString("GET_FLOAT_FAILED"), value.toString().trim(), new Integer(columnIndex)));
        }
    }

    public double getDouble(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return 0.0;
        }
        try {
            return new Double(value.toString().trim());
        }
        catch (NumberFormatException ex) {
            throw new SQLException(MessageFormat.format(rb.getString("GET_DOUBLE_FAILED"), value.toString().trim(), new Integer(columnIndex)));
        }
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkExecuted();
        return this.getBigDecimal(columnIndex, scale);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (!this.isBinary(this.rowSetMD.getColumnType(columnIndex))) {
            throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
        }
        return (byte[])this.getCurrentRow().getColumnObject(columnIndex);
    }

    public java.sql.Date getDate(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        switch (this.rowSetMD.getColumnType(columnIndex)) {
            case 91: {
                long sec = ((java.sql.Date)value).getTime();
                return new java.sql.Date(sec);
            }
            case 93: {
                long sec = ((Timestamp)value).getTime();
                return new java.sql.Date(sec);
            }
            case -1: 
            case 1: 
            case 12: {
                try {
                    DateFormat df = DateFormat.getDateInstance();
                    return (java.sql.Date)df.parse(value.toString());
                }
                catch (ParseException ex) {
                    throw new SQLException(MessageFormat.format(rb.getString("GET_TIMESTAMP_FAILED"), value.toString().trim(), new Integer(columnIndex)));
                }
            }
        }
        throw new SQLException(MessageFormat.format(rb.getString("GET_TIMESTAMP2_FAILED"), value.toString().trim(), new Integer(columnIndex)));
    }

    public Time getTime(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        switch (this.rowSetMD.getColumnType(columnIndex)) {
            case 92: {
                return (Time)value;
            }
            case 93: {
                long sec = ((Timestamp)value).getTime();
                return new Time(sec);
            }
            case -1: 
            case 1: 
            case 12: {
                try {
                    DateFormat tf = DateFormat.getTimeInstance();
                    return (Time)tf.parse(value.toString());
                }
                catch (ParseException ex) {
                    throw new SQLException(MessageFormat.format(rb.getString("GET_TIME_FAILED"), value.toString().trim(), new Integer(columnIndex)));
                }
            }
        }
        throw new SQLException(MessageFormat.format(rb.getString("GET_TIME2_FAILED"), value.toString().trim(), new Integer(columnIndex)));
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        switch (this.rowSetMD.getColumnType(columnIndex)) {
            case 93: {
                return (Timestamp)value;
            }
            case 92: {
                long sec = ((Time)value).getTime();
                return new Timestamp(sec);
            }
            case 91: {
                long sec = ((java.sql.Date)value).getTime();
                return new Timestamp(sec);
            }
            case -1: 
            case 1: 
            case 12: {
                try {
                    DateFormat tf = DateFormat.getTimeInstance();
                    return (Timestamp)tf.parse(value.toString());
                }
                catch (ParseException ex) {
                    throw new SQLException(MessageFormat.format(rb.getString("GET_TIMESTAMP_FAILED"), value.toString().trim(), new Integer(columnIndex)));
                }
            }
        }
        throw new SQLException(MessageFormat.format(rb.getString("GET_TIMESTAMP2_FAILED"), value.toString().trim(), new Integer(columnIndex)));
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.asciiStream = null;
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.lastValueNull = true;
            return null;
        }
        try {
            if (!this.isString(this.rowSetMD.getColumnType(columnIndex))) {
                throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
            }
            this.asciiStream = new ByteArrayInputStream(((String)value).getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new SQLException(ex.getMessage());
        }
        return this.asciiStream;
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.unicodeStream = null;
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (!this.isBinary(this.rowSetMD.getColumnType(columnIndex)) && !this.isString(this.rowSetMD.getColumnType(columnIndex))) {
            throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
        }
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.lastValueNull = true;
            return null;
        }
        this.unicodeStream = new StringBufferInputStream(value.toString());
        return this.unicodeStream;
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.binaryStream = null;
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (!this.isBinary(this.rowSetMD.getColumnType(columnIndex))) {
            throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
        }
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.lastValueNull = true;
            return null;
        }
        this.binaryStream = new ByteArrayInputStream((byte[])value);
        return this.binaryStream;
    }

    public String getString(String columnName) throws SQLException {
        this.checkExecuted();
        return this.getString(this.getColIdxByName(columnName));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        this.checkExecuted();
        return this.getBoolean(this.getColIdxByName(columnName));
    }

    public byte getByte(String columnName) throws SQLException {
        this.checkExecuted();
        return this.getByte(this.getColIdxByName(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        this.checkExecuted();
        return this.getShort(this.getColIdxByName(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        this.checkExecuted();
        return this.getInt(this.getColIdxByName(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        this.checkExecuted();
        return this.getLong(this.getColIdxByName(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        this.checkExecuted();
        return this.getFloat(this.getColIdxByName(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        this.checkExecuted();
        return this.getDouble(this.getColIdxByName(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        this.checkExecuted();
        return this.getBigDecimal(this.getColIdxByName(columnName), scale);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        this.checkExecuted();
        return this.getBytes(this.getColIdxByName(columnName));
    }

    public java.sql.Date getDate(String columnName) throws SQLException {
        this.checkExecuted();
        return this.getDate(this.getColIdxByName(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        this.checkExecuted();
        return this.getTime(this.getColIdxByName(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        this.checkExecuted();
        return this.getTimestamp(this.getColIdxByName(columnName));
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        this.checkExecuted();
        return this.getAsciiStream(this.getColIdxByName(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        this.checkExecuted();
        return this.getUnicodeStream(this.getColIdxByName(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        this.checkExecuted();
        return this.getBinaryStream(this.getColIdxByName(columnName));
    }

    public SQLWarning getWarnings() {
        return this.sqlwarn;
    }

    public void clearWarnings() {
        this.sqlwarn = null;
    }

    public String getCursorName() throws SQLException {
        throw new SQLException(rb.getString("POSITIONED_UPDATES_NOT_SUPPORTED"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        Log.getLogger().entering(this.getClass().getName(), "getMetaData()");
        if (this.rowSetMD == null) {
            Connection tempConn = null;
            Statement tempPS = null;
            try {
                ResultSetMetaData rsmd;
                tempConn = CachedRowSetXImpl5.getConnection(this.getDataSourceName(), this.getUrl(), this.getUsername(), this.getPassword());
                Log.getLogger().finest("Connection: " + tempConn + "  DataSourceName: " + this.getDataSourceName() + "  URL: " + this.getUrl());
                if (tempConn == null) {
                    throw new NamingException(rb.getString("NAME_NOT_FOUND") + " " + this.getDataSourceName());
                }
                tempPS = tempConn.prepareStatement(this.getCommand());
                this.rowSetMD = new RowSetMetaDataXImpl();
                try {
                    rsmd = tempPS.getMetaData();
                    Log.getLogger().finest("After calling tempPS.getMetaData(), rsmd: " + rsmd);
                    if (rsmd == null && "Oracle".equals(tempConn.getMetaData().getDatabaseProductName())) {
                        rsmd = this.oracleFixup(tempConn, this.getCommand());
                    }
                }
                catch (SQLException e) {
                    Log.getLogger().finest("Exception caught: " + e.getErrorCode() + " : " + e.getMessage());
                    if (e.getErrorCode() == 17144) {
                        rsmd = this.oracleFixup(tempConn, this.getCommand());
                    }
                    throw e;
                }
                this.initMetaData(this.rowSetMD, rsmd);
            }
            catch (NamingException e) {
                Log.getLogger().finest("Caught exception: " + e + " " + e.getMessage());
            }
            finally {
                if (tempPS != null) {
                    tempPS.close();
                }
                if (tempConn != null) {
                    try {
                        if (!tempConn.getAutoCommit()) {
                            tempConn.rollback();
                        }
                    }
                    catch (Exception exception) {}
                    tempConn.close();
                }
            }
        }
        Log.getLogger().exiting(this.getClass().getName(), "getMetaData()");
        return this.rowSetMD;
    }

    private ResultSetMetaData oracleFixup(Connection tempConn, String command) throws SQLException {
        Log.getLogger().entering("CachedRowSetXImpl", "oracleFixup()", command);
        String cmd = command;
        String groupBy = "";
        int pos = cmd.toUpperCase().indexOf("GROUP BY");
        if (pos != -1) {
            groupBy = cmd.substring(pos);
            cmd = cmd.substring(0, pos);
        }
        String[] parts = cmd.split("(?i:where|having|order by)");
        String newCommand = parts[0] + " WHERE 1=0 " + groupBy;
        Log.getLogger().finest("Executing modified statement: " + newCommand);
        PreparedStatement tempPS = tempConn.prepareStatement(newCommand);
        tempPS.execute();
        return tempPS.getMetaData();
    }

    public Object getObject(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        if (value instanceof Struct) {
            Struct s = (Struct)value;
            Map<String, Class<?>> map = this.getTypeMap();
            Class<?> c = map.get(s.getSQLTypeName());
            if (c != null) {
                SQLData obj = null;
                try {
                    obj = (SQLData)c.newInstance();
                }
                catch (InstantiationException ex) {
                    throw new SQLException(rb.getString("UNABLE_TO_INSTANTIATE") + ex.getMessage());
                }
                catch (IllegalAccessException ex) {
                    throw new SQLException(rb.getString("UNABLE_TO_INSTANTIATE") + ex.getMessage());
                }
                Object[] attribs = s.getAttributes(map);
                SQLInputImpl sqlInput = new SQLInputImpl(attribs, map);
                obj.readSQL(sqlInput, s.getSQLTypeName());
                return obj;
            }
        }
        return value;
    }

    public Object getObject(String columnName) throws SQLException {
        this.checkExecuted();
        return this.getObject(this.getColIdxByName(columnName));
    }

    public int findColumn(String columnName) throws SQLException {
        return this.getColIdxByName(columnName);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (this.isBinary(this.rowSetMD.getColumnType(columnIndex))) {
            Object value = this.getCurrentRow().getColumnObject(columnIndex);
            if (value == null) {
                this.lastValueNull = true;
                return null;
            }
            this.charStream = new InputStreamReader(new ByteArrayInputStream((byte[])value));
        } else if (this.isString(this.rowSetMD.getColumnType(columnIndex))) {
            Object value = this.getCurrentRow().getColumnObject(columnIndex);
            if (value == null) {
                this.lastValueNull = true;
                return null;
            }
            this.charStream = new StringReader(value.toString());
        } else {
            throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
        }
        return this.charStream;
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        this.checkExecuted();
        return this.getCharacterStream(this.getColIdxByName(columnName));
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        try {
            return new BigDecimal(value.toString().trim());
        }
        catch (NumberFormatException ex) {
            throw new SQLException(MessageFormat.format(rb.getString("GET_DOUBLE_FAILED"), value.toString().trim(), new Integer(columnIndex)));
        }
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        this.checkExecuted();
        return this.getBigDecimal(this.getColIdxByName(columnName));
    }

    public int size() {
        return this.numRows;
    }

    public boolean isBeforeFirst() throws SQLException {
        this.checkExecuted();
        return this.cursorPos == 0 && this.numRows > 0;
    }

    public boolean isAfterLast() throws SQLException {
        this.checkExecuted();
        return this.cursorPos == this.numRows + 1 && this.numRows > 0;
    }

    public boolean isFirst() throws SQLException {
        this.checkExecuted();
        int saveCursorPos = this.cursorPos;
        int saveAbsoluteCursorPos = this.absolutePos;
        this.internalFirst();
        if (this.cursorPos == saveCursorPos) {
            return true;
        }
        this.cursorPos = saveCursorPos;
        this.absolutePos = saveAbsoluteCursorPos;
        return false;
    }

    public boolean isLast() throws SQLException {
        this.checkExecuted();
        int saveCursorPos = this.cursorPos;
        int saveAbsoluteCursorPos = this.absolutePos;
        boolean saveShowDeleted = this.getShowDeleted();
        this.setShowDeleted(true);
        this.internalLast();
        if (this.cursorPos == saveCursorPos) {
            this.setShowDeleted(saveShowDeleted);
            return true;
        }
        this.setShowDeleted(saveShowDeleted);
        this.cursorPos = saveCursorPos;
        this.absolutePos = saveAbsoluteCursorPos;
        return false;
    }

    public void beforeFirst() throws SQLException {
        this.checkExecuted();
        if (this.getType() == 1003) {
            throw new SQLException(rb.getString("RESULTSET_TYPE_FORWARD_ONLY"));
        }
        this.cursorPos = 0;
        this.absolutePos = 0;
        this.notifyCursorMoved();
    }

    public void afterLast() throws SQLException {
        this.checkExecuted();
        if (this.numRows > 0) {
            this.cursorPos = this.numRows + 1;
            this.absolutePos = 0;
            this.notifyCursorMoved();
        }
    }

    public boolean first() throws SQLException {
        this.checkExecuted();
        if (this.getType() == 1003) {
            throw new SQLException(rb.getString("RESULTSET_TYPE_FORWARD_ONLY"));
        }
        boolean ret = this.internalFirst();
        this.notifyCursorMoved();
        return ret;
    }

    protected boolean internalFirst() throws SQLException {
        boolean ret = false;
        if (this.numRows > 0) {
            this.cursorPos = 1;
            ret = !this.getShowDeleted() && this.rowDeleted() ? this.internalNext() : true;
        }
        this.absolutePos = ret ? 1 : 0;
        return ret;
    }

    public boolean last() throws SQLException {
        this.checkExecuted();
        if (this.getType() == 1003) {
            throw new SQLException(rb.getString("RESULTSET_TYPE_FORWARD_ONLY"));
        }
        boolean ret = this.internalLast();
        this.notifyCursorMoved();
        return ret;
    }

    protected boolean internalLast() throws SQLException {
        boolean ret = false;
        if (this.numRows > 0) {
            this.cursorPos = this.numRows;
            ret = !this.getShowDeleted() && this.rowDeleted() ? this.internalPrevious() : true;
        }
        this.absolutePos = ret ? this.numRows - this.numDeleted : 0;
        return ret;
    }

    public int getRow() throws SQLException {
        this.checkExecuted();
        if (this.numRows > 0 && this.cursorPos > 0 && this.cursorPos < this.numRows + 1 && !this.getShowDeleted() && !this.rowDeleted()) {
            return this.absolutePos;
        }
        if (this.getShowDeleted()) {
            return this.cursorPos;
        }
        return 0;
    }

    public boolean absolute(int row) throws SQLException {
        this.checkExecuted();
        if (row == 0 || this.getType() == 1003) {
            throw new SQLException(rb.getString("RESULTSET_TYPE_FORWARD_ONLY"));
        }
        if (row > 0) {
            if (row > this.numRows) {
                this.afterLast();
                return false;
            }
            if (this.absolutePos <= 0) {
                this.internalFirst();
            }
        } else {
            if (this.cursorPos + row < 0) {
                this.beforeFirst();
                return false;
            }
            if (this.absolutePos >= 0) {
                this.internalLast();
            }
        }
        while (this.absolutePos != row && !(this.absolutePos < row ? !this.internalNext() : !this.internalPrevious())) {
        }
        this.notifyCursorMoved();
        return !this.isAfterLast() && !this.isBeforeFirst();
    }

    public boolean relative(int rows) throws SQLException {
        this.checkExecuted();
        if (this.numRows == 0 || this.isBeforeFirst() || this.isAfterLast() || this.getType() == 1003) {
            throw new SQLException(rb.getString("RESULTSET_TYPE_FORWARD_ONLY"));
        }
        if (rows == 0) {
            return true;
        }
        if (rows > 0) {
            if (this.cursorPos + rows > this.numRows) {
                this.afterLast();
            } else {
                for (int i = 0; i < rows && this.internalNext(); ++i) {
                }
            }
        } else if (this.cursorPos + rows < 0) {
            this.beforeFirst();
        } else {
            for (int i = rows; i < 0 && this.internalPrevious(); ++i) {
            }
        }
        this.notifyCursorMoved();
        return !this.isAfterLast() && !this.isBeforeFirst();
    }

    public boolean previous() throws SQLException {
        this.checkExecuted();
        if (this.getType() == 1003) {
            throw new SQLException(rb.getString("RESULTSET_TYPE_FORWARD_ONLY"));
        }
        if (this.cursorPos < 0 || this.cursorPos > this.numRows + 1) {
            throw new SQLException(rb.getString("INVALID_CURSOR_POS"));
        }
        boolean ret = this.internalPrevious();
        this.notifyCursorMoved();
        return ret;
    }

    protected boolean internalPrevious() throws SQLException {
        boolean ret = false;
        do {
            if (this.cursorPos > 1) {
                --this.cursorPos;
                ret = true;
                continue;
            }
            if (this.cursorPos != 1) continue;
            --this.cursorPos;
            ret = false;
            break;
        } while (!this.getShowDeleted() && this.rowDeleted());
        this.absolutePos = ret ? --this.absolutePos : 0;
        return ret;
    }

    public boolean rowUpdated() throws SQLException {
        this.checkExecuted();
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(rb.getString("INVALID_INSERT_ROW_OP"));
        }
        return ((Row)this.getCurrentRow()).getUpdated();
    }

    public boolean columnUpdated(int idx) throws SQLException {
        this.checkExecuted();
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(rb.getString("INVALID_INSERT_ROW_OP"));
        }
        return ((Row)this.getCurrentRow()).getColUpdated(idx - 1);
    }

    public boolean columnUpdated(String columnName) throws SQLException {
        this.checkExecuted();
        return this.columnUpdated(this.getColIdxByName(columnName));
    }

    public boolean rowInserted() throws SQLException {
        this.checkExecuted();
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(rb.getString("INVALID_INSERT_ROW_OP"));
        }
        return ((Row)this.getCurrentRow()).getInserted();
    }

    public boolean rowDeleted() throws SQLException {
        this.checkExecuted();
        if (this.isAfterLast() || this.isBeforeFirst() || this.onInsertRow) {
            throw new SQLException(rb.getString("INVALID_CURSOR_POS"));
        }
        return ((Row)this.getCurrentRow()).getDeleted();
    }

    private boolean isNumeric(int type) {
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private boolean isString(int type) {
        switch (type) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private boolean isBinary(int type) {
        switch (type) {
            case -4: 
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    private boolean isTemporal(int type) {
        switch (type) {
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    private Object convertNumeric(Object srcObj, int srcType, int trgType) throws SQLException {
        if (srcType == trgType) {
            return srcObj;
        }
        if (!this.isNumeric(trgType) && !this.isString(trgType)) {
            throw new SQLException(rb.getString("DATATYPE_MISMATCH") + trgType);
        }
        try {
            switch (trgType) {
                case -7: {
                    Integer i = new Integer(srcObj.toString().trim());
                    return i.equals(new Integer(0)) ? new Boolean(false) : new Boolean(true);
                }
                case -6: {
                    return new Byte(srcObj.toString().trim());
                }
                case 5: {
                    return new Short(srcObj.toString().trim());
                }
                case 4: {
                    return new Integer(srcObj.toString().trim());
                }
                case -5: {
                    return new Long(srcObj.toString().trim());
                }
                case 2: 
                case 3: {
                    return new BigDecimal(srcObj.toString().trim());
                }
                case 6: 
                case 7: {
                    return new Float(srcObj.toString().trim());
                }
                case 8: {
                    return new Double(srcObj.toString().trim());
                }
                case -1: 
                case 1: 
                case 12: {
                    return new String(srcObj.toString());
                }
            }
            throw new SQLException(rb.getString("DATATYPE_MISMATCH") + trgType);
        }
        catch (NumberFormatException ex) {
            throw new SQLException(rb.getString("DATATYPE_MISMATCH") + trgType);
        }
    }

    private Object convertTemporal(Object srcObj, int srcType, int trgType) throws SQLException {
        if (srcType == trgType) {
            return srcObj;
        }
        if (this.isNumeric(trgType) || !this.isString(trgType) && !this.isTemporal(trgType)) {
            throw new SQLException(rb.getString("DATATYPE_MISMATCH") + trgType);
        }
        try {
            switch (trgType) {
                case 91: {
                    if (srcType == 93) {
                        return new java.sql.Date(((Timestamp)srcObj).getTime());
                    }
                    throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
                }
                case 93: {
                    if (srcType == 92) {
                        return new Timestamp(((Time)srcObj).getTime());
                    }
                    return new Timestamp(((java.sql.Date)srcObj).getTime());
                }
                case 92: {
                    if (srcType == 93) {
                        return new Time(((Timestamp)srcObj).getTime());
                    }
                    throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
                }
                case -1: 
                case 1: 
                case 12: {
                    return new String(srcObj.toString());
                }
            }
            throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
        }
        catch (NumberFormatException ex) {
            throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
        }
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        BaseRow row = this.getCurrentRow();
        row.setColumnObject(columnIndex, null);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertNumeric(new Boolean(x), -7, this.rowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertNumeric(new Byte(x), -6, this.rowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertNumeric(new Short(x), 5, this.rowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertNumeric(new Integer(x), 4, this.rowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertNumeric(new Long(x), -5, this.rowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertNumeric(new Float(x), 7, this.rowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertNumeric(new Double(x), 8, this.rowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertNumeric(x, 2, this.rowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.getCurrentRow().setColumnObject(columnIndex, x);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (!this.isBinary(this.rowSetMD.getColumnType(columnIndex))) {
            throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
        }
        this.getCurrentRow().setColumnObject(columnIndex, x);
    }

    public void updateDate(int columnIndex, java.sql.Date x) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertTemporal(x, 91, this.rowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertTemporal(x, 92, this.rowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertTemporal(x, 93, this.rowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (!this.isString(this.rowSetMD.getColumnType(columnIndex)) && !this.isBinary(this.rowSetMD.getColumnType(columnIndex))) {
            throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
        }
        byte[] buf = new byte[length];
        try {
            int charsRead = 0;
            while ((charsRead += x.read(buf, charsRead, length - charsRead)) != length) {
            }
        }
        catch (IOException ex) {
            throw new SQLException(rb.getString("READ_FAILED_ASCII_STREAM"));
        }
        String str = new String(buf);
        this.getCurrentRow().setColumnObject(columnIndex, str);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (!this.isBinary(this.rowSetMD.getColumnType(columnIndex))) {
            throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
        }
        byte[] buf = new byte[length];
        try {
            int bytesRead = 0;
            while ((bytesRead += x.read(buf, bytesRead, length - bytesRead)) != -1) {
            }
        }
        catch (IOException ex) {
            throw new SQLException(rb.getString("READ_FAILED_BINARY_STREAM"));
        }
        this.getCurrentRow().setColumnObject(columnIndex, buf);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (!this.isString(this.rowSetMD.getColumnType(columnIndex)) && !this.isBinary(this.rowSetMD.getColumnType(columnIndex))) {
            throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
        }
        char[] buf = new char[length];
        try {
            int charsRead = 0;
            while ((charsRead += x.read(buf, charsRead, length - charsRead)) != length) {
            }
        }
        catch (IOException ex) {
            throw new SQLException(rb.getString("READ_FAILED_BINARY_STREAM"));
        }
        String str = new String(buf);
        this.getCurrentRow().setColumnObject(columnIndex, str);
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        int type = this.rowSetMD.getColumnType(columnIndex);
        if (type == 3 || type == 2) {
            ((BigDecimal)x).setScale(scale);
        }
        this.getCurrentRow().setColumnObject(columnIndex, x);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.getCurrentRow().setColumnObject(columnIndex, x);
    }

    public void updateNull(String columnName) throws SQLException {
        this.checkExecuted();
        this.updateNull(this.getColIdxByName(columnName));
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.checkExecuted();
        this.updateBoolean(this.getColIdxByName(columnName), x);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.checkExecuted();
        this.updateByte(this.getColIdxByName(columnName), x);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.checkExecuted();
        this.updateShort(this.getColIdxByName(columnName), x);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.checkExecuted();
        this.updateInt(this.getColIdxByName(columnName), x);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.checkExecuted();
        this.updateLong(this.getColIdxByName(columnName), x);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.checkExecuted();
        this.updateFloat(this.getColIdxByName(columnName), x);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.checkExecuted();
        this.updateDouble(this.getColIdxByName(columnName), x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.checkExecuted();
        this.updateBigDecimal(this.getColIdxByName(columnName), x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.checkExecuted();
        this.updateString(this.getColIdxByName(columnName), x);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.checkExecuted();
        this.updateBytes(this.getColIdxByName(columnName), x);
    }

    public void updateDate(String columnName, java.sql.Date x) throws SQLException {
        this.checkExecuted();
        this.updateDate(this.getColIdxByName(columnName), x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.checkExecuted();
        this.updateTime(this.getColIdxByName(columnName), x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.checkExecuted();
        this.updateTimestamp(this.getColIdxByName(columnName), x);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.checkExecuted();
        this.updateAsciiStream(this.getColIdxByName(columnName), x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.checkExecuted();
        this.updateBinaryStream(this.getColIdxByName(columnName), x, length);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.checkExecuted();
        this.updateCharacterStream(this.getColIdxByName(columnName), reader, length);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.checkExecuted();
        this.updateObject(this.getColIdxByName(columnName), x, scale);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.checkExecuted();
        this.updateObject(this.getColIdxByName(columnName), x);
    }

    public void insertRow() throws SQLException {
        this.checkExecuted();
        if (!this.onInsertRow) {
            throw new SQLException(rb.getString("INSERT_ROW_FAILED"));
        }
        Row insRow = new Row(this.rowSetMD.getColumnCount(), this.insertRow.getOrigRow());
        insRow.setInserted();
        int pos = this.currentRow >= this.numRows || this.currentRow < 0 ? this.numRows : this.currentRow;
        this.rvh.add(pos, insRow);
        ++this.numRows;
        this.onInsertRow = false;
        this.cursorPos = this.currentRow;
        this.notifyRowChanged();
    }

    public void updateRow() throws SQLException {
        this.checkExecuted();
        if (this.onInsertRow) {
            throw new SQLException(rb.getString("UPDATE_ROW_CALLED_ON_INSERT_ROW"));
        }
        ((Row)this.getCurrentRow()).setUpdated();
        this.notifyRowChanged();
    }

    public void deleteRow() throws SQLException {
        this.checkExecuted();
        this.checkCursor();
        ((Row)this.getCurrentRow()).setDeleted();
        ++this.numDeleted;
        this.notifyRowChanged();
    }

    public void refreshRow() throws SQLException {
        this.checkExecuted();
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(rb.getString("INVALID_CURSOR_POS"));
        }
        Row currentRow = (Row)this.getCurrentRow();
        currentRow.clearUpdated();
    }

    public void cancelRowUpdates() throws SQLException {
        this.checkExecuted();
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(rb.getString("INVALID_CURSOR_POS"));
        }
        Row currentRow = (Row)this.getCurrentRow();
        if (currentRow.getUpdated()) {
            currentRow.clearUpdated();
            this.notifyRowChanged();
        }
    }

    public void moveToInsertRow() throws SQLException {
        this.checkExecuted();
        if (this.getConcurrency() == 1007) {
            throw new SQLException(rb.getString("RESULTSET_IS_READONLY"));
        }
        if (this.insertRow == null) {
            if (this.rowSetMD == null) {
                throw new SQLException(rb.getString("MOVE_TO_INSERT_ROW_NO_MD"));
            }
            int numCols = this.rowSetMD.getColumnCount();
            if (numCols > 0) {
                this.insertRow = new InsertRow(numCols);
            } else {
                throw new SQLException(rb.getString("MOVE_TO_INSERT_ROW_INVALID_NO_OF_COLS"));
            }
        }
        this.onInsertRow = true;
        this.currentRow = this.cursorPos;
        this.cursorPos = -1;
        this.insertRow.initInsertRow();
    }

    public void moveToCurrentRow() throws SQLException {
        this.checkExecuted();
        if (!this.onInsertRow) {
            return;
        }
        this.cursorPos = this.currentRow;
        this.onInsertRow = false;
    }

    public Statement getStatement() throws SQLException {
        return null;
    }

    public Object getObject(int columnIndex, Map map) throws SQLException {
        Struct s;
        Class c;
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        if (value instanceof Struct && (c = (Class)map.get((s = (Struct)value).getSQLTypeName())) != null) {
            SQLData obj = null;
            try {
                obj = (SQLData)c.newInstance();
            }
            catch (InstantiationException ex) {
                throw new SQLException(rb.getString("UNABLE_TO_INSTANTIATE") + ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                throw new SQLException(rb.getString("UNABLE_TO_INSTANTIATE") + ex.getMessage());
            }
            Object[] attribs = s.getAttributes(map);
            SQLInputImpl sqlInput = new SQLInputImpl(attribs, map);
            obj.readSQL(sqlInput, s.getSQLTypeName());
            return obj;
        }
        return value;
    }

    public Ref getRef(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (this.rowSetMD.getColumnType(columnIndex) != 2006) {
            throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
        }
        this.setLastValueNull(false);
        Ref value = (Ref)this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        return value;
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (this.rowSetMD.getColumnType(columnIndex) != 2004) {
            throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
        }
        this.setLastValueNull(false);
        Blob value = (Blob)this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        return value;
    }

    public Clob getClob(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (this.rowSetMD.getColumnType(columnIndex) != 2005) {
            throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
        }
        this.setLastValueNull(false);
        Clob value = (Clob)this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        return value;
    }

    public Array getArray(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (this.rowSetMD.getColumnType(columnIndex) != 2003) {
            throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
        }
        this.setLastValueNull(false);
        Array value = (Array)this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        return value;
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        this.checkExecuted();
        return this.getObject(this.getColIdxByName(columnName), map);
    }

    public Ref getRef(String colName) throws SQLException {
        this.checkExecuted();
        return this.getRef(this.getColIdxByName(colName));
    }

    public Blob getBlob(String colName) throws SQLException {
        this.checkExecuted();
        return this.getBlob(this.getColIdxByName(colName));
    }

    public Clob getClob(String colName) throws SQLException {
        this.checkExecuted();
        return this.getClob(this.getColIdxByName(colName));
    }

    public Array getArray(String colName) throws SQLException {
        this.checkExecuted();
        return this.getArray(this.getColIdxByName(colName));
    }

    public java.sql.Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        value = this.convertTemporal(value, this.rowSetMD.getColumnType(columnIndex), 91);
        Calendar defaultCal = Calendar.getInstance();
        defaultCal.setTime((Date)value);
        cal.set(1, defaultCal.get(1));
        cal.set(2, defaultCal.get(2));
        cal.set(5, defaultCal.get(5));
        return new java.sql.Date(cal.getTime().getTime());
    }

    public java.sql.Date getDate(String columnName, Calendar cal) throws SQLException {
        this.checkExecuted();
        return this.getDate(this.getColIdxByName(columnName), cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        value = this.convertTemporal(value, this.rowSetMD.getColumnType(columnIndex), 92);
        Calendar defaultCal = Calendar.getInstance();
        defaultCal.setTime((Date)value);
        cal.set(11, defaultCal.get(11));
        cal.set(12, defaultCal.get(12));
        cal.set(13, defaultCal.get(13));
        return new Time(cal.getTime().getTime());
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        this.checkExecuted();
        return this.getTime(this.getColIdxByName(columnName), cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        value = this.convertTemporal(value, this.rowSetMD.getColumnType(columnIndex), 93);
        Calendar defaultCal = Calendar.getInstance();
        defaultCal.setTime((Date)value);
        cal.set(1, defaultCal.get(1));
        cal.set(2, defaultCal.get(2));
        cal.set(5, defaultCal.get(5));
        cal.set(11, defaultCal.get(11));
        cal.set(12, defaultCal.get(12));
        cal.set(13, defaultCal.get(13));
        return new Timestamp(cal.getTime().getTime());
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        this.checkExecuted();
        return this.getTimestamp(this.getColIdxByName(columnName), cal);
    }

    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    private static Connection getConnection(String dataSourceName, String url, String username, String password) throws SQLException {
        Log.getLogger().entering("CachedRowSetXImpl", "getConnection()", new Object[]{dataSourceName, url, username, password});
        Connection conn = null;
        if (dataSourceName != null) {
            try {
                InitialContext ctx = new InitialContext();
                Log.getLogger().finest("About to get DataSource, ctx: " + ctx);
                DataSource ds = (DataSource)ctx.lookup(dataSourceName);
                if (ds == null) {
                    throw new NamingException(rb.getString("NAME_NOT_FOUND") + " " + dataSourceName);
                }
                Log.getLogger().finest("About to get connection, DataSource: " + ds);
                if (username == null || username.equals("")) {
                    conn = ds.getConnection();
                }
                conn = ds.getConnection(username, password);
            }
            catch (NamingException ex) {
                Log.getLogger().finest("Caught exception: " + ex + " " + ex.getMessage());
            }
            catch (SQLException sqe) {
                Log.getLogger().finest("Caught exception: " + sqe + " " + sqe.getMessage());
                throw new SQLException(rb.getString("UNABLE_TO_CONNECT") + sqe.getMessage());
            }
        } else if (url != null) {
            try {
                conn = DriverManager.getConnection(url, username, password);
            }
            catch (SQLException sqe) {
                Log.getLogger().finest("Caught exception: " + sqe + " " + sqe.getMessage());
            }
        } else {
            throw new SQLException(rb.getString("BOTH_DS_AND_URL_CANNOT_BE_NULL"));
        }
        return conn;
    }

    public void setMetaData(RowSetMetaData md) throws SQLException {
        this.rowSetMD = md;
    }

    public abstract ResultSet getOriginal() throws SQLException;

    public abstract ResultSet getOriginalRow() throws SQLException;

    public void setOriginalRow() throws SQLException {
        this.checkExecuted();
        if (this.onInsertRow) {
            throw new SQLException(rb.getString("INVALID_INSERT_ROW_OP"));
        }
        Row row = (Row)this.getCurrentRow();
        this.makeRowOriginal(row);
        if (row.getDeleted()) {
            this.removeCurrentRow();
            --this.numRows;
        }
    }

    private void makeRowOriginal(Row row) {
        if (row.getInserted()) {
            row.clearInserted();
        }
        if (row.getUpdated()) {
            row.moveCurrentToOrig();
        }
    }

    public void setOriginal() throws SQLException {
        this.checkExecuted();
        Iterator i = this.rvh.iterator();
        while (i.hasNext()) {
            Row row = (Row)i.next();
            this.makeRowOriginal(row);
            if (!row.getDeleted()) continue;
            i.remove();
            --this.numRows;
        }
        this.numDeleted = 0;
        this.notifyRowSetChanged();
    }

    public String getTableName() throws SQLException {
        return this.tableName;
    }

    public void setTableName(String tabName) throws SQLException {
        if (tabName == null) {
            throw new SQLException(rb.getString("TABLENAME_CANNOT_BE_NULL"));
        }
        this.tableName = new String(tabName);
    }

    public int[] getKeyColumns() throws SQLException {
        return this.keyCols;
    }

    public void setKeyColumns(int[] keys) throws SQLException {
        int numCols = 0;
        if (this.rowSetMD != null && keys.length > (numCols = this.rowSetMD.getColumnCount())) {
            throw new SQLException(rb.getString("INVALID_KEY_COLS"));
        }
        this.keyCols = new int[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            if (this.rowSetMD != null && (keys[i] <= 0 || keys[i] > numCols)) {
                throw new SQLException(MessageFormat.format(rb.getString("INVALID_COLUMN_INDEX"), new Integer(keys[i])));
            }
            this.keyCols[i] = keys[i];
        }
    }

    public void updateRef(int columnIndex, Ref ref) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.getCurrentRow().setColumnObject(columnIndex, new SerialRef(ref));
    }

    public void updateRef(String columnName, Ref ref) throws SQLException {
        this.checkExecuted();
        this.updateRef(this.getColIdxByName(columnName), ref);
    }

    public void updateClob(int columnIndex, Clob c) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (!this.dbmslocatorsUpdateCopy) {
            throw new SQLException(rb.getString("OP_NOT_SUPPORTED_BY_DB"));
        }
        this.getCurrentRow().setColumnObject(columnIndex, new SerialClob(c));
    }

    public void updateClob(String columnName, Clob c) throws SQLException {
        this.checkExecuted();
        this.updateClob(this.getColIdxByName(columnName), c);
    }

    public void updateBlob(int columnIndex, Blob b) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (!this.dbmslocatorsUpdateCopy) {
            throw new SQLException(rb.getString("OP_NOT_SUPPORTED_BY_DB"));
        }
        this.getCurrentRow().setColumnObject(columnIndex, new SerialBlob(b));
    }

    public void updateBlob(String columnName, Blob b) throws SQLException {
        this.checkExecuted();
        this.updateBlob(this.getColIdxByName(columnName), b);
    }

    public void updateArray(int columnIndex, Array a) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.getCurrentRow().setColumnObject(columnIndex, new SerialArray(a));
    }

    public void updateArray(String columnName, Array a) throws SQLException {
        this.checkExecuted();
        this.updateArray(this.getColIdxByName(columnName), a);
    }

    public URL getURL(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (this.rowSetMD.getColumnType(columnIndex) != 70) {
            throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
        }
        this.setLastValueNull(false);
        URL value = (URL)this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        return value;
    }

    public URL getURL(String columnName) throws SQLException {
        this.checkExecuted();
        return this.getURL(this.getColIdxByName(columnName));
    }

    public RowSetWarning getRowSetWarnings() {
        try {
            this.notifyCursorMoved();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.rowsetWarning;
    }

    public void commit() throws SQLException {
        this.checkExecuted();
        if (this.conn != null) {
            this.conn.commit();
        }
    }

    public void rollback() throws SQLException {
        this.checkExecuted();
        if (this.conn != null) {
            this.conn.rollback();
        }
    }

    public void rollback(Savepoint s) throws SQLException {
        this.checkExecuted();
        if (this.conn != null) {
            this.conn.rollback(s);
        }
    }

    public void unsetMatchColumn(int[] columnIdxes) throws SQLException {
        for (int j = 0; j < columnIdxes.length; ++j) {
            int i_val = Integer.parseInt(this.iMatchColumns.get(j).toString());
            if (columnIdxes[j] == i_val) continue;
            throw new SQLException(rb.getString("MATCH_COLUMNS_NOT_THE_SAME"));
        }
        for (int i = 0; i < columnIdxes.length; ++i) {
            this.iMatchColumns.set(i, new Integer(-1));
        }
    }

    public void unsetMatchColumn(String[] columnIdxes) throws SQLException {
        for (int j = 0; j < columnIdxes.length; ++j) {
            if (columnIdxes[j].equals(this.strMatchColumns.get(j))) continue;
            throw new SQLException(rb.getString("MATCH_COLUMNS_NOT_THE_SAME"));
        }
        for (int i = 0; i < columnIdxes.length; ++i) {
            this.strMatchColumns.set(i, null);
        }
    }

    public String[] getMatchColumnNames() throws SQLException {
        Object[] str_temp = new String[this.strMatchColumns.size()];
        if (this.strMatchColumns.get(0) == null) {
            throw new SQLException(rb.getString("SET_MATCH_COLUMNS_BEFORE_GETTING"));
        }
        this.strMatchColumns.copyInto(str_temp);
        return str_temp;
    }

    public int[] getMatchColumnIndexes() throws SQLException {
        Object[] int_temp = new Integer[this.iMatchColumns.size()];
        int[] i_temp = new int[this.iMatchColumns.size()];
        int i_val = (Integer)this.iMatchColumns.get(0);
        if (i_val == -1) {
            throw new SQLException(rb.getString("SET_MATCH_COLUMNS_BEFORE_GETTING"));
        }
        this.iMatchColumns.copyInto(int_temp);
        for (int i = 0; i < int_temp.length; ++i) {
            i_temp[i] = (Integer)int_temp[i];
        }
        return i_temp;
    }

    public void setMatchColumn(int[] columnIdxes) throws SQLException {
        for (int j = 0; j < columnIdxes.length; ++j) {
            if (columnIdxes[j] >= 0) continue;
            throw new SQLException(rb.getString("MATCH_COL_MUST_BE_GT_0"));
        }
        for (int i = 0; i < columnIdxes.length; ++i) {
            this.iMatchColumns.add(i, new Integer(columnIdxes[i]));
        }
    }

    public void setMatchColumn(String[] columnNames) throws SQLException {
        for (int j = 0; j < columnNames.length; ++j) {
            if (columnNames[j] != null && !columnNames[j].equals("")) continue;
            throw new SQLException(rb.getString("MATCH_COL_CANNOT_BE_NULL_OR_EMPTY"));
        }
        for (int i = 0; i < columnNames.length; ++i) {
            this.strMatchColumns.add(i, columnNames[i]);
        }
    }

    public void setMatchColumn(int columnIdx) throws SQLException {
        if (columnIdx < 0) {
            throw new SQLException(rb.getString("COL_ID_HAS_TO_BE_GT_0"));
        }
        this.iMatchColumns.set(0, new Integer(columnIdx));
    }

    public void setMatchColumn(String columnName) throws SQLException {
        if ((columnName = columnName.trim()) == "" || columnName.equals(null)) {
            throw new SQLException(rb.getString("COL_ID_HAS_TO_BE_NON_NULL"));
        }
        this.strMatchColumns.set(0, columnName);
    }

    public void unsetMatchColumn(int columnIdx) throws SQLException {
        if (!this.iMatchColumns.get(0).equals(new Integer(columnIdx))) {
            throw new SQLException(rb.getString("COL_UNSET_NOT_SAME_AS_SET"));
        }
        if (this.strMatchColumns.get(0) != null) {
            throw new SQLException(rb.getString("USE_COL_NAME_AS_ARG_TO_UNSETMATCHCOL"));
        }
        this.iMatchColumns.set(0, new Integer(-1));
    }

    public void unsetMatchColumn(String columnName) throws SQLException {
        columnName = columnName.trim();
        if (!this.strMatchColumns.get(0).equals(columnName)) {
            throw new SQLException(rb.getString("COL_UNSET_NOT_SAME_AS_SET"));
        }
        if ((Integer)this.iMatchColumns.get(0) > 0) {
            throw new SQLException(rb.getString("USE_COL_ID_AS_ARG_TO_UNSETMATCHCOL"));
        }
        this.strMatchColumns.set(0, null);
    }

    public void rowSetPopulated(RowSetEvent event, int numRows) throws SQLException {
        if (numRows < 0 || numRows < this.getFetchSize()) {
            throw new SQLException(rb.getString("NUM_ROWS_CANNOT_BE_LT_0_OR_LT_FETCHSIZE"));
        }
        if (this.size() % numRows == 0) {
            RowSetEvent event_temp;
            event = event_temp = new RowSetEvent(this);
            this.notifyRowSetChanged();
        }
    }

    public void populate(ResultSet data, int start) throws SQLException {
        Map<String, Class<?>> map = this.getTypeMap();
        this.cursorPos = 0;
        if (this.populatecallcount == 0) {
            if (start < 0) {
                throw new SQLException(rb.getString("START_POS_CANNOT_BE_NEGATIVE"));
            }
            if (this.getMaxRows() == 0) {
                data.absolute(start);
                while (data.next()) {
                    ++this.totalRows;
                }
                ++this.totalRows;
            }
            this.startPos = start;
        }
        ++this.populatecallcount;
        this.resultSet = data;
        if (this.endPos - this.startPos >= this.getMaxRows() && this.getMaxRows() > 0) {
            this.endPos = this.prevEndPos;
            this.pagenotend = false;
            return;
        }
        if ((this.maxRowsreached != this.getMaxRows() || this.maxRowsreached != this.totalRows) && this.pagenotend) {
            this.startPrev = start - this.getPageSize();
        }
        if (this.pageSize == 0) {
            this.prevEndPos = this.endPos;
            this.endPos = start + this.getMaxRows();
        } else {
            this.prevEndPos = this.endPos;
            this.endPos = start + this.getPageSize();
        }
        if (start == 1) {
            this.resultSet.beforeFirst();
        } else {
            this.resultSet.absolute(start - 1);
        }
        this.rvh = this.pageSize == 0 ? new Vector(this.getMaxRows()) : new Vector(this.getPageSize());
        if (data == null) {
            throw new SQLException(rb.getString("INVALID_RESULTSET_SUPPLIED"));
        }
        this.rsmd = data.getMetaData();
        this.rowSetMD = new RowSetMetaDataXImpl();
        this.initMetaData(this.rowSetMD, this.rsmd);
        this.rsmd = null;
        int numCols = this.rowSetMD.getColumnCount();
        int mRows = this.getMaxRows();
        int rowsFetched = 0;
        Row currentRow = null;
        if (!data.next() && mRows == 0) {
            this.endPos = this.prevEndPos;
            this.pagenotend = false;
            return;
        }
        data.previous();
        while (data.next()) {
            currentRow = new Row(numCols);
            if (this.pageSize == 0) {
                if (rowsFetched >= mRows && mRows > 0) {
                    this.rowsetWarning.setNextException(new SQLException(rb.getString("MAX_ROWS_EXCEEDED")));
                    break;
                }
            } else if (rowsFetched >= this.pageSize || this.maxRowsreached >= mRows && mRows > 0) {
                this.rowsetWarning.setNextException(new SQLException(rb.getString("MAX_ROWS_EXCEEDED")));
                break;
            }
            for (int i = 1; i <= numCols; ++i) {
                Object obj = map == null ? data.getObject(i) : data.getObject(i, map);
                if (obj instanceof Struct) {
                    obj = new SerialStruct((Struct)obj, map);
                } else if (obj instanceof SQLData) {
                    obj = new SerialStruct((SQLData)obj, map);
                } else if (obj instanceof Blob) {
                    obj = new SerialBlob((Blob)obj);
                } else if (obj instanceof Clob) {
                    obj = new SerialClob((Clob)obj);
                } else if (obj instanceof Array) {
                    obj = new SerialArray((Array)obj, map);
                }
                currentRow.initColumnObject(i, obj);
            }
            ++rowsFetched;
            ++this.maxRowsreached;
            this.rvh.add(currentRow);
        }
        this.numRows = rowsFetched;
        this.executed = true;
        this.notifyRowSetChanged();
    }

    public boolean nextPage() throws SQLException {
        if (this.populatecallcount == 0) {
            throw new SQLException(rb.getString("INVALID_OP_ROWSET_NOT_POPULATED"));
        }
        if (this.populatecallcount == 1) {
            ++this.populatecallcount;
            return this.pagenotend;
        }
        this.onFirstPage = false;
        if (this.callWithCon) {
            this.crsReader.setStartPosition(this.endPos);
            this.crsReader.readData(this);
            this.resultSet = null;
        } else {
            this.populate(this.resultSet, this.endPos);
        }
        return this.pagenotend;
    }

    public void setPageSize(int size) throws SQLException {
        if (size < 0) {
            throw new SQLException(rb.getString("PAGESIZE_MUST_BE_GE_0"));
        }
        if (size > this.getMaxRows() && this.getMaxRows() != 0) {
            throw new SQLException(rb.getString("PAGESIZE_MUST_BE_LE_MAXROWS"));
        }
        this.pageSize = size;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean previousPage() throws SQLException {
        int pS = this.getPageSize();
        int mR = this.maxRowsreached;
        if (this.populatecallcount == 0) {
            throw new SQLException(rb.getString("INVALID_OP_ROWSET_NOT_POPULATED"));
        }
        if (!this.callWithCon && this.resultSet.getType() == 1003) {
            throw new SQLException(rb.getString("RESULTSET_TYPE_FORWARD_ONLY"));
        }
        this.pagenotend = true;
        if (this.startPrev < this.startPos) {
            this.onFirstPage = true;
            return false;
        }
        if (this.onFirstPage) {
            return false;
        }
        int rem = mR % pS;
        if (rem == 0) {
            this.maxRowsreached -= 2 * pS;
            if (this.callWithCon) {
                this.crsReader.setStartPosition(this.startPrev);
                this.crsReader.readData(this);
                this.resultSet = null;
            } else {
                this.populate(this.resultSet, this.startPrev);
            }
            return true;
        }
        this.maxRowsreached -= pS + rem;
        if (this.callWithCon) {
            this.crsReader.setStartPosition(this.startPrev);
            this.crsReader.readData(this);
            this.resultSet = null;
        } else {
            this.populate(this.resultSet, this.startPrev);
        }
        return true;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String[] getColumnCatalogNames() {
        return this.columnCatalogNames;
    }

    public String getColumnCatalogNames(int index) {
        return this.columnCatalogNames[index];
    }

    public void setColumnCatalogNames(String[] columnCatalogNames) {
        this.columnCatalogNames = columnCatalogNames;
    }

    public void setColumnCatalogNames(int index, String columnCatalogName) {
        this.columnCatalogNames[index] = columnCatalogName;
    }

    public String[] getColumnSchemaNames() {
        return this.columnSchemaNames;
    }

    public String getColumnSchemaNames(int index) {
        return this.columnSchemaNames[index];
    }

    public void setColumnSchemaNames(String[] columnSchemaNames) {
        this.columnSchemaNames = columnSchemaNames;
    }

    public void setColumnSchemaNames(int index, String columnSchemaName) {
        this.columnSchemaNames[index] = columnSchemaName;
    }

    public String[] getColumnTableNames() {
        return this.columnTableNames;
    }

    public String getColumnTableNames(int index) {
        return this.columnTableNames[index];
    }

    public void setColumnTableNames(String[] columnTableNames) {
        this.columnTableNames = columnTableNames;
    }

    public void setColumnTableNames(int index, String columnTableName) {
        this.columnTableNames[index] = columnTableName;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String getColumnNames(int index) {
        return this.columnNames[index];
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public void setColumnNames(int index, String columnName) {
        this.columnNames[index] = columnName;
    }

    public boolean[] getInsertableColumns() {
        return this.insertableColumns;
    }

    public boolean getInsertableColumns(int index) {
        return this.insertableColumns[index];
    }

    public void setInsertableColumns(boolean[] insertableColumns) {
        this.insertableColumns = insertableColumns;
    }

    public void setInsertableColumns(int index, boolean insertableColumn) {
        this.insertableColumns[index] = insertableColumn;
    }

    public boolean[] getUpdatableColumns() {
        return this.updatableColumns;
    }

    public boolean getUpdatableColumns(int index) {
        return this.updatableColumns[index];
    }

    public void setUpdatableColumns(boolean[] updatableColumns) {
        this.updatableColumns = updatableColumns;
    }

    public void setUpdatableColumns(int index, boolean updatableColumn) {
        this.updatableColumns[index] = updatableColumn;
    }

    public boolean getPrintStatements() {
        return this.printStatements;
    }

    public void setPrintStatements(boolean printStatements) {
        this.printStatements = printStatements;
    }
}

