/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support;

import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.support.GroovyProjectExtender;
import org.netbeans.modules.groovy.support.spi.GroovyFeature;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.util.Lookup;

public class GsfClasspathHook
extends ProjectOpenedHook {
    private final Project project;

    public GsfClasspathHook(Project project, Lookup lookup) {
        this.project = project;
    }

    protected void projectOpened() {
        if (this.isGroovyEnabled()) {
            GroovyProjectExtender.registerGsfClassPath(this.project);
        }
    }

    protected void projectClosed() {
        if (this.isGroovyEnabled()) {
            GroovyProjectExtender.unregisterGsfClassPath(this.project);
        }
    }

    private boolean isGroovyEnabled() {
        GroovyFeature groovyFeature = (GroovyFeature)this.project.getLookup().lookup(GroovyFeature.class);
        return groovyFeature == null ? false : groovyFeature.isGroovyEnabled();
    }
}

