/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.text;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.text.Keymap;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.text.DesignerCaret;
import org.netbeans.modules.visualweb.text.DesignerPaneBaseUI;
import org.netbeans.modules.visualweb.text.actions.BeginLineAction;
import org.netbeans.modules.visualweb.text.actions.BeginWordAction;
import org.netbeans.modules.visualweb.text.actions.DefaultKeyTypedAction;
import org.netbeans.modules.visualweb.text.actions.DeleteNextCharAction;
import org.netbeans.modules.visualweb.text.actions.DeletePrevCharAction;
import org.netbeans.modules.visualweb.text.actions.EndLineAction;
import org.netbeans.modules.visualweb.text.actions.EndWordAction;
import org.netbeans.modules.visualweb.text.actions.NextVisualPositionAction;
import org.netbeans.modules.visualweb.text.actions.SelectAllAction;
import org.netbeans.modules.visualweb.text.actions.SelectLineAction;

public abstract class DesignerPaneBase
extends JComponent
implements Scrollable,
Accessible {
    public static final String forwardAction = "caret-forward";
    public static final String backwardAction = "caret-backward";
    public static final String upAction = "caret-up";
    public static final String downAction = "caret-down";
    public static final String selectionForwardAction = "selection-forward";
    public static final String selectionBackwardAction = "selection-backward";
    public static final String selectionUpAction = "selection-up";
    public static final String selectionDownAction = "selection-down";
    public static final String defaultKeyTypedAction = "default-typed";
    public static final String deletePrevCharAction = "delete-previous";
    public static final String deleteNextCharAction = "delete-next";
    public static final String selectWordAction = "select-word";
    public static final String beginWordAction = "caret-begin-word";
    public static final String endWordAction = "caret-end-word";
    public static final String selectionBeginWordAction = "selection-begin-word";
    public static final String selectionEndWordAction = "selection-end-word";
    public static final String selectLineAction = "select-line";
    public static final String selectAllAction = "select-all";
    public static final String selectionBeginLineAction = "selection-begin-line";
    public static final String selectionEndLineAction = "selection-end-line";
    public static final String beginLineAction = "caret-begin-line";
    public static final String endLineAction = "caret-end-line";
    private static DesignerPaneBase focusedComponent;
    private static final Action[] defaultActions;
    private static Map<String, Keymap> keymapTable;
    public static final String DEFAULT_KEYMAP = "default";
    private static final String uiClassID = "EditorPaneUI";
    private transient DesignerCaret caret;
    private transient Keymap keymap;
    private Color caretColor;
    private Color selectionColor;
    private Color selectedTextColor;

    public DesignerPaneBase() {
        this.enableEvents(2056L);
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.setLayout(null);
    }

    public abstract WebForm getWebForm();

    public DesignerPaneBaseUI getUI() {
        return (DesignerPaneBaseUI)this.ui;
    }

    public void setUI(DesignerPaneBaseUI designerPaneBaseUI) {
        super.setUI(designerPaneBaseUI);
    }

    public void updateUI() {
        DesignerPaneBase.info("Updating UI, ui=" + this.ui);
        this.setUI((DesignerPaneBaseUI)UIManager.getUI(this));
        DesignerPaneBase.info("after update, ui=" + this.ui);
        this.invalidate();
    }

    public static final DesignerPaneBase getFocusedComponent() {
        return focusedComponent;
    }

    public Action[] getActions() {
        return (Action[])defaultActions.clone();
    }

    private DesignerCaret getCaret() {
        return this.caret;
    }

    public void setCaret(DesignerCaret designerCaret) {
        if (this.caret != null) {
            this.caret.deinstall(this);
        }
        DesignerCaret designerCaret2 = this.caret;
        this.caret = designerCaret;
        if (this.caret != null) {
            this.caret.install(this);
        }
        this.firePropertyChange("caret", designerCaret2, this.caret);
    }

    public void setKeymap(Keymap keymap) {
        Keymap keymap2 = this.keymap;
        this.keymap = keymap;
        this.firePropertyChange("keymap", keymap2, this.keymap);
        this.updateInputMap(keymap2, keymap);
    }

    void updateInputMap(Keymap keymap, Keymap keymap2) {
        Serializable serializable;
        InputMap inputMap;
        InputMap inputMap2 = inputMap = this.getInputMap(0);
        while (inputMap != null && !(inputMap instanceof KeymapWrapper)) {
            inputMap2 = inputMap;
            inputMap = inputMap.getParent();
        }
        if (inputMap != null) {
            if (keymap2 == null) {
                if (inputMap2 != inputMap) {
                    inputMap2.setParent(inputMap.getParent());
                } else {
                    inputMap2.setParent(null);
                }
            } else {
                serializable = new KeymapWrapper(keymap2);
                inputMap2.setParent((InputMap)serializable);
                if (inputMap2 != inputMap) {
                    ((InputMap)serializable).setParent(inputMap.getParent());
                }
            }
        } else if (keymap2 != null && (inputMap = this.getInputMap(0)) != null) {
            serializable = new KeymapWrapper(keymap2);
            ((InputMap)serializable).setParent(inputMap.getParent());
            inputMap.setParent((InputMap)serializable);
        }
        ActionMap actionMap = serializable;
        for (serializable = this.getActionMap(); serializable != null && !(serializable instanceof KeymapActionMap); serializable = ((ActionMap)serializable).getParent()) {
            actionMap = serializable;
        }
        if (serializable != null) {
            if (keymap2 == null) {
                if (actionMap != serializable) {
                    actionMap.setParent(((ActionMap)serializable).getParent());
                } else {
                    actionMap.setParent(null);
                }
            } else {
                KeymapActionMap keymapActionMap = new KeymapActionMap(keymap2);
                actionMap.setParent(keymapActionMap);
                if (actionMap != serializable) {
                    keymapActionMap.setParent(((ActionMap)serializable).getParent());
                }
            }
        } else if (keymap2 != null && (serializable = this.getActionMap()) != null) {
            KeymapActionMap keymapActionMap = new KeymapActionMap(keymap2);
            keymapActionMap.setParent(((ActionMap)serializable).getParent());
            ((ActionMap)serializable).setParent(keymapActionMap);
        }
    }

    public Keymap getKeymap() {
        return this.keymap;
    }

    public static Keymap addKeymap(String string, Keymap keymap) {
        DefaultKeymap defaultKeymap = new DefaultKeymap(string, keymap);
        if (string != null) {
            keymapTable.put(string, defaultKeymap);
        }
        return defaultKeymap;
    }

    public static Keymap removeKeymap(String string) {
        return keymapTable.remove(string);
    }

    public static Keymap getKeymap(String string) {
        return keymapTable.get(string);
    }

    public static void loadKeymap(Keymap keymap, KeyBinding[] keyBindingArray, Action[] actionArray) {
        Action action;
        int n;
        HashMap<String, Action> hashMap = new HashMap<String, Action>();
        for (n = 0; n < actionArray.length; ++n) {
            action = actionArray[n];
            String string = (String)action.getValue("Name");
            hashMap.put(string != null ? string : "", action);
        }
        for (n = 0; n < keyBindingArray.length; ++n) {
            action = (Action)hashMap.get(keyBindingArray[n].actionName);
            if (action == null) continue;
            keymap.addActionForKeyStroke(keyBindingArray[n].key, action);
        }
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public void setCaretColor(Color color) {
        Color color2 = this.caretColor;
        this.caretColor = color;
        this.firePropertyChange("caretColor", color2, this.caretColor);
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color color) {
        Color color2 = this.selectionColor;
        this.selectionColor = color;
        this.firePropertyChange("selectionColor", color2, this.selectionColor);
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public void setSelectedTextColor(Color color) {
        Color color2 = this.selectedTextColor;
        this.selectedTextColor = color;
        this.firePropertyChange("selectedTextColor", color2, this.selectedTextColor);
    }

    public String getText(DomProvider.DomPosition domPosition, int n) {
        throw new RuntimeException("Not yet implemented!");
    }

    public DomProvider.DomPosition getCaretPosition() {
        if (this.caret == null) {
            return DomProvider.DomPosition.NONE;
        }
        return this.caret.getDot();
    }

    public void select(DomProvider.DomPosition domPosition, DomProvider.DomPosition domPosition2) {
        this.setCaretDot(domPosition);
        this.moveCaretDot(domPosition2);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return rectangle.height / 10;
            }
            case 0: {
                return rectangle.width / 10;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return rectangle.height;
            }
            case 0: {
                return rectangle.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleDesignerPaneBase();
        }
        return this.accessibleContext;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.getParent() instanceof JViewport) {
            Dimension dimension2;
            int n;
            JViewport jViewport = (JViewport)this.getParent();
            DesignerPaneBaseUI designerPaneBaseUI = this.getUI();
            int n2 = dimension.width;
            int n3 = dimension.height;
            if (!this.getScrollableTracksViewportWidth()) {
                n = jViewport.getWidth();
                dimension2 = designerPaneBaseUI.getMinimumSize(this);
                if (n != 0 && n < dimension2.width) {
                    n2 = dimension2.width;
                }
            }
            if (!this.getScrollableTracksViewportHeight()) {
                n = jViewport.getHeight();
                dimension2 = designerPaneBaseUI.getMinimumSize(this);
                if (n != 0 && n < dimension2.height) {
                    n3 = dimension2.height;
                }
            }
            if (n2 != dimension.width || n3 != dimension.height) {
                dimension = new Dimension(n2, n3);
            }
        }
        return dimension;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            DesignerPaneBaseUI designerPaneBaseUI = this.getUI();
            int n = jViewport.getWidth();
            Dimension dimension = designerPaneBaseUI.getMinimumSize(this);
            Dimension dimension2 = designerPaneBaseUI.getMaximumSize(this);
            if (n >= dimension.width && n <= dimension2.width) {
                return true;
            }
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            DesignerPaneBaseUI designerPaneBaseUI = this.getUI();
            int n = jViewport.getHeight();
            Dimension dimension = designerPaneBaseUI.getMinimumSize(this);
            if (n >= dimension.height) {
                Dimension dimension2 = designerPaneBaseUI.getMaximumSize(this);
                if (n <= dimension2.height) {
                    return true;
                }
            }
        }
        return false;
    }

    public void replaceSelection(String string) {
        boolean bl;
        WebForm webForm = this.getWebForm();
        if (this.caret == null) {
            return;
        }
        boolean bl2 = bl = !this.caret.replaceSelection(string);
        if (bl) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        }
    }

    public Transferable copySelection(boolean bl) {
        if (this.caret == null) {
            return null;
        }
        if (this.caret.hasSelection()) {
            String string = this.caret.getSelectedText();
            StringSelection stringSelection = new StringSelection(string);
            if (bl) {
                this.caret.removeSelection();
            }
            return stringSelection;
        }
        return new StringSelection("");
    }

    public boolean hasCaret() {
        return this.getCaret() != null;
    }

    public boolean hasCaretSelection() {
        return this.caret == null ? false : this.caret.hasSelection();
    }

    public DomProvider.DomPosition getFirstPosition() {
        return this.caret == null ? DomProvider.DomPosition.NONE : this.caret.getFirstPosition();
    }

    public DomProvider.DomPosition getLastPosition() {
        return this.caret == null ? DomProvider.DomPosition.NONE : this.caret.getLastPosition();
    }

    public boolean isCaretReadOnlyRegion() {
        return this.caret == null ? false : this.caret.isReadOnlyRegion();
    }

    public boolean isCaretVisible() {
        return this.caret == null ? false : this.caret.isVisible();
    }

    public DomProvider.DomPosition getCaretDot() {
        return this.caret == null ? DomProvider.DomPosition.NONE : this.caret.getDot();
    }

    public DomProvider.DomPosition getCaretMark() {
        return this.caret == null ? DomProvider.DomPosition.NONE : this.caret.getMark();
    }

    public void createCaret() {
        DesignerCaret designerCaret = this.getUI().createCaret();
        this.setCaret(designerCaret);
    }

    public boolean removeNextChar() {
        return this.caret == null ? false : this.caret.removeNextChar();
    }

    public boolean removePreviousChar() {
        return this.caret == null ? false : this.caret.removePreviousChar();
    }

    public DomProvider.DomRange getCaretRange() {
        return this.caret == null ? null : this.caret.getRange();
    }

    public void setCaretDot(DomProvider.DomPosition domPosition) {
        if (this.caret != null) {
            this.caret.setDot(domPosition);
        }
    }

    public void moveCaretDot(DomProvider.DomPosition domPosition) {
        if (this.caret != null) {
            this.caret.moveDot(domPosition);
        }
    }

    public void setCaretVisible(boolean bl) {
        if (this.caret != null) {
            this.caret.setVisible(bl);
        }
    }

    public void paintCaret(Graphics graphics) {
        if (this.caret != null) {
            this.caret.paint(graphics);
        }
    }

    public void setCaretMagicPosition(Point point) {
        if (this.caret != null) {
            this.caret.setMagicCaretPosition(point);
        }
    }

    public Point getCaretMagicPosition() {
        return this.caret == null ? null : this.caret.getMagicCaretPosition();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.caret != null) {
            this.caret.mousePressed(mouseEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.caret != null) {
            this.caret.mouseClicked(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.caret != null) {
            this.caret.mouseDragged(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.caret != null) {
            this.caret.mouseReleased(mouseEvent);
        }
    }

    public void caretDetachDom() {
        if (this.caret != null) {
            this.caret.detachDom();
        }
    }

    public abstract void escape(long var1);

    private static void info(String string) {
        Logger logger = DesignerPaneBase.getLogger();
        logger.info(string);
    }

    private static Logger getLogger() {
        return Logger.getLogger(DesignerPaneBase.class.getName());
    }

    static {
        defaultActions = new Action[]{new DefaultKeyTypedAction(), new BeginWordAction(beginWordAction, false), new EndWordAction(endWordAction, false), new BeginWordAction(selectionBeginWordAction, true), new EndWordAction(selectionEndWordAction, true), new BeginLineAction(beginLineAction, false), new EndLineAction(endLineAction, false), new BeginLineAction(selectionBeginLineAction, true), new EndLineAction(selectionEndLineAction, true), new DeletePrevCharAction(), new DeleteNextCharAction(), new NextVisualPositionAction(forwardAction, false, 3), new NextVisualPositionAction(backwardAction, false, 7), new NextVisualPositionAction(upAction, false, 1), new NextVisualPositionAction(downAction, false, 5), new NextVisualPositionAction(selectionForwardAction, true, 3), new NextVisualPositionAction(selectionBackwardAction, true, 7), new NextVisualPositionAction(selectionUpAction, true, 1), new NextVisualPositionAction(selectionDownAction, true, 5), new SelectLineAction(), new SelectAllAction()};
        keymapTable = null;
        try {
            keymapTable = new Hashtable<String, Keymap>(17);
            Keymap keymap = DesignerPaneBase.addKeymap(DEFAULT_KEYMAP, null);
            keymap.setDefaultAction(new DefaultKeyTypedAction());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private class AccessibleDesignerPaneBase
    extends JComponent.AccessibleJComponent {
        public AccessibleDesignerPaneBase() {
            super(DesignerPaneBase.this);
        }
    }

    static class KeymapActionMap
    extends ActionMap {
        private Keymap keymap;

        KeymapActionMap(Keymap keymap) {
            this.keymap = keymap;
        }

        public Object[] keys() {
            boolean bl;
            Object[] objectArray = super.keys();
            Object[] objectArray2 = this.keymap.getBoundActions();
            int n = objectArray == null ? 0 : objectArray.length;
            int n2 = objectArray2 == null ? 0 : objectArray2.length;
            boolean bl2 = bl = this.keymap.getDefaultAction() != null;
            if (bl) {
                ++n2;
            }
            if (n == 0) {
                if (bl) {
                    Object[] objectArray3 = new Object[n2];
                    if (n2 > 1) {
                        System.arraycopy(objectArray2, 0, objectArray3, 0, n2 - 1);
                    }
                    objectArray3[n2 - 1] = KeymapWrapper.DefaultActionKey;
                    return objectArray3;
                }
                return objectArray2;
            }
            if (n2 == 0) {
                return objectArray;
            }
            Object[] objectArray4 = new Object[n + n2];
            System.arraycopy(objectArray, 0, objectArray4, 0, n);
            if (bl) {
                if (n2 > 1) {
                    System.arraycopy(objectArray2, 0, objectArray4, n, n2 - 1);
                }
                objectArray4[n + n2 - 1] = KeymapWrapper.DefaultActionKey;
            } else {
                System.arraycopy(objectArray2, 0, objectArray4, n, n2);
            }
            return objectArray4;
        }

        public int size() {
            int n;
            Action[] actionArray = this.keymap.getBoundActions();
            int n2 = n = actionArray == null ? 0 : actionArray.length;
            if (this.keymap.getDefaultAction() != null) {
                ++n;
            }
            return super.size() + n;
        }

        public Action get(Object object) {
            Action action = super.get(object);
            if (action == null) {
                if (object == KeymapWrapper.DefaultActionKey) {
                    action = this.keymap.getDefaultAction();
                } else if (object instanceof Action) {
                    action = (Action)object;
                }
            }
            return action;
        }
    }

    static class KeymapWrapper
    extends InputMap {
        static final Object DefaultActionKey = new Object();
        private Keymap keymap;

        KeymapWrapper(Keymap keymap) {
            this.keymap = keymap;
        }

        public KeyStroke[] keys() {
            int n;
            KeyStroke[] keyStrokeArray = super.keys();
            KeyStroke[] keyStrokeArray2 = this.keymap.getBoundKeyStrokes();
            int n2 = keyStrokeArray == null ? 0 : keyStrokeArray.length;
            int n3 = n = keyStrokeArray2 == null ? 0 : keyStrokeArray2.length;
            if (n2 == 0) {
                return keyStrokeArray2;
            }
            if (n == 0) {
                return keyStrokeArray;
            }
            KeyStroke[] keyStrokeArray3 = new KeyStroke[n2 + n];
            System.arraycopy(keyStrokeArray, 0, keyStrokeArray3, 0, n2);
            System.arraycopy(keyStrokeArray2, 0, keyStrokeArray3, n2, n);
            return keyStrokeArray3;
        }

        public int size() {
            KeyStroke[] keyStrokeArray = this.keymap.getBoundKeyStrokes();
            int n = keyStrokeArray == null ? 0 : keyStrokeArray.length;
            return super.size() + n;
        }

        public Object get(KeyStroke keyStroke) {
            Object object = this.keymap.getAction(keyStroke);
            if (object == null && (object = super.get(keyStroke)) == null && keyStroke.getKeyChar() != '\uffff' && this.keymap.getDefaultAction() != null) {
                object = DefaultActionKey;
            }
            return object;
        }
    }

    static class DefaultKeymap
    implements Keymap {
        String nm;
        Keymap parent;
        Hashtable<KeyStroke, Action> bindings;
        Action defaultAction;

        DefaultKeymap(String string, Keymap keymap) {
            this.nm = string;
            this.parent = keymap;
            this.bindings = new Hashtable();
        }

        public Action getDefaultAction() {
            if (this.defaultAction != null) {
                return this.defaultAction;
            }
            return this.parent != null ? this.parent.getDefaultAction() : null;
        }

        public void setDefaultAction(Action action) {
            this.defaultAction = action;
        }

        public String getName() {
            return this.nm;
        }

        public Action getAction(KeyStroke keyStroke) {
            Action action = this.bindings.get(keyStroke);
            if (action == null && this.parent != null) {
                action = this.parent.getAction(keyStroke);
            }
            return action;
        }

        public KeyStroke[] getBoundKeyStrokes() {
            KeyStroke[] keyStrokeArray = new KeyStroke[this.bindings.size()];
            int n = 0;
            Enumeration<KeyStroke> enumeration = this.bindings.keys();
            while (enumeration.hasMoreElements()) {
                keyStrokeArray[n++] = enumeration.nextElement();
            }
            return keyStrokeArray;
        }

        public Action[] getBoundActions() {
            Action[] actionArray = new Action[this.bindings.size()];
            int n = 0;
            Enumeration<Action> enumeration = this.bindings.elements();
            while (enumeration.hasMoreElements()) {
                actionArray[n++] = enumeration.nextElement();
            }
            return actionArray;
        }

        public KeyStroke[] getKeyStrokesForAction(Action action) {
            if (action == null) {
                return null;
            }
            Object[] objectArray = null;
            Vector<KeyStroke> vector = null;
            KeyStroke[] keyStrokeArray = this.bindings.keys();
            while (keyStrokeArray.hasMoreElements()) {
                KeyStroke keyStroke = keyStrokeArray.nextElement();
                if (this.bindings.get(keyStroke) != action) continue;
                if (vector == null) {
                    vector = new Vector<KeyStroke>();
                }
                vector.addElement(keyStroke);
            }
            if (this.parent != null && (keyStrokeArray = this.parent.getKeyStrokesForAction(action)) != null) {
                int n;
                int n2 = 0;
                for (n = keyStrokeArray.length - 1; n >= 0; --n) {
                    if (!this.isLocallyDefined(keyStrokeArray[n])) continue;
                    keyStrokeArray[n] = null;
                    ++n2;
                }
                if (n2 > 0 && n2 < keyStrokeArray.length) {
                    if (vector == null) {
                        vector = new Vector();
                    }
                    for (n = keyStrokeArray.length - 1; n >= 0; --n) {
                        if (keyStrokeArray[n] == null) continue;
                        vector.addElement(keyStrokeArray[n]);
                    }
                } else if (n2 == 0) {
                    if (vector == null) {
                        objectArray = keyStrokeArray;
                    } else {
                        objectArray = new KeyStroke[vector.size() + keyStrokeArray.length];
                        vector.copyInto(objectArray);
                        System.arraycopy(keyStrokeArray, 0, objectArray, vector.size(), keyStrokeArray.length);
                        vector = null;
                    }
                }
            }
            if (vector != null) {
                objectArray = new KeyStroke[vector.size()];
                vector.copyInto(objectArray);
            }
            return objectArray;
        }

        public boolean isLocallyDefined(KeyStroke keyStroke) {
            return this.bindings.containsKey(keyStroke);
        }

        public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
            this.bindings.put(keyStroke, action);
        }

        public void removeKeyStrokeBinding(KeyStroke keyStroke) {
            this.bindings.remove(keyStroke);
        }

        public void removeBindings() {
            this.bindings.clear();
        }

        public Keymap getResolveParent() {
            return this.parent;
        }

        public void setResolveParent(Keymap keymap) {
            this.parent = keymap;
        }

        public String toString() {
            return super.toString() + "[name=" + this.nm + ", bindings=" + this.bindings + "]";
        }
    }

    public static class KeyBinding {
        public KeyStroke key;
        public String actionName;

        public KeyBinding(KeyStroke keyStroke, String string) {
            this.key = keyStroke;
            this.actionName = string;
        }
    }
}

