/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class ImageCache {
    private Map<URL, ImageIcon> images;

    public ImageIcon get(URL uRL) {
        if (this.images == null) {
            return null;
        }
        return this.images.get(uRL);
    }

    public void put(URL uRL, ImageIcon imageIcon) {
        if (this.images == null) {
            this.images = new HashMap<URL, ImageIcon>();
        }
        this.images.put(uRL, imageIcon);
    }

    public void flush() {
        if (this.images != null) {
            for (URL uRL : this.images.keySet()) {
                try {
                    new URI(uRL.toExternalForm());
                }
                catch (URISyntaxException uRISyntaxException) {
                    ErrorManager.getDefault().notify(1, (Throwable)uRISyntaxException);
                    continue;
                }
                FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                if (fileObject == null) continue;
                fileObject.refresh(false);
            }
            this.images = null;
        }
    }

    public String toString() {
        return super.toString() + "[images=" + this.images + "]";
    }
}

