/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.ModelViewMapper;
import org.netbeans.modules.visualweb.designer.DesignerPane;
import org.netbeans.modules.visualweb.designer.DesignerUtils;
import org.netbeans.modules.visualweb.designer.InteractionManager;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DndHandler {
    public static final int DROP_DENIED = 0;
    public static final int DROP_PARENTED = 1;
    public static final int DROP_LINKED = 2;
    private static final transient boolean DONT_SHOW_MATCHES = System.getProperty("designer.dontShowDropTarget") != null;
    private transient WebForm webform;
    private transient WeakReference<Element> recentDropTargetComponentRootElementWRef = new WeakReference<Object>(null);
    private transient Element currentMatchedComponentRootElement;
    private transient Element currentRegionElement;
    private transient String lastMessage;
    private transient Point dropPoint;
    private transient Dimension dropSize;
    private transient DomProvider.DomPosition insertPos = DomProvider.DomPosition.NONE;
    private transient int dropAction;

    public DndHandler(WebForm webForm) {
        this.webform = webForm;
        if (DesignerUtils.DEBUG) {
            DesignerUtils.debugLog(this.getClass().getName() + "()");
        }
        if (webForm == null) {
            throw new IllegalStateException("Null webform");
        }
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        return this.importDataExt(jComponent, transferable);
    }

    private boolean importDataExt(JComponent jComponent, Transferable transferable) {
        if (jComponent == null) {
            return false;
        }
        if (this.dropPoint == null && this.insertPos == DomProvider.DomPosition.NONE) {
            this.dropPoint = this.webform.getPastePoint();
        }
        InteractionManager.stopCnCForWebForm(this.webform);
        if (this.insertPos != DomProvider.DomPosition.NONE) {
            if (this.insertPos.isRenderedPosition()) {
                this.insertPos = this.insertPos.getSourcePosition();
            }
            if (this.insertPos != DomProvider.DomPosition.NONE) {
                this.dropPoint = null;
            }
        }
        Point point = this.getDropPoint();
        DomProvider.DomPosition domPosition = this.insertPos;
        DomProvider.DomPosition domPosition2 = this.computeDocumentPosition(point, domPosition);
        Node node = domPosition2.getNode();
        int n = domPosition2.getOffset();
        CssBox cssBox = point == null ? null : ModelViewMapper.findBox(this.webform.getPane().getPageBox(), point.x, point.y);
        Element element = cssBox == null ? null : cssBox.getElement();
        Element element2 = cssBox == null ? null : this.getDropeeComponent(cssBox);
        boolean bl = this.webform.isGridMode() || cssBox != null && cssBox.isGrid();
        boolean bl2 = this.webform.importData(jComponent, transferable, point, node, n, this.getDropSize(), bl, element, element2, this.dropAction);
        this.dropSize = null;
        this.insertPos = DomProvider.DomPosition.NONE;
        this.dropPoint = null;
        this.clearDropMatch();
        return bl2;
    }

    void importString(String string, Point point) {
        this.setDropPoint(point);
        Point point2 = this.getDropPoint();
        DomProvider.DomPosition domPosition = this.insertPos;
        DomProvider.DomPosition domPosition2 = this.computeDocumentPosition(point2, domPosition);
        Node node = domPosition2.getNode();
        int n = domPosition2.getOffset();
        CssBox cssBox = point2 == null ? null : ModelViewMapper.findBox(this.webform.getPane().getPageBox(), point2.x, point2.y);
        Element element = cssBox == null ? null : cssBox.getElement();
        Element element2 = cssBox == null ? null : this.getDropeeComponent(cssBox);
        boolean bl = this.webform.isGridMode() || cssBox != null && cssBox.isGrid();
        this.webform.importString(string, point2, node, n, this.getDropSize(), bl, element, element2);
    }

    private Element getDropeeComponent(CssBox cssBox) {
        Element element = ModelViewMapper.findElement(cssBox);
        return element;
    }

    private DomProvider.DomPosition computeDocumentPosition(Point point, DomProvider.DomPosition domPosition) {
        DesignerPane designerPane;
        if (point == null && domPosition == null && this.webform.getPane().hasCaret() && !(designerPane = this.webform.getPane()).isCaretReadOnlyRegion()) {
            domPosition = designerPane.getCaretPosition();
        }
        if (domPosition != null && domPosition != DomProvider.DomPosition.NONE && !InteractionManager.isReadOnlyRegion(domPosition)) {
            return domPosition;
        }
        return DomProvider.DomPosition.NONE;
    }

    Element getRecentDropTargetComponentRootElement() {
        return (Element)this.recentDropTargetComponentRootElementWRef.get();
    }

    public int getDropType(Point point, Transferable transferable, boolean bl) {
        if (transferable == null) {
            return 0;
        }
        CssBox cssBox = ModelViewMapper.findBox(this.webform.getPane().getPageBox(), point.x, point.y);
        Element element = this.getDropeeComponent(cssBox);
        Element element2 = cssBox == null ? null : cssBox.getElement();
        return this.webform.getDropType(element, element2, transferable, bl);
    }

    public void showDropMatch(Element element, Element element2, int n) {
        this.recentDropTargetComponentRootElementWRef = new WeakReference<Element>(element);
        if (DONT_SHOW_MATCHES || this.currentMatchedComponentRootElement == element && this.currentRegionElement == element2) {
            return;
        }
        this.currentMatchedComponentRootElement = element;
        this.currentRegionElement = element2;
        if (element2 != null) {
            assert (n == 2);
            this.webform.getManager().highlight(element, element2);
            this.lastMessage = NbBundle.getMessage(DndHandler.class, (String)"LinkTarget", (Object)this.webform.getDomProviderService().getRegionDisplayName(element2));
            StatusDisplayer.getDefault().setStatusText(this.lastMessage);
        } else if (element != null) {
            if (this.webform.canHighlightComponentRootElement(element)) {
                this.webform.getManager().highlight(element, null);
            } else {
                this.webform.getManager().highlight(null, null);
            }
            if (n == 2) {
                this.lastMessage = NbBundle.getMessage(DndHandler.class, (String)"LinkTarget", (Object)this.webform.getDomProviderService().getInstanceName(element));
                StatusDisplayer.getDefault().setStatusText(this.lastMessage);
            } else if (n == 1) {
                this.lastMessage = NbBundle.getMessage(DndHandler.class, (String)"ParentTarget", (Object)this.webform.getDomProviderService().getInstanceName(element));
                StatusDisplayer.getDefault().setStatusText(this.lastMessage);
            } else assert (false) : n;
        } else {
            this.clearDropMatch();
        }
    }

    public void clearDropMatch() {
        this.currentMatchedComponentRootElement = null;
        this.webform.getManager().highlight(null, null);
        if (StatusDisplayer.getDefault().getStatusText() == this.lastMessage) {
            StatusDisplayer.getDefault().setStatusText("");
        }
        this.lastMessage = null;
    }

    public int getDropTypeForComponent(Point point, Element element, boolean bl) {
        if (point == null) {
            throw new IllegalArgumentException("Null drop point.");
        }
        CssBox cssBox = ModelViewMapper.findBox(this.webform.getPane().getPageBox(), point.x, point.y);
        Element element2 = this.getDropeeComponent(cssBox);
        Element element3 = cssBox == null ? null : cssBox.getElement();
        return this.webform.getDropTypeForComponent(element2, element3, element, bl);
    }

    public Point getDropPoint() {
        return this.dropPoint;
    }

    public void setDropPoint(Point point) {
        this.dropPoint = point;
    }

    public Dimension getDropSize() {
        return this.dropSize;
    }

    public void setDropSize(Dimension dimension) {
        this.dropSize = dimension;
    }

    public void setInsertPosition(DomProvider.DomPosition domPosition) {
        this.insertPos = domPosition;
    }

    public void setDropAction(int n) {
        this.dropAction = n;
    }
}

