/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.css2;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.api.designer.markup.MarkupService;
import org.netbeans.modules.visualweb.css2.BoxType;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.FormatContext;
import org.netbeans.modules.visualweb.designer.DesignerPane;
import org.netbeans.modules.visualweb.designer.DesignerUtils;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.openide.ErrorManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class TextBox
extends CssBox {
    public static final int UNDERLINE = 1;
    public static final int STRIKE = 2;
    public static final int OVERLINE = 4;
    private int beginDomOffset = -1;
    private int endDomOffset = -1;
    private final int beginOffset;
    private final int endOffset;
    private char[] contentChars;
    private String xhtml;
    private String jspx;
    private FontMetrics metrics;
    private Color fg;
    private int decoration;
    private Text node;

    public TextBox(WebForm webForm, Element element, Text text, char[] cArray, String string, String string2, int n, int n2, Color color, Color color2, int n3, FontMetrics fontMetrics, boolean bl) {
        super(webForm, element, BoxType.TEXT, true, true);
        int n4;
        this.contentChars = cArray;
        this.beginOffset = n;
        this.endOffset = n2;
        this.node = text;
        this.decoration = n3;
        this.fg = color;
        this.bg = color2;
        this.metrics = fontMetrics;
        this.xhtml = string;
        this.jspx = string2;
        this.hidden = bl;
        this.width = n4 = DesignerUtils.getNonTabbedTextWidth(cArray, n, n2, fontMetrics);
        if (fontMetrics != null) {
            this.height = fontMetrics.getHeight();
        } else {
            ErrorManager.getDefault().log("No metrics found");
        }
        this.contentWidth = this.width;
        this.contentHeight = this.height;
    }

    protected void initialize() {
    }

    protected void initializeDesignBean() {
    }

    protected void initializeInvariants() {
    }

    protected void initializeHorizontalWidths(FormatContext formatContext) {
    }

    protected String paramString() {
        return "text=\"" + (this.contentChars == null ? null : this.getText()) + "\", " + super.paramString() + (this.metrics == null ? "" : ", font ascent=" + this.metrics.getAscent() + ", descent=" + this.metrics.getDescent() + ", height=" + this.metrics.getHeight() + ", font=" + this.metrics.getFont()) + ", boffset=" + this.beginOffset + ", eoffset=" + this.endOffset;
    }

    public String getText() {
        return new String(this.contentChars, this.beginOffset, this.endOffset - this.beginOffset);
    }

    protected void paintBackground(Graphics graphics, int n, int n2) {
        if (this.hidden) {
            return;
        }
        if (this.bg != null) {
            int n3 = this.getX() + n;
            int n4 = this.getY() + n2;
            graphics.setColor(this.bg);
            graphics.fillRect(n3, n4, this.width, this.height);
        }
    }

    public void paint(Graphics graphics, int n, int n2) {
        if (this.hidden) {
            return;
        }
        graphics.setFont(this.metrics.getFont());
        DesignerPane designerPane = this.webform.getPane();
        if (designerPane != null && designerPane.hasCaretSelection()) {
            if (!this.paintSelectedText(graphics, n, n2)) {
                graphics.setColor(this.fg);
                int n3 = this.getX() + n;
                int n4 = this.getY() + n2;
                int n5 = n4 + this.metrics.getHeight() - this.metrics.getDescent();
                graphics.drawChars(this.contentChars, this.beginOffset, this.endOffset - this.beginOffset, n3, n5);
                this.paintLines(graphics, n3, n4, n5, this.getWidth());
            }
            return;
        }
        int n6 = this.getX() + n;
        int n7 = this.getY() + n2;
        graphics.setColor(this.fg);
        int n8 = n7 + this.metrics.getHeight() - this.metrics.getDescent();
        graphics.drawChars(this.contentChars, this.beginOffset, this.endOffset - this.beginOffset, n6, n8);
        this.paintLines(graphics, n6, n7, n8, this.getWidth());
        if (CssBox.paintText) {
            graphics.setColor(Color.BLUE);
            graphics.drawRect(this.getAbsoluteX(), this.getAbsoluteY(), this.width, this.height);
        }
    }

    private boolean paintSelectedText(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (this.node == null) {
            return false;
        }
        DesignerPane designerPane = this.webform.getPane();
        if (designerPane == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("WebForm has null pane, webForm=" + this.webform));
            return false;
        }
        if (!designerPane.hasCaretSelection()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Pane doesn't have caret selection, pane=" + designerPane));
            return false;
        }
        DomProvider.DomPosition domPosition = designerPane.getFirstPosition();
        DomProvider.DomPosition domPosition2 = domPosition.getRenderedPosition();
        DomProvider.DomPosition domPosition3 = designerPane.getLastPosition();
        DomProvider.DomPosition domPosition4 = domPosition3.getRenderedPosition();
        Node node = domPosition2.getNode();
        if (node == null) {
            return false;
        }
        Node node2 = domPosition4.getNode();
        if (node2 == null) {
            return false;
        }
        Text text = this.node;
        if (!this.webform.isRenderedNode(text)) {
            text = MarkupService.getRenderedTextForText((Text)text);
        }
        int n6 = this.webform.compareBoundaryPoints(node, domPosition2.getOffset(), text, this.endOffset);
        int n7 = this.webform.compareBoundaryPoints(node2, domPosition4.getOffset(), text, this.beginOffset);
        if (n6 < 0 || n7 > 0) {
            return false;
        }
        if (node == text) {
            n5 = domPosition2.getOffset();
            if (n5 < this.beginOffset) {
                n5 = this.beginOffset;
            }
        } else {
            n5 = this.beginOffset;
        }
        if (node2 == text) {
            n4 = domPosition4.getOffset();
            if (n4 > this.endOffset) {
                n4 = this.endOffset;
            }
        } else {
            n4 = this.endOffset;
        }
        int n8 = this.getX() + n;
        int n9 = this.getY() + n2;
        int n10 = n9 + this.metrics.getHeight() - this.metrics.getDescent();
        if (n5 > this.beginOffset) {
            graphics.setColor(this.fg);
            graphics.drawChars(this.contentChars, this.beginOffset, n5 - this.beginOffset, n8, n10);
            n3 = DesignerUtils.getNonTabbedTextWidth(this.contentChars, this.beginOffset, n5, this.metrics);
            this.paintLines(graphics, n8, n9, n10, n3);
            n8 += n3;
        }
        if (n4 > n5) {
            graphics.setColor(designerPane.getSelectedTextColor());
            graphics.drawChars(this.contentChars, n5, n4 - n5, n8, n10);
            n3 = DesignerUtils.getNonTabbedTextWidth(this.contentChars, n5, n4, this.metrics);
            this.paintLines(graphics, n8, n9, n10, n3);
            n8 += n3;
        }
        if (n4 < this.endOffset) {
            graphics.setColor(this.fg);
            graphics.drawChars(this.contentChars, n4, this.endOffset - n4, n8, n10);
            n3 = DesignerUtils.getNonTabbedTextWidth(this.contentChars, n4, this.endOffset, this.metrics);
            this.paintLines(graphics, n8, n9, n10, n3);
            n8 += n3;
        }
        return true;
    }

    private void paintLines(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        if ((this.decoration & 1) != 0) {
            n5 = n3;
            graphics.drawLine(n, ++n5, n + n4, n5);
        }
        if ((this.decoration & 2) != 0) {
            n5 = n3;
            graphics.drawLine(n, n5 -= (int)((float)this.metrics.getAscent() * 0.4f), n + n4, n5);
        }
        if ((this.decoration & 4) != 0) {
            graphics.drawLine(n, n2, n + n4, n2);
        }
    }

    public FontMetrics getMetrics() {
        return this.metrics;
    }

    public boolean isUnderline() {
        return (this.decoration & 1) != 0;
    }

    public boolean isStrikeThrough() {
        return (this.decoration & 2) != 0;
    }

    public boolean isOverline() {
        return (this.decoration & 4) != 0;
    }

    public Color getTextColor() {
        return this.fg;
    }

    public int getIntrinsicWidth() {
        return this.width;
    }

    public int getIntrinsicHeight() {
        return this.height;
    }

    public int getBaseline() {
        return this.metrics.getHeight() - this.metrics.getDescent();
    }

    public DomProvider.DomPosition getFirstPosition() {
        if (this.node != null) {
            return this.webform.createDomPosition(this.node, this.getDomStartOffset(), DomProvider.DomPosition.Bias.FORWARD);
        }
        return DomProvider.DomPosition.NONE;
    }

    public DomProvider.DomPosition getLastPosition() {
        if (this.node != null) {
            return this.webform.createDomPosition(this.node, this.getDomEndOffset(), DomProvider.DomPosition.Bias.BACKWARD);
        }
        return DomProvider.DomPosition.NONE;
    }

    public DomProvider.DomPosition computePosition(int n) {
        int n2;
        int n3;
        if (this.node == null) {
            return DomProvider.DomPosition.NONE;
        }
        int n4 = TextBox.getNonTabbedTextOffset(this.contentChars, this.beginOffset, this.endOffset - this.beginOffset, this.metrics, 0, n);
        if (n4 < this.endOffset && n - (n3 = DesignerUtils.getNonTabbedTextWidth(this.contentChars, this.beginOffset, n4, this.metrics)) > (n2 = DesignerUtils.getNonTabbedTextWidth(this.contentChars, n4, n4 + 1, this.metrics)) / 2) {
            ++n4;
        }
        if (this.jspx != this.xhtml && this.jspx.indexOf(38) != -1) {
            n4 = this.webform.getDomProviderService().getUnexpandedOffset(this.jspx, n4);
        }
        return this.webform.createDomPosition(this.node, n4, DomProvider.DomPosition.Bias.FORWARD);
    }

    private static final int getNonTabbedTextOffset(char[] cArray, int n, int n2, FontMetrics fontMetrics, int n3, int n4) {
        int n5;
        if (n3 >= n4) {
            return n;
        }
        int n6 = n5 = n3;
        int n7 = n + n2;
        for (int i = n; i < n7; ++i) {
            char c = cArray[i];
            n6 = c == '\t' || c == '\n' ? (n6 += fontMetrics.charWidth(' ')) : (n6 += fontMetrics.charWidth(c));
            if (n4 >= n5 && n4 < n6) {
                if (n4 - n5 < n6 - n4) {
                    return i;
                }
                return i + 1;
            }
            n5 = n6;
        }
        return n;
    }

    public Rectangle getBoundingBox(DomProvider.DomPosition domPosition) {
        int n = this.jspx == this.xhtml || this.jspx.indexOf(38) == -1 ? domPosition.getOffset() : this.webform.getDomProviderService().getExpandedOffset(this.jspx, domPosition.getOffset());
        if (n > this.contentChars.length) {
            this.contentChars = domPosition.getNode().getNodeValue().toCharArray();
        }
        int n2 = DesignerUtils.getNonTabbedTextWidth(this.contentChars, this.beginOffset, n, this.metrics);
        int n3 = 1;
        if (domPosition.getOffset() < this.contentChars.length) {
            n3 = DesignerUtils.getNonTabbedTextWidth(this.contentChars, n, n, this.metrics);
        }
        return new Rectangle(this.getAbsoluteX() + n2, this.getAbsoluteY(), n3, this.getHeight());
    }

    public Text getNode() {
        return this.node;
    }

    public int getDomStartOffset() {
        if (this.beginDomOffset == -1) {
            this.beginDomOffset = this.jspx == this.xhtml || this.jspx.indexOf(38) == -1 ? this.beginOffset : this.webform.getDomProviderService().getUnexpandedOffset(this.jspx, this.beginOffset);
        }
        return this.beginDomOffset;
    }

    public int getDomEndOffset() {
        if (this.endDomOffset == -1) {
            this.endDomOffset = this.jspx == this.xhtml || this.jspx.indexOf(38) == -1 ? this.endOffset : this.webform.getDomProviderService().getUnexpandedOffset(this.jspx, this.endOffset);
        }
        return this.endDomOffset;
    }

    public DomProvider.DomPosition getPrev(DomProvider.DomPosition domPosition) {
        if (this.node == null) {
            return DomProvider.DomPosition.NONE;
        }
        if (domPosition.getOffset() > this.getDomStartOffset()) {
            int n = this.jspx == this.xhtml || this.jspx.indexOf(38) == -1 ? domPosition.getOffset() : this.webform.getDomProviderService().getExpandedOffset(this.jspx, domPosition.getOffset());
            n = this.isCharacterPair(n - 2) ? (n -= 2) : --n;
            if (this.jspx != this.xhtml && this.jspx.indexOf(38) != -1) {
                n = this.webform.getDomProviderService().getUnexpandedOffset(this.jspx, n);
            }
            return this.webform.createDomPosition(this.node, n, DomProvider.DomPosition.Bias.BACKWARD);
        }
        return DomProvider.DomPosition.NONE;
    }

    public DomProvider.DomPosition getNext(DomProvider.DomPosition domPosition) {
        if (this.node == null) {
            return DomProvider.DomPosition.NONE;
        }
        if (domPosition.getOffset() < this.getDomEndOffset()) {
            int n = this.jspx == this.xhtml || this.jspx.indexOf(38) == -1 ? domPosition.getOffset() : this.webform.getDomProviderService().getExpandedOffset(this.jspx, domPosition.getOffset());
            n = this.isCharacterPair(n) ? (n += 2) : ++n;
            if (this.jspx != this.xhtml && this.jspx.indexOf(38) != -1) {
                n = this.webform.getDomProviderService().getUnexpandedOffset(this.jspx, n);
            }
            return this.webform.createDomPosition(this.node, n, DomProvider.DomPosition.Bias.FORWARD);
        }
        return DomProvider.DomPosition.NONE;
    }

    private boolean isCharacterPair(int n) {
        if (n >= 0 && n < this.endOffset - 1) {
            char c = this.contentChars[n];
            char c2 = this.contentChars[n + 1];
            if (c >= '\ud800' && c <= '\udbff' && c2 >= '\udc00' && c2 <= '\udfff') {
                return true;
            }
        }
        return false;
    }
}

