/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.css2;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.api.designer.markup.MarkupService;
import org.netbeans.modules.visualweb.css2.BoxType;
import org.netbeans.modules.visualweb.css2.ContainerBox;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.ExternalDocumentBox;
import org.netbeans.modules.visualweb.css2.LineBox;
import org.netbeans.modules.visualweb.css2.LineBoxGroup;
import org.netbeans.modules.visualweb.css2.PageBox;
import org.netbeans.modules.visualweb.css2.SpaceBox;
import org.netbeans.modules.visualweb.css2.TextBox;
import org.netbeans.modules.visualweb.designer.CssUtilities;
import org.netbeans.modules.visualweb.designer.DesignerUtils;
import org.netbeans.modules.visualweb.designer.InlineEditor;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.openide.ErrorManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelViewMapper {
    private ModelViewMapper(WebForm webForm) {
    }

    public static DomProvider.DomPosition computeArrowLeft(WebForm webForm, DomProvider.DomPosition domPosition) {
        if (domPosition.isRenderedPosition()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalArgumentException("Node is expected to be not rendered, node=" + domPosition.getNode()));
        }
        DomProvider.DomPosition domPosition2 = domPosition.getRenderedPosition();
        LineBox lineBox = ModelViewMapper.findLineBox(webForm.getPane().getPageBox(), domPosition2);
        if (lineBox == null) {
            return DomProvider.DomPosition.NONE;
        }
        DomProvider.DomPosition domPosition3 = ModelViewMapper.findPrevPosition(lineBox, domPosition2, webForm.getManager().getInlineEditor());
        if (domPosition3 != DomProvider.DomPosition.NONE && domPosition3.isRenderedPosition()) {
            domPosition3 = domPosition3.getSourcePosition();
        }
        return domPosition3;
    }

    public static DomProvider.DomPosition computeArrowRight(WebForm webForm, DomProvider.DomPosition domPosition) {
        if (domPosition.isRenderedPosition()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalArgumentException("Node is expected to be not rendered, node=" + domPosition.getNode()));
        }
        DomProvider.DomPosition domPosition2 = domPosition.getRenderedPosition();
        LineBox lineBox = ModelViewMapper.findLineBox(webForm.getPane().getPageBox(), domPosition2);
        if (lineBox == null) {
            return DomProvider.DomPosition.NONE;
        }
        DomProvider.DomPosition domPosition3 = ModelViewMapper.findNextPosition(lineBox, domPosition2, webForm.getManager().getInlineEditor());
        if (domPosition3 != DomProvider.DomPosition.NONE && domPosition3.isRenderedPosition()) {
            domPosition3 = domPosition3.getSourcePosition();
        }
        return domPosition3;
    }

    public static DomProvider.DomPosition computeArrowUp(WebForm webForm, DomProvider.DomPosition domPosition) {
        DomProvider.DomPosition domPosition2;
        if (domPosition.isRenderedPosition()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Node is expected to be not rendered, node=" + domPosition.getNode()));
        }
        DomProvider.DomPosition domPosition3 = domPosition.getRenderedPosition();
        LineBox lineBox = ModelViewMapper.findLineBox(webForm.getPane().getPageBox(), domPosition3);
        if (lineBox == null) {
            return DomProvider.DomPosition.NONE;
        }
        if (!webForm.getPane().hasCaret()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Pane doesn't have caret!"));
            return DomProvider.DomPosition.NONE;
        }
        Point point = webForm.getPane().getCaretMagicPosition();
        LineBox lineBox2 = lineBox;
        do {
            if ((lineBox2 = ModelViewMapper.findPrevLineBox(lineBox2)) != null) continue;
            return DomProvider.DomPosition.NONE;
        } while (!ModelViewMapper.isValidPosition(webForm, domPosition2 = lineBox2.computePosition(point.x - lineBox2.getAbsoluteX()), false, webForm.getManager().getInlineEditor()));
        if (domPosition2 != DomProvider.DomPosition.NONE && domPosition2.isRenderedPosition()) {
            domPosition2 = domPosition2.getSourcePosition();
        }
        return domPosition2;
    }

    public static DomProvider.DomPosition computeArrowDown(WebForm webForm, DomProvider.DomPosition domPosition) {
        DomProvider.DomPosition domPosition2;
        if (domPosition.isRenderedPosition()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Node is expected to be not rendered, node=" + domPosition.getNode()));
        }
        DomProvider.DomPosition domPosition3 = domPosition.getRenderedPosition();
        LineBox lineBox = ModelViewMapper.findLineBox(webForm.getPane().getPageBox(), domPosition3);
        if (lineBox == null) {
            return DomProvider.DomPosition.NONE;
        }
        if (!webForm.getPane().hasCaret()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Pane doesn't have caret!"));
            return DomProvider.DomPosition.NONE;
        }
        Point point = webForm.getPane().getCaretMagicPosition();
        LineBox lineBox2 = lineBox;
        do {
            if ((lineBox2 = ModelViewMapper.findNextLineBox(lineBox2)) != null) continue;
            return DomProvider.DomPosition.NONE;
        } while (!ModelViewMapper.isValidPosition(webForm, domPosition2 = lineBox2.computePosition(point.x - lineBox2.getAbsoluteX()), false, webForm.getManager().getInlineEditor()));
        if (domPosition2 != DomProvider.DomPosition.NONE && domPosition2.isRenderedPosition()) {
            domPosition2 = domPosition2.getSourcePosition();
        }
        return domPosition2;
    }

    private static DomProvider.DomPosition findNextPosition(LineBox lineBox, DomProvider.DomPosition domPosition, InlineEditor inlineEditor) {
        Object object;
        CssBox cssBox;
        int n;
        Object object2;
        if (domPosition.isSourcePosition()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalArgumentException("Node is expected to be rendered, node=" + domPosition.getNode()));
        }
        Node node = domPosition.getNode();
        int n2 = domPosition.getOffset();
        if (node.getNodeType() == 1) {
            object2 = node.getChildNodes();
            if (n2 >= object2.getLength() || domPosition.getBias() == DomProvider.DomPosition.Bias.BACKWARD && n2 > 0) {
                node = object2.item(n2 - 1);
                n2 = 1;
            } else {
                node = object2.item(n2);
                n2 = 0;
            }
        }
        object2 = null;
        int n3 = lineBox.getBoxCount();
        for (n = 0; n < n3; ++n) {
            object2 = lineBox.getBox(n);
            if (((CssBox)object2).getBoxType() == BoxType.TEXT) {
                cssBox = (TextBox)object2;
                if (((TextBox)cssBox).getNode() != node || n2 > ((TextBox)cssBox).getDomEndOffset()) continue;
                object = ((TextBox)cssBox).getNext(domPosition);
                if (object == DomProvider.DomPosition.NONE) break;
                return object;
            }
            if (((CssBox)object2).getBoxType() == BoxType.SPACE) {
                cssBox = (SpaceBox)object2;
                if (((SpaceBox)cssBox).getNode() != node || n2 > ((SpaceBox)cssBox).getDomEndOffset()) continue;
                object = ((SpaceBox)cssBox).getNext(domPosition);
                if (object == DomProvider.DomPosition.NONE) break;
                return object;
            }
            if (((CssBox)object2).getBoxType() == BoxType.LINEBREAK) break;
            if (ModelViewMapper.getComponentRootElementParentForCssBox((CssBox)object2) != node) continue;
            if (n2 == 0) {
                return lineBox.getWebForm().createDomPosition(MarkupService.getSourceElementForElement((Element)ModelViewMapper.getComponentRootElementParentForCssBox((CssBox)object2)), true);
            }
            if (n >= n3 - 1) {
                return ModelViewMapper.getFirstPosNextLine(lineBox, inlineEditor);
            }
            return ModelViewMapper.findFirstLineboxPosition(lineBox, n + 1, inlineEditor);
        }
        if (n == n3) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Next position not found, lb=" + lineBox + ", pos=" + domPosition));
            return DomProvider.DomPosition.NONE;
        }
        while (true) {
            DomProvider.DomPosition domPosition2;
            if (n == n3) {
                return ModelViewMapper.getFirstPosNextLine(lineBox, inlineEditor);
            }
            if (n >= n3 - 1 || lineBox.getBox(n + 1).getBoxType() == BoxType.LINEBREAK) {
                return ModelViewMapper.getFirstPosNextLine(lineBox, inlineEditor);
            }
            cssBox = lineBox.getBox(n + 1);
            if (cssBox.getBoxType() == BoxType.TEXT) {
                object = (TextBox)cssBox;
                domPosition2 = ((TextBox)object).getNext(((TextBox)object).getFirstPosition());
                if (ModelViewMapper.isValidPosition(lineBox.getWebForm(), domPosition2, false, inlineEditor)) {
                    return domPosition2;
                }
                ++n;
                continue;
            }
            if (cssBox.getBoxType() != BoxType.SPACE) break;
            object = (SpaceBox)cssBox;
            domPosition2 = ((SpaceBox)object).getNext(((SpaceBox)object).getFirstPosition());
            if (ModelViewMapper.isValidPosition(lineBox.getWebForm(), domPosition2, false, inlineEditor)) {
                return domPosition2;
            }
            ++n;
        }
        if ((n += 2) >= n3) {
            return ModelViewMapper.getFirstPosNextLine(lineBox, inlineEditor);
        }
        return ModelViewMapper.findFirstLineboxPosition(lineBox, n, inlineEditor);
    }

    private static DomProvider.DomPosition getFirstPosNextLine(LineBox lineBox, InlineEditor inlineEditor) {
        LineBox lineBox2 = ModelViewMapper.findNextLineBox(lineBox);
        if (lineBox2 != null) {
            return ModelViewMapper.findFirstLineboxPosition(lineBox2, 0, inlineEditor);
        }
        return DomProvider.DomPosition.NONE;
    }

    private static DomProvider.DomPosition getLastPosPrevLine(LineBox lineBox, InlineEditor inlineEditor) {
        LineBox lineBox2 = ModelViewMapper.findPrevLineBox(lineBox);
        if (lineBox2 != null) {
            return ModelViewMapper.findLastLineboxPosition(lineBox2, inlineEditor);
        }
        return DomProvider.DomPosition.NONE;
    }

    private static DomProvider.DomPosition findPrevPosition(LineBox lineBox, DomProvider.DomPosition domPosition, InlineEditor inlineEditor) {
        Object object;
        CssBox cssBox;
        int n;
        Object object2;
        if (domPosition.isSourcePosition()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalArgumentException("Node is expected to be rendered, node=" + domPosition.getNode()));
        }
        Node node = domPosition.getNode();
        int n2 = domPosition.getOffset();
        if (node.getNodeType() == 1) {
            object2 = node.getChildNodes();
            if (n2 >= object2.getLength() || domPosition.getBias() == DomProvider.DomPosition.Bias.BACKWARD && n2 > 0) {
                node = object2.item(n2 - 1);
                n2 = 1;
            } else {
                node = object2.item(n2);
                n2 = 0;
            }
        }
        object2 = null;
        int n3 = lineBox.getBoxCount();
        for (n = 0; n < n3; ++n) {
            object2 = lineBox.getBox(n);
            if (((CssBox)object2).getBoxType() == BoxType.TEXT) {
                cssBox = (TextBox)object2;
                if (((TextBox)cssBox).getNode() != node || n2 > ((TextBox)cssBox).getDomEndOffset()) continue;
                object = ((TextBox)cssBox).getPrev(domPosition);
                if (object == DomProvider.DomPosition.NONE) break;
                return object;
            }
            if (((CssBox)object2).getBoxType() == BoxType.SPACE) {
                cssBox = (SpaceBox)object2;
                if (((SpaceBox)cssBox).getNode() != node || n2 > ((SpaceBox)cssBox).getDomEndOffset()) continue;
                object = ((SpaceBox)cssBox).getPrev(domPosition);
                if (object == DomProvider.DomPosition.NONE) break;
                return object;
            }
            if (((CssBox)object2).getBoxType() == BoxType.LINEBREAK) break;
            if (ModelViewMapper.getComponentRootElementParentForCssBox((CssBox)object2) != node) continue;
            if (n2 == 1) {
                return lineBox.getWebForm().createDomPosition(MarkupService.getSourceElementForElement((Element)ModelViewMapper.getComponentRootElementParentForCssBox((CssBox)object2)), false);
            }
            if (n == 0) {
                return ModelViewMapper.getLastPosPrevLine(lineBox, inlineEditor);
            }
            return ModelViewMapper.findLastLineboxPosition(lineBox, n - 1, inlineEditor);
        }
        if (n == n3) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Previous position not found, lb=" + lineBox + ", pos=" + domPosition));
            return DomProvider.DomPosition.NONE;
        }
        while (true) {
            DomProvider.DomPosition domPosition2;
            if (n == 0) {
                return ModelViewMapper.getLastPosPrevLine(lineBox, inlineEditor);
            }
            cssBox = lineBox.getBox(n - 1);
            if (cssBox.getBoxType() == BoxType.TEXT) {
                object = (TextBox)cssBox;
                domPosition2 = ((TextBox)object).getPrev(((TextBox)object).getLastPosition());
                if (ModelViewMapper.isValidPosition(lineBox.getWebForm(), domPosition2, false, inlineEditor)) {
                    return domPosition2;
                }
                --n;
                continue;
            }
            if (cssBox.getBoxType() != BoxType.SPACE) break;
            object = (SpaceBox)cssBox;
            domPosition2 = ((SpaceBox)object).getPrev(((SpaceBox)object).getLastPosition());
            if (ModelViewMapper.isValidPosition(lineBox.getWebForm(), domPosition2, false, inlineEditor)) {
                return domPosition2;
            }
            --n;
        }
        if (--n < 0) {
            return ModelViewMapper.getLastPosPrevLine(lineBox, inlineEditor);
        }
        return ModelViewMapper.findLastLineboxPosition(lineBox, n, inlineEditor);
    }

    private static DomProvider.DomPosition findFirstLineboxPosition(LineBox lineBox, int n, InlineEditor inlineEditor) {
        if (lineBox.getBoxCount() <= n) {
            return DomProvider.DomPosition.NONE;
        }
        while (true) {
            DomProvider.DomPosition domPosition;
            Object object;
            CssBox cssBox;
            if ((cssBox = lineBox.getBox(n)).getBoxType() == BoxType.TEXT) {
                object = (TextBox)cssBox;
                domPosition = ((TextBox)object).getFirstPosition();
                if (ModelViewMapper.isValidPosition(lineBox.getWebForm(), domPosition, false, inlineEditor)) {
                    return domPosition;
                }
            } else if (cssBox.getBoxType() == BoxType.SPACE) {
                object = (SpaceBox)cssBox;
                domPosition = ((SpaceBox)object).getFirstPosition();
                if (ModelViewMapper.isValidPosition(lineBox.getWebForm(), domPosition, false, inlineEditor)) {
                    return domPosition;
                }
            } else {
                object = lineBox.getWebForm().createDomPosition(cssBox.getSourceElement(), false);
                if (ModelViewMapper.isValidPosition(lineBox.getWebForm(), (DomProvider.DomPosition)object, false, inlineEditor)) {
                    return object;
                }
            }
            if (++n != lineBox.getBoxCount()) continue;
            do {
                if ((lineBox = ModelViewMapper.findNextLineBox(lineBox)) != null) continue;
                return DomProvider.DomPosition.NONE;
            } while ((n = 0) >= lineBox.getBoxCount());
        }
    }

    private static DomProvider.DomPosition findLastLineboxPosition(LineBox lineBox, int n, InlineEditor inlineEditor) {
        if (lineBox.getBoxCount() <= n) {
            assert (false) : lineBox;
            return DomProvider.DomPosition.NONE;
        }
        while (true) {
            Object object;
            Object object2;
            CssBox cssBox;
            if ((cssBox = lineBox.getBox(n)).getBoxType() == BoxType.TEXT) {
                object2 = (TextBox)cssBox;
                object = ((TextBox)object2).getLastPosition();
                if (ModelViewMapper.isValidPosition(lineBox.getWebForm(), (DomProvider.DomPosition)object, false, inlineEditor)) {
                    return object;
                }
            } else if (cssBox.getBoxType() == BoxType.SPACE) {
                object2 = (SpaceBox)cssBox;
                object = ((SpaceBox)object2).getLastPosition();
                if (ModelViewMapper.isValidPosition(lineBox.getWebForm(), (DomProvider.DomPosition)object, false, inlineEditor)) {
                    return object;
                }
            } else {
                if (n > 0) {
                    DomProvider.DomPosition domPosition;
                    object2 = lineBox.getBox(n - 1);
                    if (((CssBox)object2).getBoxType() == BoxType.TEXT) {
                        object = (TextBox)object2;
                        domPosition = ((TextBox)object).getLastPosition();
                        if (ModelViewMapper.isValidPosition(lineBox.getWebForm(), domPosition, false, inlineEditor)) {
                            return domPosition;
                        }
                    } else if (((CssBox)object2).getBoxType() == BoxType.SPACE) {
                        object = (SpaceBox)object2;
                        domPosition = ((SpaceBox)object).getLastPosition();
                        if (ModelViewMapper.isValidPosition(lineBox.getWebForm(), domPosition, false, inlineEditor)) {
                            return domPosition;
                        }
                    }
                }
                object2 = lineBox.getWebForm().createDomPosition(cssBox.getSourceElement(), false);
                if (ModelViewMapper.isValidPosition(lineBox.getWebForm(), (DomProvider.DomPosition)object2, false, inlineEditor)) {
                    return object2;
                }
            }
            if (--n >= 0) continue;
            do {
                if ((lineBox = ModelViewMapper.findPrevLineBox(lineBox)) != null) continue;
                return DomProvider.DomPosition.NONE;
            } while ((n = lineBox.getBoxCount() - 1) < 0);
        }
    }

    private static DomProvider.DomPosition findLastLineboxPosition(LineBox lineBox, InlineEditor inlineEditor) {
        if (lineBox.getBoxCount() == 0) {
            return DomProvider.DomPosition.NONE;
        }
        int n = lineBox.getBoxCount() - 1;
        while (true) {
            DomProvider.DomPosition domPosition;
            Object object;
            CssBox cssBox;
            if ((cssBox = lineBox.getBox(n)).getBoxType() == BoxType.LINEBREAK) {
                object = lineBox.getWebForm().createDomPosition(cssBox.getSourceElement(), false);
                if (ModelViewMapper.isValidPosition(lineBox.getWebForm(), (DomProvider.DomPosition)object, false, inlineEditor)) {
                    return object;
                }
            }
            if (cssBox.getBoxType() == BoxType.TEXT) {
                object = (TextBox)cssBox;
                domPosition = ((TextBox)object).getLastPosition();
                if (ModelViewMapper.isValidPosition(lineBox.getWebForm(), domPosition, false, inlineEditor)) {
                    return domPosition;
                }
            } else if (cssBox.getBoxType() == BoxType.SPACE) {
                object = (SpaceBox)cssBox;
                domPosition = ((SpaceBox)object).getLastPosition();
                if (ModelViewMapper.isValidPosition(lineBox.getWebForm(), domPosition, false, inlineEditor)) {
                    return domPosition;
                }
            } else {
                object = lineBox.getWebForm().createDomPosition(cssBox.getSourceElement(), true);
                if (ModelViewMapper.isValidPosition(lineBox.getWebForm(), (DomProvider.DomPosition)object, false, inlineEditor)) {
                    return object;
                }
            }
            if (--n >= 0) continue;
            do {
                if ((lineBox = ModelViewMapper.findPrevLineBox(lineBox)) != null) continue;
                return DomProvider.DomPosition.NONE;
            } while ((n = lineBox.getBoxCount() - 1) < 0);
        }
    }

    private static LineBox findNextLineBox(CssBox cssBox) {
        CssBox cssBox2;
        if (cssBox != null && cssBox.getBoxType() != BoxType.LINEBOX && cssBox.getParent() instanceof LineBoxGroup) {
            cssBox2 = cssBox.getParent();
            int n = cssBox2.getBoxCount();
            block0: for (int i = 0; i < n; ++i) {
                CssBox cssBox3 = cssBox2.getBox(i);
                if (cssBox3.getBoxType() != BoxType.LINEBOX) continue;
                int n2 = cssBox3.getBoxCount();
                for (int j = 0; j < n2; ++j) {
                    CssBox cssBox4 = cssBox3.getBox(j);
                    if (cssBox4 != cssBox) continue;
                    for (int k = i + 1; k < n; ++k) {
                        CssBox cssBox5 = cssBox2.getBox(k);
                        if (cssBox5.getBoxType() != BoxType.LINEBOX) continue;
                        return (LineBox)cssBox5;
                    }
                    continue block0;
                }
            }
            cssBox = cssBox2;
        }
        while (cssBox != null) {
            for (cssBox2 = cssBox.getNextNormalBlockBox(); cssBox2 != null; cssBox2 = cssBox2.getNextNormalBlockBox()) {
                LineBox lineBox = ModelViewMapper.findFirstLineBox(cssBox2);
                if (lineBox == null) continue;
                return lineBox;
            }
            cssBox = cssBox.getParent();
        }
        return null;
    }

    private static LineBox findPrevLineBox(CssBox cssBox) {
        CssBox cssBox2;
        if (cssBox != null && cssBox.getBoxType() != BoxType.LINEBOX && cssBox.getParent() instanceof LineBoxGroup) {
            cssBox2 = cssBox.getParent();
            int n = cssBox2.getBoxCount();
            block0: for (int i = 0; i < n; ++i) {
                CssBox cssBox3 = cssBox2.getBox(i);
                if (cssBox3.getBoxType() != BoxType.LINEBOX) continue;
                int n2 = cssBox3.getBoxCount();
                for (int j = 0; j < n2; ++j) {
                    CssBox cssBox4 = cssBox3.getBox(j);
                    if (cssBox4 != cssBox) continue;
                    for (int k = i - 1; k >= 0; --k) {
                        CssBox cssBox5 = cssBox2.getBox(k);
                        if (cssBox5.getBoxType() != BoxType.LINEBOX) continue;
                        return (LineBox)cssBox5;
                    }
                    continue block0;
                }
            }
            cssBox = cssBox2;
        }
        while (cssBox != null) {
            for (cssBox2 = cssBox.getPrevNormalBlockBox(); cssBox2 != null; cssBox2 = cssBox2.getPrevNormalBlockBox()) {
                LineBox lineBox = ModelViewMapper.findLastLineBox(cssBox2);
                if (lineBox == null) continue;
                return lineBox;
            }
            cssBox = cssBox.getParent();
        }
        return null;
    }

    private static LineBox findFirstLineBox(CssBox cssBox) {
        if (cssBox.getBoxType() == BoxType.LINEBOX && cssBox instanceof LineBox) {
            return (LineBox)cssBox;
        }
        int n = cssBox.getBoxCount();
        for (int i = 0; i < n; ++i) {
            LineBox lineBox;
            CssBox cssBox2 = cssBox.getBox(i);
            if (cssBox2 instanceof ExternalDocumentBox || (lineBox = ModelViewMapper.findFirstLineBox(cssBox2)) == null) continue;
            return lineBox;
        }
        return null;
    }

    private static LineBox findLastLineBox(CssBox cssBox) {
        if (cssBox.getBoxType() == BoxType.LINEBOX && cssBox instanceof LineBox) {
            return (LineBox)cssBox;
        }
        for (int i = cssBox.getBoxCount() - 1; i >= 0; --i) {
            LineBox lineBox;
            CssBox cssBox2 = cssBox.getBox(i);
            if (cssBox2 instanceof ExternalDocumentBox || (lineBox = ModelViewMapper.findLastLineBox(cssBox2)) == null) continue;
            return lineBox;
        }
        return null;
    }

    private static LineBox findLineBox(PageBox pageBox, DomProvider.DomPosition domPosition) {
        CssBox cssBox = ModelViewMapper.findBox(pageBox, domPosition);
        if (cssBox == null) {
            return null;
        }
        return ModelViewMapper.findLineBox(cssBox, domPosition.getBias() == DomProvider.DomPosition.Bias.FORWARD);
    }

    private static LineBox findLineBox(CssBox cssBox, boolean bl) {
        int n;
        CssBox cssBox2;
        CssBox cssBox3;
        for (cssBox3 = cssBox; cssBox3 != null && !(cssBox3 instanceof LineBoxGroup); cssBox3 = cssBox3.getParent()) {
        }
        if (cssBox3 == null) {
            return null;
        }
        if (!(cssBox3 instanceof LineBoxGroup)) {
            CssBox cssBox4 = cssBox3.getFirstNormalBox();
            if (cssBox4 instanceof LineBoxGroup) {
                return (LineBox)cssBox4.getBox(0);
            }
            return null;
        }
        LineBoxGroup lineBoxGroup = (LineBoxGroup)cssBox3;
        int n2 = lineBoxGroup.getBoxCount();
        for (int i = 0; i < n2; ++i) {
            CssBox cssBox5 = lineBoxGroup.getBox(i);
            if (cssBox5 instanceof LineBox) {
                cssBox2 = (LineBox)cssBox5;
                n = ((ContainerBox)cssBox2).getBoxCount();
                for (int j = 0; j < n; ++j) {
                    if (((ContainerBox)cssBox2).getBox(j) != cssBox) continue;
                    return cssBox2;
                }
                continue;
            }
            assert (cssBox5.getBoxType() == BoxType.FLOAT);
        }
        Element element = ModelViewMapper.getComponentRootElementParentForCssBox(cssBox);
        assert (element != null);
        if (bl) {
            int n3 = lineBoxGroup.getBoxCount();
            for (n2 = 0; n2 < n3; ++n2) {
                cssBox2 = lineBoxGroup.getBox(n2);
                if (cssBox2 instanceof LineBox) {
                    CssBox cssBox6 = cssBox2;
                    int n4 = ((ContainerBox)cssBox6).getBoxCount();
                    for (n = 0; n < n4; ++n) {
                        CssBox cssBox7 = ((ContainerBox)cssBox6).getBox(n);
                        for (Node node = ModelViewMapper.getComponentRootElementParentForCssBox(cssBox7); node != null; node = node.getParentNode()) {
                            if (node != element) continue;
                            return cssBox6;
                        }
                    }
                    continue;
                }
                assert (cssBox2.getBoxType() == BoxType.FLOAT);
            }
        } else {
            n2 = lineBoxGroup.getBoxCount();
            for (int i = n2 - 1; i >= 0; --i) {
                cssBox2 = lineBoxGroup.getBox(i);
                if (cssBox2 instanceof LineBox) {
                    CssBox cssBox8 = cssBox2;
                    n = ((ContainerBox)cssBox8).getBoxCount();
                    for (int j = n - 1; j >= 0; --j) {
                        CssBox cssBox9 = ((ContainerBox)cssBox8).getBox(j);
                        for (Node node = ModelViewMapper.getComponentRootElementParentForCssBox(cssBox9); node != null; node = node.getParentNode()) {
                            if (node != element) continue;
                            return cssBox8;
                        }
                    }
                    continue;
                }
                assert (cssBox2.getBoxType() == BoxType.FLOAT);
            }
        }
        return null;
    }

    public static CssBox findBox(CssBox cssBox, Node node, int n) {
        if (cssBox.getBoxType() == BoxType.TEXT) {
            TextBox textBox = (TextBox)cssBox;
            if (textBox.getNode() == node && n <= textBox.getDomEndOffset()) {
                return textBox;
            }
            return null;
        }
        if (cssBox.getBoxType() == BoxType.SPACE) {
            SpaceBox spaceBox = (SpaceBox)cssBox;
            if (spaceBox.getNode() == node && n <= spaceBox.getDomEndOffset()) {
                return spaceBox;
            }
            return null;
        }
        if (cssBox.getElement() == node || cssBox.getSourceElement() == node) {
            return cssBox;
        }
        int n2 = cssBox.getBoxCount();
        for (int i = 0; i < n2; ++i) {
            CssBox cssBox2;
            CssBox cssBox3 = cssBox.getBox(i);
            CssBox cssBox4 = ModelViewMapper.findBox(cssBox3, node, n);
            if (cssBox4 == null) continue;
            if (cssBox4.getBoxType() == BoxType.SPACE && i < n2 - 1 && (cssBox2 = ModelViewMapper.findBox(cssBox.getBox(i + 1), node, n)) != null) {
                if (cssBox2.getBoxType() == BoxType.TEXT && ((TextBox)cssBox2).getDomStartOffset() >= n) {
                    return cssBox2;
                }
                if (cssBox2.getBoxType() != BoxType.SPACE) {
                    return cssBox2;
                }
            }
            return cssBox4;
        }
        return null;
    }

    private static CssBox findBox(PageBox pageBox, DomProvider.DomPosition domPosition) {
        if (domPosition == DomProvider.DomPosition.NONE) {
            return null;
        }
        Node node = domPosition.getNode();
        int n = domPosition.getOffset();
        if (node.getNodeType() == 3 || node.getNodeType() == 4) {
            Node node2 = node.getParentNode();
            CssBox cssBox = null;
            if (node2 != null && node2.getNodeType() == 1) {
                Element element = (Element)node2;
                CssBox cssBox2 = pageBox.getWebForm().findCssBoxForElement(element);
                if (cssBox2 != null) {
                    cssBox = ModelViewMapper.findBox(cssBox2, node, n);
                    if (cssBox == null && node.getNodeValue().length() == 0 && node.getNextSibling() != null) {
                        cssBox = ModelViewMapper.findBox(cssBox2, node.getNextSibling(), 0);
                    }
                    if (cssBox == null && DesignerUtils.onlyWhitespace(node.getNodeValue())) {
                        if (domPosition.getBias() == DomProvider.DomPosition.Bias.FORWARD) {
                            if (node.getNextSibling() != null) {
                                cssBox = ModelViewMapper.findBox(cssBox2, node.getNextSibling(), 0);
                            }
                        } else if (node.getPreviousSibling() != null) {
                            cssBox = ModelViewMapper.findBox(cssBox2, node.getPreviousSibling(), 0);
                        }
                    }
                }
            }
            if (cssBox == null) {
                cssBox = ModelViewMapper.findBox((CssBox)pageBox, node, n);
            }
            return cssBox;
        }
        if (node.getNodeType() == 1) {
            Object object;
            Element element = (Element)node;
            NodeList nodeList = element.getChildNodes();
            int n2 = nodeList.getLength();
            if (n2 != 0 && n < n2) {
                if (domPosition.getBias() == DomProvider.DomPosition.Bias.BACKWARD && n > 0 && n - 1 < n2) {
                    object = nodeList.item(n - 1);
                    if (object.getNodeType() == 1) {
                        element = (Element)object;
                    } else if (object.getNodeType() == 3 || object.getNodeType() == 4) {
                        CssBox cssBox = pageBox.getWebForm().findCssBoxForElement(element);
                        CssBox cssBox3 = null;
                        if (cssBox != null && (cssBox3 = ModelViewMapper.findBox(cssBox, (Node)object, n)) == null && object.getNodeValue().length() == 0 && object.getNextSibling() != null) {
                            cssBox3 = ModelViewMapper.findBox(cssBox, object.getNextSibling(), 0);
                        }
                        if (cssBox3 == null) {
                            cssBox3 = ModelViewMapper.findBox((CssBox)pageBox, (Node)object, n);
                        }
                        return cssBox3;
                    }
                } else if (n < n2 && (object = nodeList.item(n)).getNodeType() == 1) {
                    element = (Element)object;
                }
            }
            object = pageBox.getWebForm().findCssBoxForElement(element);
            return object;
        }
        ErrorManager.getDefault().log("Unexpected node type in findBox: " + node);
        return null;
    }

    public static Rectangle modelToView(PageBox pageBox, DomProvider.DomPosition domPosition) {
        DomProvider.DomPosition domPosition2;
        if (pageBox == null) {
            return null;
        }
        if (domPosition == DomProvider.DomPosition.NONE) {
            return null;
        }
        if (domPosition.isRenderedPosition()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalArgumentException("Node is expected to be not rendered, node=" + domPosition.getNode()));
        }
        if ((domPosition2 = domPosition.getRenderedPosition()) == DomProvider.DomPosition.NONE) {
            return null;
        }
        Node node = domPosition2.getNode();
        int n = domPosition2.getOffset();
        if (node.getNodeType() == 1) {
            if (node.getChildNodes().getLength() == 0) {
                CssBox cssBox;
                Element element = (Element)node;
                for (cssBox = pageBox.getWebForm().findCssBoxForElement(element); cssBox != null && cssBox.getHeight() == 0x7FFFFFFD && cssBox.getBoxCount() > 0; cssBox = cssBox.getBox(0)) {
                }
                if (cssBox != null) {
                    int n2 = cssBox.getHeight();
                    n2 = CssUtilities.getDesignerFontMetricsForElement(element, null, pageBox.getWebForm().getDefaultFontSize()).getHeight();
                    Rectangle rectangle = new Rectangle(cssBox.getAbsoluteX(), cssBox.getAbsoluteY(), cssBox.getWidth(), n2);
                    if (cssBox.isInlineBox()) {
                        rectangle.y = cssBox.getAbsoluteY() + cssBox.getHeight() - n2;
                    }
                    return rectangle;
                }
                return null;
            }
            if (domPosition2.getBias() == DomProvider.DomPosition.Bias.BACKWARD && n > 0 && n - 1 < node.getChildNodes().getLength()) {
                node = node.getChildNodes().item(n - 1);
                n = 1;
            } else if (n < node.getChildNodes().getLength()) {
                node = node.getChildNodes().item(n);
                n = 0;
            } else if (n > 0) {
                n = (node = node.getChildNodes().item(n - 1)).getNodeType() == 3 ? node.getNodeValue().length() : 1;
            }
        } else if (node.getNodeType() == 11) {
            if (node.getChildNodes().getLength() == 0) {
                return null;
            }
            if (domPosition2.getBias() == DomProvider.DomPosition.Bias.BACKWARD && n > 0 && n - 1 < node.getChildNodes().getLength()) {
                node = node.getChildNodes().item(n - 1);
                n = 1;
            } else if (n < node.getChildNodes().getLength()) {
                node = node.getChildNodes().item(n);
                n = 0;
            } else if (n > 0) {
                if ((node = node.getChildNodes().item(n - 1)).getNodeType() == 3) {
                    n = node.getNodeValue().length();
                } else {
                    if (node.getNodeType() == 1) {
                        return ModelViewMapper.modelToView(pageBox, pageBox.getWebForm().createDomPosition(node, node.getChildNodes().getLength(), DomProvider.DomPosition.Bias.FORWARD));
                    }
                    n = 1;
                }
            }
        }
        if (node.getNodeType() == 3 || node.getNodeType() == 4) {
            Object object;
            Node node2 = node.getParentNode();
            CssBox cssBox = null;
            CssBox cssBox2 = null;
            if (node2 != null && node2.getNodeType() == 1) {
                object = (Element)node2;
                cssBox = pageBox.getWebForm().findCssBoxForElement((Element)object);
                if (cssBox != null) {
                    cssBox2 = ModelViewMapper.findBox(cssBox, node, n);
                }
            }
            if (cssBox2 == null) {
                cssBox2 = ModelViewMapper.findBox((CssBox)pageBox, node, n);
            }
            if (cssBox2 == null && (node.getNodeType() == 3 || node.getNodeType() == 4) && node.getNextSibling() != null && node.getNextSibling().getNodeType() == 1 && ((Element)node.getNextSibling()).getTagName().equals(HtmlTag.BR.name)) {
                cssBox2 = ModelViewMapper.findBox((CssBox)pageBox, node.getNextSibling(), 0);
            }
            if (cssBox2 != null) {
                int n3 = cssBox2.getAbsoluteX();
                if (cssBox2.getBoxType() == BoxType.TEXT) {
                    return ((TextBox)cssBox2).getBoundingBox(pageBox.getWebForm().createDomPosition(node, n, DomProvider.DomPosition.Bias.FORWARD));
                }
                if (cssBox2.getBoxType() == BoxType.SPACE) {
                    return ((SpaceBox)cssBox2).getBoundingBox(pageBox.getWebForm().createDomPosition(node, n, DomProvider.DomPosition.Bias.FORWARD));
                }
                return new Rectangle(n3, cssBox2.getAbsoluteY(), cssBox2.getWidth(), cssBox2.getHeight());
            }
            if (n > 0 && node.getNodeValue().charAt(n - 1) == ' ' && (cssBox2 = ModelViewMapper.findBox((CssBox)pageBox, node, n - 1)) != null) {
                object = null;
                if (cssBox2.getBoxType() == BoxType.TEXT) {
                    object = ((TextBox)cssBox2).getBoundingBox(pageBox.getWebForm().createDomPosition(node, n, DomProvider.DomPosition.Bias.FORWARD));
                    ((Rectangle)object).width += ((TextBox)cssBox2).getMetrics().charWidth(' ');
                    return object;
                }
                if (cssBox2.getBoxType() == BoxType.SPACE) {
                    object = ((SpaceBox)cssBox2).getBoundingBox(pageBox.getWebForm().createDomPosition(node, n, DomProvider.DomPosition.Bias.FORWARD));
                    ((Rectangle)object).width += ((SpaceBox)cssBox2).getMetrics().charWidth(' ');
                    return object;
                }
                int n4 = 5;
                return new Rectangle(cssBox2.getAbsoluteX() + n4, cssBox2.getAbsoluteY(), cssBox2.getWidth(), cssBox2.getHeight());
            }
            if (cssBox != null) {
                Node node3;
                int n5 = cssBox.getHeight();
                n5 = CssUtilities.getDesignerFontMetricsForElement(cssBox.getElement(), null, pageBox.getWebForm().getDefaultFontSize()).getHeight();
                for (node3 = node.getPreviousSibling(); node3 != null && (cssBox2 = ModelViewMapper.findBox(cssBox, node3, 0)) == null; node3 = node3.getPreviousSibling()) {
                }
                if (cssBox2 != null) {
                    Rectangle rectangle = new Rectangle(cssBox2.getAbsoluteX() + cssBox2.getWidth(), cssBox2.getAbsoluteY(), cssBox2.getWidth(), n5);
                    for (node3 = node3.getNextSibling(); node3 != node; node3 = node3.getNextSibling()) {
                        if (!(node3 instanceof Element) || !((Element)node3).getTagName().equals("br")) continue;
                        rectangle.y += n5;
                        rectangle.x = cssBox2.getAbsoluteX();
                    }
                    return rectangle;
                }
                Rectangle rectangle = new Rectangle(cssBox.getAbsoluteX(), cssBox.getAbsoluteY(), cssBox.getWidth(), n5);
                return rectangle;
            }
            return null;
        }
        if (node.getNodeType() == 1) {
            Rectangle rectangle;
            LineBox lineBox;
            Object object;
            Element element = (Element)node;
            for (object = pageBox.getWebForm().findCssBoxForElement(element); object != null && ((CssBox)object).getHeight() == 0x7FFFFFFD && ((CssBox)object).getBoxCount() > 0; object = ((CssBox)object).getBox(0)) {
            }
            if (object == null) {
                object = ModelViewMapper.findBox((CssBox)pageBox, node, n);
            }
            if (object != null && CssBox.getElementForComponentRootCssBox((CssBox)object) == null && (lineBox = ModelViewMapper.findLineBox((CssBox)object, n == 0)) != null) {
                rectangle = null;
                Element element2 = ModelViewMapper.getComponentRootElementParentForCssBox((CssBox)object);
                boolean bl = n == 0;
                CssBox cssBox = null;
                int n6 = lineBox.getBoxCount();
                for (int i = 0; i < n6; ++i) {
                    CssBox cssBox3 = lineBox.getBox(i);
                    if (ModelViewMapper.getComponentRootElementParentForCssBox(cssBox3) != element2) continue;
                    cssBox = cssBox3;
                    if (bl) break;
                }
                if ((rectangle = cssBox) != null) {
                    object = rectangle;
                }
            }
            if (object != null) {
                int n7 = ((CssBox)object).getHeight();
                n7 = CssUtilities.getDesignerFontMetricsForElement(element, null, pageBox.getWebForm().getDefaultFontSize()).getHeight();
                rectangle = new Rectangle(((CssBox)object).getAbsoluteX(), ((CssBox)object).getAbsoluteY(), ((CssBox)object).getWidth(), n7);
                if (n == 1) {
                    rectangle.x += ((CssBox)object).getWidth();
                }
                if (((CssBox)object).isInlineBox()) {
                    rectangle.y = ((CssBox)object).getAbsoluteY() + ((CssBox)object).getHeight() - n7;
                }
                return rectangle;
            }
            return null;
        }
        ErrorManager.getDefault().log("Unexpected node type in modelToView: " + node);
        return null;
    }

    private static Element getComponentRootElementParentForCssBox(CssBox cssBox) {
        do {
            Element element;
            if ((element = CssBox.getElementForComponentRootCssBox(cssBox)) == null) continue;
            return element;
        } while ((cssBox = cssBox.getParent()) != null);
        return null;
    }

    public static DomProvider.DomPosition viewToModel(WebForm webForm, int n, int n2) {
        try {
            DomProvider.DomPosition domPosition = ModelViewMapper.findClosestPosition(webForm, n, n2);
            if (domPosition != DomProvider.DomPosition.NONE && domPosition.isRenderedPosition()) {
                return domPosition.getSourcePosition();
            }
            return domPosition;
        }
        catch (Throwable throwable) {
            ErrorManager.getDefault().notify(throwable);
            return DomProvider.DomPosition.NONE;
        }
    }

    private static DomProvider.DomPosition findClosestPosition(WebForm webForm, int n, int n2) {
        LineBox lineBox;
        DomProvider.DomPosition domPosition;
        Object object;
        CssBox cssBox = webForm.getPane().getPageBox().findCssBox(n, n2);
        if (cssBox == null) {
            return DomProvider.DomPosition.NONE;
        }
        assert (!cssBox.isPlaceHolder());
        if (cssBox instanceof LineBoxGroup && (object = ModelViewMapper.findLineBoxClosestTo(cssBox, n2, webForm.getManager().getInlineEditor())) != DomProvider.DomPosition.NONE) {
            return object;
        }
        object = ModelViewMapper.findLineBox(cssBox, true);
        if (object != null && ModelViewMapper.isValidPosition(webForm, domPosition = ((LineBox)object).computePosition(n - ((CssBox)object).getAbsoluteX()), false, webForm.getManager().getInlineEditor())) {
            return domPosition;
        }
        domPosition = ModelViewMapper.findLineBoxClosestTo(cssBox, n2, webForm.getManager().getInlineEditor());
        if (domPosition != DomProvider.DomPosition.NONE) {
            return domPosition;
        }
        LineBox lineBox2 = ModelViewMapper.findPrevLineBox(cssBox);
        if (lineBox2 == null) {
            lineBox2 = ModelViewMapper.findLastLineBox(cssBox);
        }
        Rectangle rectangle = null;
        DomProvider.DomPosition domPosition2 = null;
        if (lineBox2 != null && (domPosition2 = ModelViewMapper.findLastLineboxPosition(lineBox2, webForm.getManager().getInlineEditor())) != DomProvider.DomPosition.NONE) {
            if (domPosition2.isRenderedPosition()) {
                domPosition2 = domPosition2.getSourcePosition();
            }
            rectangle = ModelViewMapper.modelToView(webForm.getPane().getPageBox(), domPosition2);
        }
        if ((lineBox = ModelViewMapper.findNextLineBox(cssBox)) == null) {
            lineBox = ModelViewMapper.findFirstLineBox(cssBox);
        }
        Rectangle rectangle2 = null;
        DomProvider.DomPosition domPosition3 = null;
        if (lineBox != null && (domPosition3 = ModelViewMapper.findFirstLineboxPosition(lineBox, 0, webForm.getManager().getInlineEditor())) != DomProvider.DomPosition.NONE) {
            if (domPosition3.isRenderedPosition()) {
                domPosition3 = domPosition3.getSourcePosition();
            }
            rectangle2 = ModelViewMapper.modelToView(webForm.getPane().getPageBox(), domPosition3);
        }
        if (rectangle2 != null && rectangle != null) {
            if (lineBox2 == lineBox) {
                return domPosition2;
            }
            if (Math.abs(n2 - rectangle2.y) < Math.abs(n2 - rectangle.y)) {
                return domPosition3;
            }
            return domPosition2;
        }
        if (rectangle2 != null) {
            return domPosition3;
        }
        if (rectangle != null) {
            return domPosition2;
        }
        return DomProvider.DomPosition.NONE;
    }

    private static DomProvider.DomPosition findLineBoxClosestTo(CssBox cssBox, int n, InlineEditor inlineEditor) {
        int n2;
        if (cssBox.getBoxType() == BoxType.LINEBOX && cssBox instanceof LineBox) {
            LineBox lineBox = (LineBox)cssBox;
            n2 = lineBox.getAbsoluteY();
            if (n == 0x7FFFFFFE || n >= n2 && n <= n2 + lineBox.getHeight()) {
                return ModelViewMapper.findLastLineboxPosition(lineBox, inlineEditor);
            }
        }
        if (!(cssBox instanceof ExternalDocumentBox)) {
            n2 = cssBox.getBoxCount();
            for (int i = 0; i < n2; ++i) {
                DomProvider.DomPosition domPosition = ModelViewMapper.findLineBoxClosestTo(cssBox.getBox(i), n, inlineEditor);
                if (domPosition == null) continue;
                return domPosition;
            }
        }
        return DomProvider.DomPosition.NONE;
    }

    public static DomProvider.DomPosition getLineBegin(WebForm webForm, DomProvider.DomPosition domPosition) {
        if (domPosition.isRenderedPosition()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalArgumentException("Node is expected to be not rendered, node=" + domPosition.getNode()));
        }
        DomProvider.DomPosition domPosition2 = domPosition.getRenderedPosition();
        LineBox lineBox = ModelViewMapper.findLineBox(webForm.getPane().getPageBox(), domPosition2);
        if (lineBox == null) {
            assert (false) : domPosition2;
            return DomProvider.DomPosition.NONE;
        }
        DomProvider.DomPosition domPosition3 = ModelViewMapper.findFirstLineboxPosition(lineBox, 0, webForm.getManager().getInlineEditor());
        return domPosition3.getSourcePosition();
    }

    public static DomProvider.DomPosition getLineEnd(WebForm webForm, DomProvider.DomPosition domPosition) {
        if (domPosition.isRenderedPosition()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalArgumentException("Node is expected to be not rendered, node=" + domPosition.getNode()));
        }
        DomProvider.DomPosition domPosition2 = domPosition.getRenderedPosition();
        LineBox lineBox = ModelViewMapper.findLineBox(webForm.getPane().getPageBox(), domPosition2);
        if (lineBox == null) {
            return DomProvider.DomPosition.NONE;
        }
        DomProvider.DomPosition domPosition3 = ModelViewMapper.findLastLineboxPosition(lineBox, webForm.getManager().getInlineEditor());
        return domPosition3.getSourcePosition();
    }

    public static DomProvider.DomPosition getWordStart(PageBox pageBox, DomProvider.DomPosition domPosition) {
        DomProvider.DomPosition domPosition2;
        CssBox cssBox;
        if (domPosition.isRenderedPosition()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalArgumentException("Node is expected to be not rendered, node=" + domPosition.getNode()));
        }
        if ((cssBox = ModelViewMapper.findBox(pageBox, domPosition2 = domPosition.getRenderedPosition())) == null) {
            return DomProvider.DomPosition.NONE;
        }
        if (cssBox.getBoxType() == BoxType.TEXT) {
            TextBox textBox = (TextBox)cssBox;
            DomProvider.DomPosition domPosition3 = pageBox.getWebForm().createDomPosition(textBox.getNode(), textBox.getDomStartOffset(), DomProvider.DomPosition.Bias.FORWARD);
            return domPosition3.getSourcePosition();
        }
        if (cssBox.getBoxType() == BoxType.SPACE) {
            SpaceBox spaceBox = (SpaceBox)cssBox;
            DomProvider.DomPosition domPosition4 = pageBox.getWebForm().createDomPosition(spaceBox.getNode(), spaceBox.getDomStartOffset(), DomProvider.DomPosition.Bias.FORWARD);
            return domPosition4.getSourcePosition();
        }
        return DomProvider.DomPosition.NONE;
    }

    public static DomProvider.DomPosition getWordEnd(PageBox pageBox, DomProvider.DomPosition domPosition) {
        DomProvider.DomPosition domPosition2;
        CssBox cssBox;
        if (domPosition.isRenderedPosition()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalArgumentException("Node is expected to be not rendered, node=" + domPosition.getNode()));
        }
        if ((cssBox = ModelViewMapper.findBox(pageBox, domPosition2 = domPosition.getRenderedPosition())) == null) {
            return DomProvider.DomPosition.NONE;
        }
        if (cssBox.getBoxType() == BoxType.TEXT) {
            TextBox textBox = (TextBox)cssBox;
            DomProvider.DomPosition domPosition3 = pageBox.getWebForm().createDomPosition(textBox.getNode(), textBox.getDomEndOffset(), DomProvider.DomPosition.Bias.BACKWARD);
            return domPosition3.getSourcePosition();
        }
        if (cssBox.getBoxType() == BoxType.SPACE) {
            SpaceBox spaceBox = (SpaceBox)cssBox;
            DomProvider.DomPosition domPosition4 = pageBox.getWebForm().createDomPosition(spaceBox.getNode(), spaceBox.getDomEndOffset(), DomProvider.DomPosition.Bias.BACKWARD);
            return domPosition4.getSourcePosition();
        }
        return DomProvider.DomPosition.NONE;
    }

    public static DomProvider.DomPosition getFirstDocumentPosition(WebForm webForm, boolean bl) {
        DomProvider.DomPosition domPosition;
        LineBox lineBox;
        if (webForm.getPane().getPageBox() == null) {
            return DomProvider.DomPosition.NONE;
        }
        if (webForm.getPane().getPageBox().getElement().getOwnerDocument() != webForm.getHtmlDom()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Owner document is expected to be html dom=" + webForm.getHtmlDom() + ", but it is dom=" + webForm.getPane().getPageBox().getElement().getOwnerDocument()));
        }
        if (webForm.getPane().getPageBox() != null && (lineBox = ModelViewMapper.findFirstLineBox(webForm.getPane().getPageBox())) != null && (domPosition = ModelViewMapper.findFirstLineboxPosition(lineBox, 0, webForm.getManager().getInlineEditor())) != DomProvider.DomPosition.NONE) {
            if (domPosition.isRenderedPosition()) {
                return domPosition.getSourcePosition();
            }
            return domPosition;
        }
        return DomProvider.DomPosition.NONE;
    }

    public static DomProvider.DomPosition getLastDocumentPosition(WebForm webForm, boolean bl) {
        DomProvider.DomPosition domPosition;
        LineBox lineBox;
        if (webForm.getPane().getPageBox() == null) {
            return DomProvider.DomPosition.NONE;
        }
        if (webForm.getPane().getPageBox().getElement().getOwnerDocument() != webForm.getHtmlDom()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Owner document is expected to be html dom=" + webForm.getHtmlDom() + ", but it is dom=" + webForm.getPane().getPageBox().getElement().getOwnerDocument()));
        }
        if (webForm.getPane().getPageBox() != null && (lineBox = ModelViewMapper.findLastLineBox(webForm.getPane().getPageBox())) != null && (domPosition = ModelViewMapper.findLastLineboxPosition(lineBox, lineBox.getBoxCount() - 1, webForm.getManager().getInlineEditor())) != DomProvider.DomPosition.NONE) {
            if (domPosition.isRenderedPosition()) {
                return domPosition.getSourcePosition();
            }
            return domPosition;
        }
        return DomProvider.DomPosition.NONE;
    }

    public static boolean isValidPosition(WebForm webForm, DomProvider.DomPosition domPosition, boolean bl, InlineEditor inlineEditor) {
        return ModelViewMapper.findValidPosition(webForm, domPosition, bl, inlineEditor) != DomProvider.DomPosition.NONE;
    }

    public static DomProvider.DomPosition findValidPosition(WebForm webForm, DomProvider.DomPosition domPosition, boolean bl, InlineEditor inlineEditor) {
        Object object;
        Node node;
        if (domPosition == null) {
            return null;
        }
        if (domPosition == DomProvider.DomPosition.NONE) {
            return domPosition;
        }
        Node node2 = domPosition.getNode();
        if (!bl && inlineEditor != null) {
            if (inlineEditor.checkPosition(domPosition)) {
                return domPosition;
            }
            return DomProvider.DomPosition.NONE;
        }
        if (!bl && webForm.isRenderedNode(node = domPosition.getTargetElement())) {
            object = CssProvider.getEngineService().getComputedValueForElement((Element)node, 48);
            if (CssProvider.getValueService().isAbsoluteValue(object) || CssProvider.getValueService().isRelativeValue(object) || CssProvider.getValueService().isFixedValue(object)) {
                return DomProvider.DomPosition.NONE;
            }
        }
        while (node2 != null) {
            if (webForm.isRenderedNode(node2) && MarkupService.getSourceNodeForNode((Node)node2) == null) {
                if (bl) {
                    node = node2;
                    while (node != null) {
                        if (node.getNodeType() == 1 && MarkupService.getSourceElementForElement((Element)(object = (Element)node)) != null) {
                            Element element = webForm.getDomProviderService().getSourceElementWhichRendersChildren((Element)object);
                            if (element != null) {
                                object = element;
                            }
                            return webForm.createDomPosition((Node)object, domPosition.getOffset() > 0);
                        }
                        if ((node = node.getParentNode()) != null) continue;
                        return DomProvider.DomPosition.NONE;
                    }
                } else {
                    return DomProvider.DomPosition.NONE;
                }
            }
            if (node2 instanceof Element) {
                node = (Element)node2;
                object = webForm.getDomProviderService().getSourceElementWhichRendersChildren((Element)node);
                if (object != null) {
                    if (object == MarkupService.getSourceElementForElement((Element)node)) break;
                    if (bl) {
                        Object object2 = object;
                        return webForm.createDomPosition((Node)object2, domPosition.getOffset() > 0);
                    }
                    return DomProvider.DomPosition.NONE;
                }
            }
            node2 = node2.getParentNode();
        }
        if (domPosition != DomProvider.DomPosition.NONE && inlineEditor != null && inlineEditor.checkPosition(domPosition) || domPosition.isSourcePosition()) {
            return domPosition;
        }
        if (bl) {
            for (node2 = domPosition.getNode(); node2 != null; node2 = node2.getParentNode()) {
                if (!(node2 instanceof Element)) continue;
                node = (Element)node2;
                object = webForm.getDomProviderService().getComponentRootElementForElement((Element)node);
                if (object == null) continue;
                Element element = MarkupService.getSourceElementForElement((Element)object);
                return webForm.createDomPosition(element, domPosition.getOffset() > 0);
            }
            return DomProvider.DomPosition.NONE;
        }
        return domPosition;
    }

    public static CssBox findBox(PageBox pageBox, Element element) {
        CssBox cssBox = pageBox.getWebForm().findCssBoxForElement(element);
        if (cssBox != null) {
            return cssBox;
        }
        DomProvider.DomPosition domPosition = pageBox.getWebForm().createDomPosition(element, false);
        if (domPosition.isSourcePosition()) {
            domPosition = domPosition.getRenderedPosition();
        }
        if (domPosition == DomProvider.DomPosition.NONE) {
            return null;
        }
        cssBox = ModelViewMapper.findBox(pageBox, domPosition);
        if (cssBox != null) {
            return cssBox;
        }
        return null;
    }

    public static Element findElement(CssBox cssBox) {
        WebForm webForm;
        WebForm webForm2 = webForm = cssBox == null ? null : cssBox.getWebForm();
        if (webForm == null) {
            return null;
        }
        while (cssBox != null) {
            Element element = cssBox.getElement();
            if (element != null && !webForm.getDomProviderService().isSpecialComponent(element)) {
                return element;
            }
            cssBox = cssBox.getParent();
        }
        return null;
    }

    public static Element findComponentRootElement(CssBox cssBox) {
        WebForm webForm;
        WebForm webForm2 = webForm = cssBox == null ? null : cssBox.getWebForm();
        if (webForm == null) {
            return null;
        }
        while (cssBox != null) {
            Element element;
            Element element2 = cssBox.getElement();
            ContainerBox containerBox = cssBox.getParent();
            Element element3 = element = containerBox == null ? null : containerBox.getElement();
            if (webForm.getDomProviderService().isPrincipalElement(element2, element) && !webForm.getDomProviderService().isSpecialComponent(element2)) {
                return element2;
            }
            cssBox = cssBox.getParent();
        }
        return null;
    }

    public static CssBox findBox(PageBox pageBox, int n, int n2) {
        return pageBox.findCssBox(n, n2);
    }

    public static Element findElement(PageBox pageBox, int n, int n2) {
        CssBox cssBox = ModelViewMapper.findBox(pageBox, n, n2);
        return ModelViewMapper.findElement(cssBox);
    }

    public static Rectangle findShape(PageBox pageBox, Element element) {
        if (element == null) {
            return null;
        }
        CssBox cssBox = ModelViewMapper.findBoxForComponentRootElement(pageBox, element);
        if (cssBox == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("Null box for element=" + element));
            return null;
        }
        return new Rectangle(cssBox.getAbsoluteX(), cssBox.getAbsoluteY(), cssBox.getWidth(), cssBox.getHeight());
    }

    public static CssBox findBoxForComponentRootElement(PageBox pageBox, Element element) {
        return pageBox.findCssBoxForComponentRootElement(element);
    }

    public static List<Rectangle> getComponentRectangles(PageBox pageBox, Element element) {
        Rectangle rectangle;
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        pageBox.computeRectangles(element, arrayList);
        if (arrayList.size() == 0 && (rectangle = ModelViewMapper.getComponentBounds(pageBox, element)) != null) {
            arrayList.add(rectangle);
        }
        return arrayList;
    }

    public static Rectangle getComponentBounds(PageBox pageBox, Element element) {
        if (element == null) {
            return null;
        }
        Rectangle rectangle = pageBox.computeBounds(element, null);
        if (rectangle == null) {
            Element[] elementArray;
            WebForm webForm = pageBox.getWebForm();
            for (Element element2 : elementArray = webForm.getDomProviderService().getChildComponentRootElements(element)) {
                rectangle = pageBox.computeBounds(element2, rectangle);
            }
        }
        return rectangle;
    }

    public static Element findClosestComponentRootElement(WebForm webForm, Node node) {
        while (node != null) {
            if (node instanceof Element && webForm.getDomProviderService().isPrincipalElement((Element)node, null)) {
                return (Element)node;
            }
            node = node.getParentNode();
        }
        return null;
    }
}

