/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.css2;

import org.netbeans.modules.visualweb.css2.BoxType;
import org.netbeans.modules.visualweb.css2.ContainerBox;
import org.netbeans.modules.visualweb.css2.CreateContext;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.FieldSetBox;
import org.netbeans.modules.visualweb.css2.FormComponentBox;
import org.netbeans.modules.visualweb.css2.FrameBox;
import org.netbeans.modules.visualweb.css2.ImageBox;
import org.netbeans.modules.visualweb.css2.JspIncludeBox;
import org.netbeans.modules.visualweb.css2.LineBreakBox;
import org.netbeans.modules.visualweb.css2.ListBox;
import org.netbeans.modules.visualweb.css2.ObjectBox;
import org.netbeans.modules.visualweb.css2.TableBox;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.w3c.dom.Element;

public class BoxFactory {
    private BoxFactory() {
    }

    public static CssBox create(CreateContext createContext, HtmlTag htmlTag, WebForm webForm, Element element, BoxType boxType, boolean bl, boolean bl2) {
        if (htmlTag == null) {
            throw new NullPointerException("Parameter tag may not be null!");
        }
        if (htmlTag.isReplacedTag() != bl2) {
            throw new IllegalArgumentException("Parameters are incorrect, tag.isReplaceTag=" + htmlTag.isReplacedTag() + ", and replaced=" + bl2 + ", has to match!");
        }
        if (htmlTag.isHiddenTag()) {
            return null;
        }
        CssBox cssBox = BoxFactory.createBox(createContext, htmlTag, webForm, element, boxType, bl, bl2);
        if (cssBox != null) {
            cssBox.tag = htmlTag;
        }
        return cssBox;
    }

    private static CssBox createBox(CreateContext createContext, HtmlTag htmlTag, WebForm webForm, Element element, BoxType boxType, boolean bl, boolean bl2) {
        char c = htmlTag.getTagName().charAt(0);
        switch (c) {
            case 't': {
                if (htmlTag == HtmlTag.TABLE) {
                    CssBox cssBox = TableBox.getTableBox(webForm, element, boxType, bl, bl2);
                    return cssBox;
                }
                if (htmlTag != HtmlTag.TEXTAREA) break;
                CssBox cssBox = FormComponentBox.getBox(webForm, element, htmlTag, boxType, bl, bl2);
                return cssBox;
            }
            case 'i': {
                if (htmlTag == HtmlTag.INPUT) {
                    CssBox cssBox = FormComponentBox.getBox(webForm, element, htmlTag, boxType, bl, bl2);
                    return cssBox;
                }
                if (htmlTag == HtmlTag.IMG) {
                    CssBox cssBox = ImageBox.getImageBox(webForm, element, webForm.getPane(), boxType, bl);
                    return cssBox;
                }
                if (htmlTag != HtmlTag.IFRAME) break;
                return FrameBox.getFrameBox(createContext, webForm, element, boxType, htmlTag, bl);
            }
            case 'b': {
                if (htmlTag == HtmlTag.BR) {
                    return new LineBreakBox(webForm, element, htmlTag);
                }
                if (htmlTag != HtmlTag.BUTTON) break;
                CssBox cssBox = FormComponentBox.getBox(webForm, element, htmlTag, boxType, bl, bl2);
                return cssBox;
            }
            case 'j': {
                if (htmlTag != HtmlTag.JSPINCLUDE && htmlTag != HtmlTag.JSPINCLUDEX) break;
                return JspIncludeBox.getJspIncludeBox(createContext, webForm, element, boxType, htmlTag, bl);
            }
            case 'f': {
                if (htmlTag != HtmlTag.FIELDSET) break;
                return FieldSetBox.getFieldSetBox(webForm, element, boxType, htmlTag, bl);
            }
            case 'a': {
                if (htmlTag != HtmlTag.APPLET) break;
                return ObjectBox.getObjectBox(webForm, element, boxType, htmlTag, bl);
            }
            case 'o': {
                if (htmlTag == HtmlTag.OL) {
                    ListBox listBox = new ListBox(webForm, element, boxType, bl, bl2);
                    return listBox;
                }
                if (htmlTag != HtmlTag.OBJECT) break;
                return ObjectBox.getObjectBox(webForm, element, boxType, htmlTag, bl);
            }
            case 's': {
                if (htmlTag != HtmlTag.SELECT) break;
                CssBox cssBox = FormComponentBox.getBox(webForm, element, htmlTag, boxType, bl, bl2);
                return cssBox;
            }
            case 'u': {
                if (htmlTag != HtmlTag.UL) break;
                ListBox listBox = new ListBox(webForm, element, boxType, bl, bl2);
                return listBox;
            }
            case 'm': {
                if (htmlTag != HtmlTag.MENU) break;
                ListBox listBox = new ListBox(webForm, element, boxType, bl, bl2);
                return listBox;
            }
            case 'd': {
                if (htmlTag != HtmlTag.DIR) break;
                ListBox listBox = new ListBox(webForm, element, boxType, bl, bl2);
                return listBox;
            }
        }
        ContainerBox containerBox = new ContainerBox(webForm, element, boxType, bl, bl2);
        return containerBox;
    }
}

