/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.util;

import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmClassifierBasedTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmFriendClass;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionPointerType;
import org.netbeans.modules.cnd.api.model.CsmIdentifiable;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInitializerListContainer;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameterType;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUsingDirective;
import org.netbeans.modules.cnd.api.model.CsmValidable;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmGotoStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;

public class CsmKindUtilities {
    public static boolean isInstantiation(CsmObject csmObject) {
        return csmObject instanceof CsmInstantiation;
    }

    private CsmKindUtilities() {
    }

    public static boolean isProject(Object object) {
        return object instanceof CsmProject;
    }

    public static boolean isCsmObject(Object object) {
        return object instanceof CsmObject;
    }

    public static boolean isValidable(CsmObject csmObject) {
        return csmObject instanceof CsmValidable;
    }

    public static boolean isQualified(CsmObject csmObject) {
        return csmObject instanceof CsmQualifiedNamedElement;
    }

    public static boolean isDeclaration(CsmObject csmObject) {
        return csmObject instanceof CsmDeclaration;
    }

    public static boolean isBuiltIn(CsmObject csmObject) {
        if (CsmKindUtilities.isDeclaration(csmObject)) {
            return ((CsmDeclaration)csmObject).getKind() == CsmDeclaration.Kind.BUILT_IN;
        }
        return false;
    }

    public static boolean isTemplateInstantiation(CsmObject csmObject) {
        return csmObject instanceof CsmInstantiation;
    }

    public static boolean isTemplateParameterType(CsmObject csmObject) {
        return csmObject instanceof CsmTemplateParameterType;
    }

    public static boolean isTemplate(CsmObject csmObject) {
        return csmObject instanceof CsmTemplate && ((CsmTemplate)csmObject).isTemplate();
    }

    public static boolean isTemplateParameter(CsmObject csmObject) {
        return csmObject instanceof CsmTemplateParameter;
    }

    public static boolean isClassifierBasedTemplateParameter(CsmObject csmObject) {
        return csmObject instanceof CsmClassifierBasedTemplateParameter;
    }

    public static boolean isFunctionPointerType(CsmObject csmObject) {
        return csmObject instanceof CsmFunctionPointerType;
    }

    public static boolean isType(CsmObject csmObject) {
        return csmObject instanceof CsmType;
    }

    public static boolean isTypedef(CsmObject csmObject) {
        if (CsmKindUtilities.isDeclaration(csmObject)) {
            return ((CsmDeclaration)csmObject).getKind() == CsmDeclaration.Kind.TYPEDEF;
        }
        return false;
    }

    public static boolean isStatement(CsmObject csmObject) {
        return csmObject instanceof CsmStatement;
    }

    public static boolean isDeclarationStatement(CsmObject csmObject) {
        return csmObject instanceof CsmDeclarationStatement;
    }

    public static boolean isCompoundStatement(CsmObject csmObject) {
        if (CsmKindUtilities.isStatement(csmObject)) {
            return ((CsmStatement)csmObject).getKind() == CsmStatement.Kind.COMPOUND;
        }
        return false;
    }

    public static boolean isGotoStatement(CsmObject csmObject) {
        return csmObject instanceof CsmGotoStatement;
    }

    public static boolean isLabel(CsmObject csmObject) {
        return csmObject instanceof CsmLabel;
    }

    public static boolean isOffsetable(Object object) {
        return object instanceof CsmOffsetable;
    }

    public static boolean isNamedElement(CsmObject csmObject) {
        return csmObject instanceof CsmNamedElement;
    }

    public static boolean isNamedElement(Object object) {
        return object instanceof CsmNamedElement;
    }

    public static boolean isEnum(CsmObject csmObject) {
        if (CsmKindUtilities.isDeclaration(csmObject)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)csmObject).getKind();
            return kind == CsmDeclaration.Kind.ENUM;
        }
        return false;
    }

    public static boolean isEnumerator(CsmObject csmObject) {
        return csmObject instanceof CsmEnumerator;
    }

    public static boolean isClassifier(CsmObject csmObject) {
        return csmObject instanceof CsmClassifier;
    }

    public static boolean isCompoundClassifier(CsmObject csmObject) {
        return csmObject instanceof CsmCompoundClassifier;
    }

    public static boolean isClass(CsmObject csmObject) {
        if (CsmKindUtilities.isDeclaration(csmObject)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)csmObject).getKind();
            return kind == CsmDeclaration.Kind.CLASS || kind == CsmDeclaration.Kind.STRUCT || kind == CsmDeclaration.Kind.UNION;
        }
        return false;
    }

    public static boolean isUnion(CsmObject csmObject) {
        if (CsmKindUtilities.isDeclaration(csmObject)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)csmObject).getKind();
            return kind == CsmDeclaration.Kind.UNION;
        }
        return false;
    }

    public static boolean isClassForwardDeclaration(CsmObject csmObject) {
        if (CsmKindUtilities.isDeclaration(csmObject)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)csmObject).getKind();
            return kind == CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION;
        }
        return false;
    }

    public static boolean isScope(CsmObject csmObject) {
        return csmObject instanceof CsmScope;
    }

    public static boolean isScopeElement(CsmObject csmObject) {
        return csmObject instanceof CsmScopeElement;
    }

    public static boolean isFunction(CsmObject csmObject) {
        if (CsmKindUtilities.isDeclaration(csmObject)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)csmObject).getKind();
            return kind == CsmDeclaration.Kind.FUNCTION || kind == CsmDeclaration.Kind.FUNCTION_DEFINITION;
        }
        return false;
    }

    public static boolean isParameter(CsmObject csmObject) {
        return csmObject instanceof CsmParameter;
    }

    public static boolean isOperator(CsmObject csmObject) {
        if (CsmKindUtilities.isFunction(csmObject)) {
            return ((CsmFunction)csmObject).isOperator();
        }
        return false;
    }

    public static boolean isFunctionDeclaration(CsmObject csmObject) {
        if (CsmKindUtilities.isDeclaration(csmObject)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)csmObject).getKind();
            return kind == CsmDeclaration.Kind.FUNCTION;
        }
        return false;
    }

    public static boolean isFunctionDefinition(CsmObject csmObject) {
        if (CsmKindUtilities.isDeclaration(csmObject)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)csmObject).getKind();
            return kind == CsmDeclaration.Kind.FUNCTION_DEFINITION;
        }
        return false;
    }

    public static boolean isFile(CsmObject csmObject) {
        return csmObject instanceof CsmFile;
    }

    public static boolean isInheritance(CsmObject csmObject) {
        return csmObject instanceof CsmInheritance;
    }

    public static boolean isNamespace(CsmObject csmObject) {
        return csmObject instanceof CsmNamespace;
    }

    public static boolean isNamespaceDefinition(CsmObject csmObject) {
        if (CsmKindUtilities.isDeclaration(csmObject)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)csmObject).getKind();
            return kind == CsmDeclaration.Kind.NAMESPACE_DEFINITION;
        }
        return false;
    }

    public static boolean isClassMember(CsmObject csmObject) {
        if (csmObject instanceof CsmMember) {
            if (CsmKindUtilities.isClass(csmObject)) {
                return CsmKindUtilities.isClass(((CsmClass)csmObject).getScope());
            }
            return true;
        }
        return false;
    }

    public static boolean isVariable(CsmObject csmObject) {
        if (CsmKindUtilities.isDeclaration(csmObject)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)csmObject).getKind();
            return kind == CsmDeclaration.Kind.VARIABLE || kind == CsmDeclaration.Kind.VARIABLE_DEFINITION;
        }
        return false;
    }

    public static boolean isVariableDeclaration(CsmObject csmObject) {
        if (CsmKindUtilities.isDeclaration(csmObject)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)csmObject).getKind();
            return kind == CsmDeclaration.Kind.VARIABLE;
        }
        return false;
    }

    public static boolean isVariableDefinition(CsmObject csmObject) {
        if (CsmKindUtilities.isDeclaration(csmObject)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)csmObject).getKind();
            return kind == CsmDeclaration.Kind.VARIABLE_DEFINITION;
        }
        return false;
    }

    public static boolean isLocalVariable(CsmObject csmObject) {
        if (CsmKindUtilities.isVariable(csmObject)) {
            if (CsmKindUtilities.isClassMember(csmObject)) {
                return false;
            }
            CsmScope csmScope = ((CsmVariable)csmObject).getScope();
            return !CsmKindUtilities.isFile(csmScope) && !CsmKindUtilities.isNamespace(csmScope);
        }
        return false;
    }

    public static boolean isFileLocalVariable(CsmObject csmObject) {
        if (CsmKindUtilities.isVariable(csmObject)) {
            return CsmKindUtilities.isFile(((CsmVariable)csmObject).getScope());
        }
        return false;
    }

    public static boolean isGlobalVariable(CsmObject csmObject) {
        if (CsmKindUtilities.isVariable(csmObject)) {
            return CsmKindUtilities.isNamespace(((CsmVariable)csmObject).getScope());
        }
        return false;
    }

    public static boolean isParamVariable(CsmObject csmObject) {
        if (CsmKindUtilities.isVariable(csmObject)) {
            assert (!(csmObject instanceof CsmParameter) || !CsmKindUtilities.isClassMember(csmObject)) : "parameter is not class member";
            return csmObject instanceof CsmParameter;
        }
        return false;
    }

    public static boolean isField(CsmObject csmObject) {
        if (CsmKindUtilities.isVariable(csmObject)) {
            return CsmKindUtilities.isClassMember(csmObject);
        }
        return false;
    }

    public static boolean isGlobalFunction(CsmObject csmObject) {
        if (CsmKindUtilities.isFunction(csmObject)) {
            return !CsmKindUtilities.isClassMember(CsmBaseUtilities.getFunctionDeclaration((CsmFunction)csmObject));
        }
        return false;
    }

    public static boolean isMethod(CsmObject csmObject) {
        if (CsmKindUtilities.isFunction(csmObject)) {
            return CsmKindUtilities.isClassMember(CsmBaseUtilities.getFunctionDeclaration((CsmFunction)csmObject));
        }
        return false;
    }

    public static boolean isMethodDeclaration(CsmObject csmObject) {
        if (CsmKindUtilities.isFunction(csmObject)) {
            return CsmKindUtilities.isClassMember(csmObject);
        }
        return false;
    }

    public static boolean isMethodDefinition(CsmObject csmObject) {
        if (CsmKindUtilities.isFunctionDefinition(csmObject)) {
            return CsmKindUtilities.isClassMember(CsmBaseUtilities.getFunctionDeclaration((CsmFunction)csmObject));
        }
        return false;
    }

    public static boolean isConstructor(CsmObject csmObject) {
        return csmObject instanceof CsmInitializerListContainer;
    }

    public static boolean isDestructor(CsmObject csmObject) {
        CsmFunction csmFunction;
        if (CsmKindUtilities.isMethod(csmObject) && (csmFunction = CsmBaseUtilities.getFunctionDeclaration((CsmFunction)csmObject)) != null && csmFunction.getName().length() > 0) {
            return csmFunction.getName().charAt(0) == '~';
        }
        return false;
    }

    public static boolean isExpression(CsmObject csmObject) {
        return csmObject instanceof CsmExpression;
    }

    public static boolean isMacro(CsmObject csmObject) {
        return csmObject instanceof CsmMacro;
    }

    public static boolean isInclude(CsmObject csmObject) {
        return csmObject instanceof CsmInclude;
    }

    public static boolean isUsing(CsmObject csmObject) {
        return csmObject instanceof CsmUsingDeclaration || csmObject instanceof CsmUsingDirective;
    }

    public static boolean isNamespaceAlias(CsmObject csmObject) {
        return csmObject instanceof CsmNamespaceAlias;
    }

    public static boolean isUsingDirective(CsmObject csmObject) {
        return csmObject instanceof CsmUsingDirective;
    }

    public static boolean isUsingDeclaration(CsmObject csmObject) {
        return csmObject instanceof CsmUsingDeclaration;
    }

    public static boolean isFriend(CsmObject csmObject) {
        return csmObject instanceof CsmFriend;
    }

    public static boolean isFriendClass(CsmObject csmObject) {
        return csmObject instanceof CsmFriendClass;
    }

    public static boolean isFriendMethod(CsmObject csmObject) {
        return csmObject instanceof CsmFriendFunction;
    }

    public static boolean isExternVariable(CsmDeclaration csmDeclaration) {
        if (CsmKindUtilities.isVariable(csmDeclaration)) {
            return ((CsmVariable)csmDeclaration).isExtern();
        }
        return false;
    }

    public static boolean isIdentifiable(Object object) {
        return object instanceof CsmIdentifiable;
    }
}

