/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model;

import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmModelStateListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;

public final class CsmModelAccessor {
    private static CsmModel model;
    private static CsmModel dummy;
    private static CsmModelStateListener stateListener;
    private static final Cancellable cancellableStub;
    private static final boolean TRACE_GET_MODEL;

    public static CsmModelState getModelState() {
        CsmModel csmModel = model;
        return csmModel == null ? CsmModelState.OFF : csmModel.getState();
    }

    private CsmModelAccessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CsmModel getModel() {
        if (TRACE_GET_MODEL) {
            Thread.dumpStack();
        }
        if (model != null) return model;
        Class<CsmModel> clazz = CsmModel.class;
        synchronized (CsmModel.class) {
            if (model != null) return model;
            model = (CsmModel)Lookup.getDefault().lookup(CsmModel.class);
            if (model == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return CsmModelAccessor.getStub();
            }
            CsmListeners.getDefault().addModelStateListener(stateListener);
            // ** MonitorExit[var0] (shouldn't be in output)
            return model;
        }
    }

    private static CsmModel getStub() {
        if (dummy == null) {
            dummy = new ModelStub();
        }
        return dummy;
    }

    static {
        stateListener = new CsmModelStateListener(){

            public void modelStateChanged(CsmModelState csmModelState, CsmModelState csmModelState2) {
                if (csmModelState == CsmModelState.OFF) {
                    CsmListeners.getDefault().removeModelStateListener(stateListener);
                    model = null;
                }
            }
        };
        cancellableStub = new Cancellable(){

            public boolean cancel() {
                return true;
            }
        };
        TRACE_GET_MODEL = Boolean.getBoolean("trace.get.model");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModelStub
    implements CsmModel {
        private ModelStub() {
        }

        @Override
        public Collection<CsmProject> projects() {
            return Collections.emptyList();
        }

        @Override
        public CsmProject getProject(Object object) {
            return null;
        }

        @Override
        public CsmFile findFile(CharSequence charSequence) {
            return null;
        }

        @Override
        public CsmModelState getState() {
            return CsmModelState.OFF;
        }

        @Override
        public Cancellable enqueue(Runnable runnable) {
            return cancellableStub;
        }

        @Override
        public Cancellable enqueue(Runnable runnable, CharSequence charSequence) {
            return cancellableStub;
        }
    }
}

