/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.refactoring.ui.tree;

import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.CategorizedSchemaNodeFactory;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class XMLSchemaTreeElement
implements TreeElement {
    RefactoringElement element;
    Node node;
    SchemaComponent component;

    XMLSchemaTreeElement(RefactoringElement refactoringElement) {
        this.element = refactoringElement;
        this.component = (SchemaComponent)refactoringElement.getLookup().lookup(SchemaComponent.class);
        assert (this.component instanceof SchemaComponent) : "This TreeElement handles SchemaComponents only";
        SchemaComponent schemaComponent = (SchemaComponent)SchemaComponent.class.cast(this.component);
        CategorizedSchemaNodeFactory categorizedSchemaNodeFactory = new CategorizedSchemaNodeFactory(schemaComponent.getModel(), Lookups.singleton((Object)schemaComponent));
        this.node = categorizedSchemaNodeFactory.createNode(schemaComponent);
    }

    XMLSchemaTreeElement(Object object) {
        this.component = (SchemaComponent)object;
        CategorizedSchemaNodeFactory categorizedSchemaNodeFactory = new CategorizedSchemaNodeFactory(this.component.getModel(), Lookups.singleton((Object)this.component));
        this.node = categorizedSchemaNodeFactory.createNode(this.component);
    }

    public TreeElement getParent(boolean bl) {
        Object var2_2 = null;
        if (this.component.getParent() != null) {
            return TreeElementFactory.getTreeElement((Object)this.component.getParent());
        }
        FileObject fileObject = (FileObject)this.component.getModel().getModelSource().getLookup().lookup(FileObject.class);
        return TreeElementFactory.getTreeElement((Object)fileObject);
    }

    public Icon getIcon() {
        return new ImageIcon(this.node.getIcon(1));
    }

    public String getText(boolean bl) {
        if (this.element != null) {
            String string = this.node.getHtmlDisplayName();
            String string2 = MessageFormat.format(NbBundle.getMessage(XMLSchemaTreeElement.class, (String)"LBL_Usage_Node"), this.node.getName(), this.node.getShortDescription(), string == null ? "" : string);
            return string2;
        }
        return this.node.getName();
    }

    public Object getUserObject() {
        if (this.element != null) {
            return this.element;
        }
        return this.component;
    }
}

