/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.refactoring.query.readers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.xml.nbprefuse.AnalysisConstants;
import org.netbeans.modules.xml.refactoring.ui.CancelSignal;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalAttributeGroup;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalGroup;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.schema.model.visitor.Preview;
import org.netbeans.modules.xml.schema.refactoring.SchemaUIHelper;
import org.netbeans.modules.xml.schema.refactoring.ui.QueryUtilities;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryUnusedGlobalsReader {
    private static final int GCT = 2;
    private static final int GST = 5;
    private static final int GRP = 4;
    private static final int AT = 0;
    private static final int ATG = 1;
    private static final int ELE = 3;

    public Node findUnusedGlobals(CancelSignal cancelSignal, SchemaModel schemaModel, Boolean bl) {
        Collection collection;
        if (cancelSignal == null || schemaModel == null || bl == null) {
            return null;
        }
        AbstractNode abstractNode = new AbstractNode((Children)new Children.Array());
        abstractNode.setDisplayName(NbBundle.getMessage(QueryUnusedGlobalsReader.class, (String)"LBL_Unused_Global_Components"));
        abstractNode.setIconBaseWithExtension("org/netbeans/modules/xml/schema/refactoring/resources/unused-query.PNG");
        Schema schema = schemaModel.getSchema();
        Node[] nodeArray = new Node[bl != false ? 5 : 6];
        ArrayList<SchemaComponent> arrayList = new ArrayList<SchemaComponent>();
        Collection collection2 = schema.getComplexTypes();
        AbstractNode abstractNode2 = QueryUtilities.createCategoryNode(AnalysisConstants.GlobalTypes.COMPLEX_TYPE);
        nodeArray[2] = abstractNode2;
        arrayList.addAll(collection2);
        Collection collection3 = null;
        int n = 1;
        if (!bl.booleanValue()) {
            --n;
            collection3 = schema.getElements();
            collection = QueryUtilities.createCategoryNode(AnalysisConstants.GlobalTypes.ELEMENT);
            nodeArray[3] = collection;
            arrayList.addAll(collection3);
        }
        collection = schema.getSimpleTypes();
        AbstractNode abstractNode3 = QueryUtilities.createCategoryNode(AnalysisConstants.GlobalTypes.SIMPLE_TYPE);
        nodeArray[5 - n] = abstractNode3;
        arrayList.addAll(collection);
        Collection collection4 = schema.getGroups();
        AbstractNode abstractNode4 = QueryUtilities.createCategoryNode(AnalysisConstants.GlobalTypes.GROUP);
        nodeArray[4 - n] = abstractNode4;
        arrayList.addAll(collection4);
        Collection collection5 = schema.getAttributes();
        AbstractNode abstractNode5 = QueryUtilities.createCategoryNode(AnalysisConstants.GlobalTypes.ATTRIBUTE);
        nodeArray[0] = abstractNode5;
        arrayList.addAll(collection5);
        Collection collection6 = schema.getAttributeGroups();
        AbstractNode abstractNode6 = QueryUtilities.createCategoryNode(AnalysisConstants.GlobalTypes.ATTRIBUTE_GROUP);
        nodeArray[1] = abstractNode6;
        arrayList.addAll(collection6);
        ArrayList<FileObject> arrayList2 = new ArrayList<FileObject>();
        FileObject fileObject = (FileObject)schemaModel.getModelSource().getLookup().lookup(FileObject.class);
        arrayList2.add(fileObject);
        FileObject fileObject2 = fileObject.getParent();
        this.getFiles(arrayList2, fileObject2, null, fileObject);
        List<SourceGroup> list = QueryUtilities.getProjectSourceGroups(schemaModel, "java");
        if (list != null) {
            for (SourceGroup sourceGroup : list) {
                FileObject fileObject3 = sourceGroup.getRootFolder();
                if (fileObject3 == fileObject2) continue;
                this.getFiles(arrayList2, fileObject3, fileObject2, fileObject);
            }
        }
        this.findUnused(cancelSignal, arrayList, arrayList2);
        if (cancelSignal.isCancelRequested()) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(QueryUnusedGlobalsReader.class, (String)"LBL_Query_Cancelled"));
            return null;
        }
        for (SchemaComponent schemaComponent : arrayList) {
            this.createNode(schemaComponent, nodeArray, n);
        }
        abstractNode.getChildren().add(nodeArray);
        StatusDisplayer.getDefault().setStatusText(arrayList.size() == 1 ? NbBundle.getMessage(QueryUnusedGlobalsReader.class, (String)"LBL_Found_1_Unused_Component") : MessageFormat.format(NbBundle.getMessage(QueryUnusedGlobalsReader.class, (String)"LBL_Found_Unused_Global_Components"), arrayList.size()));
        return abstractNode;
    }

    private void findUnused(CancelSignal cancelSignal, List<SchemaComponent> list, List<FileObject> list2) {
        for (FileObject fileObject : list2) {
            ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)true);
            SchemaModel schemaModel = SchemaModelFactory.getDefault().getModel(modelSource);
            if (schemaModel.getState() == Model.State.NOT_WELL_FORMED) continue;
            assert (schemaModel != null) : "Cannot get SchemaModel for " + fileObject.getNameExt();
            Iterator<SchemaComponent> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (cancelSignal.isCancelRequested()) {
                    return;
                }
                SchemaComponent schemaComponent = iterator.next();
                Referenceable referenceable = (Referenceable)Referenceable.class.cast(schemaComponent);
                Preview preview = QueryUtilities.getUsagesPreview(schemaModel.getSchema(), (NamedReferenceable)NamedReferenceable.class.cast(referenceable));
                assert (preview != null) : "QueryUtilities.getUsagesPreview() returned null preview";
                Map map = preview.getUsages();
                assert (map != null) : "QueryUtilities.getUsagesPreview() returned preview with null map";
                if (map.size() <= 0) continue;
                iterator.remove();
            }
        }
    }

    private void getFiles(List<FileObject> list, FileObject fileObject, FileObject fileObject2, FileObject fileObject3) {
        if (fileObject != null && fileObject.isFolder() && fileObject != fileObject2) {
            FileObject[] fileObjectArray;
            for (FileObject fileObject4 : fileObjectArray = fileObject.getChildren()) {
                if (fileObject4.isData() && fileObject4.getExt().equals("xsd") && fileObject4 != fileObject3) {
                    list.add(fileObject4);
                    continue;
                }
                this.getFiles(list, fileObject4, fileObject2, fileObject3);
            }
        }
    }

    private void createNode(SchemaComponent schemaComponent, Node[] nodeArray, int n) {
        if (!(schemaComponent instanceof Referenceable) || nodeArray == null) {
            return;
        }
        int n2 = 0;
        if (schemaComponent instanceof GlobalComplexType) {
            n2 = 2;
        } else if (schemaComponent instanceof GlobalSimpleType) {
            n2 = 5 - n;
        } else if (schemaComponent instanceof GlobalGroup) {
            n2 = 4 - n;
        } else if (schemaComponent instanceof GlobalAttribute) {
            n2 = 0;
        } else if (schemaComponent instanceof GlobalAttributeGroup) {
            n2 = 1;
        } else if (schemaComponent instanceof GlobalElement) {
            n2 = 3;
        }
        SchemaUIHelper schemaUIHelper = new SchemaUIHelper();
        Object object = schemaUIHelper.getDisplayNode((Component)schemaComponent);
        object = new FilterNode((Node)object){

            public String getHtmlDisplayName() {
                return null;
            }
        };
        nodeArray[n2].getChildren().add(new Node[]{object});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FindUsagesResult {
        USAGES_FOUND,
        NO_USAGES_FOUND,
        CANCEL_REQUESTED;

    }
}

