/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.refactoring;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.ProblemDetailsFactory;
import org.netbeans.modules.refactoring.spi.ProblemDetailsImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.netbeans.modules.xml.refactoring.ErrorItem;
import org.netbeans.modules.xml.refactoring.FauxRefactoringElement;
import org.netbeans.modules.xml.refactoring.XMLRefactoringPlugin;
import org.netbeans.modules.xml.refactoring.XMLRefactoringTransaction;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.refactoring.ui.WhereUsedQueryUI;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.schema.refactoring.SchemaRefactoringElement;
import org.netbeans.modules.xml.schema.refactoring.SchemaRefactoringPlugin;
import org.netbeans.modules.xml.schema.refactoring.SchemaSafeDeleteRefactoringPlugin;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaMoveRefactoringPlugin
extends SchemaRefactoringPlugin
implements XMLRefactoringPlugin {
    private MoveRefactoring request;
    public static final String XSD_MIME_TYPE = "application/x-schema+xml";

    public void cancelRequest() {
    }

    public Problem fastCheckParameters() {
        URL uRL = (URL)this.request.getTarget().lookup(URL.class);
        if (uRL == null) {
            return null;
        }
        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
        if (fileObject != null && !fileObject.canWrite()) {
            return new Problem(true, NbBundle.getMessage(SchemaMoveRefactoringPlugin.class, (String)"ERR_PackageIsReadOnly"));
        }
        Referenceable referenceable = (Referenceable)this.request.getRefactoringSource().lookup(Referenceable.class);
        if (!(referenceable instanceof Model)) {
            return null;
        }
        FileObject fileObject2 = (FileObject)((Model)referenceable).getModelSource().getLookup().lookup(FileObject.class);
        String string = fileObject2.getName();
        if (fileObject != null) {
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                if (!fileObjectArray[i].getName().equals(string) || !"xsd".equals(fileObjectArray[i].getExt()) || fileObjectArray[i].equals(fileObject2)) continue;
                return new Problem(true, NbBundle.getMessage(SchemaMoveRefactoringPlugin.class, (String)"ERR_FileToMoveClashes"));
            }
        }
        return null;
    }

    public SchemaMoveRefactoringPlugin(MoveRefactoring moveRefactoring) {
        this.request = moveRefactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        RefactoringSession refactoringSession;
        Object object2;
        Referenceable referenceable = (Referenceable)this.request.getRefactoringSource().lookup(Referenceable.class);
        if (referenceable == null) {
            return null;
        }
        if (!(referenceable instanceof Model)) {
            return null;
        }
        this.fireProgressListenerStart(1, -1);
        XMLRefactoringTransaction xMLRefactoringTransaction = (XMLRefactoringTransaction)this.request.getContext().lookup(XMLRefactoringTransaction.class);
        Set<Object> set = new HashSet<Component>();
        Component component = (Component)this.request.getContext().lookup(Component.class);
        if (component == null) {
            set = this.getSearchRoots(referenceable);
        } else {
            set.add(component);
        }
        this.findErrors = new ArrayList();
        ArrayList arrayList = new ArrayList();
        for (Object object2 : set) {
            refactoringSession = this.find(referenceable, (Component)object2);
            if (refactoringSession == null || refactoringSession.size() <= 0) continue;
            arrayList.addAll(refactoringSession);
        }
        xMLRefactoringTransaction.register((XMLRefactoringPlugin)this, arrayList);
        refactoringElementsBag.registerTransaction((Transaction)xMLRefactoringTransaction);
        for (Object object2 : arrayList) {
            ((SchemaRefactoringElement)((Object)object2)).addTransactionObject(xMLRefactoringTransaction);
            refactoringElementsBag.add((AbstractRefactoring)this.request, (RefactoringElementImplementation)object2);
            this.fireProgressListenerStep();
        }
        Iterator<Object> iterator = SharedUtils.getModel((Referenceable)referenceable);
        object2 = (FileObject)iterator.getModelSource().getLookup().lookup(FileObject.class);
        if (XSD_MIME_TYPE.equals(FileUtil.getMIMEType((FileObject)object2))) {
            refactoringElementsBag.add((AbstractRefactoring)this.request, (RefactoringElementImplementation)new FauxRefactoringElement(referenceable, NbBundle.getMessage(SchemaMoveRefactoringPlugin.class, (String)"LBL_Move")));
        }
        if (this.isMoveToDifferentPackage()) {
            refactoringSession = RefactoringSession.create((String)"move");
            Referenceable referenceable2 = referenceable;
            WhereUsedQuery whereUsedQuery = new WhereUsedQuery(Lookups.singleton((Object)referenceable2));
            whereUsedQuery.prepare(refactoringSession);
            WhereUsedQueryUI whereUsedQueryUI = new WhereUsedQueryUI(referenceable2);
            List<ErrorItem> list = this.checkDifferentPackageMoveErrors(refactoringSession);
            if (list != null && list.size() > 0) {
                Problem problem = this.processErrors(list, whereUsedQueryUI, refactoringSession);
                this.fireProgressListenerStop();
                return problem;
            }
        }
        if (this.findErrors.size() > 0) {
            refactoringSession = this.processErrors(this.findErrors);
            return refactoringSession;
        }
        this.fireProgressListenerStop();
        return null;
    }

    public void doRefactoring(List<RefactoringElementImplementation> list) throws IOException {
        Map map = SharedUtils.getModelMap(list);
        Set set = map.keySet();
        Referenceable referenceable = (Referenceable)this.request.getRefactoringSource().lookup(Referenceable.class);
        for (Model model : set) {
            this._refactorUsages(model, (Set)map.get(model), this.request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _refactorUsages(Model model, Set<RefactoringElementImplementation> set, MoveRefactoring moveRefactoring) throws IOException {
        if (model == null) {
            return;
        }
        if (!(model instanceof SchemaModel)) {
            return;
        }
        SchemaModel schemaModel = (SchemaModel)model;
        boolean bl = !schemaModel.isIntransaction();
        try {
            if (bl) {
                schemaModel.startTransaction();
            }
            for (RefactoringElementImplementation refactoringElementImplementation : set) {
                SchemaModelReference schemaModelReference;
                if (!(refactoringElementImplementation instanceof SchemaRefactoringElement) || (schemaModelReference = (SchemaModelReference)refactoringElementImplementation.getLookup().lookup(SchemaModelReference.class)) == null) continue;
                String string = schemaModelReference.getSchemaLocation();
                try {
                    string = SharedUtils.calculateNewLocationString((Model)model, (MoveRefactoring)moveRefactoring);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                schemaModelReference.setSchemaLocation(string);
            }
        }
        finally {
            if (bl && schemaModel.isIntransaction()) {
                schemaModel.endTransaction();
            }
        }
    }

    @Override
    public void setModelReference(Component component, String string) {
        if (component instanceof SchemaModelReference) {
            boolean bl;
            Model model = component.getModel();
            boolean bl2 = bl = !model.isIntransaction();
            if (bl) {
                model.startTransaction();
            }
            ((SchemaModelReference)component).setSchemaLocation(string);
            if (bl && model.isIntransaction()) {
                model.endTransaction();
            }
        }
    }

    private boolean isMoveToDifferentPackage() {
        Referenceable referenceable = (Referenceable)this.request.getRefactoringSource().lookup(Referenceable.class);
        URL uRL = (URL)this.request.getTarget().lookup(URL.class);
        if (uRL == null) {
            return false;
        }
        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
        if (fileObject == null) {
            try {
                fileObject = SharedUtils.getOrCreateFolder((URL)uRL);
            }
            catch (Exception exception) {
                return false;
            }
        }
        ArrayList arrayList = new ArrayList();
        if (referenceable instanceof Model) {
            FileObject fileObject2 = (FileObject)((Model)referenceable).getModelSource().getLookup().lookup(FileObject.class);
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject2);
            FileObject fileObject3 = SharedUtils.getSourceFolder((Project)project, (FileObject)fileObject2);
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            if (sourceGroupArray != null && sourceGroupArray.length > 0 && fileObject3 != null && fileObject != null && fileObject3 != fileObject && !FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject)) {
                return true;
            }
        }
        return false;
    }

    private List<ErrorItem> checkDifferentPackageMoveErrors(RefactoringSession refactoringSession) {
        ErrorItem errorItem;
        Referenceable referenceable = (Referenceable)this.request.getRefactoringSource().lookup(Referenceable.class);
        ArrayList<ErrorItem> arrayList = new ArrayList<ErrorItem>();
        if (!refactoringSession.getRefactoringElements().isEmpty()) {
            errorItem = new ErrorItem((Object)referenceable, NbBundle.getMessage(SchemaMoveRefactoringPlugin.class, (String)"ERR_MoveToDifferentSourcePackage"), ErrorItem.Level.WARNING);
            arrayList.add(errorItem);
        }
        if (referenceable instanceof SchemaModel && !super.getExternalReferences((Model)referenceable).isEmpty()) {
            errorItem = new ErrorItem((Object)referenceable, NbBundle.getMessage(SchemaMoveRefactoringPlugin.class, (String)"ERR_MoveToDifferentSourcePackage"), ErrorItem.Level.WARNING);
            arrayList.add(errorItem);
        }
        return arrayList;
    }

    public Problem processErrors(List<ErrorItem> list, WhereUsedQueryUI whereUsedQueryUI, RefactoringSession refactoringSession) {
        if (list == null || list.size() == 0) {
            return null;
        }
        Problem problem = null;
        Problem problem2 = null;
        Problem problem3 = null;
        for (ErrorItem errorItem : list) {
            if (problem == null) {
                problem2 = problem = new Problem(this.isFatal(errorItem), errorItem.getMessage(), ProblemDetailsFactory.createProblemDetails((ProblemDetailsImplementation)new ProblemDetailsImplemen((RefactoringUI)whereUsedQueryUI, refactoringSession)));
                problem3 = problem;
                break;
            }
            problem2 = new Problem(this.isFatal(errorItem), errorItem.getMessage());
            problem.setNext(problem2);
            problem = problem2;
        }
        return problem3;
    }

    private class ProblemDetailsImplemen
    implements ProblemDetailsImplementation {
        private RefactoringUI ui;
        private RefactoringSession rs;

        public ProblemDetailsImplemen(RefactoringUI refactoringUI, RefactoringSession refactoringSession) {
            this.ui = refactoringUI;
            this.rs = refactoringSession;
        }

        public void showDetails(Action action, Cancellable cancellable) {
            cancellable.cancel();
            UI.openRefactoringUI((RefactoringUI)this.ui, (RefactoringSession)this.rs, (Action)action);
        }

        public String getDetailsHint() {
            return NbBundle.getMessage(SchemaSafeDeleteRefactoringPlugin.class, (String)"LBL_ShowUsages");
        }
    }
}

