/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error.includes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.highlight.error.BadgeProvider;
import org.netbeans.modules.cnd.highlight.error.includes.ErrorIncludeDialog;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailedIncludesAction
extends NodeAction {
    public FailedIncludesAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    private String i18n(String string) {
        return NbBundle.getMessage(FailedIncludesAction.class, (String)string);
    }

    protected void performAction(Node[] nodeArray) {
        List<NativeProject> list = this.getNativeProjects(nodeArray);
        if (list == null || list.size() != 1) {
            return;
        }
        NativeProject nativeProject = list.get(0);
        HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
        Set<CsmUID<CsmFile>> set = BadgeProvider.getInstance().getFailedFiles(nativeProject);
        if (set != null) {
            for (CsmUID<CsmFile> csmUID : set) {
                CsmFile csmFile = (CsmFile)csmUID.getObject();
                assert (csmFile != null);
                if (csmFile == null) continue;
                hashSet.add(csmFile);
            }
        }
        ErrorIncludeDialog.showErrorIncludeDialog(hashSet);
    }

    protected boolean enable(Node[] nodeArray) {
        List<NativeProject> list = this.getNativeProjects(nodeArray);
        if (list == null || list.size() != 1) {
            return false;
        }
        return BadgeProvider.getInstance().hasFailedFiles(list.get(0));
    }

    private List<NativeProject> getNativeProjects(Node[] nodeArray) {
        ArrayList<NativeProject> arrayList = new ArrayList<NativeProject>();
        for (int i = 0; i < nodeArray.length; ++i) {
            Project project = (Project)nodeArray[i].getLookup().lookup(Project.class);
            if (project == null) {
                return null;
            }
            NativeProject nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class);
            if (nativeProject == null) {
                return null;
            }
            arrayList.add(nativeProject);
        }
        return arrayList;
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return this.i18n("ErrorIncludeMenu_Title");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

