/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error;

import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.openide.util.NbBundle;

public class IncludeErrorProvider
extends CsmErrorProvider {
    public String getName() {
        return "include-errors";
    }

    protected void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        for (CsmInclude csmInclude : request.getFile().getIncludes()) {
            if (request.isCancelled()) break;
            if (csmInclude.getIncludeFile() != null) continue;
            response.addError((CsmErrorInfo)new IncludeErrorInfo(csmInclude));
        }
    }

    private static class IncludeErrorInfo
    extends OffsetableErrorInfo
    implements CsmErrorInfo {
        private String message;

        public IncludeErrorInfo(CsmInclude csmInclude) {
            super((CsmOffsetable)csmInclude, CsmErrorInfo.Severity.ERROR);
            this.message = NbBundle.getMessage(IncludeErrorProvider.class, (String)"HighlightProvider_IncludeMissed", (Object)IncludeErrorInfo.getIncludeText(csmInclude));
        }

        public String getMessage() {
            return this.message;
        }

        private static String getIncludeText(CsmInclude csmInclude) {
            if (csmInclude.isSystem()) {
                return "<" + csmInclude.getIncludeName() + ">";
            }
            return "\"" + csmInclude.getIncludeName() + "\"";
        }
    }

    private static abstract class OffsetableErrorInfo
    implements CsmErrorInfo {
        private int start;
        private int end;
        private CsmErrorInfo.Severity severity;

        public OffsetableErrorInfo(CsmOffsetable csmOffsetable, CsmErrorInfo.Severity severity) {
            this.start = csmOffsetable.getStartOffset();
            this.end = csmOffsetable.getEndOffset();
            this.severity = severity;
        }

        public int getEndOffset() {
            return this.end;
        }

        public int getStartOffset() {
            return this.start;
        }

        public CsmErrorInfo.Severity getSeverity() {
            return this.severity;
        }
    }
}

