/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.project.anttasks.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.bpel.project.CommandlineBpelProjectXmlCatalogProvider;
import org.netbeans.modules.bpel.project.anttasks.util.CatalogReader;
import org.netbeans.modules.bpel.project.anttasks.util.Util;
import org.netbeans.modules.xml.catalogsupport.DefaultProjectCatalogSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageCatalogArtifacts {
    private final Logger logger = Logger.getLogger(PackageCatalogArtifacts.class.getName());
    private final String retrieverPathPrefix = "nbproject/private/cache/retriever/";
    private final String retrieverPathPrefix2 = "retrieved/";
    private static final String METAINF = "META-INF/";

    public void doCopy(File sourceDirectory, File buildDirectory) {
        CommandlineBpelProjectXmlCatalogProvider.getInstance().setSourceDirectory(sourceDirectory.getAbsolutePath());
        File catalogFile = new File(CommandlineBpelProjectXmlCatalogProvider.getInstance().getProjectCatalogUri());
        if (!catalogFile.exists() || catalogFile.length() == 0L) {
            return;
        }
        try {
            CatalogReader catalogReader = new CatalogReader(catalogFile.getCanonicalPath());
            this.doCopy(sourceDirectory, buildDirectory, catalogReader);
        }
        catch (CatalogPackagingException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (SAXException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void doCopy(File sourceDirectory, File buildDirectory, CatalogReader catalogReader) throws CatalogPackagingException {
        try {
            List<String> systemIds = catalogReader.getSystemIds();
            List<String> locations = catalogReader.getLocations();
            File metaInfDirectory = new File(buildDirectory, "META-INF");
            metaInfDirectory.mkdirs();
            PrintWriter writer = new PrintWriter(new FileWriter(new File(metaInfDirectory, "catalog.xml")));
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            writer.println("<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\" prefer=\"system\">");
            for (int i = 0; i < systemIds.size(); ++i) {
                String systemId = systemIds.get(i);
                String location = locations.get(i);
                this.handleEntry(systemId, location, sourceDirectory, buildDirectory, writer);
            }
            writer.println("</catalog>");
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new CatalogPackagingException(e);
        }
    }

    private void handleEntry(String systemId, String location, File sourceDirectory, File buildDirectory, PrintWriter catalogWriter) throws CatalogPackagingException {
        block11: {
            File projectDirectory = sourceDirectory.getParentFile();
            try {
                URI uri = new URI(location);
                if (uri.getScheme() == null) {
                    if (location.startsWith("src/")) {
                        String localUri = location;
                        Util.copyFile(new File(projectDirectory, location), new File(buildDirectory, METAINF + localUri));
                        this.printToCatalog(catalogWriter, systemId, localUri);
                    } else if (location.startsWith("nbproject/private/cache/retriever/")) {
                        String localUri = "src/_references/_cache/" + location.substring("nbproject/private/cache/retriever/".length());
                        localUri = localUri.replace("../", "__/").replace("//", "/");
                        Util.copyFile(new File(projectDirectory, location), new File(buildDirectory, METAINF + localUri));
                        this.printToCatalog(catalogWriter, systemId, localUri);
                    } else if (location.startsWith("retrieved/")) {
                        String localUri = "src/_references/_retrieved/" + location.substring("retrieved/".length());
                        localUri = localUri.replace("../", "__/").replace("//", "/");
                        Util.copyFile(new File(projectDirectory, location), new File(buildDirectory, METAINF + localUri));
                        this.printToCatalog(catalogWriter, systemId, localUri);
                    } else {
                        String localUri = "src/_references/_relative/" + location;
                        localUri = localUri.replace("../", "__/").replace("//", "/");
                        Util.copyFile(new File(projectDirectory, location), new File(buildDirectory, METAINF + localUri));
                        this.printToCatalog(catalogWriter, systemId, localUri);
                    }
                    break block11;
                }
                if (uri.getScheme().equals("nb-uri")) {
                    Project project = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)sourceDirectory));
                    this.processNbUriLocation(project, systemId, location, buildDirectory, catalogWriter);
                    break block11;
                }
                throw new CatalogPackagingException("This URI is not supported: " + location);
            }
            catch (IOException e) {
                throw new CatalogPackagingException(e);
            }
            catch (URISyntaxException e) {
                throw new CatalogPackagingException(e);
            }
        }
    }

    private void processNbUriLocation(Project project, String namespace, String location, File buildDirectory, PrintWriter catalogWriter) throws CatalogPackagingException {
        try {
            FileObject refdFileObject = this.getCatalogSupport(project).resolveProjectProtocol(new URI(location));
            File refdFile = FileUtil.toFile((FileObject)refdFileObject);
            Project refdProject = FileOwnerQuery.getOwner((FileObject)refdFileObject);
            String refdProjectDirName = refdProject.getProjectDirectory().getName();
            String refdFilePath = Util.getRelativePath(FileUtil.toFile((FileObject)refdProject.getProjectDirectory()), refdFile);
            String localUri = "src/_references/_projects/" + refdProjectDirName + "/" + refdFilePath;
            localUri = localUri.replace("../", "__/").replace("//", "/");
            Util.copyFile(refdFile, new File(buildDirectory, METAINF + localUri));
            this.printToCatalog(catalogWriter, namespace, localUri);
            this.processImports(refdFile, refdProject, buildDirectory, catalogWriter);
        }
        catch (IOException e) {
            throw new CatalogPackagingException(e);
        }
        catch (URISyntaxException e) {
            throw new CatalogPackagingException(e);
        }
    }

    private void processImports(File file, Project project, File buildDirectory, PrintWriter catalogWriter) throws CatalogPackagingException {
        try {
            File projectDirectory = FileUtil.toFile((FileObject)project.getProjectDirectory());
            String projectDirname = projectDirectory.getName();
            String catalogPath = new File(FileUtil.toFile((FileObject)project.getProjectDirectory()), "catalog.xml").getAbsolutePath();
            CatalogReader catalogReader = new CatalogReader(catalogPath);
            List<String> systemIds = catalogReader.getSystemIds();
            List<String> locations = catalogReader.getLocations();
            List<String> imports = this.parseImports(file);
            for (String key : imports) {
                URI uri;
                String location;
                String systemId;
                int index = systemIds.indexOf(key);
                if (index != -1) {
                    systemId = systemIds.get(index);
                    location = locations.get(index);
                    uri = new URI(location);
                    if (uri.getScheme() == null) {
                        File refdFile;
                        String localUri;
                        if (location.startsWith("src/")) {
                            localUri = "src/_references/_projects/" + projectDirname + "/" + location;
                            localUri = localUri.replace("../", "__/").replace("//", "/");
                            refdFile = new File(projectDirectory, location);
                            Util.copyFile(refdFile, new File(buildDirectory, METAINF + localUri));
                            this.printToCatalog(catalogWriter, systemId, localUri);
                            this.processImports(refdFile, project, buildDirectory, catalogWriter);
                            continue;
                        }
                        if (location.startsWith("nbproject/private/cache/retriever/")) {
                            localUri = "src/_references/_projects/" + projectDirname + "/_references/_cache/" + location.substring("nbproject/private/cache/retriever/".length());
                            localUri = localUri.replace("../", "__/").replace("//", "/");
                            refdFile = new File(projectDirectory, location);
                            Util.copyFile(refdFile, new File(buildDirectory, METAINF + localUri));
                            this.printToCatalog(catalogWriter, systemId, localUri);
                            this.processImports(refdFile, project, buildDirectory, catalogWriter);
                            continue;
                        }
                        if (location.startsWith("retrieved/")) {
                            localUri = "src/_references/_projects/" + projectDirname + "/_references/_retrieved/" + location.substring("retrieved/".length());
                            localUri = localUri.replace("../", "__/").replace("//", "/");
                            refdFile = new File(projectDirectory, location);
                            Util.copyFile(refdFile, new File(buildDirectory, METAINF + localUri));
                            this.printToCatalog(catalogWriter, systemId, localUri);
                            this.processImports(refdFile, project, buildDirectory, catalogWriter);
                            continue;
                        }
                        localUri = "src/_references/_projects/" + projectDirname + "/_references/_relative/" + location;
                        localUri = localUri.replace("../", "__/").replace("//", "/");
                        refdFile = new File(projectDirectory, location);
                        Util.copyFile(refdFile, new File(buildDirectory, METAINF + localUri));
                        this.printToCatalog(catalogWriter, systemId, localUri);
                        this.processImports(refdFile, project, buildDirectory, catalogWriter);
                        continue;
                    }
                    if (uri.getScheme().equals("nb-uri")) {
                        this.processNbUriLocation(project, systemId, location, buildDirectory, catalogWriter);
                        continue;
                    }
                    throw new CatalogPackagingException("This URI is not supported: " + location);
                }
                systemId = key;
                location = key;
                uri = new URI(location);
                if (uri.getScheme() == null) {
                    String localUri;
                    File refdFile = new File(file.getParentFile(), location);
                    String refdFileRelativePath = Util.getRelativePath(projectDirectory, refdFile);
                    if (!refdFileRelativePath.startsWith("..")) {
                        localUri = "src/_references/_projects/" + projectDirname + "/" + refdFileRelativePath;
                        Util.copyFile(refdFile, new File(buildDirectory, METAINF + localUri));
                    } else {
                        localUri = "src/_references/_projects/" + projectDirname + "/_references/_relative/" + location;
                        localUri = localUri.replace("../", "__/").replace("//", "/");
                        Util.copyFile(refdFile, new File(buildDirectory, METAINF + localUri));
                        this.printToCatalog(catalogWriter, systemId, localUri);
                    }
                    this.processImports(refdFile, project, buildDirectory, catalogWriter);
                    continue;
                }
                throw new CatalogPackagingException("This URI is not supported: " + location);
            }
        }
        catch (IOException e) {
            throw new CatalogPackagingException(e);
        }
        catch (URISyntaxException e) {
            throw new CatalogPackagingException(e);
        }
        catch (SAXException e) {
            throw new CatalogPackagingException(e);
        }
    }

    private List<String> parseImports(File file) throws CatalogPackagingException {
        MyHandler handler = new MyHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(file, (DefaultHandler)handler);
        }
        catch (IOException e) {
            throw new CatalogPackagingException(e);
        }
        catch (SAXException e) {
            throw new CatalogPackagingException(e);
        }
        catch (ParserConfigurationException e) {
            throw new CatalogPackagingException(e);
        }
        return handler.getLocations();
    }

    private void printToCatalog(PrintWriter writer, String systemId, String uri) {
        writer.println("    <system systemId=\"" + systemId + "\" " + "uri=\"" + uri.replace("\\", "/") + "\"/>");
    }

    private DefaultProjectCatalogSupport getCatalogSupport(Project project) {
        AntProjectHelper antHelper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
        ReferenceHelper referenceHelper = (ReferenceHelper)project.getLookup().lookup(ReferenceHelper.class);
        return new DefaultProjectCatalogSupport(project, antHelper, referenceHelper);
    }

    public static class CatalogPackagingException
    extends Exception {
        public CatalogPackagingException(String message) {
            super(message);
        }

        public CatalogPackagingException(Throwable cause) {
            super(cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyHandler
    extends DefaultHandler {
        private List<String> locations = new LinkedList<String>();

        private MyHandler() {
        }

        public List<String> getLocations() {
            return this.locations;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.endsWith("import")) {
                String wsdlLocation = attributes.getValue("location");
                String schemaLocation = attributes.getValue("schemaLocation");
                String location = wsdlLocation == null ? schemaLocation : wsdlLocation;
                this.locations.add(location);
            }
        }
    }
}

