/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tigris.subversion.javahl.BlameCallback;
import org.tigris.subversion.javahl.BlameCallback2;
import org.tigris.subversion.javahl.BlameCallbackImpl;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.ChangelistCallback;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.CommitMessage;
import org.tigris.subversion.javahl.ConflictResolverCallback;
import org.tigris.subversion.javahl.CopySource;
import org.tigris.subversion.javahl.Depth;
import org.tigris.subversion.javahl.DiffSummaryReceiver;
import org.tigris.subversion.javahl.DirEntry;
import org.tigris.subversion.javahl.Info;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.javahl.InfoCallback;
import org.tigris.subversion.javahl.ListCallback;
import org.tigris.subversion.javahl.Lock;
import org.tigris.subversion.javahl.LogDate;
import org.tigris.subversion.javahl.LogMessage;
import org.tigris.subversion.javahl.LogMessageCallback;
import org.tigris.subversion.javahl.Mergeinfo;
import org.tigris.subversion.javahl.NativeResources;
import org.tigris.subversion.javahl.Notify;
import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.ProgressListener;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.ProplistCallback;
import org.tigris.subversion.javahl.ProplistCallbackImpl;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.RevisionRange;
import org.tigris.subversion.javahl.SVNClientInterface;
import org.tigris.subversion.javahl.SVNClientLogLevel;
import org.tigris.subversion.javahl.Status;
import org.tigris.subversion.javahl.StatusCallback;
import org.tigris.subversion.javahl.SubversionException;
import org.tigris.subversion.javahl.Version;

public class SVNClient
implements SVNClientInterface {
    protected long cppAddr = this.ctNative();

    static {
        NativeResources.loadNativeLibrary();
    }

    public SVNClient() {
        try {
            this.setConfigDirectory(null);
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    private native long ctNative();

    public native void dispose();

    protected native void finalize();

    public Version getVersion() {
        return NativeResources.version;
    }

    public native String getAdminDirectoryName();

    public native boolean isAdminDirectory(String var1);

    public native String getLastPath();

    public Status singleStatus(String path, boolean onServer) throws ClientException {
        return this.status(path, false, onServer, true, false, false)[0];
    }

    public Status[] status(String path, boolean descend, boolean onServer, boolean getAll) throws ClientException {
        return this.status(path, descend, onServer, getAll, false);
    }

    public Status[] status(String path, boolean descend, boolean onServer, boolean getAll, boolean noIgnore) throws ClientException {
        return this.status(path, descend, onServer, getAll, noIgnore, false);
    }

    public Status[] status(String path, boolean descend, boolean onServer, boolean getAll, boolean noIgnore, boolean ignoreExternals) throws ClientException {
        MyStatusCallback callback = new MyStatusCallback();
        this.status(path, Depth.unknownOrImmediates(descend), onServer, getAll, noIgnore, ignoreExternals, null, callback);
        return callback.getStatusArray();
    }

    public native void status(String var1, int var2, boolean var3, boolean var4, boolean var5, boolean var6, String[] var7, StatusCallback var8) throws ClientException;

    public DirEntry[] list(String url, Revision revision, boolean recurse) throws ClientException {
        return this.list(url, revision, revision, recurse);
    }

    public DirEntry[] list(String url, Revision revision, Revision pegRevision, boolean recurse) throws ClientException {
        MyListCallback callback = new MyListCallback();
        this.list(url, revision, pegRevision, Depth.infinityOrImmediates(recurse), -1, false, callback);
        return callback.getDirEntryArray();
    }

    public native void list(String var1, Revision var2, Revision var3, int var4, int var5, boolean var6, ListCallback var7) throws ClientException;

    public native void username(String var1);

    public native void password(String var1);

    public native void setPrompt(PromptUserPassword var1);

    public LogMessage[] logMessages(String path, Revision revisionStart, Revision revisionEnd) throws ClientException {
        return this.logMessages(path, revisionStart, revisionEnd, true, false);
    }

    public LogMessage[] logMessages(String path, Revision revisionStart, Revision revisionEnd, boolean stopOnCopy) throws ClientException {
        return this.logMessages(path, revisionStart, revisionEnd, stopOnCopy, false);
    }

    public LogMessage[] logMessages(String path, Revision revisionStart, Revision revisionEnd, boolean stopOnCopy, boolean discoverPath) throws ClientException {
        return this.logMessages(path, revisionStart, revisionEnd, stopOnCopy, discoverPath, 0L);
    }

    public LogMessage[] logMessages(String path, Revision revisionStart, Revision revisionEnd, boolean stopOnCopy, boolean discoverPath, long limit) throws ClientException {
        MyLogMessageCallback callback = new MyLogMessageCallback();
        String[] revProps = new String[]{"svn:log", "svn:date", "svn:author"};
        this.logMessages(path, revisionEnd, revisionStart, revisionEnd, stopOnCopy, discoverPath, false, revProps, limit, callback);
        return callback.getMessages();
    }

    public native void logMessages(String var1, Revision var2, Revision var3, Revision var4, boolean var5, boolean var6, boolean var7, String[] var8, long var9, LogMessageCallback var11) throws ClientException;

    public long checkout(String moduleName, String destPath, Revision revision, boolean recurse) throws ClientException {
        return this.checkout(moduleName, destPath, revision, revision, recurse, false);
    }

    public long checkout(String moduleName, String destPath, Revision revision, Revision pegRevision, boolean recurse, boolean ignoreExternals) throws ClientException {
        return this.checkout(moduleName, destPath, revision, revision, Depth.infinityOrFiles(recurse), ignoreExternals, false);
    }

    public native long checkout(String var1, String var2, Revision var3, Revision var4, int var5, boolean var6, boolean var7) throws ClientException;

    public native void notification(Notify var1);

    public native void notification2(Notify2 var1);

    public native void setConflictResolver(ConflictResolverCallback var1);

    public native void setProgressListener(ProgressListener var1);

    public native void commitMessageHandler(CommitMessage var1);

    public void remove(String[] path, String message, boolean force) throws ClientException {
        this.remove(path, message, force, false, null);
    }

    public native void remove(String[] var1, String var2, boolean var3, boolean var4, Map var5) throws ClientException;

    public void revert(String path, boolean recurse) throws ClientException {
        this.revert(path, Depth.infinityOrEmpty(recurse), null);
    }

    public native void revert(String var1, int var2, String[] var3) throws ClientException;

    public void add(String path, boolean recurse) throws ClientException {
        this.add(path, recurse, false);
    }

    public void add(String path, boolean recurse, boolean force) throws ClientException {
        this.add(path, Depth.infinityOrEmpty(recurse), force, false, false);
    }

    public native void add(String var1, int var2, boolean var3, boolean var4, boolean var5) throws ClientException;

    public long update(String path, Revision revision, boolean recurse) throws ClientException {
        return this.update(new String[]{path}, revision, recurse, false)[0];
    }

    public long[] update(String[] path, Revision revision, boolean recurse, boolean ignoreExternals) throws ClientException {
        return this.update(path, revision, Depth.unknownOrFiles(recurse), false, ignoreExternals, false);
    }

    public long update(String path, Revision revision, int depth, boolean depthIsSticky, boolean ignoreExternals, boolean allowUnverObstructions) throws ClientException {
        return this.update(new String[]{path}, revision, depth, depthIsSticky, ignoreExternals, allowUnverObstructions)[0];
    }

    public native long[] update(String[] var1, Revision var2, int var3, boolean var4, boolean var5, boolean var6) throws ClientException;

    public long commit(String[] path, String message, boolean recurse) throws ClientException {
        return this.commit(path, message, recurse, false);
    }

    public long commit(String[] path, String message, boolean recurse, boolean noUnlock) throws ClientException {
        return this.commit(path, message, Depth.infinityOrEmpty(recurse), noUnlock, false, null, null);
    }

    public native long commit(String[] var1, String var2, int var3, boolean var4, boolean var5, String[] var6, Map var7) throws ClientException;

    public native void copy(CopySource[] var1, String var2, String var3, boolean var4, boolean var5, Map var6) throws ClientException;

    public void copy(String srcPath, String destPath, String message, Revision revision) throws ClientException {
        this.copy(new CopySource[]{new CopySource(srcPath, revision, Revision.HEAD)}, destPath, message, true, false, null);
    }

    public native void move(String[] var1, String var2, String var3, boolean var4, boolean var5, boolean var6, Map var7) throws ClientException;

    public void move(String srcPath, String destPath, String message, Revision ignored, boolean force) throws ClientException {
        this.move(new String[]{srcPath}, destPath, message, force, true, false, null);
    }

    public void move(String srcPath, String destPath, String message, boolean force) throws ClientException {
        this.move(new String[]{srcPath}, destPath, message, force, true, false, null);
    }

    public native void mkdir(String[] var1, String var2, boolean var3, Map var4) throws ClientException;

    public void mkdir(String[] path, String message) throws ClientException {
        this.mkdir(path, message, false, null);
    }

    public native void cleanup(String var1) throws ClientException;

    public void resolved(String path, boolean recurse) throws ClientException {
        try {
            this.resolve(path, Depth.infinityOrEmpty(recurse), 6);
        }
        catch (SubversionException e) {
            throw ClientException.fromException(e);
        }
    }

    public native void resolve(String var1, int var2, int var3) throws SubversionException;

    public long doExport(String srcPath, String destPath, Revision revision, boolean force) throws ClientException {
        return this.doExport(srcPath, destPath, revision, revision, force, false, true, null);
    }

    public long doExport(String srcPath, String destPath, Revision revision, Revision pegRevision, boolean force, boolean ignoreExternals, boolean recurse, String nativeEOL) throws ClientException {
        return this.doExport(srcPath, destPath, revision, pegRevision, force, ignoreExternals, Depth.infinityOrFiles(recurse), nativeEOL);
    }

    public native long doExport(String var1, String var2, Revision var3, Revision var4, boolean var5, boolean var6, int var7, String var8) throws ClientException;

    public long doSwitch(String path, String url, Revision revision, boolean recurse) throws ClientException {
        return this.doSwitch(path, url, revision, Revision.HEAD, Depth.unknownOrFiles(recurse), false, false, false);
    }

    public native long doSwitch(String var1, String var2, Revision var3, Revision var4, int var5, boolean var6, boolean var7, boolean var8) throws ClientException;

    public void doImport(String path, String url, String message, boolean recurse) throws ClientException {
        this.doImport(path, url, message, Depth.infinityOrFiles(recurse), false, false, null);
    }

    public native void doImport(String var1, String var2, String var3, int var4, boolean var5, boolean var6, Map var7) throws ClientException;

    public native String[] suggestMergeSources(String var1, Revision var2) throws SubversionException;

    public void merge(String path1, Revision revision1, String path2, Revision revision2, String localPath, boolean force, boolean recurse) throws ClientException {
        this.merge(path1, revision1, path2, revision2, localPath, force, recurse, false, false);
    }

    public void merge(String path1, Revision revision1, String path2, Revision revision2, String localPath, boolean force, boolean recurse, boolean ignoreAncestry, boolean dryRun) throws ClientException {
        this.merge(path1, revision1, path2, revision2, localPath, force, Depth.infinityOrFiles(recurse), ignoreAncestry, dryRun, false);
    }

    public native void merge(String var1, Revision var2, String var3, Revision var4, String var5, boolean var6, int var7, boolean var8, boolean var9, boolean var10) throws ClientException;

    public void merge(String path, Revision pegRevision, Revision revision1, Revision revision2, String localPath, boolean force, boolean recurse, boolean ignoreAncestry, boolean dryRun) throws ClientException {
        RevisionRange[] ranges = new RevisionRange[]{new RevisionRange(revision1, revision2)};
        this.merge(path, pegRevision, ranges, localPath, force, Depth.infinityOrFiles(recurse), ignoreAncestry, dryRun, false);
    }

    public native void merge(String var1, Revision var2, RevisionRange[] var3, String var4, boolean var5, int var6, boolean var7, boolean var8, boolean var9) throws ClientException;

    public native void mergeReintegrate(String var1, Revision var2, String var3, boolean var4) throws ClientException;

    public native Mergeinfo getMergeinfo(String var1, Revision var2) throws SubversionException;

    public native void getMergeinfoLog(int var1, String var2, Revision var3, String var4, Revision var5, boolean var6, String[] var7, LogMessageCallback var8) throws ClientException;

    public void diff(String target1, Revision revision1, String target2, Revision revision2, String outFileName, boolean recurse) throws ClientException {
        this.diff(target1, revision1, target2, revision2, outFileName, recurse, true, false, false);
    }

    public void diff(String target1, Revision revision1, String target2, Revision revision2, String outFileName, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws ClientException {
        this.diff(target1, revision1, target2, revision2, null, outFileName, Depth.unknownOrFiles(recurse), null, ignoreAncestry, noDiffDeleted, force);
    }

    public native void diff(String var1, Revision var2, String var3, Revision var4, String var5, String var6, int var7, String[] var8, boolean var9, boolean var10, boolean var11) throws ClientException;

    public void diff(String target, Revision pegRevision, Revision startRevision, Revision endRevision, String outFileName, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws ClientException {
        this.diff(target, pegRevision, startRevision, endRevision, null, outFileName, Depth.unknownOrFiles(recurse), null, ignoreAncestry, noDiffDeleted, force);
    }

    public native void diff(String var1, Revision var2, Revision var3, Revision var4, String var5, String var6, int var7, String[] var8, boolean var9, boolean var10, boolean var11) throws ClientException;

    public native void diffSummarize(String var1, Revision var2, String var3, Revision var4, int var5, String[] var6, boolean var7, DiffSummaryReceiver var8) throws ClientException;

    public native void diffSummarize(String var1, Revision var2, Revision var3, Revision var4, int var5, String[] var6, boolean var7, DiffSummaryReceiver var8) throws ClientException;

    public PropertyData[] properties(String path) throws ClientException {
        return this.properties(path, null);
    }

    public PropertyData[] properties(String path, Revision revision) throws ClientException {
        return this.properties(path, revision, revision);
    }

    public PropertyData[] properties(String path, Revision revision, Revision pegRevision) throws ClientException {
        ProplistCallbackImpl callback = new ProplistCallbackImpl();
        this.properties(path, revision, pegRevision, 0, null, callback);
        Map propMap = callback.getProperties(path);
        if (propMap == null) {
            return new PropertyData[0];
        }
        PropertyData[] props = new PropertyData[propMap.size()];
        Iterator it = propMap.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            String key = (String)it.next();
            props[i] = new PropertyData(path, key, (String)propMap.get(key));
            ++i;
        }
        return props;
    }

    public native void properties(String var1, Revision var2, Revision var3, int var4, String[] var5, ProplistCallback var6) throws ClientException;

    public void propertySet(String path, String name, String value, boolean recurse) throws ClientException {
        this.propertySet(path, name, value, recurse, false);
    }

    public void propertySet(String path, String name, String value, boolean recurse, boolean force) throws ClientException {
        this.propertySet(path, name, value, Depth.infinityOrEmpty(recurse), null, force, null);
    }

    public void propertySet(String path, String name, byte[] value, boolean recurse) throws ClientException {
        this.propertySet(path, name, value, recurse, false);
    }

    public void propertySet(String path, String name, byte[] value, boolean recurse, boolean force) throws ClientException {
        this.propertySet(path, name, new String(value), recurse, force);
    }

    public native void propertySet(String var1, String var2, String var3, int var4, String[] var5, boolean var6, Map var7) throws ClientException;

    public void propertyRemove(String path, String name, boolean recurse) throws ClientException {
        this.propertyRemove(path, name, Depth.infinityOrEmpty(recurse), null);
    }

    public void propertyRemove(String path, String name, int depth, String[] changelists) throws ClientException {
        this.propertySet(path, name, null, depth, changelists, false, null);
    }

    public void propertyCreate(String path, String name, String value, boolean recurse) throws ClientException {
        this.propertyCreate(path, name, value, recurse, false);
    }

    public void propertyCreate(String path, String name, String value, boolean recurse, boolean force) throws ClientException {
        this.propertySet(path, name, value, recurse, force);
    }

    public void propertyCreate(String path, String name, byte[] value, boolean recurse) throws ClientException {
        this.propertyCreate(path, name, value, recurse, false);
    }

    public void propertyCreate(String path, String name, byte[] value, boolean recurse, boolean force) throws ClientException {
        this.propertyCreate(path, name, new String(value), recurse, force);
    }

    public void propertyCreate(String path, String name, String value, int depth, String[] changelists, boolean force) throws ClientException {
        this.propertySet(path, name, value, depth, changelists, force, null);
    }

    public native PropertyData revProperty(String var1, String var2, Revision var3) throws ClientException;

    public native PropertyData[] revProperties(String var1, Revision var2) throws ClientException;

    public native void setRevProperty(String var1, String var2, Revision var3, String var4, boolean var5) throws ClientException;

    public PropertyData propertyGet(String path, String name) throws ClientException {
        return this.propertyGet(path, name, null);
    }

    public PropertyData propertyGet(String path, String name, Revision revision) throws ClientException {
        return this.propertyGet(path, name, revision, revision);
    }

    public native PropertyData propertyGet(String var1, String var2, Revision var3, Revision var4) throws ClientException;

    public byte[] fileContent(String path, Revision revision) throws ClientException {
        return this.fileContent(path, revision, revision);
    }

    public native byte[] fileContent(String var1, Revision var2, Revision var3) throws ClientException;

    public native void streamFileContent(String var1, Revision var2, Revision var3, int var4, OutputStream var5) throws ClientException;

    public native void relocate(String var1, String var2, String var3, boolean var4) throws ClientException;

    public byte[] blame(String path, Revision revisionStart, Revision revisionEnd) throws ClientException {
        BlameCallbackImpl callback = new BlameCallbackImpl();
        this.blame(path, revisionEnd, revisionStart, revisionEnd, callback);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < callback.numberOfLines()) {
            BlameCallbackImpl.BlameLine line = callback.getBlameLine(i);
            if (line != null) {
                sb.append(line.toString());
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString().getBytes();
    }

    public void blame(String path, Revision revisionStart, Revision revisionEnd, BlameCallback callback) throws ClientException {
        this.blame(path, revisionEnd, revisionStart, revisionEnd, callback);
    }

    public void blame(String path, Revision pegRevision, Revision revisionStart, Revision revisionEnd, BlameCallback callback) throws ClientException {
        BlameCallbackWrapper cw = new BlameCallbackWrapper(callback);
        this.blame(path, pegRevision, revisionStart, revisionEnd, false, false, cw);
    }

    public native void blame(String var1, Revision var2, Revision var3, Revision var4, boolean var5, boolean var6, BlameCallback2 var7) throws ClientException;

    public native void setConfigDirectory(String var1) throws ClientException;

    public native String getConfigDirectory() throws ClientException;

    public native void cancelOperation() throws ClientException;

    public native Info info(String var1) throws ClientException;

    public native void addToChangelist(String[] var1, String var2, int var3, String[] var4) throws ClientException;

    public native void removeFromChangelists(String[] var1, int var2, String[] var3) throws ClientException;

    public native void getChangelists(String var1, String[] var2, int var3, ChangelistCallback var4) throws ClientException;

    public native String getVersionInfo(String var1, String var2, boolean var3) throws ClientException;

    public static native void enableLogging(int var0, String var1);

    public static native String version();

    public static native int versionMajor();

    public static native int versionMinor();

    public static native int versionMicro();

    public native void lock(String[] var1, String var2, boolean var3) throws ClientException;

    public native void unlock(String[] var1, boolean var2) throws ClientException;

    public Info2[] info2(String pathOrUrl, Revision revision, Revision pegRevision, boolean recurse) throws ClientException {
        MyInfoCallback callback = new MyInfoCallback();
        this.info2(pathOrUrl, revision, pegRevision, Depth.infinityOrEmpty(recurse), null, callback);
        return callback.getInfoArray();
    }

    public native void info2(String var1, Revision var2, Revision var3, int var4, String[] var5, InfoCallback var6) throws ClientException;

    private class BlameCallbackWrapper
    implements BlameCallback2 {
        private BlameCallback oldCallback;

        public BlameCallbackWrapper(BlameCallback callback) {
            this.oldCallback = callback;
        }

        public void singleLine(Date date, long revision, String author, Date merged_date, long merged_revision, String merged_author, String merged_path, String line) {
            this.oldCallback.singleLine(date, revision, author, line);
        }
    }

    public static final class LogLevel
    implements SVNClientLogLevel {
    }

    private class MyInfoCallback
    implements InfoCallback {
        private List infos = new ArrayList();

        private MyInfoCallback() {
        }

        public void singleInfo(Info2 info) {
            this.infos.add(info);
        }

        public Info2[] getInfoArray() {
            return this.infos.toArray(new Info2[this.infos.size()]);
        }
    }

    private class MyListCallback
    implements ListCallback {
        private List dirents = new ArrayList();

        private MyListCallback() {
        }

        public void doEntry(DirEntry dirent, Lock lock) {
            if (dirent.getPath().length() == 0) {
                if (dirent.getNodeKind() == 1) {
                    String absPath = dirent.getAbsPath();
                    int lastSeparator = absPath.lastIndexOf(47);
                    String path = absPath.substring(lastSeparator, absPath.length());
                    dirent.setPath(path);
                } else {
                    return;
                }
            }
            this.dirents.add(dirent);
        }

        public DirEntry[] getDirEntryArray() {
            return this.dirents.toArray(new DirEntry[this.dirents.size()]);
        }
    }

    private class MyLogMessageCallback
    implements LogMessageCallback {
        private List messages = new ArrayList();

        private MyLogMessageCallback() {
        }

        public void singleMessage(ChangePath[] changedPaths, long revision, Map revprops, boolean hasChildren) {
            long timeMicros;
            String author = (String)revprops.get("svn:author");
            String message = (String)revprops.get("svn:log");
            try {
                LogDate date = new LogDate((String)revprops.get("svn:date"));
                timeMicros = date.getTimeMicros();
            }
            catch (ParseException ex) {
                timeMicros = 0L;
            }
            LogMessage msg = new LogMessage(changedPaths, revision, author, timeMicros, message);
            if (revision != -1L) {
                this.messages.add(msg);
            }
        }

        public LogMessage[] getMessages() {
            return this.messages.toArray(new LogMessage[this.messages.size()]);
        }
    }

    private class MyStatusCallback
    implements StatusCallback {
        private List statuses = new ArrayList();

        private MyStatusCallback() {
        }

        public void doStatus(Status status) {
            this.statuses.add(status);
        }

        public Status[] getStatusArray() {
            return this.statuses.toArray(new Status[this.statuses.size()]);
        }
    }
}

