/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.nodes.property;

import java.beans.PropertyEditor;
import java.util.List;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.xml.namespace.QName;
import org.netbeans.modules.sun.manager.jbi.editors.ComboBoxPropertyEditor;
import org.netbeans.modules.sun.manager.jbi.editors.PasswordEditor;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentConfigurationDescriptor;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentConfigurationMBeanAttributeInfo;
import org.netbeans.modules.sun.manager.jbi.management.model.constraint.EnumerationConstraint;
import org.netbeans.modules.sun.manager.jbi.management.model.constraint.JBIComponentConfigurationConstraint;
import org.netbeans.modules.sun.manager.jbi.management.model.constraint.MaxExclusiveConstraint;
import org.netbeans.modules.sun.manager.jbi.management.model.constraint.MaxInclusiveConstraint;
import org.netbeans.modules.sun.manager.jbi.management.model.constraint.MinExclusiveConstraint;
import org.netbeans.modules.sun.manager.jbi.management.model.constraint.MinInclusiveConstraint;
import org.netbeans.modules.sun.manager.jbi.nodes.property.ApplicationConfigurationsPropertySupport;
import org.netbeans.modules.sun.manager.jbi.nodes.property.ApplicationVariablesPropertySupport;
import org.netbeans.modules.sun.manager.jbi.nodes.property.PropertySheetOwner;
import org.netbeans.modules.sun.manager.jbi.nodes.property.SchemaBasedConfigPropertySupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaBasedConfigPropertySupportFactory {
    public static PropertySupport getPropertySupport(PropertySheetOwner propertySheetOwner, Attribute attribute, JBIComponentConfigurationMBeanAttributeInfo jBIComponentConfigurationMBeanAttributeInfo) {
        JBIComponentConfigurationDescriptor jBIComponentConfigurationDescriptor = jBIComponentConfigurationMBeanAttributeInfo.getConfigurationDescriptor();
        QName qName = jBIComponentConfigurationDescriptor.getTypeQName();
        List<JBIComponentConfigurationConstraint> list = jBIComponentConfigurationDescriptor.getConstraints();
        if (jBIComponentConfigurationDescriptor instanceof JBIComponentConfigurationDescriptor.ApplicationConfiguration) {
            return new ApplicationConfigurationsPropertySupport(propertySheetOwner, attribute, jBIComponentConfigurationMBeanAttributeInfo);
        }
        if (jBIComponentConfigurationDescriptor instanceof JBIComponentConfigurationDescriptor.ApplicationVariable) {
            return new ApplicationVariablesPropertySupport(propertySheetOwner, attribute, jBIComponentConfigurationMBeanAttributeInfo);
        }
        if (JBIComponentConfigurationDescriptor.XSD_STRING.equals(qName)) {
            if (list.size() == 0) {
                return SchemaBasedConfigPropertySupportFactory.getSimpleStringPropertySupport(propertySheetOwner, attribute, jBIComponentConfigurationMBeanAttributeInfo);
            }
            if (list.size() == 1 && list.get(0) instanceof EnumerationConstraint) {
                List<String> list2 = ((EnumerationConstraint)list.get(0)).getOptions();
                return SchemaBasedConfigPropertySupportFactory.getEnumeratedStringPropertySupport(propertySheetOwner, attribute, jBIComponentConfigurationMBeanAttributeInfo, list2);
            }
        } else {
            if (JBIComponentConfigurationDescriptor.XSD_INT.equals(qName) || JBIComponentConfigurationDescriptor.XSD_BYTE.equals(qName) || JBIComponentConfigurationDescriptor.XSD_SHORT.equals(qName) || JBIComponentConfigurationDescriptor.XSD_POSITIVE_INTEGER.equals(qName) || JBIComponentConfigurationDescriptor.XSD_NEGATIVE_INTEGER.equals(qName) || JBIComponentConfigurationDescriptor.XSD_NON_POSITIVE_INTEGER.equals(qName) || JBIComponentConfigurationDescriptor.XSD_NON_NEGATIVE_INTEGER.equals(qName)) {
                int n;
                int n2;
                if (JBIComponentConfigurationDescriptor.XSD_BYTE.equals(qName)) {
                    n2 = -128;
                    n = 127;
                } else if (JBIComponentConfigurationDescriptor.XSD_SHORT.equals(qName)) {
                    n2 = Short.MIN_VALUE;
                    n = Short.MAX_VALUE;
                } else if (JBIComponentConfigurationDescriptor.XSD_INT.equals(qName)) {
                    n2 = Integer.MIN_VALUE;
                    n = Integer.MAX_VALUE;
                } else if (JBIComponentConfigurationDescriptor.XSD_POSITIVE_INTEGER.equals(qName)) {
                    n2 = 1;
                    n = Integer.MAX_VALUE;
                } else if (JBIComponentConfigurationDescriptor.XSD_NEGATIVE_INTEGER.equals(qName)) {
                    n2 = Integer.MIN_VALUE;
                    n = -1;
                } else if (JBIComponentConfigurationDescriptor.XSD_NON_POSITIVE_INTEGER.equals(qName)) {
                    n2 = Integer.MIN_VALUE;
                    n = 0;
                } else {
                    n2 = 0;
                    n = Integer.MAX_VALUE;
                }
                for (JBIComponentConfigurationConstraint jBIComponentConfigurationConstraint : list) {
                    if (jBIComponentConfigurationConstraint instanceof MinInclusiveConstraint) {
                        n2 = Math.max(n2, (int)((MinInclusiveConstraint)jBIComponentConfigurationConstraint).getValue());
                        continue;
                    }
                    if (jBIComponentConfigurationConstraint instanceof MaxInclusiveConstraint) {
                        n = Math.min(n, (int)((MaxInclusiveConstraint)jBIComponentConfigurationConstraint).getValue());
                        continue;
                    }
                    if (jBIComponentConfigurationConstraint instanceof MinExclusiveConstraint) {
                        n2 = Math.max(n2, (int)((MinInclusiveConstraint)jBIComponentConfigurationConstraint).getValue() + 1);
                        continue;
                    }
                    if (jBIComponentConfigurationConstraint instanceof MaxExclusiveConstraint) {
                        n = Math.min(n, (int)((MaxInclusiveConstraint)jBIComponentConfigurationConstraint).getValue() - 1);
                        continue;
                    }
                    throw new RuntimeException("Constraint not supported yet: " + jBIComponentConfigurationConstraint.getClass().getName());
                }
                return SchemaBasedConfigPropertySupportFactory.getIntegerPropertySupport(propertySheetOwner, attribute, jBIComponentConfigurationMBeanAttributeInfo, n2, n);
            }
            if (JBIComponentConfigurationDescriptor.XSD_BOOLEAN.equals(qName)) {
                return SchemaBasedConfigPropertySupportFactory.getBooleanPropertySupport(propertySheetOwner, attribute, jBIComponentConfigurationMBeanAttributeInfo);
            }
        }
        System.out.println("NewSchemaBasedConfigPropertySupportFactory: Unsupported type: " + qName);
        return null;
    }

    public static PropertySupport getEnumeratedStringPropertySupport(PropertySheetOwner propertySheetOwner, Attribute attribute, MBeanAttributeInfo mBeanAttributeInfo, final List<String> list) {
        return new SchemaBasedConfigPropertySupport<String>(propertySheetOwner, String.class, attribute, mBeanAttributeInfo){

            public PropertyEditor getPropertyEditor() {
                return new ComboBoxPropertyEditor(list);
            }
        };
    }

    public static PropertySupport getIntegerPropertySupport(PropertySheetOwner propertySheetOwner, Attribute attribute, MBeanAttributeInfo mBeanAttributeInfo, final int n, final int n2) {
        return new SchemaBasedConfigPropertySupport<Integer>(propertySheetOwner, Integer.class, attribute, mBeanAttributeInfo){

            @Override
            public Integer getValue() {
                if (this.attr.getValue() instanceof String) {
                    String string = "The component's configuration schema indicates this attribute is of type 'int'. However, the MBean attribute is of type 'string'. Please fix the component.";
                    throw new ClassCastException(string);
                }
                return (Integer)super.getValue();
            }

            @Override
            protected boolean validate(Integer n3) {
                int n22 = Integer.parseInt(n3.toString());
                if (n22 < n || n22 > n2) {
                    String string = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_INVALID_INTEGER", (Object)n22, (Object)n, (Object)n2);
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    return false;
                }
                return true;
            }
        };
    }

    private static PropertySupport getBooleanPropertySupport(PropertySheetOwner propertySheetOwner, Attribute attribute, MBeanAttributeInfo mBeanAttributeInfo) {
        return new SchemaBasedConfigPropertySupport<Boolean>(propertySheetOwner, Boolean.class, attribute, mBeanAttributeInfo);
    }

    private static PropertySupport getSimpleStringPropertySupport(PropertySheetOwner propertySheetOwner, Attribute attribute, MBeanAttributeInfo mBeanAttributeInfo) {
        return new SchemaBasedConfigPropertySupport<String>(propertySheetOwner, String.class, attribute, mBeanAttributeInfo){

            public PropertyEditor getPropertyEditor() {
                if (this.info instanceof JBIComponentConfigurationMBeanAttributeInfo && ((JBIComponentConfigurationMBeanAttributeInfo)this.info).isEncrypted()) {
                    return new PasswordEditor();
                }
                return super.getPropertyEditor();
            }
        };
    }
}

