/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.nodes;

import com.sun.esb.management.api.administration.AdministrationService;
import com.sun.esb.management.api.deployment.DeploymentService;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.data.ServiceAssemblyStatisticsData;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import com.sun.jbi.ui.common.ServiceUnitInfo;
import java.awt.Image;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.sun.manager.jbi.actions.RefreshAction;
import org.netbeans.modules.sun.manager.jbi.actions.ShutdownAction;
import org.netbeans.modules.sun.manager.jbi.actions.StartAction;
import org.netbeans.modules.sun.manager.jbi.actions.StopAction;
import org.netbeans.modules.sun.manager.jbi.actions.UndeployAction;
import org.netbeans.modules.sun.manager.jbi.management.AppserverJBIMgmtController;
import org.netbeans.modules.sun.manager.jbi.management.JBIMBeanTaskResultHandler;
import org.netbeans.modules.sun.manager.jbi.management.wrapper.api.PerformanceMeasurementServiceWrapper;
import org.netbeans.modules.sun.manager.jbi.management.wrapper.api.RuntimeManagementServiceWrapper;
import org.netbeans.modules.sun.manager.jbi.nodes.AppserverJBIMgmtContainerNode;
import org.netbeans.modules.sun.manager.jbi.nodes.NodeType;
import org.netbeans.modules.sun.manager.jbi.nodes.Shutdownable;
import org.netbeans.modules.sun.manager.jbi.nodes.Startable;
import org.netbeans.modules.sun.manager.jbi.nodes.Stoppable;
import org.netbeans.modules.sun.manager.jbi.nodes.Undeployable;
import org.netbeans.modules.sun.manager.jbi.util.ProgressUI;
import org.netbeans.modules.sun.manager.jbi.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBIServiceAssemblyNode
extends AppserverJBIMgmtContainerNode
implements Startable,
Stoppable,
Shutdownable,
Undeployable {
    private static final String SERVICE_ASSEMBLY_STATISTICS_SHEET_SET_NAME = "SERVICE_ASSEMBLY_STATISTICS";
    private boolean busy;
    private static Logger logger = Logger.getLogger("org.netbeans.modules.sun.manager.jbi.nodes.JBIServiceAssemblyNode");

    public JBIServiceAssemblyNode(AppserverJBIMgmtController appserverJBIMgmtController, String string, String string2) {
        super(appserverJBIMgmtController, NodeType.SERVICE_ASSEMBLY);
        this.setName(string);
        this.setDisplayName(string);
        this.setShortDescription(Utils.getTooltip(string2));
        this.setValue("nodeDescription", string2);
    }

    protected Sheet createSheet() {
        Sheet sheet = new Sheet();
        this.addSheetSet(sheet, "GENERAL", "LBL_GENERAL_PROPERTIES", "DSC_GENERAL_PROPERTIES", this.getGeneralSheetSetProperties());
        try {
            this.addSheetSet(sheet, SERVICE_ASSEMBLY_STATISTICS_SHEET_SET_NAME, "LBL_SERVICE_ASSEMBLY_STATISTICS_PROPERTIES", "DSC_SERVICE_ASSEMBLY_STATISTICS_PROPERTIES", this.getServiceAssemblyStatisticsSheetSetProperties());
        }
        catch (ManagementRemoteException managementRemoteException) {
            logger.warning(managementRemoteException.getMessage());
        }
        return sheet;
    }

    private Map<Attribute, MBeanAttributeInfo> getServiceAssemblyStatisticsSheetSetProperties() throws ManagementRemoteException {
        AppserverJBIMgmtController appserverJBIMgmtController = this.getAppserverJBIMgmtController();
        PerformanceMeasurementServiceWrapper performanceMeasurementServiceWrapper = appserverJBIMgmtController.getPerformanceMeasurementServiceWrapper();
        ServiceAssemblyStatisticsData serviceAssemblyStatisticsData = performanceMeasurementServiceWrapper.getServiceAssemblyStatistics(this.getName(), "server");
        return Utils.getIntrospectedPropertyMap(serviceAssemblyStatisticsData, true);
    }

    public ServiceAssemblyInfo getAssemblyInfo() {
        try {
            return this.getRuntimeManagementServiceWrapper().getServiceAssembly(this.getName(), "server");
        }
        catch (ManagementRemoteException managementRemoteException) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)managementRemoteException.getMessage(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return null;
        }
    }

    private String getAssemblyState() {
        ServiceAssemblyInfo serviceAssemblyInfo = this.getAssemblyInfo();
        return serviceAssemblyInfo != null ? serviceAssemblyInfo.getState() : null;
    }

    private void clearServiceAssemblyStatusCache() {
        this.getRuntimeManagementServiceWrapper().clearServiceAssemblyStatusCache();
    }

    public Image getIcon(int n) {
        String string = "resources/ServiceAssembly.png";
        String string2 = this.getAssemblyState();
        String string3 = null;
        if (this.busy) {
            string3 = "resources/waiting.png";
        } else if ("Shutdown".equals(string2)) {
            string3 = "resources/not_deployed.png";
        } else if ("Stopped".equals(string2)) {
            string3 = "resources/down.png";
        } else if (!"Started".equals(string2)) {
            string3 = "resources/unknown.png";
        }
        return Utils.getBadgedIcon(this.getClass(), string, null, string3);
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    @Override
    public Action[] getActions(boolean bl) {
        return new SystemAction[]{SystemAction.get(StartAction.class), SystemAction.get(StopAction.class), SystemAction.get(ShutdownAction.Normal.class), SystemAction.get(UndeployAction.Normal.class), null, SystemAction.get(UndeployAction.Force.class), null, SystemAction.get(PropertiesAction.class), SystemAction.get(RefreshAction.class)};
    }

    @Override
    public void refresh() {
        RuntimeManagementServiceWrapper runtimeManagementServiceWrapper = this.getRuntimeManagementServiceWrapper();
        runtimeManagementServiceWrapper.clearServiceAssemblyStatusCache();
        super.refresh();
        this.fireIconChange();
        this.setSheet(this.createSheet());
    }

    private Map<Attribute, MBeanAttributeInfo> getGeneralSheetSetProperties() {
        ServiceAssemblyInfo serviceAssemblyInfo = this.getAssemblyInfo();
        return Utils.getIntrospectedPropertyMap(serviceAssemblyInfo, true, "org.netbeans.modules.sun.manager.jbi.management.model.beaninfo");
    }

    @Override
    public Attribute setSheetProperty(String string, Object object) {
        return null;
    }

    private void setBusy(boolean bl) {
        this.busy = bl;
        this.fireIconChange();
    }

    private void updatePropertySheet() {
        Sheet sheet = this.createSheet();
        this.setSheet(sheet);
        this.firePropertySetsChange(null, null);
    }

    @Override
    protected boolean needRefresh(String string) {
        return false;
    }

    @Override
    public boolean canStart() {
        boolean bl = false;
        if (!this.busy) {
            List list;
            String string;
            ServiceAssemblyInfo serviceAssemblyInfo = this.getAssemblyInfo();
            String string2 = string = serviceAssemblyInfo != null ? serviceAssemblyInfo.getState() : null;
            if ("Stopped".equals(string)) {
                bl = true;
            } else if ("Shutdown".equals(string)) {
                bl = true;
            } else if ("Started".equals(string) && (list = serviceAssemblyInfo.getServiceUnitInfoList()) != null) {
                for (ServiceUnitInfo serviceUnitInfo : list) {
                    String string3 = serviceUnitInfo.getState();
                    if (!"Stopped".equals(string3) && !"Shutdown".equals(string3)) continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        RuntimeManagementServiceWrapper runtimeManagementServiceWrapper = this.getRuntimeManagementServiceWrapper();
        if (runtimeManagementServiceWrapper == null) {
            return;
        }
        String string = this.getName();
        String string2 = NbBundle.getMessage(JBIServiceAssemblyNode.class, (String)"LBL_Starting_Service_Assembly", (Object[])new Object[]{string});
        final ProgressUI progressUI = new ProgressUI(string2, false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JBIServiceAssemblyNode.this.setBusy(true);
                progressUI.start();
            }
        });
        String string3 = null;
        try {
            string3 = runtimeManagementServiceWrapper.startServiceAssembly(string, "server");
        }
        catch (ManagementRemoteException managementRemoteException) {
            string3 = managementRemoteException.getMessage();
        }
        finally {
            JBIMBeanTaskResultHandler.showRemoteInvokationResult("startServiceAssembly", string, string3);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JBIServiceAssemblyNode.this.clearServiceAssemblyStatusCache();
                progressUI.finish();
                JBIServiceAssemblyNode.this.setBusy(false);
                JBIServiceAssemblyNode.this.updatePropertySheet();
            }
        });
    }

    @Override
    public boolean canStop() {
        boolean bl = false;
        if (!this.busy) {
            List list;
            String string;
            ServiceAssemblyInfo serviceAssemblyInfo = this.getAssemblyInfo();
            String string2 = string = serviceAssemblyInfo != null ? serviceAssemblyInfo.getState() : null;
            if ("Started".equals(string)) {
                bl = true;
            } else if ("Stopped".equals(string) && (list = serviceAssemblyInfo.getServiceUnitInfoList()) != null) {
                for (ServiceUnitInfo serviceUnitInfo : list) {
                    String string3 = serviceUnitInfo.getState();
                    if (!"Started".equals(string3)) continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        RuntimeManagementServiceWrapper runtimeManagementServiceWrapper = this.getRuntimeManagementServiceWrapper();
        if (runtimeManagementServiceWrapper == null) {
            return;
        }
        String string = this.getName();
        String string2 = NbBundle.getMessage(JBIServiceAssemblyNode.class, (String)"LBL_Stopping_Service_Assembly", (Object[])new Object[]{string});
        final ProgressUI progressUI = new ProgressUI(string2, false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JBIServiceAssemblyNode.this.setBusy(true);
                progressUI.start();
            }
        });
        String string3 = null;
        try {
            string3 = runtimeManagementServiceWrapper.stopServiceAssembly(string, "server");
        }
        catch (ManagementRemoteException managementRemoteException) {
            string3 = managementRemoteException.getMessage();
        }
        finally {
            JBIMBeanTaskResultHandler.showRemoteInvokationResult("stopServiceAssembly", string, string3);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JBIServiceAssemblyNode.this.clearServiceAssemblyStatusCache();
                progressUI.finish();
                JBIServiceAssemblyNode.this.setBusy(false);
                JBIServiceAssemblyNode.this.updatePropertySheet();
            }
        });
    }

    @Override
    public boolean canShutdown(boolean bl) {
        boolean bl2 = this.canStop();
        if (!bl2 && !this.busy) {
            List list;
            String string;
            ServiceAssemblyInfo serviceAssemblyInfo = this.getAssemblyInfo();
            String string2 = string = serviceAssemblyInfo != null ? serviceAssemblyInfo.getState() : null;
            if ("Stopped".equals(string)) {
                bl2 = true;
            } else if ("Shutdown".equals(string) && (list = serviceAssemblyInfo.getServiceUnitInfoList()) != null) {
                for (ServiceUnitInfo serviceUnitInfo : list) {
                    String string3 = serviceUnitInfo.getState();
                    if ("Shutdown".equals(string3)) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean bl) {
        RuntimeManagementServiceWrapper runtimeManagementServiceWrapper;
        if (this.canStop()) {
            this.stop();
        }
        if ((runtimeManagementServiceWrapper = this.getRuntimeManagementServiceWrapper()) == null) {
            return;
        }
        String string = this.getName();
        String string2 = NbBundle.getMessage(JBIServiceAssemblyNode.class, (String)"LBL_Shutting_Down_Service_Assembly", (Object[])new Object[]{string});
        final ProgressUI progressUI = new ProgressUI(string2, false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JBIServiceAssemblyNode.this.setBusy(true);
                progressUI.start();
            }
        });
        String string3 = null;
        try {
            string3 = runtimeManagementServiceWrapper.shutdownServiceAssembly(string, bl, "server");
        }
        catch (ManagementRemoteException managementRemoteException) {
            string3 = managementRemoteException.getMessage();
        }
        finally {
            JBIMBeanTaskResultHandler.showRemoteInvokationResult("shutdownServiceAssembly", string, string3);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JBIServiceAssemblyNode.this.clearServiceAssemblyStatusCache();
                progressUI.finish();
                JBIServiceAssemblyNode.this.setBusy(false);
                JBIServiceAssemblyNode.this.updatePropertySheet();
            }
        });
    }

    @Override
    public boolean canUndeploy(boolean bl) {
        String string = this.getAssemblyState();
        return bl || this.canShutdown(bl) || !this.busy && "Shutdown".equals(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean undeploy(boolean bl) {
        DeploymentService deploymentService;
        this.clearServiceAssemblyStatusCache();
        if (this.canShutdown(bl)) {
            this.shutdown(bl);
        }
        if ((deploymentService = this.getDeploymentService()) == null) {
            return false;
        }
        String string = this.getName();
        String string2 = NbBundle.getMessage(JBIServiceAssemblyNode.class, (String)"LBL_Undeploying_Service_Assembly", (Object[])new Object[]{string});
        final ProgressUI progressUI = new ProgressUI(string2, false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JBIServiceAssemblyNode.this.setBusy(true);
                progressUI.start();
            }
        });
        boolean bl2 = true;
        String string3 = null;
        try {
            string3 = deploymentService.undeployServiceAssembly(string, bl, "server");
        }
        catch (ManagementRemoteException managementRemoteException) {
            string3 = managementRemoteException.getMessage();
        }
        finally {
            bl2 = JBIMBeanTaskResultHandler.showRemoteInvokationResult("undeployServiceAssembly", string, string3);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JBIServiceAssemblyNode.this.clearServiceAssemblyStatusCache();
                progressUI.finish();
                JBIServiceAssemblyNode.this.setBusy(false);
            }
        });
        return bl2;
    }

    public String getDeploymentDescriptor() {
        String string = null;
        AdministrationService administrationService = this.getAdministrationService();
        String string2 = this.getName();
        try {
            string = administrationService.getServiceAssemblyDeploymentDescriptor(string2);
        }
        catch (ManagementRemoteException managementRemoteException) {
            managementRemoteException.printStackTrace();
        }
        return string;
    }
}

