/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.nodes;

import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.jbi.ui.common.JBIComponentInfo;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import com.sun.jbi.ui.common.ServiceUnitInfo;
import java.util.List;
import org.netbeans.modules.sun.manager.jbi.management.AppserverJBIMgmtController;
import org.netbeans.modules.sun.manager.jbi.management.wrapper.api.RuntimeManagementServiceWrapper;
import org.netbeans.modules.sun.manager.jbi.nodes.JBIComponentContainerNode;
import org.netbeans.modules.sun.manager.jbi.nodes.JBIComponentNode;
import org.netbeans.modules.sun.manager.jbi.nodes.JBIServiceAssembliesNode;
import org.netbeans.modules.sun.manager.jbi.nodes.JBIServiceAssemblyNode;
import org.netbeans.modules.sun.manager.jbi.nodes.JBIServiceUnitNode;
import org.netbeans.modules.sun.manager.jbi.nodes.NodeType;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class JBIContainerChildFactory {
    private AppserverJBIMgmtController controller;

    public JBIContainerChildFactory(AppserverJBIMgmtController appserverJBIMgmtController) {
        this.controller = appserverJBIMgmtController;
    }

    public Children getChildren(Node node, NodeType nodeType) {
        Children.Array array = new Children.Array();
        try {
            array.add(this.getChildrenObject(node, nodeType));
        }
        catch (ManagementRemoteException managementRemoteException) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)managementRemoteException.getMessage(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        return array;
    }

    public Node[] getChildrenObject(Node node, NodeType nodeType) throws ManagementRemoteException {
        Node[] nodeArray = new Node[]{};
        if (NodeType.JBI.equals((Object)nodeType)) {
            nodeArray = this.createJBIChildren();
        } else if (NodeType.SERVICE_ASSEMBLIES.equals((Object)nodeType)) {
            nodeArray = this.createServiceAssembliesChildren();
        } else if (NodeType.SERVICE_ASSEMBLY.equals((Object)nodeType)) {
            nodeArray = this.createServiceAssemblyChildren((JBIServiceAssemblyNode)node);
        } else if (NodeType.SERVICE_ENGINES.equals((Object)nodeType) || NodeType.BINDING_COMPONENTS.equals((Object)nodeType) || NodeType.SHARED_LIBRARIES.equals((Object)nodeType)) {
            nodeArray = this.createJBIComponentContainerChildren(nodeType);
        }
        return nodeArray;
    }

    private Node[] createJBIChildren() {
        return new Node[]{new JBIComponentContainerNode.ServiceEngines(this.controller), new JBIComponentContainerNode.BindingComponents(this.controller), new JBIComponentContainerNode.SharedLibraries(this.controller), new JBIServiceAssembliesNode(this.controller)};
    }

    private Node[] createJBIComponentContainerChildren(NodeType nodeType) throws ManagementRemoteException {
        RuntimeManagementServiceWrapper runtimeManagementServiceWrapper = this.controller.getRuntimeManagementServiceWrapper();
        List<JBIComponentInfo> list = null;
        if (NodeType.SERVICE_ENGINES.equals((Object)nodeType)) {
            list = runtimeManagementServiceWrapper.listServiceEngines("server");
        } else if (NodeType.BINDING_COMPONENTS.equals((Object)nodeType)) {
            list = runtimeManagementServiceWrapper.listBindingComponents("server");
        } else if (NodeType.SHARED_LIBRARIES.equals((Object)nodeType)) {
            list = runtimeManagementServiceWrapper.listSharedLibraries("server");
        } else assert (false);
        Node[] nodeArray = new Node[list.size()];
        int n = 0;
        for (JBIComponentInfo jBIComponentInfo : list) {
            String string = jBIComponentInfo.getName();
            String string2 = jBIComponentInfo.getDescription();
            JBIComponentNode jBIComponentNode = NodeType.SERVICE_ENGINES.equals((Object)nodeType) ? new JBIComponentNode.ServiceEngine(this.controller, string, string2) : (NodeType.BINDING_COMPONENTS.equals((Object)nodeType) ? new JBIComponentNode.BindingComponent(this.controller, string, string2) : new JBIComponentNode.SharedLibrary(this.controller, string, string2));
            nodeArray[n++] = jBIComponentNode;
        }
        return nodeArray;
    }

    private Node[] createServiceAssembliesChildren() throws ManagementRemoteException {
        RuntimeManagementServiceWrapper runtimeManagementServiceWrapper = this.controller.getRuntimeManagementServiceWrapper();
        List<ServiceAssemblyInfo> list = runtimeManagementServiceWrapper.listServiceAssemblies("server");
        Node[] nodeArray = new Node[list.size()];
        int n = 0;
        for (ServiceAssemblyInfo serviceAssemblyInfo : list) {
            String string = serviceAssemblyInfo.getName();
            String string2 = serviceAssemblyInfo.getDescription();
            nodeArray[n++] = new JBIServiceAssemblyNode(this.controller, string, string2);
        }
        return nodeArray;
    }

    private Node[] createServiceAssemblyChildren(JBIServiceAssemblyNode jBIServiceAssemblyNode) {
        ServiceAssemblyInfo serviceAssemblyInfo = jBIServiceAssemblyNode.getAssemblyInfo();
        List list = serviceAssemblyInfo.getServiceUnitInfoList();
        Node[] nodeArray = new Node[list.size()];
        int n = 0;
        for (ServiceUnitInfo serviceUnitInfo : list) {
            String string = serviceUnitInfo.getName();
            String string2 = serviceUnitInfo.getDescription();
            nodeArray[n++] = new JBIServiceUnitNode(this.controller, string, string, string2);
        }
        return nodeArray;
    }
}

