/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.nodes;

import com.sun.esb.management.api.administration.AdministrationService;
import com.sun.esb.management.api.configuration.ConfigurationService;
import com.sun.esb.management.api.installation.InstallationService;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.data.ComponentStatisticsData;
import com.sun.jbi.ui.common.JBIComponentInfo;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.openmbean.CompositeData;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.sun.manager.jbi.actions.AdvancedAction;
import org.netbeans.modules.sun.manager.jbi.actions.RefreshAction;
import org.netbeans.modules.sun.manager.jbi.actions.ShowComponentEndpointsStatisticsAction;
import org.netbeans.modules.sun.manager.jbi.actions.ShutdownAction;
import org.netbeans.modules.sun.manager.jbi.actions.StartAction;
import org.netbeans.modules.sun.manager.jbi.actions.StopAction;
import org.netbeans.modules.sun.manager.jbi.actions.UndeployAction;
import org.netbeans.modules.sun.manager.jbi.actions.UninstallAction;
import org.netbeans.modules.sun.manager.jbi.actions.UpgradeAction;
import org.netbeans.modules.sun.manager.jbi.management.AppserverJBIMgmtController;
import org.netbeans.modules.sun.manager.jbi.management.JBIComponentType;
import org.netbeans.modules.sun.manager.jbi.management.JBIMBeanTaskResultHandler;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentActionDescriptor;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentConfigurationDescriptor;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentConfigurationMBeanAttributeInfo;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentConfigurationParser;
import org.netbeans.modules.sun.manager.jbi.management.wrapper.api.PerformanceMeasurementServiceWrapper;
import org.netbeans.modules.sun.manager.jbi.management.wrapper.api.RuntimeManagementServiceWrapper;
import org.netbeans.modules.sun.manager.jbi.nodes.AppserverJBIMgmtLeafNode;
import org.netbeans.modules.sun.manager.jbi.nodes.JBIArtifactValidator;
import org.netbeans.modules.sun.manager.jbi.nodes.JBIComponentContainerNode;
import org.netbeans.modules.sun.manager.jbi.nodes.JBINode;
import org.netbeans.modules.sun.manager.jbi.nodes.NodeType;
import org.netbeans.modules.sun.manager.jbi.nodes.Refreshable;
import org.netbeans.modules.sun.manager.jbi.nodes.Shutdownable;
import org.netbeans.modules.sun.manager.jbi.nodes.Startable;
import org.netbeans.modules.sun.manager.jbi.nodes.Stoppable;
import org.netbeans.modules.sun.manager.jbi.nodes.Undeployable;
import org.netbeans.modules.sun.manager.jbi.nodes.Uninstallable;
import org.netbeans.modules.sun.manager.jbi.nodes.Upgradeable;
import org.netbeans.modules.sun.manager.jbi.nodes.property.SchemaBasedConfigPropertySupportFactory;
import org.netbeans.modules.sun.manager.jbi.util.ComparableAttribute;
import org.netbeans.modules.sun.manager.jbi.util.DoNotShowAgainConfirmation;
import org.netbeans.modules.sun.manager.jbi.util.FileFilters;
import org.netbeans.modules.sun.manager.jbi.util.ProgressUI;
import org.netbeans.modules.sun.manager.jbi.util.StackTraceUtil;
import org.netbeans.modules.sun.manager.jbi.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JBIComponentNode
extends AppserverJBIMgmtLeafNode
implements Refreshable,
Startable,
Stoppable,
Shutdownable,
Uninstallable,
Undeployable,
Upgradeable {
    public static final String ENVIRONMENT_VARIABLES_NAME = "EnvironmentVariables";
    public static final String APPLICATION_VARIABLES_NAME = "ApplicationVariables";
    public static final String APPLICATION_CONFIGURATIONS_NAME = "ApplicationConfigurations";
    public static final String LAST_JBI_COMPONENT_INSTALLATION_DIRECTORY = "lastJBIComponentInstallationDir";
    private static final String IDENTIFICATION_SHEET_SET_NAME = "IDENTIFICATION";
    private static final String LOGGERS_SHEET_SET_NAME = "LOGGERS";
    private static final String CONFIGURATION_SHEET_SET_NAME = "CONFIGURATION";
    private static final String COMPONENT_STATISTICS_SHEET_SET_NAME = "COMPONENT_STATISTICS";
    private static final String ACTIONABLE_MBEAN_NAME = "ManagementActions";
    private static final String ACTIONABLE_MBEAN_GET_ACTIONS_OPERATION_NAME = "getActions";
    private boolean busy;
    private JBIComponentType compType;
    private JBIComponentConfigurationDescriptor rootConfigDescriptor;
    private boolean hasJbiXmlBeenChecked;
    private static boolean confirmComponentUninstallation = true;
    private static boolean confirmComponentShutdownDuringUpgrade = true;
    private static boolean confirmForServiceAssembliesUndeployment = true;
    private static Logger logger = Logger.getLogger("org.netbeans.modules.sun.manager.jbi.nodes.JBIComponentNode");

    public JBIComponentNode(AppserverJBIMgmtController appserverJBIMgmtController, JBIComponentType jBIComponentType, NodeType nodeType, String string, String string2) {
        super(appserverJBIMgmtController, nodeType);
        this.setName(string);
        this.setDisplayName(string);
        this.setShortDescription(Utils.getTooltip(string2));
        this.setValue("nodeDescription", string2);
        this.compType = jBIComponentType;
    }

    protected Sheet createSheet() {
        Sheet.Set set;
        Sheet sheet = new Sheet();
        this.addSheetSet(sheet, "GENERAL", "LBL_GENERAL_PROPERTIES", "DSC_GENERAL_PROPERTIES", this.getGeneralSheetSetProperties());
        try {
            String string = this.getInstallationDescriptor();
            set = JBIComponentNode.getIdentificationSheetSetProperties(string);
            this.addSheetSet(sheet, IDENTIFICATION_SHEET_SET_NAME, "LBL_IDENTIFICATION_PROPERTIES", "DSC_IDENTIFICATION_PROPERTIES", (Map<Attribute, ? extends MBeanAttributeInfo>)set);
        }
        catch (Exception exception) {
            logger.warning(exception.getMessage());
        }
        try {
            Object object;
            String string;
            Object object2;
            boolean bl = false;
            set = sheet.get("GENERAL");
            if (set != null && (object2 = set.get("State")) != null && (string = (String)object2.getValue()) != null && string.equalsIgnoreCase("started")) {
                bl = true;
            }
            if (bl && !this.hasJbiXmlBeenChecked) {
                object2 = this.getName();
                string = this.getAdministrationService();
                object = string.getComponentInstallationDescriptor((String)object2);
                this.rootConfigDescriptor = JBIComponentConfigurationParser.parse((String)object);
                this.hasJbiXmlBeenChecked = true;
            }
            object2 = this.getConfigurationSheetSetProperties();
            string = null;
            if (this.rootConfigDescriptor != null) {
                object = this.createPropertySupportArrayWithSchema((Map<Attribute, JBIComponentConfigurationMBeanAttributeInfo>)object2);
                string = this.createSheetSet(CONFIGURATION_SHEET_SET_NAME, "LBL_CONFIG_PROPERTIES", "DSC_CONFIG_PROPERTIES", (PropertySupport[])object);
            } else {
                string = this.createSheetSet(CONFIGURATION_SHEET_SET_NAME, "LBL_CONFIG_PROPERTIES", "DSC_CONFIG_PROPERTIES", (Map<Attribute, ? extends MBeanAttributeInfo>)object2);
            }
            if (string != null) {
                sheet.put((Sheet.Set)string);
            }
        }
        catch (Exception exception) {
            logger.warning(exception.getMessage());
        }
        if ("Started".equals(this.getState())) {
            try {
                this.addSheetSet(sheet, COMPONENT_STATISTICS_SHEET_SET_NAME, "LBL_COMPONENT_STATISTICS_PROPERTIES", "DSC_COMPONENT_STATISTICS_PROPERTIES", this.getComponentStatisticsSheetSetProperties());
            }
            catch (Exception exception) {
                logger.warning(exception.getMessage());
            }
        }
        return sheet;
    }

    private Map<Attribute, MBeanAttributeInfo> getComponentStatisticsSheetSetProperties() throws ManagementRemoteException {
        AppserverJBIMgmtController appserverJBIMgmtController = this.getAppserverJBIMgmtController();
        PerformanceMeasurementServiceWrapper performanceMeasurementServiceWrapper = appserverJBIMgmtController.getPerformanceMeasurementServiceWrapper();
        ComponentStatisticsData componentStatisticsData = performanceMeasurementServiceWrapper.getComponentStatistics(this.getName(), "server");
        return Utils.getIntrospectedPropertyMap(componentStatisticsData, true);
    }

    protected PropertySupport[] createPropertySupportArrayWithSchema(Map<Attribute, JBIComponentConfigurationMBeanAttributeInfo> map) {
        ArrayList<PropertySupport> arrayList = new ArrayList<PropertySupport>();
        try {
            String string = this.getName();
            for (Attribute attribute : map.keySet()) {
                JBIComponentConfigurationMBeanAttributeInfo jBIComponentConfigurationMBeanAttributeInfo;
                PropertySupport propertySupport = SchemaBasedConfigPropertySupportFactory.getPropertySupport(this, attribute, jBIComponentConfigurationMBeanAttributeInfo = map.get(attribute));
                if (propertySupport == null) {
                    String string2 = "Failed to get property support for " + string + ":" + attribute.getName() + ". " + "Missing definition in configuration schema.";
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    continue;
                }
                arrayList.add(propertySupport);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList.toArray(new PropertySupport[0]);
    }

    protected Map<Attribute, MBeanAttributeInfo> getGeneralSheetSetProperties() {
        JBIComponentInfo jBIComponentInfo = this.getJBIComponentInfo();
        return Utils.getIntrospectedPropertyMap(jBIComponentInfo, false, "org.netbeans.modules.sun.manager.jbi.management.model.beaninfo");
    }

    private Map<Attribute, ? extends MBeanAttributeInfo> getConfigurationSheetSetProperties() throws ManagementRemoteException {
        LinkedHashMap<Attribute, MBeanAttributeInfo> linkedHashMap;
        block11: {
            linkedHashMap = new LinkedHashMap<Attribute, MBeanAttributeInfo>();
            ConfigurationService configurationService = this.getConfigurationService();
            String string = this.getName();
            Map map = configurationService.getComponentConfigurationAsMap(string, "server");
            try {
                if (this.rootConfigDescriptor == null) {
                    Object object;
                    Object object2;
                    Object object32;
                    ArrayList arrayList = new ArrayList();
                    if (map != null) {
                        arrayList.addAll(map.keySet());
                    }
                    Collections.sort(arrayList);
                    for (Object object32 : arrayList) {
                        object2 = map.get(object32);
                        Attribute attribute = new Attribute((String)object32, object2);
                        MBeanAttributeInfo mBeanAttributeInfo = new MBeanAttributeInfo((String)object32, object2.getClass().getName(), (String)object32, true, true, false);
                        linkedHashMap.put(attribute, mBeanAttributeInfo);
                    }
                    if (!"Started".equals(this.getState())) break block11;
                    try {
                        if (configurationService.isAppVarsSupported(string, "server")) {
                            object = configurationService.getApplicationVariablesAsTabularData(string, "server");
                            object32 = new Attribute(APPLICATION_VARIABLES_NAME, object);
                            object2 = new MBeanAttributeInfo(APPLICATION_VARIABLES_NAME, "javax.management.openmbean.TabularData", "Application variables", true, true, false);
                            linkedHashMap.put((Attribute)object32, (MBeanAttributeInfo)object2);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    try {
                        if (configurationService.isAppConfigSupported(string, "server")) {
                            object = configurationService.getApplicationConfigurationsAsTabularData(string, "server");
                            object32 = new Attribute(APPLICATION_CONFIGURATIONS_NAME, object);
                            object2 = new MBeanAttributeInfo(APPLICATION_CONFIGURATIONS_NAME, "javax.management.openmbean.TabularData", "Application configurations", true, true, false);
                            linkedHashMap.put((Attribute)object32, (MBeanAttributeInfo)object2);
                        }
                        break block11;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break block11;
                }
                this.addProperty(linkedHashMap, this.rootConfigDescriptor, configurationService, map);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return linkedHashMap;
    }

    private void addProperty(Map<Attribute, MBeanAttributeInfo> map, JBIComponentConfigurationDescriptor jBIComponentConfigurationDescriptor, ConfigurationService configurationService, Map<String, Object> map2) throws ManagementRemoteException {
        String string = jBIComponentConfigurationDescriptor.getName();
        Object object = null;
        if (jBIComponentConfigurationDescriptor instanceof JBIComponentConfigurationDescriptor.ApplicationConfiguration) {
            if ("Started".equals(this.getState())) {
                object = configurationService.getApplicationConfigurationsAsTabularData(this.getName(), "server");
            }
        } else if (jBIComponentConfigurationDescriptor instanceof JBIComponentConfigurationDescriptor.ApplicationVariable) {
            if ("Started".equals(this.getState())) {
                object = configurationService.getApplicationVariablesAsTabularData(this.getName(), "server");
            }
        } else if (jBIComponentConfigurationDescriptor.isProperty()) {
            if (!jBIComponentConfigurationDescriptor.showDisplayAtRuntime()) {
                return;
            }
            object = map2.get(string);
        } else {
            for (JBIComponentConfigurationDescriptor object2 : jBIComponentConfigurationDescriptor.getChildren()) {
                this.addProperty(map, object2, configurationService, map2);
            }
        }
        if (object != null) {
            Attribute attribute = new Attribute(string, object);
            JBIComponentConfigurationMBeanAttributeInfo jBIComponentConfigurationMBeanAttributeInfo = new JBIComponentConfigurationMBeanAttributeInfo(jBIComponentConfigurationDescriptor, object.getClass().getName(), true, true, false);
            map.put(attribute, jBIComponentConfigurationMBeanAttributeInfo);
        }
    }

    @Override
    public Attribute setSheetProperty(String string, Object object) {
        if (StackTraceUtil.isCalledBy("org.openide.explorer.propertysheet.PropertyDialogManager", "cancelValue")) {
            return new Attribute(string, object);
        }
        try {
            ConfigurationService configurationService = this.getConfigurationService();
            String string2 = this.getName();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(string, object);
            configurationService.setComponentConfiguration(string2, hashMap, "server");
            object = configurationService.getComponentConfigurationAsMap(string2, "server").get(string);
        }
        catch (ManagementRemoteException managementRemoteException) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)managementRemoteException.getMessage(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        return new Attribute(string, object);
    }

    public Attribute setLoggerSheetProperty(String string, Level level) {
        try {
            ConfigurationService configurationService = this.getConfigurationService();
            String string2 = this.getName();
            configurationService.setComponentLoggerLevel(string2, string, level, "server", null);
            this.updatePropertySheet();
        }
        catch (Exception exception) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)exception.getMessage(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            level = null;
        }
        return new Attribute(string, level);
    }

    public String setApplicationVariable(String string, CompositeData compositeData) throws ManagementRemoteException {
        ConfigurationService configurationService = this.getConfigurationService();
        String string2 = this.getName();
        return configurationService.setApplicationVariable(string2, "server", string, compositeData);
    }

    public String addApplicationVariable(String string, CompositeData compositeData) throws ManagementRemoteException {
        ConfigurationService configurationService = this.getConfigurationService();
        String string2 = this.getName();
        return configurationService.addApplicationVariable(string2, "server", string, compositeData);
    }

    public String deleteApplicationVariable(String string) throws ManagementRemoteException {
        ConfigurationService configurationService = this.getConfigurationService();
        String string2 = this.getName();
        return configurationService.deleteApplicationVariables(string2, "server", new String[]{string});
    }

    public String setApplicationConfiguration(String string, CompositeData compositeData) throws ManagementRemoteException {
        ConfigurationService configurationService = this.getConfigurationService();
        String string2 = this.getName();
        return configurationService.setApplicationConfiguration(string2, "server", string, compositeData);
    }

    public String addApplicationConfiguration(String string, CompositeData compositeData) throws ManagementRemoteException {
        ConfigurationService configurationService = this.getConfigurationService();
        String string2 = this.getName();
        return configurationService.addApplicationConfiguration(string2, "server", string, compositeData);
    }

    public String deleteApplicationConfiguration(String string) throws ManagementRemoteException {
        ConfigurationService configurationService = this.getConfigurationService();
        String string2 = this.getName();
        return configurationService.deleteApplicationConfiguration(string2, "server", string);
    }

    @Override
    public void refresh() {
        this.setSheet(this.createSheet());
    }

    public Image getIcon(int n) {
        String string = this.getState();
        String string2 = this.getIconName(string);
        String string3 = null;
        if (this.busy) {
            string3 = "resources/waiting.png";
        } else if ("Shutdown".equals(string)) {
            string3 = this.getInstalledIconBadgeName();
        } else if ("Stopped".equals(string)) {
            string3 = this.getStoppedIconBadgeName();
        } else if (!"Started".equals(string)) {
            string3 = this.getUnknownIconBadgeName();
        }
        return Utils.getBadgedIcon(this.getClass(), string2, null, string3);
    }

    protected String getInstalledIconBadgeName() {
        return "resources/not_deployed.png";
    }

    protected String getStoppedIconBadgeName() {
        return "resources/down.png";
    }

    protected String getUnknownIconBadgeName() {
        return "resources/unknown.png";
    }

    private void setBusy(boolean bl) {
        this.busy = bl;
        this.fireIconChange();
    }

    private JBIComponentInfo getJBIComponentInfo() {
        RuntimeManagementServiceWrapper runtimeManagementServiceWrapper = this.getRuntimeManagementServiceWrapper();
        if (runtimeManagementServiceWrapper != null) {
            try {
                return runtimeManagementServiceWrapper.getJBIComponent(this.compType, this.getName(), "server");
            }
            catch (ManagementRemoteException managementRemoteException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)managementRemoteException.getMessage(), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        }
        return null;
    }

    private void clearJBIComponentStatusCache(JBIComponentType jBIComponentType) {
        this.getRuntimeManagementServiceWrapper().clearJBIComponentStatusCache(jBIComponentType);
    }

    private String getState() {
        JBIComponentInfo jBIComponentInfo = this.getJBIComponentInfo();
        return jBIComponentInfo == null ? null : jBIComponentInfo.getState();
    }

    private void updatePropertySheet() {
        Sheet sheet = this.createSheet();
        this.setSheet(sheet);
        this.firePropertySetsChange(null, null);
    }

    @Override
    public boolean canStart() {
        String string = this.getState();
        return !this.busy && ("Stopped".equals(string) || "Shutdown".equals(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        RuntimeManagementServiceWrapper runtimeManagementServiceWrapper = this.getRuntimeManagementServiceWrapper();
        if (runtimeManagementServiceWrapper == null) {
            return;
        }
        String string = this.getStartProgressLabel();
        String string2 = this.getName();
        String string3 = NbBundle.getMessage(JBIComponentNode.class, (String)string, (Object[])new Object[]{string2});
        final ProgressUI progressUI = new ProgressUI(string3, false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JBIComponentNode.this.setBusy(true);
                progressUI.start();
            }
        });
        String string4 = null;
        try {
            string4 = runtimeManagementServiceWrapper.startComponent(string2, "server");
        }
        catch (ManagementRemoteException managementRemoteException) {
            string4 = managementRemoteException.getMessage();
        }
        finally {
            JBIMBeanTaskResultHandler.showRemoteInvokationResult("startComponent", string2, string4);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JBIComponentNode.this.clearJBIComponentStatusCache(JBIComponentNode.this.compType);
                progressUI.finish();
                JBIComponentNode.this.setBusy(false);
                JBIComponentNode.this.updatePropertySheet();
            }
        });
    }

    @Override
    public boolean canStop() {
        return !this.busy && "Started".equals(this.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        RuntimeManagementServiceWrapper runtimeManagementServiceWrapper = this.getRuntimeManagementServiceWrapper();
        if (runtimeManagementServiceWrapper == null) {
            return;
        }
        String string = this.getStopProgressLabel();
        String string2 = this.getName();
        String string3 = NbBundle.getMessage(JBIComponentNode.class, (String)string, (Object[])new Object[]{string2});
        final ProgressUI progressUI = new ProgressUI(string3, false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JBIComponentNode.this.setBusy(true);
                progressUI.start();
            }
        });
        String string4 = null;
        try {
            string4 = runtimeManagementServiceWrapper.stopComponent(string2, "server");
        }
        catch (ManagementRemoteException managementRemoteException) {
            string4 = managementRemoteException.getMessage();
        }
        finally {
            JBIMBeanTaskResultHandler.showRemoteInvokationResult("stopComponent", string2, string4);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JBIComponentNode.this.clearJBIComponentStatusCache(JBIComponentNode.this.compType);
                progressUI.finish();
                JBIComponentNode.this.setBusy(false);
                JBIComponentNode.this.updatePropertySheet();
            }
        });
    }

    @Override
    public boolean canShutdown(boolean bl) {
        return this.canStop() || !this.busy && "Stopped".equals(this.getState()) || bl && !"Shutdown".equals(this.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean bl) {
        RuntimeManagementServiceWrapper runtimeManagementServiceWrapper = this.getRuntimeManagementServiceWrapper();
        if (runtimeManagementServiceWrapper == null) {
            return;
        }
        if (this.canStop()) {
            this.stop();
        }
        String string = this.getShutdownProgressLabel();
        String string2 = this.getName();
        String string3 = NbBundle.getMessage(JBIComponentNode.class, (String)string, (Object[])new Object[]{string2});
        final ProgressUI progressUI = new ProgressUI(string3, false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JBIComponentNode.this.setBusy(true);
                progressUI.start();
            }
        });
        String string4 = null;
        try {
            string4 = runtimeManagementServiceWrapper.shutdownComponent(string2, bl, "server");
        }
        catch (ManagementRemoteException managementRemoteException) {
            string4 = managementRemoteException.getMessage();
        }
        finally {
            JBIMBeanTaskResultHandler.showRemoteInvokationResult("shutdownComponent", string2, string4);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JBIComponentNode.this.clearJBIComponentStatusCache(JBIComponentNode.this.compType);
                progressUI.finish();
                JBIComponentNode.this.setBusy(false);
                JBIComponentNode.this.updatePropertySheet();
            }
        });
    }

    @Override
    public boolean canUninstall(boolean bl) {
        return bl || this.canShutdown(bl) || !this.busy && "Shutdown".equals(this.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstall(boolean bl) {
        Object object;
        String string = this.getName();
        if (confirmComponentUninstallation) {
            object = new DoNotShowAgainConfirmation((Object)NbBundle.getMessage(JBIComponentNode.class, (String)"MSG_UNINSTALL_CONFIRMATION", (Object)string), NbBundle.getMessage(JBIComponentNode.class, (String)"TTL_UNINSTALL_CONFIRMATION"), 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)object) != NotifyDescriptor.YES_OPTION) {
                return;
            }
            if (((DoNotShowAgainConfirmation)((Object)object)).getDoNotShowAgain()) {
                confirmComponentUninstallation = false;
            }
        }
        if (this.canUndeploy(bl) && !this.undeploy(bl)) {
            return;
        }
        object = this.getInstallationService();
        if (object == null) {
            return;
        }
        if (this.canShutdown(bl)) {
            this.shutdown(bl);
        }
        String string2 = this.getUninstallProgressLabel();
        String string3 = NbBundle.getMessage(JBIComponentNode.class, (String)string2, (Object[])new Object[]{string});
        final ProgressUI progressUI = new ProgressUI(string3, false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                progressUI.start();
            }
        });
        String string4 = null;
        try {
            string4 = this.uninstallComponent((InstallationService)object, string, bl);
        }
        catch (ManagementRemoteException managementRemoteException) {
            string4 = managementRemoteException.getMessage();
        }
        finally {
            JBIMBeanTaskResultHandler.showRemoteInvokationResult("uninstallComponent", string, string4);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JBIComponentNode.this.clearJBIComponentStatusCache(JBIComponentNode.this.compType);
                progressUI.finish();
            }
        });
    }

    @Override
    public boolean canUpgrade() {
        return !this.busy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upgrade() {
        InstallationService installationService = this.getInstallationService();
        if (installationService == null) {
            return;
        }
        String string = this.getName();
        JFileChooser jFileChooser = this.getJFileChooser();
        int n = jFileChooser.showDialog(null, NbBundle.getMessage(JBIComponentNode.class, (String)"LBL_Upgrade_JBI_Component_Button"));
        if (n == 0) {
            Object object;
            List<File> list;
            File[] fileArray = jFileChooser.getSelectedFiles();
            if (fileArray.length > 0) {
                System.setProperty(LAST_JBI_COMPONENT_INSTALLATION_DIRECTORY, fileArray[0].getParent());
            }
            if ((list = this.filterSelectedFiles(fileArray)).size() == 0) {
                return;
            }
            String string2 = this.getState();
            if ("Stopped".equals(string2) || "Started".equals(string2)) {
                if (confirmComponentShutdownDuringUpgrade) {
                    object = new DoNotShowAgainConfirmation((Object)NbBundle.getMessage(JBIComponentNode.class, (String)"MSG_AUTO_SHUTDOWN_COMPONENT_DURING_UPGRADE", (Object)string), NbBundle.getMessage(JBIComponentNode.class, (String)"TTL_AUTO_SHUTDOWN_COMPONENT_DURING_UPGRADE"), 0);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)object) != NotifyDescriptor.YES_OPTION) {
                        return;
                    }
                    if (((DoNotShowAgainConfirmation)((Object)object)).getDoNotShowAgain()) {
                        confirmComponentShutdownDuringUpgrade = false;
                    }
                }
                this.shutdown(false);
            }
            this.clearJBIComponentStatusCache(this.compType);
            object = this.getState();
            if ("Shutdown".equals(object)) {
                String string3 = this.getUpgradeProgressMessageLabel();
                String string4 = NbBundle.getMessage(JBIComponentContainerNode.class, (String)string3, (Object)string);
                final ProgressUI progressUI = new ProgressUI(string4, false);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JBIComponentNode.this.setBusy(true);
                        progressUI.start();
                    }
                });
                String string5 = list.get(0).getAbsolutePath();
                String string6 = null;
                try {
                    string6 = installationService.upgradeComponent(string, string5);
                }
                catch (ManagementRemoteException managementRemoteException) {
                    try {
                        string6 = managementRemoteException.getMessage();
                    }
                    catch (Throwable throwable) {
                        JBIMBeanTaskResultHandler.showRemoteInvokationResult("updateComponent", string5, string6);
                        SwingUtilities.invokeLater(new Runnable(progressUI){
                            final /* synthetic */ ProgressUI val$progressUI;
                            {
                                this.val$progressUI = progressUI;
                            }

                            public void run() {
                                this.val$progressUI.finish();
                                JBIComponentNode.this.setBusy(false);
                            }
                        });
                        throw throwable;
                    }
                    JBIMBeanTaskResultHandler.showRemoteInvokationResult("updateComponent", string5, string6);
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    return;
                }
                JBIMBeanTaskResultHandler.showRemoteInvokationResult("updateComponent", string5, string6);
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            if ("Started".equals(string2)) {
                this.start();
            }
            if ("Stopped".equals(string2)) {
                this.start();
                this.stop();
            }
        }
    }

    private List<File> filterSelectedFiles(File[] fileArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        if (documentBuilder != null) {
            for (File file : fileArray) {
                if (this.getValidator().validate(file)) {
                    arrayList.add(file);
                    continue;
                }
                String string = NbBundle.getMessage(this.getClass(), (String)"MSG_INVALID_COMPONENT_SELECTION_FOR_UPGRADE", (Object)file.getName(), (Object)this.getName());
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        }
        return arrayList;
    }

    private JFileChooser getJFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        ResourceBundle resourceBundle = NbBundle.getBundle(JBIComponentNode.class);
        String string = NbBundle.getMessage(JBIComponentNode.class, (String)"LBL_Upgrade_Chooser_Name", (Object)this.getName());
        jFileChooser.setDialogTitle(string);
        jFileChooser.setDialogType(2);
        jFileChooser.setApproveButtonMnemonic(resourceBundle.getString("Upgrade_JBI_Component_Button_Mnemonic").charAt(0));
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.addChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
        jFileChooser.addChoosableFileFilter(FileFilters.JarFileFilter.getInstance());
        jFileChooser.setApproveButtonToolTipText(NbBundle.getMessage(JBIComponentNode.class, (String)"LBL_Upgrade_JBI_Component_Button"));
        jFileChooser.getAccessibleContext().setAccessibleName(string);
        jFileChooser.getAccessibleContext().setAccessibleDescription(string);
        String string2 = System.getProperty(LAST_JBI_COMPONENT_INSTALLATION_DIRECTORY);
        if (string2 != null) {
            jFileChooser.setCurrentDirectory(new File(string2));
        }
        return jFileChooser;
    }

    private static Map<Attribute, MBeanAttributeInfo> getIdentificationSheetSetProperties(String string) throws ParserConfigurationException, SAXException, IOException {
        HashMap<Attribute, MBeanAttributeInfo> hashMap = new HashMap<Attribute, MBeanAttributeInfo>();
        if (string != null && string.startsWith("<?xml")) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
            NodeList nodeList = document.getElementsByTagNameNS("http://www.sun.com/jbi/descriptor/identification", "VersionInfo");
            if (nodeList.getLength() > 0) {
                Object object;
                Object object2;
                Element element = (Element)nodeList.item(0);
                String string2 = NbBundle.getMessage(AppserverJBIMgmtController.class, (String)"LBL_BUILD_NUMBER");
                String string3 = NbBundle.getMessage(AppserverJBIMgmtController.class, (String)"DSC_BUILD_NUMBER");
                String string4 = element.getAttribute("build-number");
                if (string4 != null) {
                    object2 = new Attribute(string2, string4);
                    object = new MBeanAttributeInfo(string2, "java.lang.String", string3, true, false, false);
                    hashMap.put((Attribute)object2, (MBeanAttributeInfo)object);
                }
                object2 = NbBundle.getMessage(AppserverJBIMgmtController.class, (String)"LBL_SPECIFICATION_VERSION");
                object = NbBundle.getMessage(AppserverJBIMgmtController.class, (String)"DSC_SPECIFICATION_VERSION");
                String string5 = element.getAttribute("specification-version");
                if (string5 != null) {
                    Attribute attribute = new Attribute((String)object2, string5);
                    MBeanAttributeInfo mBeanAttributeInfo = new MBeanAttributeInfo((String)object2, "java.lang.String", (String)object, true, false, false);
                    hashMap.put(attribute, mBeanAttributeInfo);
                }
            }
        }
        return hashMap;
    }

    protected abstract String getContainerType();

    protected abstract String getIconName(String var1);

    protected abstract String getStartProgressLabel();

    protected abstract String getStopProgressLabel();

    protected abstract String getShutdownProgressLabel();

    protected abstract String getUninstallProgressLabel();

    protected abstract String getUpgradeProgressMessageLabel();

    protected abstract String uninstallComponent(InstallationService var1, String var2, boolean var3) throws ManagementRemoteException;

    protected abstract JBIArtifactValidator getValidator();

    protected abstract String getInstallationDescriptor() throws ManagementRemoteException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SharedLibrary
    extends JBIComponentNode {
        SharedLibrary(AppserverJBIMgmtController appserverJBIMgmtController, String string, String string2) {
            super(appserverJBIMgmtController, JBIComponentType.SHARED_LIBRARY, NodeType.SHARED_LIBRARY, string, string2);
        }

        @Override
        public Action[] getActions(boolean bl) {
            return new SystemAction[]{SystemAction.get(UninstallAction.Normal.class), null, SystemAction.get(PropertiesAction.class)};
        }

        @Override
        protected String uninstallComponent(InstallationService installationService, String string, boolean bl) throws ManagementRemoteException {
            return installationService.uninstallSharedLibrary(string, bl, "server");
        }

        @Override
        protected JBIArtifactValidator getValidator() {
            return null;
        }

        @Override
        protected String getContainerType() {
            return "sharedLibraries";
        }

        @Override
        protected String getIconName(String string) {
            return "resources/SharedLibrary.png";
        }

        @Override
        protected String getStartProgressLabel() {
            return null;
        }

        @Override
        protected String getStopProgressLabel() {
            return null;
        }

        @Override
        protected String getShutdownProgressLabel() {
            return null;
        }

        @Override
        protected String getUninstallProgressLabel() {
            return "LBL_Uninstalling_Shared_Library";
        }

        @Override
        protected String getUpgradeProgressMessageLabel() {
            return null;
        }

        @Override
        protected String getInstalledIconBadgeName() {
            return null;
        }

        @Override
        protected String getStoppedIconBadgeName() {
            return null;
        }

        @Override
        protected String getUnknownIconBadgeName() {
            return null;
        }

        @Override
        protected String getInstallationDescriptor() throws ManagementRemoteException {
            AdministrationService administrationService = this.getAdministrationService();
            return administrationService.getSharedLibraryInstallationDescriptor(this.getName());
        }

        @Override
        protected Map<Attribute, MBeanAttributeInfo> getGeneralSheetSetProperties() {
            Map<Attribute, MBeanAttributeInfo> map = super.getGeneralSheetSetProperties();
            for (Attribute attribute : map.keySet()) {
                if (!attribute.getName().equals("State")) continue;
                map.remove(attribute);
                break;
            }
            return map;
        }

        @Override
        public boolean canUndeploy(boolean bl) {
            return false;
        }

        @Override
        public boolean undeploy(boolean bl) {
            throw new RuntimeException("Cannot undeploy shared library.");
        }
    }

    static class BindingComponent
    extends RealJBIComponentNode {
        BindingComponent(AppserverJBIMgmtController appserverJBIMgmtController, String string, String string2) {
            super(appserverJBIMgmtController, JBIComponentType.BINDING_COMPONENT, NodeType.BINDING_COMPONENT, string, string2);
        }

        protected JBIArtifactValidator getValidator() {
            return JBIArtifactValidator.getBindingComponentValidator(this.getName());
        }

        protected String getContainerType() {
            return "bindingComponents";
        }

        protected String getIconName(String string) {
            return "resources/BindingComponent.png";
        }

        protected String getStartProgressLabel() {
            return "LBL_Starting_Binding_Component";
        }

        protected String getStopProgressLabel() {
            return "LBL_Stopping_Binding_Component";
        }

        protected String getShutdownProgressLabel() {
            return "LBL_Shutting_Down_Binding_Component";
        }

        protected String getUninstallProgressLabel() {
            return "LBL_Uninstalling_Binding_Component";
        }

        protected String getUpgradeProgressMessageLabel() {
            return "LBL_Upgrading_Binding_Component";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ServiceEngine
    extends RealJBIComponentNode {
        ServiceEngine(AppserverJBIMgmtController appserverJBIMgmtController, String string, String string2) {
            super(appserverJBIMgmtController, JBIComponentType.SERVICE_ENGINE, NodeType.SERVICE_ENGINE, string, string2);
        }

        @Override
        protected List<Action> getExtraActions() {
            ArrayList<Action> arrayList = new ArrayList<Action>();
            ConfigurationService configurationService = this.getConfigurationService();
            assert (configurationService != null);
            String string = this.getName();
            String string2 = null;
            try {
                string2 = (String)configurationService.invokeExtensionMBeanOperation(string, JBIComponentNode.ACTIONABLE_MBEAN_NAME, JBIComponentNode.ACTIONABLE_MBEAN_GET_ACTIONS_OPERATION_NAME, new Object[0], new String[0], "server", null);
            }
            catch (ManagementRemoteException managementRemoteException) {
                managementRemoteException.printStackTrace();
            }
            if (string2 != null) {
                arrayList.addAll(JBIComponentActionDescriptor.getActions(string2));
            }
            return arrayList;
        }

        @Override
        protected JBIArtifactValidator getValidator() {
            return JBIArtifactValidator.getServiceEngineValidator(this.getName());
        }

        @Override
        protected String getContainerType() {
            return "serviceEngines";
        }

        @Override
        protected String getIconName(String string) {
            return "resources/ServiceEngine.png";
        }

        @Override
        protected String getStartProgressLabel() {
            return "LBL_Starting_Service_Engine";
        }

        @Override
        protected String getStopProgressLabel() {
            return "LBL_Stopping_Service_Engine";
        }

        @Override
        protected String getShutdownProgressLabel() {
            return "LBL_Shutting_Down_Service_Engine";
        }

        @Override
        protected String getUninstallProgressLabel() {
            return "LBL_Uninstalling_Service_Engine";
        }

        @Override
        protected String getUpgradeProgressMessageLabel() {
            return "LBL_Upgrading_Service_Engine";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class RealJBIComponentNode
    extends JBIComponentNode {
        RealJBIComponentNode(AppserverJBIMgmtController appserverJBIMgmtController, JBIComponentType jBIComponentType, NodeType nodeType, String string, String string2) {
            super(appserverJBIMgmtController, jBIComponentType, nodeType, string, string2);
        }

        @Override
        public Action[] getActions(boolean bl) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(SystemAction.get(StartAction.class));
            arrayList.add(SystemAction.get(StopAction.class));
            arrayList.add(SystemAction.get(ShutdownAction.Normal.class));
            arrayList.add(SystemAction.get(UninstallAction.Normal.class));
            arrayList.add(SystemAction.get(UpgradeAction.class));
            arrayList.add(null);
            arrayList.add(SystemAction.get(AdvancedAction.class));
            List<Action> list = this.getExtraActions();
            if (list != null && list.size() > 0) {
                arrayList.add(null);
                arrayList.addAll(list);
            }
            arrayList.add(null);
            arrayList.add(SystemAction.get(UndeployAction.Normal.class));
            arrayList.add(null);
            arrayList.add(SystemAction.get(PropertiesAction.class));
            arrayList.add(SystemAction.get(RefreshAction.class));
            arrayList.add(null);
            arrayList.add(SystemAction.get(ShowComponentEndpointsStatisticsAction.class));
            return arrayList.toArray(new Action[0]);
        }

        protected List<Action> getExtraActions() {
            return null;
        }

        @Override
        protected Sheet createSheet() {
            Sheet sheet = super.createSheet();
            try {
                this.addSheetSet(sheet, JBIComponentNode.LOGGERS_SHEET_SET_NAME, "LBL_LOGGERS_PROPERTIES", "DSC_LOGGERS_PROPERTIES", this.getLoggerSheetSetProperties());
            }
            catch (ManagementRemoteException managementRemoteException) {
                logger.warning(managementRemoteException.getMessage());
            }
            return sheet;
        }

        private Map<Attribute, MBeanAttributeInfo> getLoggerSheetSetProperties() throws ManagementRemoteException {
            TreeMap<Attribute, MBeanAttributeInfo> treeMap = new TreeMap<Attribute, MBeanAttributeInfo>();
            ConfigurationService configurationService = this.getConfigurationService();
            String string = this.getName();
            Map map = configurationService.getComponentLoggerLevels(string, "server", null);
            Map map2 = configurationService.getComponentLoggerDisplayNames(string, "server", null);
            for (String string2 : map.keySet()) {
                Level level = (Level)map.get(string2);
                String string3 = (String)map2.get(string2);
                Attribute attribute = new Attribute(string2, level);
                MBeanAttributeInfo mBeanAttributeInfo = new MBeanAttributeInfo(string3, "java.util.logging.Level", string2, true, true, false);
                treeMap.put(new ComparableAttribute(attribute), mBeanAttributeInfo);
            }
            return treeMap;
        }

        @Override
        protected String uninstallComponent(InstallationService installationService, String string, boolean bl) throws ManagementRemoteException {
            return installationService.uninstallComponent(string, bl, "server");
        }

        @Override
        protected String getInstallationDescriptor() throws ManagementRemoteException {
            AdministrationService administrationService = this.getAdministrationService();
            return administrationService.getComponentInstallationDescriptor(this.getName());
        }

        @Override
        public boolean canUndeploy(boolean bl) {
            RuntimeManagementServiceWrapper runtimeManagementServiceWrapper = this.getRuntimeManagementServiceWrapper();
            if (runtimeManagementServiceWrapper == null) {
                return false;
            }
            String string = this.getName();
            try {
                List<ServiceAssemblyInfo> list = runtimeManagementServiceWrapper.listServiceAssemblies(string, "server");
                return list.size() > 0;
            }
            catch (ManagementRemoteException managementRemoteException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)managementRemoteException.getMessage(), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return true;
            }
        }

        @Override
        public boolean undeploy(boolean bl) {
            RuntimeManagementServiceWrapper runtimeManagementServiceWrapper = this.getRuntimeManagementServiceWrapper();
            if (runtimeManagementServiceWrapper == null) {
                return false;
            }
            String string = this.getName();
            List<String> list = null;
            try {
                list = runtimeManagementServiceWrapper.getServiceAssemblyNames(string, "server");
            }
            catch (ManagementRemoteException managementRemoteException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)managementRemoteException.getMessage(), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return false;
            }
            boolean bl2 = true;
            if (list.size() > 0) {
                Object object;
                JBINode jBINode = (JBINode)this.getParentNode().getParentNode();
                Node[] nodeArray = jBINode.getChildren().getNodes();
                Node node = nodeArray[0];
                Node node2 = nodeArray[1];
                Node node3 = nodeArray[3];
                try {
                    String string2;
                    List<String> list2 = this.getNonStartedComponentsForServiceAssemblies(list);
                    if (confirmForServiceAssembliesUndeployment) {
                        String object2 = Utils.wordWrapString(list.toString(), 80, "<br>");
                        object = list2.size() > 0 ? (StackTraceUtil.isCalledBy("org.netbeans.modules.sun.manager.jbi.nodes.JBIComponentNode", "uninstall") ? NbBundle.getMessage(JBIComponentNode.class, (String)"MSG_UNDEPLOY_WITH_AUTO_COMPONENT_START_DURING_UNINSTALL_CONFIRMATION", (Object)string, (Object)object2, (Object)list2) : NbBundle.getMessage(JBIComponentNode.class, (String)"MSG_UNDEPLOY_WITH_AUTO_COMPONENT_START_CONFIRMATION", (Object)string, (Object)object2, (Object)list2)) : (StackTraceUtil.isCalledBy("org.netbeans.modules.sun.manager.jbi.nodes.JBIComponentNode", "uninstall") ? NbBundle.getMessage(JBIComponentNode.class, (String)"MSG_UNDEPLOY_DURING_UNINSTALL_CONFIRMATION", (Object)string, (Object)object2) : NbBundle.getMessage(JBIComponentNode.class, (String)"MSG_UNDEPLOY_CONFIRMATION", (Object)string, (Object)object2));
                        string2 = NbBundle.getMessage(JBIComponentNode.class, (String)"TTL_UNDEPLOY_CONFIRMATION");
                        DoNotShowAgainConfirmation doNotShowAgainConfirmation = new DoNotShowAgainConfirmation(object, string2, 0);
                        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)doNotShowAgainConfirmation) == NotifyDescriptor.NO_OPTION) {
                            return false;
                        }
                        if (doNotShowAgainConfirmation.getDoNotShowAgain()) {
                            confirmForServiceAssembliesUndeployment = false;
                        }
                    }
                    List<JBIComponentInfo> message = runtimeManagementServiceWrapper.listBindingComponents("server");
                    object = list2.iterator();
                    while (object.hasNext()) {
                        string2 = object.next();
                        boolean bl3 = false;
                        for (JBIComponentInfo jBIComponentInfo : message) {
                            if (!jBIComponentInfo.getName().equals(string2)) continue;
                            bl3 = true;
                            break;
                        }
                        Node node4 = bl3 ? this.getChildNode(node2, string2) : this.getChildNode(node, string2);
                        ((Startable)node4).start();
                    }
                }
                catch (ManagementRemoteException managementRemoteException) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)managementRemoteException.getMessage(), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    return false;
                }
                for (String string3 : list) {
                    object = this.getChildNode(node3, string3);
                    if (object == null) continue;
                    bl2 = bl2 && ((Undeployable)object).undeploy(bl);
                }
            }
            return bl2;
        }

        private Node getChildNode(Node node, String string) {
            Node[] nodeArray;
            for (Node node2 : nodeArray = node.getChildren().getNodes()) {
                if (!node2.getName().equals(string)) continue;
                return node2;
            }
            return null;
        }

        private List<String> getNonStartedComponentsForServiceAssemblies(List<String> list) throws ManagementRemoteException {
            ArrayList<String> arrayList = new ArrayList<String>();
            RuntimeManagementServiceWrapper runtimeManagementServiceWrapper = this.getRuntimeManagementServiceWrapper();
            assert (runtimeManagementServiceWrapper != null);
            AdministrationService administrationService = this.getAdministrationService();
            assert (administrationService != null);
            HashSet<String> hashSet = new HashSet<String>();
            for (String object2 : list) {
                hashSet.addAll(RealJBIComponentNode.getComponentsForServiceAssembly(administrationService, object2));
            }
            List<JBIComponentInfo> list2 = runtimeManagementServiceWrapper.listBindingComponents("server");
            List<JBIComponentInfo> list3 = runtimeManagementServiceWrapper.listServiceEngines("server");
            for (String string : hashSet) {
                String string2 = null;
                Iterator<Object> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    JBIComponentInfo jBIComponentInfo = (JBIComponentInfo)iterator.next();
                    if (!jBIComponentInfo.getName().equals(string)) continue;
                    string2 = jBIComponentInfo.getState();
                    break;
                }
                if (string2 == null) {
                    for (JBIComponentInfo jBIComponentInfo : list3) {
                        if (!jBIComponentInfo.getName().equals(string)) continue;
                        string2 = jBIComponentInfo.getState();
                        break;
                    }
                }
                if ("Started".equals(string2)) continue;
                arrayList.add(string);
            }
            return arrayList;
        }

        private static List<String> getComponentsForServiceAssembly(AdministrationService administrationService, String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                String string2 = administrationService.getServiceAssemblyDeploymentDescriptor(string);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(new InputSource(new StringReader(string2)));
                NodeList nodeList = document.getElementsByTagName("service-unit");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    String string3 = ((Element)element.getElementsByTagName("component-name").item(0)).getFirstChild().getNodeValue();
                    arrayList.add(string3);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return arrayList;
        }
    }
}

