/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.nodes;

import com.sun.esb.management.api.installation.InstallationService;
import com.sun.esb.management.common.ManagementRemoteException;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.sun.manager.jbi.actions.InstallAction;
import org.netbeans.modules.sun.manager.jbi.actions.RefreshAction;
import org.netbeans.modules.sun.manager.jbi.management.AppserverJBIMgmtController;
import org.netbeans.modules.sun.manager.jbi.management.JBIComponentType;
import org.netbeans.modules.sun.manager.jbi.management.JBIMBeanTaskResultHandler;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentConfigurationDescriptor;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentConfigurationParser;
import org.netbeans.modules.sun.manager.jbi.management.wrapper.api.RuntimeManagementServiceWrapper;
import org.netbeans.modules.sun.manager.jbi.nodes.AppserverJBIMgmtContainerNode;
import org.netbeans.modules.sun.manager.jbi.nodes.Installable;
import org.netbeans.modules.sun.manager.jbi.nodes.JBIArtifactValidator;
import org.netbeans.modules.sun.manager.jbi.nodes.JBIComponentInstallationConfigurationDialog;
import org.netbeans.modules.sun.manager.jbi.nodes.NodeType;
import org.netbeans.modules.sun.manager.jbi.util.FileFilters;
import org.netbeans.modules.sun.manager.jbi.util.ProgressUI;
import org.netbeans.modules.sun.manager.jbi.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JBIComponentContainerNode
extends AppserverJBIMgmtContainerNode
implements Installable {
    private boolean busy;
    private static Logger logger = Logger.getLogger("org.netbeans.modules.sun.manager.jbi.node.JBIComponentContainerNode");

    public JBIComponentContainerNode(AppserverJBIMgmtController appserverJBIMgmtController, NodeType nodeType, String string) {
        super(appserverJBIMgmtController, nodeType);
        this.setDisplayName(string);
    }

    public Image getIcon(int n) {
        String string = "resources/folder.png";
        String string2 = this.getBadgeIconName();
        String string3 = this.busy ? "resources/waiting.png" : null;
        return Utils.getBadgedIcon(this.getClass(), string, string2, string3);
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    @Override
    public void refresh() {
        RuntimeManagementServiceWrapper runtimeManagementServiceWrapper = this.getRuntimeManagementServiceWrapper();
        runtimeManagementServiceWrapper.clearJBIComponentStatusCache(this.getComponentType());
        super.refresh();
    }

    private void setBusy(boolean bl) {
        this.busy = bl;
        this.fireIconChange();
    }

    protected Map<Attribute, MBeanAttributeInfo> getGeneralSheetSetProperties() {
        return null;
    }

    @Override
    public Attribute setSheetProperty(String string, Object object) {
        return null;
    }

    @Override
    public void install(boolean bl) {
        List<File> list;
        InstallationService installationService = this.getInstallationService();
        assert (installationService != null);
        JFileChooser jFileChooser = this.getJFileChooser();
        int n = jFileChooser.showDialog(null, NbBundle.getMessage(JBIComponentContainerNode.class, (String)"LBL_Install_JBI_Component_Button"));
        if (n != 0) {
            return;
        }
        File[] fileArray = jFileChooser.getSelectedFiles();
        if (fileArray.length > 0) {
            System.setProperty("lastJBIComponentInstallationDir", fileArray[0].getParent());
        }
        if ((list = this.filterSelectedFiles(fileArray)).size() == 0) {
            return;
        }
        String string = this.getInstallProgressMessageLabel();
        String string2 = NbBundle.getMessage(JBIComponentContainerNode.class, (String)string);
        final ProgressUI progressUI = new ProgressUI(string2, false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JBIComponentContainerNode.this.setBusy(true);
                progressUI.start();
            }
        });
        for (File file : list) {
            String string3 = file.getAbsolutePath();
            try {
                String string4 = this.installComponent(string3);
                if (string4 == null) continue;
                String string5 = string4.toLowerCase();
                if (!(string5.contains("error") || string5.contains("warning") || string5.contains("exception") || string5.contains("info"))) {
                    if (!bl) continue;
                    try {
                        String string6 = string4;
                        RuntimeManagementServiceWrapper runtimeManagementServiceWrapper = this.getRuntimeManagementServiceWrapper();
                        string4 = runtimeManagementServiceWrapper.startComponent(string6, "server");
                        JBIMBeanTaskResultHandler.showRemoteInvokationResult("startComponent", string6, string4);
                    }
                    catch (ManagementRemoteException managementRemoteException) {
                        JBIMBeanTaskResultHandler.showRemoteInvokationResult("startComponent", string3, managementRemoteException.getMessage());
                    }
                    continue;
                }
                JBIMBeanTaskResultHandler.showRemoteInvokationResult("installComponent", string3, string4);
            }
            catch (ManagementRemoteException managementRemoteException) {
                JBIMBeanTaskResultHandler.showRemoteInvokationResult("installComponent", string3, managementRemoteException.getMessage());
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                progressUI.finish();
                JBIComponentContainerNode.this.setBusy(false);
            }
        });
    }

    private List<File> filterSelectedFiles(File[] fileArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        if (documentBuilder != null) {
            JBIArtifactValidator jBIArtifactValidator = this.getValidator();
            for (File file : fileArray) {
                if (jBIArtifactValidator.validate(file)) {
                    arrayList.add(file);
                    continue;
                }
                String string = NbBundle.getMessage(this.getClass(), (String)this.getComponentTypeLabel());
                String string2 = NbBundle.getMessage(this.getClass(), (String)"MSG_INVALID_COMPONENT_INSTALLATION", (Object)file.getName(), (Object)string);
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        }
        return arrayList;
    }

    private JFileChooser getJFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        ResourceBundle resourceBundle = NbBundle.getBundle(JBIComponentContainerNode.class);
        String string = this.getFileChooserTitleLabel();
        jFileChooser.setDialogTitle(resourceBundle.getString(string));
        jFileChooser.setDialogType(2);
        jFileChooser.setApproveButtonMnemonic(resourceBundle.getString("Install_JBI_Component_Button_Mnemonic").charAt(0));
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.addChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
        jFileChooser.addChoosableFileFilter(FileFilters.JarFileFilter.getInstance());
        jFileChooser.setApproveButtonToolTipText(resourceBundle.getString("LBL_Install_JBI_Component_Button"));
        jFileChooser.getAccessibleContext().setAccessibleName(resourceBundle.getString(string));
        jFileChooser.getAccessibleContext().setAccessibleDescription(resourceBundle.getString(string));
        String string2 = System.getProperty("lastJBIComponentInstallationDir");
        if (string2 != null) {
            jFileChooser.setCurrentDirectory(new File(string2));
        }
        return jFileChooser;
    }

    protected abstract String installComponent(String var1) throws ManagementRemoteException;

    protected abstract String getFileChooserTitleLabel();

    protected abstract String getInstallProgressMessageLabel();

    protected abstract String getBadgeIconName();

    protected abstract JBIArtifactValidator getValidator();

    protected abstract String getComponentTypeLabel();

    protected abstract JBIComponentType getComponentType();

    static class SharedLibraries
    extends JBIComponentContainerNode {
        SharedLibraries(AppserverJBIMgmtController appserverJBIMgmtController) {
            super(appserverJBIMgmtController, NodeType.SHARED_LIBRARIES, NbBundle.getMessage(JBIComponentContainerNode.class, (String)"SHARED_LIBRARIES"));
        }

        public Action[] getActions(boolean bl) {
            return new SystemAction[]{SystemAction.get(InstallAction.InstallOnly.class), null, SystemAction.get(RefreshAction.class)};
        }

        protected String installComponent(String string) throws ManagementRemoteException {
            InstallationService installationService = this.getInstallationService();
            return installationService.installSharedLibrary(string, "server");
        }

        protected JBIArtifactValidator getValidator() {
            return JBIArtifactValidator.getSharedLibraryValidator();
        }

        protected String getFileChooserTitleLabel() {
            return "LBL_Install_Shared_Library_Chooser_Name";
        }

        protected String getInstallProgressMessageLabel() {
            return "LBL_Installing_Shared_Library";
        }

        protected String getBadgeIconName() {
            return "resources/SharedLibraryBadge.png";
        }

        protected String getComponentTypeLabel() {
            return "SHARED_LIBRARY";
        }

        protected JBIComponentType getComponentType() {
            return JBIComponentType.SHARED_LIBRARY;
        }

        protected boolean needRefresh(String string) {
            return string.equals("SharedLibrary");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(this.getClass());
        }
    }

    static class BindingComponents
    extends RealJBIComponentContainerNode {
        BindingComponents(AppserverJBIMgmtController appserverJBIMgmtController) {
            super(appserverJBIMgmtController, NodeType.BINDING_COMPONENTS, NbBundle.getMessage(JBIComponentContainerNode.class, (String)"BINDING_COMPONENTS"));
        }

        protected JBIArtifactValidator getValidator() {
            return JBIArtifactValidator.getBindingComponentValidator(null);
        }

        protected String getFileChooserTitleLabel() {
            return "LBL_Install_Binding_Component_Chooser_Name";
        }

        protected String getInstallProgressMessageLabel() {
            return "LBL_Installing_Binding_Component";
        }

        protected String getBadgeIconName() {
            return "resources/BindingComponentBadge.png";
        }

        protected String getComponentTypeLabel() {
            return "BINDING_COMPONENT";
        }

        protected JBIComponentType getComponentType() {
            return JBIComponentType.BINDING_COMPONENT;
        }

        protected boolean needRefresh(String string) {
            return string.equals("BindingComponent");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(this.getClass());
        }
    }

    static class ServiceEngines
    extends RealJBIComponentContainerNode {
        ServiceEngines(AppserverJBIMgmtController appserverJBIMgmtController) {
            super(appserverJBIMgmtController, NodeType.SERVICE_ENGINES, NbBundle.getMessage(JBIComponentContainerNode.class, (String)"SERVICE_ENGINES"));
        }

        protected JBIArtifactValidator getValidator() {
            return JBIArtifactValidator.getServiceEngineValidator(null);
        }

        protected String getFileChooserTitleLabel() {
            return "LBL_Install_Service_Engine_Chooser_Name";
        }

        protected String getInstallProgressMessageLabel() {
            return "LBL_Installing_Service_Engine";
        }

        protected String getBadgeIconName() {
            return "resources/ServiceEngineBadge.png";
        }

        protected String getComponentTypeLabel() {
            return "SERVICE_ENGINE";
        }

        protected JBIComponentType getComponentType() {
            return JBIComponentType.SERVICE_ENGINE;
        }

        protected boolean needRefresh(String string) {
            return string.equals("ServiceEngine");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(this.getClass());
        }
    }

    static abstract class RealJBIComponentContainerNode
    extends JBIComponentContainerNode {
        RealJBIComponentContainerNode(AppserverJBIMgmtController appserverJBIMgmtController, NodeType nodeType, String string) {
            super(appserverJBIMgmtController, nodeType, string);
        }

        public Action[] getActions(boolean bl) {
            return new SystemAction[]{SystemAction.get(InstallAction.InstallOnly.class), SystemAction.get(InstallAction.InstallAndStart.class), null, SystemAction.get(RefreshAction.class)};
        }

        protected String installComponent(String string) throws ManagementRemoteException {
            Properties properties = new Properties();
            InstallationService installationService = this.getInstallationService();
            try {
                JarFile jarFile = new JarFile(string);
                ZipEntry zipEntry = jarFile.getEntry("META-INF/jbi.xml");
                InputStream inputStream = jarFile.getInputStream(zipEntry);
                String string2 = this.getContent(inputStream);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(new InputSource(new StringReader(string2)));
                JBIComponentConfigurationDescriptor jBIComponentConfigurationDescriptor = JBIComponentConfigurationParser.parse(document);
                if (jBIComponentConfigurationDescriptor != null && jBIComponentConfigurationDescriptor.showDisplayAtInstallation(true)) {
                    String string3 = this.getComponentIDFromJbiDoc(document);
                    JBIComponentInstallationConfigurationDialog jBIComponentInstallationConfigurationDialog = new JBIComponentInstallationConfigurationDialog(string3, jBIComponentConfigurationDescriptor);
                    jBIComponentInstallationConfigurationDialog.pack();
                    jBIComponentInstallationConfigurationDialog.setLocationRelativeTo(null);
                    jBIComponentInstallationConfigurationDialog.setVisible(true);
                    if (jBIComponentInstallationConfigurationDialog.isCancelled()) {
                        return null;
                    }
                    properties = jBIComponentInstallationConfigurationDialog.getProperties();
                    logger.info("Install " + string3 + " with these properties:" + properties);
                }
            }
            catch (Exception exception) {
                logger.severe(exception.getMessage());
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)exception.getMessage(), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            return installationService.installComponent(string, properties, "server");
        }

        private String getComponentIDFromJbiDoc(Document document) {
            Element element;
            NodeList nodeList;
            Element element2;
            NodeList nodeList2;
            NodeList nodeList3 = document.getElementsByTagName("component");
            if (nodeList3.getLength() > 0 && (nodeList2 = (element2 = (Element)nodeList3.item(0)).getElementsByTagName("identification")).getLength() > 0 && (nodeList = (element = (Element)nodeList2.item(0)).getElementsByTagName("name")).getLength() > 0) {
                Element element3 = (Element)nodeList.item(0);
                return element3.getFirstChild().getNodeValue();
            }
            return null;
        }

        private String getContent(InputStream inputStream) {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuffer stringBuffer = new StringBuffer();
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string);
                }
                return stringBuffer.toString();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getContent(File file) {
            String string = "";
            BufferedReader bufferedReader = null;
            try {
                String string2;
                bufferedReader = new BufferedReader(new FileReader(file));
                while ((string2 = bufferedReader.readLine()) != null) {
                    string = string + string2;
                }
            }
            catch (IOException iOException) {
                System.out.println("IOException: " + iOException);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return string;
        }
    }
}

