/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.management.model.constraint;

import org.netbeans.modules.sun.manager.jbi.management.model.constraint.JBIComponentConfigurationConstraint;
import org.openide.util.NbBundle;

public class TotalDigitsConstraint
implements JBIComponentConfigurationConstraint {
    private int totalDigits;

    TotalDigitsConstraint(int n) {
        if (n <= 0) {
            String string = NbBundle.getMessage(this.getClass(), (String)"MSG_ILLEGAL_TOTAL_DIGITS", (Object)n);
            throw new IllegalArgumentException(string);
        }
        this.totalDigits = n;
    }

    public int getValue() {
        return this.totalDigits;
    }

    public String validate(Object object) {
        if (object == null) {
            return NbBundle.getMessage(this.getClass(), (String)"MSG_NULL_VALUE");
        }
        double d = Double.parseDouble(object.toString());
        int n = 0;
        double d2 = d;
        while (d2 != (double)Math.round(d2)) {
            d2 *= 10.0;
            ++n;
        }
        if (Math.abs(d2) < Math.pow(10.0, this.totalDigits) && 0 <= n && n <= this.totalDigits) {
            return null;
        }
        return NbBundle.getMessage(this.getClass(), (String)"MSG_EXCEED_TOTAL_DIGITS", (Object)d, (Object)this.totalDigits);
    }
}

