/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.actions;

import org.netbeans.modules.sun.manager.jbi.nodes.Installable;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public abstract class InstallAction
extends NodeAction {
    private boolean autoStart;

    private InstallAction(boolean bl) {
        this.autoStart = bl;
    }

    protected void performAction(Node[] nodeArray) {
        Lookup lookup = nodeArray[0].getLookup();
        final Installable installable = (Installable)lookup.lookup(Installable.class);
        if (installable != null) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        installable.install(InstallAction.this.autoStart);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    protected boolean enable(Node[] nodeArray) {
        return nodeArray != null && nodeArray.length == 1;
    }

    protected boolean asynchronous() {
        return false;
    }

    public static class InstallAndStart
    extends InstallAction {
        public InstallAndStart() {
            super(true);
        }

        public String getName() {
            return NbBundle.getMessage(InstallAction.class, (String)"LBL_InstallAndStartAction");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }
    }

    public static class InstallOnly
    extends InstallAction {
        public InstallOnly() {
            super(false);
        }

        public String getName() {
            return NbBundle.getMessage(InstallAction.class, (String)"LBL_InstallAction");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }
    }
}

