/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.asm.base.ident;

import antlr.Token;
import antlr.TokenStreamException;
import java.io.Reader;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.asm.base.SparcModelProvider;
import org.netbeans.modules.asm.base.X86ModelProvider;
import org.netbeans.modules.asm.base.att.ATTIdentResolver;
import org.netbeans.modules.asm.base.att.ATTSparcSyntaxProvider;
import org.netbeans.modules.asm.base.att.ATTx86SyntaxProvider;
import org.netbeans.modules.asm.base.dis.DisSparcSyntaxProvider;
import org.netbeans.modules.asm.base.dis.DisX86SyntaxProvider;
import org.netbeans.modules.asm.base.generated.IdentScanner;
import org.netbeans.modules.asm.base.syntax.IdentResolver;
import org.netbeans.modules.asm.model.AbstractAsmModel;
import org.netbeans.modules.asm.model.AsmModelProvider;
import org.netbeans.modules.asm.model.AsmSyntaxProvider;
import org.netbeans.modules.asm.model.AsmTypesProvider;
import org.netbeans.modules.asm.model.util.DefaultAsmTypesEntry;
import org.netbeans.modules.asm.model.util.DefaultResolverResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparcX86Resolver
implements AsmTypesProvider {
    public static final AsmSyntaxProvider ATT_X86_SYNTAX = new ATTx86SyntaxProvider();
    public static final AsmSyntaxProvider ATT_SPARC_SYNTAX = new ATTSparcSyntaxProvider();
    public static final AsmSyntaxProvider DIS_X86_SYNTAX = new DisX86SyntaxProvider();
    public static final AsmSyntaxProvider DIS_SPARC_SYNTAX = new DisSparcSyntaxProvider();
    public static final AsmModelProvider AMD64 = X86ModelProvider.getInstance();
    public static final AsmModelProvider SPARC = SparcModelProvider.getInstance();

    @Override
    public List<AsmTypesProvider.AsmTypesEntry> getAsmTypes() {
        DefaultAsmTypesEntry defaultAsmTypesEntry = new DefaultAsmTypesEntry(AMD64, ATT_X86_SYNTAX, DIS_X86_SYNTAX);
        DefaultAsmTypesEntry defaultAsmTypesEntry2 = new DefaultAsmTypesEntry(SPARC, ATT_SPARC_SYNTAX, DIS_SPARC_SYNTAX);
        return Arrays.asList(defaultAsmTypesEntry, defaultAsmTypesEntry2);
    }

    @Override
    public AsmTypesProvider.ResolverResult resolve(Reader reader) {
        AbstractAsmModel abstractAsmModel = (AbstractAsmModel)AMD64.getModel();
        AbstractAsmModel abstractAsmModel2 = (AbstractAsmModel)SPARC.getModel();
        IdentResolver[] identResolverArray = new IdentResolver[]{new ATTIdentResolver(abstractAsmModel), new ATTIdentResolver(abstractAsmModel2)};
        SyntaxChooser syntaxChooser = new SyntaxChooser();
        ModelChooser modelChooser = new ModelChooser(identResolverArray);
        this.resolver(reader, new ScannerListener[]{syntaxChooser, modelChooser});
        int n = modelChooser.getResult();
        AsmModelProvider asmModelProvider = n == 0 ? AMD64 : SPARC;
        AsmSyntaxProvider asmSyntaxProvider = syntaxChooser.hasDis() ? (n == 0 ? DIS_X86_SYNTAX : DIS_SPARC_SYNTAX) : (n == 0 ? ATT_X86_SYNTAX : ATT_SPARC_SYNTAX);
        return new DefaultResolverResult(asmModelProvider, asmSyntaxProvider, null);
    }

    private void resolver(Reader reader, ScannerListener[] token) {
        Token token2;
        IdentScanner identScanner = new IdentScanner(reader);
        for (ScannerListener scannerListener : token) {
            scannerListener.start();
        }
        do {
            try {
                token2 = identScanner.nextToken();
            }
            catch (TokenStreamException tokenStreamException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Ident lexer crashed");
                break;
            }
            for (Token token3 : token) {
                token3.token(token2);
            }
        } while (token2.getType() != 1);
        int n = identScanner.getNumLines();
        for (Token token3 : token) {
            token3.end(n);
        }
    }

    private static class ModelChooser
    implements ScannerListener {
        private int[] results;
        private IdentResolver[] resolvers;

        public ModelChooser(IdentResolver[] identResolverArray) {
            assert (identResolverArray.length > 0);
            this.resolvers = identResolverArray;
            this.results = new int[identResolverArray.length];
        }

        public int getResult() {
            int n = 0;
            for (int i = 1; i < this.results.length; ++i) {
                if (this.results[n] >= this.results[i]) continue;
                n = i;
            }
            if (this.results[n] == 0) {
                return 0;
            }
            return n;
        }

        public void token(Token token) {
            String string = token.getText();
            int n = token.getType();
            if (n == 47) {
                for (int i = 0; i < this.resolvers.length; ++i) {
                    if (this.resolvers[i].getRegister(string) == null) continue;
                    int n2 = i;
                    this.results[n2] = this.results[n2] + 1;
                }
            }
        }

        public void start() {
        }

        public void end(int n) {
        }
    }

    private static class SyntaxChooser
    implements ScannerListener {
        private int numPluses;
        private int numOpcodes;
        private int numComments;
        private int numLines;

        private SyntaxChooser() {
        }

        public void token(Token token) {
            String string = token.getText();
            int n = token.getType();
            switch (n) {
                case 29: {
                    if (!"+".equals(string)) break;
                    ++this.numPluses;
                    break;
                }
                case 45: {
                    ++this.numComments;
                    break;
                }
                case 46: {
                    if (!this.isOpcode(string)) break;
                    ++this.numOpcodes;
                }
            }
        }

        public boolean hasDis() {
            float f = 0.0f;
            float f2 = 0.0f;
            if (this.numLines > 0) {
                f = (float)this.numOpcodes / (float)this.numLines;
                f2 = (float)this.numPluses / (float)this.numLines;
            }
            return Float.compare(f, 2.0f) > 0 || Float.compare(f2, 0.9f) > 0;
        }

        private boolean isOpcode(String string) {
            return string.length() == 2 && this.isHexDigit(string.charAt(0)) && this.isHexDigit(string.charAt(1));
        }

        private boolean isHexDigit(char c) {
            return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
        }

        public void end(int n) {
            this.numLines = n - this.numComments;
        }

        public void start() {
        }
    }

    private static interface ScannerListener
    extends EventListener {
        public void start();

        public void token(Token var1);

        public void end(int var1);
    }
}

