/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.dirchooser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;
import org.netbeans.swing.dirchooser.DirectoryChooserUI;
import org.netbeans.swing.dirchooser.Module;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingChooserUI
extends ComponentUI {
    private static final String USE_SHELL_FOLDER = "FileChooser.useShellFolder";
    private static boolean firstTime = true;

    public static ComponentUI createUI(JComponent jComponent) {
        ComponentUI componentUI;
        JFileChooser jFileChooser = (JFileChooser)jComponent;
        if (Utilities.isWindows() && !Boolean.TRUE.equals(jFileChooser.getClientProperty(USE_SHELL_FOLDER))) {
            jFileChooser.putClientProperty(USE_SHELL_FOLDER, Boolean.FALSE);
        }
        Class<? extends FileChooserUI> clazz = DelegatingChooserUI.getCurChooser(jFileChooser);
        try {
            Method method = clazz.getMethod("createUI", JComponent.class);
            componentUI = (ComponentUI)method.invoke(null, jFileChooser);
        }
        catch (Exception exception) {
            Logger.getLogger(DelegatingChooserUI.class.getName()).log(Level.FINE, "Could not instantiate custom chooser, fallbacking to Metal", exception);
            componentUI = MetalFileChooserUI.createUI(jComponent);
        }
        if (firstTime) {
            jFileChooser.addPropertyChangeListener("fileSelectionChanged", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
                    jFileChooser.updateUI();
                }
            });
        }
        return componentUI;
    }

    private static Class<? extends FileChooserUI> getCurChooser(JFileChooser jFileChooser) {
        if (jFileChooser.getFileSelectionMode() == 1) {
            return DirectoryChooserUI.class;
        }
        return Module.getOrigChooser();
    }
}

