/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.util;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.soa.ui.axinodes.AxiomUtils;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xslt.tmap.model.api.Operation;
import org.netbeans.modules.xslt.tmap.model.api.Service;
import org.netbeans.modules.xslt.tmap.model.api.TMapComponent;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.model.api.Transform;
import org.netbeans.modules.xslt.tmap.model.api.TransformMap;
import org.netbeans.modules.xslt.tmap.model.api.VariableReference;
import org.netbeans.modules.xslt.tmap.model.api.WSDLReference;
import org.netbeans.modules.xslt.tmap.nodes.NavigatorNodeFactory;
import org.netbeans.modules.xslt.tmap.nodes.NodeType;
import org.openide.cookies.EditCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class TMapUtil {
    private TMapUtil() {
    }

    public static Transform getTransform(TMapModel tMapModel, FileObject fileObject) {
        List<Service> list;
        assert (tMapModel != null && fileObject != null);
        Transform transform = null;
        TransformMap transformMap = tMapModel.getTransformMap();
        List<Service> list2 = list = transformMap == null ? null : transformMap.getServices();
        if (list != null) {
            Service service;
            List<Operation> list3;
            Iterator<Service> iterator = list.iterator();
            while (iterator.hasNext() && (list3 = (service = iterator.next()).getOperations()) != null) {
                for (Operation operation : list3) {
                    List<Transform> list4 = operation.getTransforms();
                    for (Transform transform2 : list4) {
                        if (!TMapUtil.isEqual(fileObject, transform2.getFile())) continue;
                        transform = transform2;
                        break;
                    }
                    if (transform == null) continue;
                    break;
                }
                if (transform == null) continue;
                break;
            }
        }
        return transform;
    }

    public static boolean isEqual(FileObject fileObject, String string) {
        assert (fileObject != null);
        if (string == null) {
            return false;
        }
        String string2 = fileObject.getPath();
        if (string2.equals(string)) {
            return true;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        File file2 = FileUtil.toFile((FileObject)fileObject);
        while ((file2 = file2.getParentFile()) != null) {
            file = file2;
        }
        if (string != null && string.startsWith(file.getPath())) {
            return false;
        }
        String string3 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        boolean bl = true;
        bl = string != null && string.equals(fileObject.getNameExt());
        return bl;
    }

    public static AXIComponent getSourceComponent(Transform transform) {
        AXIComponent aXIComponent = null;
        aXIComponent = TMapUtil.getAXIComponent(TMapUtil.getSchemaComponent(transform, true));
        return aXIComponent;
    }

    public static AXIComponent getTargetComponent(Transform transform) {
        AXIComponent aXIComponent = null;
        aXIComponent = TMapUtil.getAXIComponent(TMapUtil.getSchemaComponent(transform, false));
        return aXIComponent;
    }

    private static AXIComponent getAXIComponent(ReferenceableSchemaComponent referenceableSchemaComponent) {
        if (referenceableSchemaComponent == null) {
            return null;
        }
        AXIComponent aXIComponent = null;
        AXIModel aXIModel = AXIModelFactory.getDefault().getModel(referenceableSchemaComponent.getModel());
        if (aXIModel != null) {
            aXIComponent = AxiomUtils.findGlobalComponent((AXIDocument)aXIModel.getRoot(), null, (SchemaComponent)referenceableSchemaComponent);
        }
        return aXIComponent;
    }

    public static ReferenceableSchemaComponent getSchemaComponent(Transform transform, boolean bl) {
        VariableReference variableReference;
        assert (transform != null);
        ReferenceableSchemaComponent referenceableSchemaComponent = null;
        VariableReference variableReference2 = variableReference = bl ? transform.getSource() : transform.getResult();
        if (variableReference != null) {
            referenceableSchemaComponent = TMapUtil.getMessageSchemaType(variableReference);
        }
        return referenceableSchemaComponent;
    }

    private static ReferenceableSchemaComponent getMessageSchemaType(VariableReference variableReference) {
        if (variableReference == null) {
            return null;
        }
        ReferenceableSchemaComponent referenceableSchemaComponent = null;
        WSDLReference wSDLReference = variableReference.getPart();
        Part part = wSDLReference == null ? null : (Part)wSDLReference.get();
        NamedComponentReference namedComponentReference = null;
        if (part != null) {
            namedComponentReference = part.getElement();
            if (namedComponentReference == null) {
                namedComponentReference = part.getType();
            }
            referenceableSchemaComponent = (ReferenceableSchemaComponent)namedComponentReference.get();
        }
        return referenceableSchemaComponent;
    }

    public static void goToTreeView(Component component) {
        if (!(component instanceof TMapComponent)) {
            return;
        }
        final TMapComponent tMapComponent = (TMapComponent)component;
        if (tMapComponent.getModel() == null) {
            return;
        }
        FileObject fileObject = SoaUtil.getFileObjectByModel((Model)tMapComponent.getModel());
        if (fileObject == null) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            final Lookup lookup = dataObject != null ? dataObject.getLookup() : null;
            final EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
            if (editCookie == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    editCookie.edit();
                    TMapUtil.openActiveTreeEditor();
                    if (lookup != null || tMapComponent != null) {
                        NodeType nodeType = NodeType.getNodeType(tMapComponent);
                        if (nodeType == null) {
                            return;
                        }
                        Node node = NavigatorNodeFactory.getInstance().createNode(nodeType, (Object)tMapComponent, Children.LEAF, lookup);
                        TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
                        if (topComponent != null) {
                            topComponent.setActivatedNodes(new Node[0]);
                            topComponent.setActivatedNodes(new Node[]{node});
                        }
                    }
                }
            });
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return;
        }
    }

    public static void goToSourceView(Component component) {
        if (component.getModel() == null) {
            return;
        }
        if (!(component instanceof DocumentComponent)) {
            return;
        }
        DocumentComponent documentComponent = (DocumentComponent)component;
        FileObject fileObject = SoaUtil.getFileObjectByModel((Model)component.getModel());
        if (fileObject == null) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (lineCookie == null) {
                return;
            }
            int n = SoaUtil.getLineNum((DocumentComponent)documentComponent);
            if (n < 0) {
                return;
            }
            final Line line = lineCookie.getLineSet().getCurrent(n);
            final int n2 = SoaUtil.getColumnNum((DocumentComponent)documentComponent);
            if (n2 < 0) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    line.show(2, n2);
                    TMapUtil.openActiveSourceEditor();
                }
            });
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return;
        }
    }

    private static void openActiveTreeEditor() {
        SoaUtil.openActiveMVEditor((String)"tmap-tree");
    }

    private static void openActiveSourceEditor() {
        SoaUtil.openActiveMVEditor((String)"tmapsource");
    }
}

