/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.model.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.xml.catalogsupport.DefaultProjectCatalogSupport;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.model.spi.ExternalModelRetriever;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalModelRetrieverImpl
implements ExternalModelRetriever {
    @Override
    public Collection<WSDLModel> getWSDLModels(TMapModel tMapModel, String string) {
        if (string == null) {
            return Collections.emptyList();
        }
        LinkedList<WSDLModel> linkedList = new LinkedList<WSDLModel>();
        ExternalModelRetrieverImpl.collectWsdlModelsViaFS(tMapModel, string, linkedList);
        return linkedList;
    }

    private static void collectWsdlModelsViaFS(TMapModel tMapModel, String string, List<WSDLModel> list) {
        FileObject[] fileObjectArray;
        for (FileObject fileObject : fileObjectArray = ExternalModelRetrieverImpl.getFilesByNamespace(tMapModel.getModelSource(), string, Utilities.DocumentTypesEnum.wsdl)) {
            ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)true);
            WSDLModel wSDLModel = WSDLModelFactory.getDefault().getModel(modelSource);
            if (wSDLModel == null) continue;
            list.add(wSDLModel);
        }
    }

    private static FileObject[] getFilesByNamespace(ModelSource modelSource, String string, Utilities.DocumentTypesEnum documentTypesEnum) {
        File file;
        Object object;
        assert (string != null);
        LinkedList linkedList = new LinkedList();
        FileObject fileObject = (FileObject)modelSource.getLookup().lookup(FileObject.class);
        if (fileObject == null) {
            return new FileObject[0];
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        arrayList.addAll(Arrays.asList(ProjectUtils.getSources((Project)project).getSourceGroups("xml")));
        DefaultProjectCatalogSupport defaultProjectCatalogSupport = (DefaultProjectCatalogSupport)project.getLookup().lookup(DefaultProjectCatalogSupport.class);
        if (defaultProjectCatalogSupport != null && (object = defaultProjectCatalogSupport.getProjectReferences()) != null && object.size() > 0) {
            Iterator object2 = object.iterator();
            while (object2.hasNext()) {
                file = (Project)object2.next();
                arrayList.addAll(Arrays.asList(ProjectUtils.getSources((Project)file).getSourceGroups("xml")));
            }
        }
        for (SourceGroup sourceGroup : arrayList) {
            file = FileUtil.toFile((FileObject)sourceGroup.getRootFolder());
            if (file == null) {
                return null;
            }
            Map map = Utilities.getFiles2NSMappingInProj((File)file, (Utilities.DocumentTypesEnum)documentTypesEnum);
            for (Map.Entry entry : map.entrySet()) {
                String string2 = (String)entry.getValue();
                if (!string.equals(string2)) continue;
                linkedList.add(entry.getKey());
            }
        }
        return linkedList.toArray(new FileObject[linkedList.size()]);
    }
}

