/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs.statistics;

import java.io.PrintStream;
import java.util.Map;
import org.netbeans.modules.cnd.repository.sfs.statistics.BaseStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeStatistics
extends BaseStatistics<Integer> {
    protected int rangeCount;
    private Range[] ranges;

    public RangeStatistics(String string, int n) {
        this(string, n, 10);
    }

    public RangeStatistics(String string, int n, int n2) {
        super(string, n);
        this.rangeCount = n2;
    }

    public void consume(int n) {
        this.consume(n, n);
    }

    @Override
    public void print(PrintStream printStream) {
        int n = this.cnt == 0 ? 0 : this.sum / this.cnt;
        printStream.printf("%s %8d min    %8d max    %8d avg    %8d cnt    %8d sum\n", this.text, this.min, this.max, n, this.cnt, this.sum);
        if (this.values != null) {
            this.printDistribution(printStream);
        }
    }

    @Override
    protected void printDistribution(PrintStream printStream) {
        printStream.printf("\tDistribution:\n", new Object[0]);
        if (this.level > 2 || this.values.size() <= this.rangeCount) {
            this.printDistributionDetailed(printStream);
        } else {
            this.printDistributionGrouped(printStream);
        }
    }

    private void createRanges() {
        int[] nArray = new int[this.values.size()];
        int n = 0;
        for (Map.Entry entry : this.values.entrySet()) {
            nArray[n++] = (Integer)entry.getKey();
        }
        this.ranges = new Range[this.rangeCount];
        int n2 = this.values.size() / this.rangeCount + (this.values.size() % this.rangeCount == 0 ? 0 : 1);
        for (int i = 0; i < this.ranges.length; ++i) {
            int n3 = Math.min(n2 * i, nArray.length - 1);
            int n4 = Math.min(n3 + n2 - 1, nArray.length - 1);
            try {
                this.ranges[i] = new Range(nArray[n3], nArray[n4]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.printf("i=%d from=%d to=%d valuesArray.length=%d\n", i, n3, n4, nArray.length);
                arrayIndexOutOfBoundsException.printStackTrace(System.err);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    private Range getRange(int n) {
        if (this.ranges == null) {
            this.createRanges();
        }
        for (int i = 0; i < this.ranges.length; ++i) {
            if (this.ranges[i].from > n || n > this.ranges[i].to) continue;
            return this.ranges[i];
        }
        throw new IllegalArgumentException("Value " + n + " are out of range " + this.min + '-' + this.max);
    }

    private void printDistributionGrouped(PrintStream printStream) {
        for (Map.Entry entry : this.values.entrySet()) {
            Range range = this.getRange((Integer)entry.getKey());
            range.cnt += ((Integer)entry.getValue()).intValue();
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.ranges.length; ++i) {
            n = Math.max(n3, this.ranges[i].from);
            n2 = Math.max(n3, this.ranges[i].to);
            n3 = Math.max(n3, this.ranges[i].cnt);
        }
        n = (int)Math.log10(n) + 1;
        n2 = (int)Math.log10(n2) + 1;
        n3 = (int)Math.log10(n3) + 1;
        StringBuilder stringBuilder = new StringBuilder("\t%");
        stringBuilder.append(n);
        stringBuilder.append("d - %");
        stringBuilder.append(n2);
        stringBuilder.append("d   %");
        stringBuilder.append(n3);
        stringBuilder.append("d   %2d%%\n");
        for (int i = 0; i < this.ranges.length; ++i) {
            if (this.ranges[i].cnt <= 0) continue;
            int n4 = this.ranges[i].cnt * 100 / this.cnt;
            printStream.printf(stringBuilder.toString(), this.ranges[i].from, this.ranges[i].to, this.ranges[i].cnt, n4);
        }
    }

    private static class Range {
        public int from;
        public int to;
        public int cnt;

        public Range(int n, int n2) {
            this.from = n;
            this.to = n2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.from);
            stringBuilder.append('-');
            stringBuilder.append(this.to);
            stringBuilder.append(": ");
            stringBuilder.append(this.cnt);
            return stringBuilder.toString();
        }
    }
}

